package com.ejie.aa83b.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Clase que encapsula la informacion para las excepciones controladas
 * 
 * @author DS
 */
public class Aa83bErrorGenericoException extends RuntimeException implements
		Serializable {

	private static final long serialVersionUID = 1L;

	private List<Aa83bErrorField> errorsFields = null;

	// Tiles en la que mostrar el error
	private String tiles = null;

	private boolean generaTextArea = false;

	/**
	 * Constructor 'ErrorFieldsException'
	 * 
	 * @param tiles
	 *            tiles
	 * @param campo
	 *            campo
	 * @param mensaje
	 *            mensaje
	 * @param param
	 *            param
	 */
	public Aa83bErrorGenericoException(String tiles, String campo,
			String mensaje, String param) {
		super("ErrorGenericoException");
		this.tiles = tiles;
		this.errorsFields = new ArrayList<Aa83bErrorField>();
		this.errorsFields.add(new Aa83bErrorField(campo, mensaje, param));
	}

	/**
	 * Constructor 'ErrorFieldsException'
	 * 
	 * @param tiles
	 *            tiles
	 * @param campo
	 *            campo
	 * @param mensaje
	 *            mensaje
	 * @param param
	 *            param
	 * @param paramIsKey
	 *            boolean
	 */
	public Aa83bErrorGenericoException(String tiles, String campo,
			String mensaje, String param, boolean paramIsKey) {
		super("ErrorGenericoException");
		this.tiles = tiles;
		this.errorsFields = new ArrayList<Aa83bErrorField>();
		this.errorsFields.add(new Aa83bErrorField(campo, mensaje, param,
				paramIsKey));
	}

	/**
	 * Constructor 'ErrorFieldsException'
	 * 
	 * @param campo
	 *            String
	 * @param mensajeCode
	 *            String
	 */
	public Aa83bErrorGenericoException(String campo, String mensajeCode) {
		super("ErrorFieldsException");
		this.errorsFields = new ArrayList<Aa83bErrorField>();
		this.errorsFields.add(new Aa83bErrorField(campo, mensajeCode));
	}

	/**
	 * Constructor 'ErrorFieldsException'
	 * 
	 * @param errorsFields
	 *            List<ErrorField>
	 */
	public Aa83bErrorGenericoException(List<Aa83bErrorField> errorsFields) {
		super("ErrorGenericoException");
		this.errorsFields = errorsFields;
	}

	/**
	 * Constructor 'ErrorFieldsException'
	 * 
	 * @param generaTextArea
	 *            boolean
	 * @param errorsFields
	 *            List<ErrorField>
	 */
	public Aa83bErrorGenericoException(boolean generaTextArea,
			List<Aa83bErrorField> errorsFields) {
		super("ErrorGenericoException");
		this.errorsFields = errorsFields;
		this.generaTextArea = generaTextArea;
	}

	/**
	 * Constructor a utilizar por clases hijas, para mantener la traza completa
	 * del error, mas un mensaje descriptivo que mostrar al usuario.
	 * 
	 * @param mensajeCode
	 *            Codigo del literal que contiene el mensaje de error
	 * @param cause
	 *            Excepcion que ha producido el error
	 */
	public Aa83bErrorGenericoException(String mensajeCode, Throwable cause) {
		super("ErrorGenericoException", cause);
		this.errorsFields = new ArrayList<Aa83bErrorField>();
		this.errorsFields.add(new Aa83bErrorField(null, mensajeCode));
	}

	/**
	 * Constructor a utilizar para describir el mensaje de error recuperado de
	 * un servicio externo
	 * 
	 * @param mensaje
	 *            de error obtenido de un servicio externo
	 */
	public Aa83bErrorGenericoException(String mensaje) {
		super(mensaje);
	}

	/**
	 * Method 'getErrorsFields'.
	 * 
	 * @return List<ErrorField>
	 */
	public List<Aa83bErrorField> getErrorsFields() {
		return this.errorsFields;
	}

	/**
	 * Method 'setErrorsFields'.
	 * 
	 * @param errorsFields
	 *            List<ErrorField>
	 */
	public void setErrorsFields(List<Aa83bErrorField> errorsFields) {
		this.errorsFields = errorsFields;
	}

	/**
	 * Method 'getTiles'.
	 * 
	 * @return String
	 */
	public String getTiles() {
		return this.tiles;
	}

	/**
	 * Method 'setTiles'.
	 * 
	 * @param tiles
	 *            String
	 */
	public void setTiles(String tiles) {
		this.tiles = tiles;
	}

	/**
	 * Method 'isGeneraTextArea'.
	 * 
	 * @return boolean
	 */
	public boolean isGeneraTextArea() {
		return this.generaTextArea;
	}

	/**
	 * Method 'setGeneraTextArea'.
	 * 
	 * @param generaTextArea
	 *            boolean
	 */
	public void setGeneraTextArea(boolean generaTextArea) {
		this.generaTextArea = generaTextArea;
	}
}