package com.ejie.aa83b.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * ErrorField.
 * 
 * @author DS
 */
public class Aa83bErrorField implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Nombre del campo o label del campo
	 */
	private String campo;
	/**
	 * Errores del campo
	 */
	private List<Aa83bMensaje> mensajes;

	/**
	 * Method 'ErrorField'.
	 * 
	 * @param campo
	 *            campo
	 * @param mensajes
	 *            mensajes
	 */
	public Aa83bErrorField(String campo, List<Aa83bMensaje> mensajes) {
		this.campo = campo;
		this.mensajes = mensajes;
	}

	/**
	 * Method 'ErrorField'.
	 * 
	 * @param campo
	 *            campo
	 * @param mensaje
	 *            Mensaje
	 */
	public Aa83bErrorField(String campo, Aa83bMensaje mensaje) {
		this.campo = campo;
		this.mensajes = new ArrayList<Aa83bMensaje>();
		this.mensajes.add(mensaje);
	}

	/**
	 * Method 'ErrorField'.
	 * 
	 * @param campo
	 *            campo
	 * @param mensaje
	 *            Mensaje
	 */
	public Aa83bErrorField(String campo, String mensaje) {
		this.campo = campo;
		this.mensajes = new ArrayList<Aa83bMensaje>();
		this.mensajes.add(new Aa83bMensaje(mensaje));
	}

	/**
	 * Method 'ErrorField'.
	 * 
	 * @param campo
	 *            campo
	 * @param mensaje
	 *            Mensaje
	 * @param param
	 *            String
	 */
	public Aa83bErrorField(String campo, String mensaje, String param) {
		this.campo = campo;
		this.mensajes = new ArrayList<Aa83bMensaje>();
		this.mensajes.add(new Aa83bMensaje(mensaje, param));
	}

	/**
	 * Method 'ErrorField'.
	 * 
	 * @param campo
	 *            campo
	 * @param mensaje
	 *            Mensaje
	 * @param param
	 *            String
	 * @param paramIsKey
	 *            boolean
	 */
	public Aa83bErrorField(String campo, String mensaje, String param,
			boolean paramIsKey) {
		this.campo = campo;
		this.mensajes = new ArrayList<Aa83bMensaje>();
		this.mensajes.add(new Aa83bMensaje(mensaje, param, paramIsKey));
	}

	/**
	 * Method 'getCampo'.
	 * 
	 * @return String
	 */
	public String getCampo() {
		return this.campo;
	}

	/**
	 * Method 'setCampo'.
	 * 
	 * @param campo
	 *            String
	 */
	public void setCampo(String campo) {
		this.campo = campo;
	}

	/**
	 * Method 'getMensajes'.
	 * 
	 * @return List<Mensaje>
	 */
	public List<Aa83bMensaje> getMensajes() {
		return this.mensajes;
	}

	/**
	 * Method 'setMensajes'.
	 * 
	 * @param mensajes
	 *            List<Mensaje>
	 */
	public void setMensajes(List<Aa83bMensaje> mensajes) {
		this.mensajes = mensajes;
	}
}