package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.model.Aa83bNotificacionCorreosDatosRemesa;
import com.ejie.aa83b.model.Aa83bNotificacionCorreosDatosUsuario;
import com.ejie.aa83b.service.Aa83b21t00Service;
import com.ejie.aa83b.service.Aa83b23t00Service;
import com.ejie.aa83b.service.Aa83b25t00Service;
import com.ejie.aa83b.service.Aa83bNoraService;


@Repository
@Transactional
public class Aa83bNotificacionesCorreosDaoImpl implements Aa83bNotificacionesCorreosDao {
	/** The jdbc template. */
	 private JdbcTemplate jdbcTemplate;
	 
	 @Autowired()
	 private Aa83b21t00Service aa83b21t00Service;
	 
	 @Autowired()
	 private Aa83b23t00Service aa83b23t00Service;
	 
	 @Autowired()
	 private Aa83b25t00Service aa83b25t00Service;
	 
	 @Autowired()
	 private Aa83bNoraService aa83bNoraService;
	 
	private static final Logger logger = LoggerFactory
	.getLogger(Aa83bNotificacionesCorreosDaoImpl.class);

	 
	 /**
		 * Method use to set the datasource.
		 * 
		 * @param dataSource
		 *            DataSource
		 */

		@Resource
		public void setDataSource(DataSource dataSource) {
			this.jdbcTemplate = new JdbcTemplate(dataSource);
		}
		
		/** The comunicacionrowMap map. */
		private RowMapper<Aa83bNotificacionCorreosDatosUsuario> rwMap = new RowMapper<Aa83bNotificacionCorreosDatosUsuario>() {
			public Aa83bNotificacionCorreosDatosUsuario mapRow(ResultSet resultSet,
					int rowNum) throws SQLException {
				return new Aa83bNotificacionCorreosDatosUsuario(
						resultSet.getString("ID_SOL"),
						resultSet.getString("TIPOSOL"),
						resultSet.getString("ANYO"),
						resultSet.getString("NOMBRE"),
						resultSet.getString("APELLIDOS"),
						resultSet.getString("PROVINCIA"),
						resultSet.getString("MUNICIPIO"),
						resultSet.getString("DIRECCION"),
						resultSet.getString("CODIGOPOSTAL"),
						resultSet.getInt("ID_FASE"),
						resultSet.getInt("ID_TRAMITE")
						);
			}
		};
		
		/** The comunicacionrowMap map. */
		private RowMapper<Aa83bNotificacionCorreosDatosRemesa> rwMap2 = new RowMapper<Aa83bNotificacionCorreosDatosRemesa>() {
			public Aa83bNotificacionCorreosDatosRemesa mapRow(ResultSet resultSet,
					int rowNum) throws SQLException {
				return new Aa83bNotificacionCorreosDatosRemesa(
						resultSet.getInt("ID_SOL"),
						resultSet.getInt("ID_ANYO"),
						resultSet.getInt("ID_TIPOSOL"),
						resultSet.getInt("ID_REMESA"),
						resultSet.getInt("ID_COLECCION"),
						resultSet.getInt("ID_ENVIO"),
						resultSet.getString("CODIGO_REMESA"),
						resultSet.getString("CODIGO_COLECCION"),
						resultSet.getString("CODIGO_ENVIO"),
						resultSet.getString("CODIGO_SITUACION"),
						resultSet.getString("DESCRIPCION_ES"),
						resultSet.getString("DESCRIPCION_EU"),
						resultSet.getString("FECHA_SITUACION"),
						resultSet.getString("UIDPUESTOTRAMITADOR")
						);
			}
		};
		
		public Aa83bNotificacionCorreosDatosUsuario findComunicaciones(
				String id, String anyo, String tipoSol) {
			
			String selectPrincipal="SELECT ID_SOL, TIPOSOL, ANYO, NOMBRE, APELLIDOS, PROVINCIA, MUNICIPIO, DIRECCION, CODIGOPOSTAL, ID_FASE, ID_TRAMITE FROM ";
			String select = null;
			if("HAB".equals(tipoSol)){
				Aa83b21t00 aa83b21t00 = new Aa83b21t00();
				aa83b21t00.setId021(Integer.parseInt(id));
				aa83b21t00.setIdAno021(Long.parseLong(anyo));
				aa83b21t00 = aa83b21t00Service.find(aa83b21t00);
				String calleComunic = aa83b21t00.getCalleIdComunic021();
				String provinciaComunic = aa83b21t00.getProvinciaComunic021();
				String municipioComunic = aa83b21t00.getMunicipComunic021();
				Aa83bCalle calle=new Aa83bCalle();
				calle.setDs_o(calleComunic);
				calle.setProvincia_id(provinciaComunic);
				calle.setMunicipio_id(municipioComunic);
				calle = aa83bNoraService.findCallePorString(calle);
				String calleDsO = calleComunic;
				String tipoVia = aa83bNoraService.findTipoViaPorDefecto();
				logger.info("TIPO VIA DEFECTO!!!!!!!!!!!! " + tipoVia);
				if(StringUtils.isNotEmpty(calle.getId())){
					// Si existe la calle en nora sobreescribimos los valores de la calle y tipo de va
					calleDsO = calle.getDs_o();
					tipoVia = calle.getTipo_via();
				}
				 select="(SELECT AA83B21T00.ID_021 AS ID_SOL, TIPO_SOL_003 AS TIPOSOL, AA83B21T00.ID_ANO_021 AS ANYO, " +
				" AA83B21T00.NOMBRE_021 AS NOMBRE, (AA83B21T00.APEL1_021  || ' ' || AA83B21T00.APEL2_021) AS APELLIDOS," +
				" PROVINCIA.DS_O AS PROVINCIA, MUNICIPIO.DS_O AS MUNICIPIO, " +
				" ( '" + tipoVia + "' || ' ' || '" + calleDsO + "' || ' ' || AA83B21T00.NUMERO_COMUNIC_021 ||  ' ' || AA83B21T00.BIS_COMUNIC_021 || ' ' ||  AA83B21T00.PISO_COMUNIC_021  || ' ' || AA83B21T00.LETRA_COMUNIC_021 ) AS DIRECCION," +
				" AA83B21T00.CPOSTAL_COMUNIC_021 AS CODIGOPOSTAL, " +
				" AA83B02T00.ID_001_FASE AS ID_FASE, AA83B02T00.ID_002 AS ID_TRAMITE " +
				" FROM AA83B21T00 " +
				" INNER JOIN AA83B09T00 " +
				" ON AA83B21T00.ID_021 =AA83B09T00.ID_021_NUM_SOL " +
				" AND AA83B21T00.ID_ANO_021=AA83B09T00.ID_ANO_021 " +
				" AND AA83B09T00.ID_009= (SELECT MAX( ID_009 )  FROM AA83B09T00 WHERE AA83B09T00.ID_021_NUM_SOL=AA83B21T00.ID_021)" +
				" INNER JOIN AA83B03T00 ON AA83B03T00.ID_003=AA83B09T00.ID_003_TIPO_SOL" +
				" INNER JOIN AA83B02T00 ON AA83B02T00.ID_002=AA83B09T00.ID_002_TRAM" +
				" AND AA83B02T00.ID_003_TIPO_SOL=AA83B03T00.ID_003" +
				" AND AA83B02T00.ID_001_FASE=AA83B09T00.ID_001_FASE" +
				" AND AA83B02T00.ID_003_TIPO_SOL=3" +
				" INNER JOIN AA83B01V00 ON AA83B01V00.ID_001=AA83B02T00.ID_001_FASE" +
				" INNER JOIN  T17I.T17_PROVINCIA PROVINCIA ON PROVINCIA.ID= AA83B21T00.PROVINCIA_COMUNIC_021" +
				" INNER JOIN  T17I.T17_MUNICIPIO MUNICIPIO ON MUNICIPIO.ID= AA83B21T00.MUNICIP_COMUNIC_021" +
				//" INNER JOIN T17I.T17_CALLE CALLE ON CALLE.ID= AA83B21T00.CALLE_COMUNIC_021" +
				" WHERE AA83B21T00.TIPO_NOTIFICACION_021 <> 'T'" +
				" AND MUNICIPIO.PROVINCIA_ID= PROVINCIA.ID) ";
			}else if("ESF".equals(tipoSol)){
				Aa83b23t00 aa83b23t00 = new Aa83b23t00();
				aa83b23t00.setId023(Integer.parseInt(id));
				aa83b23t00.setIdAno023(Long.parseLong(anyo));
				aa83b23t00 = aa83b23t00Service.find(aa83b23t00);
				String calleComunic = aa83b23t00.getCalleIdComunic023();
				String provinciaComunic = aa83b23t00.getProvinciaComunic023();
				String municipioComunic = aa83b23t00.getMunicipComunic023();
				Aa83bCalle calle=new Aa83bCalle();
				calle.setDs_o(calleComunic);
				calle.setProvincia_id(provinciaComunic);
				calle.setMunicipio_id(municipioComunic);
				calle = aa83bNoraService.findCallePorString(calle);
				String calleDsO = calleComunic;
				String tipoVia = aa83bNoraService.findTipoViaPorDefecto();
				if(StringUtils.isNotEmpty(calle.getId())){
					// Si existe la calle en nora sobreescribimos los valores de la calle y tipo de va
					calleDsO = calle.getDs_o();
					tipoVia = calle.getTipo_via();
				}
				 select="(SELECT AA83B23T00.ID_023 AS ID_SOL, TIPO_SOL_003 AS TIPOSOL, AA83B23T00.ID_ANO_023 AS ANYO," +
				" AA83B23T00.NOMBRE_023 AS NOMBRE, (AA83B23T00.APEL1_023  || ' ' || AA83B23T00.APEL2_023) AS APELLIDOS," +
				" PROVINCIA.DS_O AS PROVINCIA, MUNICIPIO.DS_O AS MUNICIPIO," +
				" ( '" + tipoVia + "' || ' ' || '" + calleDsO + "' || ' ' || AA83B23T00.NUMERO_COMUNIC_023 || ' ' || AA83B23T00.BIS_COMUNIC_023  || ' ' ||  AA83B23T00.PISO_COMUNIC_023  || ' ' || AA83B23T00.LETRA_COMUNIC_023 ) AS DIRECCION," +
				" AA83B23T00.CPOSTAL_COMUNIC_023 AS CODIGOPOSTAL, " +
				" AA83B02T00.ID_001_FASE   AS ID_FASE, AA83B02T00.ID_002 AS ID_TRAMITE " +
				" FROM AA83B23T00 INNER JOIN AA83B10T00" +
				" ON AA83B23T00.ID_023 =AA83B10T00.ID_023_NUM_SOL" +
				" AND AA83B23T00.ID_ANO_023=AA83B10T00.ID_ANO_023" +
				" AND AA83B10T00.ID_010= (SELECT MAX( ID_010 )  FROM AA83B10T00 WHERE AA83B10T00.ID_023_NUM_SOL=AA83B23T00.ID_023)" +
				" INNER JOIN AA83B03T00 ON AA83B03T00.ID_003=AA83B10T00.ID_003_TIPO_SOL" +
				" INNER JOIN AA83B02T00 ON AA83B02T00.ID_002=AA83B10T00.ID_002_TRAM" +
				" AND AA83B02T00.ID_003_TIPO_SOL=AA83B03T00.ID_003 AND AA83B02T00.ID_001_FASE=AA83B10T00.ID_001_FASE" +
				" AND AA83B02T00.ID_003_TIPO_SOL=2" +
				" INNER JOIN AA83B01V00 ON AA83B01V00.ID_001=AA83B02T00.ID_001_FASE" +
				" INNER JOIN  T17I.T17_PROVINCIA PROVINCIA ON PROVINCIA.ID= AA83B23T00.PROVINCIA_COMUNIC_023" +
				" INNER JOIN  T17I.T17_MUNICIPIO MUNICIPIO ON MUNICIPIO.ID= AA83B23T00.MUNICIP_COMUNIC_023" +
				//" INNER JOIN T17I.T17_CALLE CALLE ON CALLE.ID= AA83B23T00.CALLE_COMUNIC_023" +
				" WHERE AA83B23T00.TIPO_NOTIFICACION_023 <> 'T'" +
				" AND MUNICIPIO.PROVINCIA_ID= PROVINCIA.ID) ";
			}else if ("ARR".equals(tipoSol)){
				Aa83b25t00 aa83b25t00 = new Aa83b25t00();
				aa83b25t00.setId025(Integer.parseInt(id));
				aa83b25t00.setIdAno025(Long.parseLong(anyo));
				aa83b25t00 = aa83b25t00Service.find(aa83b25t00);
				String calleComunic = aa83b25t00.getCalleIdComunic025();
				String provinciaComunic = aa83b25t00.getProvinciaComunic025();
				String municipioComunic = aa83b25t00.getMunicipComunic025();
				Aa83bCalle calle=new Aa83bCalle();
				calle.setDs_o(calleComunic);
				calle.setProvincia_id(provinciaComunic);
				calle.setMunicipio_id(municipioComunic);
				calle = aa83bNoraService.findCallePorString(calle);
				String calleDsO = calleComunic;
				String tipoVia = aa83bNoraService.findTipoViaPorDefecto();
				if(StringUtils.isNotEmpty(calle.getId())){
					// Si existe la calle en nora sobreescribimos los valores de la calle y tipo de va
					calleDsO = calle.getDs_o();
					tipoVia = calle.getTipo_via();
				}
				select="(SELECT AA83B25T00.ID_025 AS ID_SOL, TIPO_SOL_003 AS TIPOSOL, AA83B25T00.ID_ANO_025 AS ANYO," +
				" AA83B25T00.NOMBRE_025 AS NOMBRE, (AA83B25T00.APEL1_025  || ' ' || AA83B25T00.APEL2_025) AS APELLIDOS," +
				" PROVINCIA.DS_O AS PROVINCIA, MUNICIPIO.DS_O AS MUNICIPIO," +
				" ( '" + tipoVia + "' || ' ' || '" + calleDsO + "' || ' ' || AA83B25T00.NUMERO_COMUNIC_025  || ' ' || AA83B25T00.BIS_COMUNIC_025 || ' ' ||  AA83B25T00.PISO_COMUNIC_025  || ' ' || AA83B25T00.LETRA_COMUNIC_025 ) AS DIRECCION," +
				" AA83B25T00.CPOSTAL_COMUNIC_025 AS CODIGOPOSTAL," +
				" AA83B02T00.ID_001_FASE   AS ID_FASE, AA83B02T00.ID_002 AS ID_TRAMITE " +
				" FROM AA83B25T00" +
				" INNER JOIN AA83B11T00 ON AA83B25T00.ID_025 =AA83B11T00.ID_025_NUM_SOL" +
				" AND AA83B25T00.ID_ANO_025=AA83B11T00.ID_ANO_SOL_025" +
				" AND AA83B11T00.ID_011= (SELECT MAX( ID_011 )  FROM AA83B11T00 WHERE AA83B11T00.ID_025_NUM_SOL=AA83B25T00.ID_025)" +
				" INNER JOIN AA83B03T00 ON AA83B03T00.ID_003=AA83B11T00.ID_003_TIPO_SOL" +
				" INNER JOIN AA83B02T00 ON AA83B02T00.ID_002 =AA83B11T00.ID_002_TRAM" +
				" AND AA83B02T00.ID_003_TIPO_SOL=AA83B03T00.ID_003 AND AA83B02T00.ID_001_FASE=AA83B11T00.ID_001_FASE" +
				" AND AA83B02T00.ID_003_TIPO_SOL=1" +
				" INNER JOIN AA83B01V00 ON AA83B01V00.ID_001=AA83B02T00.ID_001_FASE" +
				" INNER JOIN  T17I.T17_PROVINCIA PROVINCIA ON PROVINCIA.ID= AA83B25T00.PROVINCIA_COMUNIC_025" +
				" INNER JOIN  T17I.T17_MUNICIPIO MUNICIPIO ON MUNICIPIO.ID= AA83B25T00.MUNICIP_COMUNIC_025" +
				//" INNER JOIN T17I.T17_CALLE CALLE ON CALLE.ID= AA83B25T00.CALLE_COMUNIC_025" +
				" WHERE AA83B25T00.TIPO_NOTIFICACION_025 <> 'T'" +
				" AND MUNICIPIO.PROVINCIA_ID= PROVINCIA.ID) ";
			}
			
			String where=" WHERE  TIPOSOL= ? " +
					" AND ANYO= ? " +
					" AND ID_SOL= ?";
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer();
			query.append(selectPrincipal);
			query.append(select);
			query.append(where);
			params.add(tipoSol);
			params.add(anyo);
			params.add(id);

			 List<Aa83bNotificacionCorreosDatosUsuario> notif = (List<Aa83bNotificacionCorreosDatosUsuario>) this.jdbcTemplate.query(
					query.toString(), rwMap, params.toArray());
			return (Aa83bNotificacionCorreosDatosUsuario) DataAccessUtils.uniqueResult(notif);
		}
		
		                
		public Aa83bNotificacionCorreosDatosRemesa add(Aa83bNotificacionCorreosDatosRemesa datosRemesa) {
			//Cogemos la fecha y hora actuales para coger el envio ms reciente en caso de que un expediente tenga ms de un envio
			Calendar calendar = Calendar.getInstance();
			Timestamp currentTimestamp = new java.sql.Timestamp(calendar.getTime().getTime());
			
			
			String query = "INSERT INTO AA83B43T00 (ID_SOL, ID_ANYO, ID_TIPOSOL, ID_REMESA, ID_COLECCION, ID_ENVIO, CODIGO_REMESA, CODIGO_COLECCION, CODIGO_ENVIO, FECHA_ENVIO, UIDPUESTOTRAMITADOR) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
			this.jdbcTemplate.update(query, datosRemesa.getId_sol(), datosRemesa.getId_anyo(), datosRemesa.getTipoSol(),
					datosRemesa.getIdRemesa(), datosRemesa.getIdColeccion(), datosRemesa.getIdEnvio(),
					datosRemesa.getCodigoRemesa(), datosRemesa.getCodigoColeccion(), datosRemesa.getCodigoEnvio(), currentTimestamp, datosRemesa.getUidPuestoTramitador());
			return datosRemesa;
			
		}
		
		public List<Aa83bNotificacionCorreosDatosRemesa> buscarSituacionRemesa(String id, String anyo, String tipoSol){
			String select="SELECT * FROM AA83B43T00 " +
					" WHERE ID_SOL= ? " +
					" AND ID_ANYO= ? " +
					" AND ID_TIPOSOL=? order by FECHA_ENVIO desc";
			StringBuffer query = new StringBuffer();
			List<Object> params = new ArrayList<Object>();
			query.append(select);
			params.add(id);
			params.add(anyo);
			params.add(tipoSol);
			
			
			
			 List<Aa83bNotificacionCorreosDatosRemesa> notif = (List<Aa83bNotificacionCorreosDatosRemesa>) this.jdbcTemplate.query(
						query.toString(), rwMap2, params.toArray());
				return notif;
		}
		
		/**
		 * StringBuilder initilization value
		 */
		public static final int STRING_BUILDER_INIT = 4096;
		
}
