package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.lang.StringUtils;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.A83bComunidad;
import com.ejie.aa83b.model.A83bLocalidad;
import com.ejie.aa83b.model.A83bMunicipio;
import com.ejie.aa83b.model.A83bPais;
import com.ejie.aa83b.model.A83bProvincia;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.x38.dto.JQGridRequestDto;

//TODO: Auto-generated Javadoc
/**
 * The Class A83bNoraDaoImpl.
 * 
 * @author Deusto Sistemas
 */
@Repository
@Transactional
public class Aa83bNoraDaoImpl implements Aa83bNoraDao {

	/** The jdbc template. */
	private JdbcTemplate jdbcTemplate;

	/** The comunidadrw map. */
	private RowMapper<A83bComunidad> comunidadrwMap = new RowMapper<A83bComunidad>() {
		public A83bComunidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new A83bComunidad(resultSet.getString("ID"),
					resultSet.getString("DS_O"));
		}
	};

	/** The paisrw map. */
	private RowMapper<A83bPais> paisrwMap = new RowMapper<A83bPais>() {
		public A83bPais mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new A83bPais(resultSet.getString("ID"),
					resultSet.getString("DS_O"));
		}
	};

	/** The provinciarw map. */
	private RowMapper<A83bProvincia> provinciarwMap = new RowMapper<A83bProvincia>() {
		public A83bProvincia mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new A83bProvincia(resultSet.getString("ID"),
					resultSet.getString("DS_O"),
					resultSet.getString("AUTONOMIA_ID"));
		}
	};

	/** The municipiorw map. */
	private RowMapper<A83bMunicipio> municipiorwMap = new RowMapper<A83bMunicipio>() {
		public A83bMunicipio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new A83bMunicipio(resultSet.getString("ID"),
					resultSet.getString("DS_O"),
					resultSet.getString("PROVINCIA_ID"));
		}
	};
	/** The callew map. */
	private RowMapper<Aa83bCalle> callewMap = new RowMapper<Aa83bCalle>() {
		public Aa83bCalle mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83bCalle(resultSet.getString("ID"),
					resultSet.getString("CALLE_COD"), 
					resultSet.getString("DS_O")+" ("+resultSet.getString("TIPO_VIA")+")",
					resultSet.getString("DS_E")+" ("+resultSet.getString("TIPO_VIA")+")",
					resultSet.getString("PROVINCIA_ID"),
					resultSet.getString("MUNICIPIO_ID"),
					resultSet.getString("TIPO_VIA"),
					resultSet.getString("TIPO_VIA_ID"),
					resultSet.getString("ESTADO"));
		}
	};
	
	private RowMapper<Aa83bCalle> callewMapId = new RowMapper<Aa83bCalle>() {
		public Aa83bCalle mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83bCalle(resultSet.getString("ID"));
		}
	};
	
	private RowMapper<Aa83bCalle> callewMapPorString = new RowMapper<Aa83bCalle>() {
		public Aa83bCalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa83bCalle(
				resultSet.getString("ID"),
				resultSet.getString("CALLE_COD"),
				resultSet.getString("DS_O"),
				resultSet.getString("TIPO_VIA")
			);
		}
	};
	
	private RowMapper<String> cpwMapId = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return resultSet.getString("CODIGO_POSTAL");
		}
	};
	
	private RowMapper<String> cpwMapTipoVia = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return resultSet.getString("DSC");
		}
	};
	
	private RowMapper<A83bLocalidad> rwMapLocalidad = new RowMapper<A83bLocalidad>() {
		public A83bLocalidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new A83bLocalidad(resultSet.getLong("ID"),
					resultSet.getString("DSO"),
					resultSet.getString("MUNICIPIOID"),
					resultSet.getString("PROVINCIAID"),
					resultSet.getLong("ENTIDADID"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public List<A83bMunicipio> findMunicipios(A83bMunicipio a83bmunicipio,
			JQGridRequestDto jqGridRequestDto) {
		// Voy a hacer que elija una provincia
		if (a83bmunicipio != null
				&& "-1".equals(a83bmunicipio.getProvincia_id())) {
			return new ArrayList<A83bMunicipio>();
		}
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT  t17i.id, t17i.ds_o, t17i.provincia_id "
						+ "FROM T17I.T17_MUNICIPIO t17i ");
		if (a83bmunicipio != null
				&& !"-1".equals(a83bmunicipio.getProvincia_id())) {
			StringBuffer where = new StringBuffer(50);
			where.append("WHERE t17i.PROVINCIA_ID = ?");
			query.append(where);
			params.add(a83bmunicipio.getProvincia_id());
		}
		StringBuffer order = new StringBuffer(50);
		order.append(" ORDER BY t17i.DS_O ASC");
		query.append(order);

		return (List<A83bMunicipio>) this.jdbcTemplate.query(query.toString(),
				municipiorwMap, params.toArray());

	}

	public List<A83bProvincia> findProvincias(A83bProvincia a83bprovincia,
			JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT  t17i.id, t17i.ds_o, t17i.autonomia_id "
						+ "FROM T17I.T17_PROVINCIA t17i ");
		if (a83bprovincia != null
				&& !"-1".equals(a83bprovincia.getAutonomia_id())) {
			StringBuffer where = new StringBuffer(50);
			where.append("WHERE t17i.AUTONOMIA_ID = ?");
			query.append(where);
			params.add(a83bprovincia.getAutonomia_id());
		}
		StringBuffer order = new StringBuffer(50);
		order.append(" ORDER BY t17i.DS_O ASC");
		query.append(order);

		return (List<A83bProvincia>) this.jdbcTemplate.query(query.toString(),
				provinciarwMap, params.toArray());
	}

	public A83bProvincia findProvinciasId(A83bProvincia a83bprovincia) {
		String query = "SELECT  t17i.id, t17i.ds_o, t17i.autonomia_id FROM T17I.T17_PROVINCIA t17i WHERE t17i.ID= ?";
		List<A83bProvincia> A83bProvinciaList = this.jdbcTemplate.query(
				query.toString(), provinciarwMap, a83bprovincia.getId());

		return (A83bProvincia) DataAccessUtils.uniqueResult(A83bProvinciaList);
	}

	public List<A83bComunidad> findComunidades(A83bComunidad a83bcomunidad,
			JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT  t17i.id, t17i.ds_o "
				+ "FROM T17I.T17_AUTONOMIA t17i ");

		StringBuffer order = new StringBuffer(3000);
		order.append(" ORDER BY t17i.DS_O ASC");
		query.append(order);

		return (List<A83bComunidad>) this.jdbcTemplate.query(query.toString(),
				comunidadrwMap, params.toArray());
	}

	public List<A83bPais> findPaises(A83bPais a83bPais,
			JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT  t17i.id, t17i.ds_o "
				+ "FROM T17I.T17_PAIS t17i ");

		StringBuffer order = new StringBuffer(3000);
		order.append(" ORDER BY t17i.DS_O ASC");
		query.append(order);

		return (List<A83bPais>) this.jdbcTemplate.query(query.toString(),
				paisrwMap, params.toArray());
	}

	public A83bPais findPaisesById(A83bPais a83bPais) {
		String query = "SELECT  t17i.id, t17i.ds_o FROM T17I.T17_PAIS t17i WHERE t17i.ID= ?";
		List<A83bPais> A83bPaisList = this.jdbcTemplate.query(query.toString(),
				paisrwMap, a83bPais.getId());

		return (A83bPais) DataAccessUtils.uniqueResult(A83bPaisList);
	}

	public List<Aa83bCalle> findCalles(Aa83bCalle Aa83bCalle,
			JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT CALLE.ID, CALLE.CALLE_COD,CALLE.DS_O,CALLE.DS_E,CALLE.PROVINCIA_ID,CALLE.MUNICIPIO_ID,");
		query.append(" CALLE.TIPO_VIA, CALLE.TIPO_VIA_ID,CALLE.ESTADO ");
		query.append(" FROM T17I.T17_CALLE CALLE RIGHT OUTER join t17i.t17_portal PORTAL on CALLE.ID=PORTAL.CALLE_ID ");
		query.append(" WHERE CALLE.PROVINCIA_ID=").append(Aa83bCalle.getProvincia_id());
		query.append(" AND CALLE.MUNICIPIO_ID=").append(Aa83bCalle.getMunicipio_id());
		if(StringUtils.isNotEmpty(Aa83bCalle.getDs_o())){
			query.append(" AND UPPER(CALLE.DS_O) LIKE '%").append(Aa83bCalle.getDs_o().toUpperCase()).append("%'");
		}
		query.append(" GROUP BY CALLE.ID,CALLE.CALLE_COD,CALLE.DS_O,CALLE.DS_E,CALLE.PROVINCIA_ID,CALLE.MUNICIPIO_ID,CALLE.TIPO_VIA, CALLE.TIPO_VIA_ID,CALLE.ESTADO");
		StringBuffer order = new StringBuffer(3000);
		order.append(" ORDER BY CALLE.DS_O ASC");
		query.append(order);
		return (List<Aa83bCalle>) this.jdbcTemplate.query(query.toString(),
				callewMap, params.toArray());
	}
	public List<Aa83bCalle> findCallesPorId(Aa83bCalle Aa83bCalle,
			JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT CALLE.ID");
		query.append(" FROM T17I.T17_CALLE CALLE");
		query.append(" WHERE CALLE.PROVINCIA_ID=").append(Aa83bCalle.getProvincia_id());
		query.append(" AND CALLE.MUNICIPIO_ID=").append(Aa83bCalle.getMunicipio_id());
		query.append(" AND CALLE.ID=").append(Aa83bCalle.getCalle_cod());
		return (List<Aa83bCalle>) this.jdbcTemplate.query(query.toString(),
				callewMapId, params.toArray());
	}
	
	public Aa83bCalle findCalle(Aa83bCalle Aa83bCalle,
			JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT  t1.ID ID, t1.CALLE_COD, t1.DS_O , t1.DS_E, t1.PROVINCIA_ID, t1.MUNICIPIO_ID, t1.TIPO_VIA, t1.TIPO_VIA_ID, t1.ESTADO "
				+ "FROM T17I.T17_CALLE t1");
		query.append(" WHERE t1.ID=").append(Aa83bCalle.getCalle_cod());
		List<Aa83bCalle> calle=(List<Aa83bCalle>) this.jdbcTemplate.query(query.toString(),
				callewMap, params.toArray());
		return calle.get(0);
	}
	public Aa83bCalle findCallePorString(Aa83bCalle aa83bCalle) {
		List<Object> params = new ArrayList<Object>();
		Aa83bCalle calleRetorno=new Aa83bCalle();
		StringBuffer query = new StringBuffer("SELECT  t1.ID ID, t1.CALLE_COD CALLE_COD, t1.DS_O DS_O, t1.TIPO_VIA TIPO_VIA"
				+ " FROM T17I.T17_CALLE t1");
		query.append(" WHERE t1.DS_O like '").append(aa83bCalle.getDs_o()).append("' AND t1.PROVINCIA_ID='").append(aa83bCalle.getProvincia_id()).append("' AND t1.MUNICIPIO_ID='").append(aa83bCalle.getMunicipio_id()).append("'");
		List<Aa83bCalle> calle=(List<Aa83bCalle>) this.jdbcTemplate.query(query.toString(),
				callewMapPorString, params.toArray());
		if(!calle.isEmpty()){
			calleRetorno=calle.get(0);
		}
		return calleRetorno;
	}
	public String findCodigoPostal(String id,int numero) {
		StringBuffer query = new StringBuffer("SELECT TRIM(CODIGO_POSTAL) CODIGO_POSTAL FROM T17I.T17_PORTAL  WHERE CALLE_ID =").append(id).append(" AND (NUMERO=").append(numero);
		query.append(" OR NUMERO=0)");
		String resultado="";
		List<String> codigo=this.jdbcTemplate.query(query.toString(),cpwMapId);
		if(!codigo.isEmpty()){
			resultado=(String)codigo.get(0);
		}
		return resultado;
	}
	
	public String findTipoViaPorDefecto() {
		StringBuffer query = new StringBuffer("SELECT t1.DS_C DSC FROM T17I.T17_TIPO_VIA t1 WHERE t1.ID = 'CL'");
		String tipoVia = "";
		List<String> resultado = this.jdbcTemplate.query(query.toString(), cpwMapTipoVia);
		if (!resultado.isEmpty()) {
			tipoVia = (String) resultado.get(0);
		}
		return tipoVia;
	}
	
	@Override
	public A83bMunicipio findMunicipiosId(A83bMunicipio a83bMunicipio) {
		// TODO Auto-generated method stub
		// Voy a hacer que elija una provincia

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT  t17i.id, t17i.ds_o, t17i.provincia_id "
						+ "FROM T17I.T17_MUNICIPIO t17i ");
		if (a83bMunicipio != null
				&& !"-1".equals(a83bMunicipio.getProvincia_id())) {
			StringBuffer where = new StringBuffer(50);
			where.append(" WHERE t17i.PROVINCIA_ID = ? ");
			where.append(" AND t17i.id = ? ");
			query.append(where);
			params.add(a83bMunicipio.getProvincia_id());
			params.add(a83bMunicipio.getId());
		}
		StringBuffer order = new StringBuffer(50);
		order.append(" ORDER BY t17i.DS_O ASC");
		query.append(order);

		List<A83bMunicipio> listaMunis = this.jdbcTemplate.query(
				query.toString(), municipiorwMap, params.toArray());
		if (listaMunis.size() != 0)
			return listaMunis.get(0);
		else
			return null;
	}
	
	@Transactional(readOnly = true)
	public A83bLocalidad  findProvMunLocalidadByCodPostal(String codigoPostal, String calleId, int numero){
		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder(
				"SELECT t1.ID ID, t1.DS_O DSO, t1.MUNICIPIO_ID MUNICIPIOID, t1.PROVINCIA_ID PROVINCIAID, t1.ENTIDAD_ID ENTIDADID FROM T17I.t17_localidad t1 WHERE ID=(");
		query.append("SELECT  * FROM ( ");
		query.append("select distinct(t2.localidad_id) from t17i.t17_portal t2 ");
		query.append("WHERE 1=1");

		if (codigoPostal != null) {
			query.append(" AND TRIM(t2.CODIGO_POSTAL) = ? AND CALLE_ID = ? AND NUMERO = ?");
			params.add(codigoPostal);
			params.add(calleId);
			params.add(numero);
		}
		query.append(" ORDER BY t2.localidad_id ASC");
		query.append(") WHERE ROWNUM <= 1");
		query.append(")");

		return (A83bLocalidad) this.jdbcTemplate.queryForObject(
				query.toString(), rwMapLocalidad, params.toArray());
	}
}
