package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import com.ejie.aa83b.dao.Aa83bEstadisticasDao;

import com.ejie.aa83b.model.Aa83bContadorGraficos;
import com.ejie.aa83b.model.Aa83bContadorNacionalidad;
import com.ejie.aa83b.model.Aa83bContadorTerritorios;
import com.ejie.aa83b.model.Aa83bEstadisticasBusqueda;
import com.ejie.aa83b.model.Aa83bEstadisticasFechas;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

@Repository
@Transactional
public class Aa83bEstadisticasDaoImpl implements Aa83bEstadisticasDao {

	/** The jdbc template. */
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/** The contador Busqueda Standard map. */
	private RowMapper<Aa83bEstadisticasBusqueda> contrSMap = new RowMapper<Aa83bEstadisticasBusqueda>() {
		public Aa83bEstadisticasBusqueda mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83bEstadisticasBusqueda(
					resultSet.getString("tipo_Sol"), resultSet.getInt("anyo"),
					resultSet.getInt("id"), resultSet.getString("desc_es"),
					resultSet.getString("desc_eu"),
					resultSet.getDate("f_actu"), resultSet.getInt("mes"),
					resultSet.getString("ds_o"), resultSet.getString("ds_o"),
					resultSet.getString("ds_e_nacionalidad"),
					resultSet.getString("ds_c_nacionalidad"));
		}
	};
	/** The contadorNacionalidad map. */
	private RowMapper<Aa83bContadorNacionalidad> contrwMap = new RowMapper<Aa83bContadorNacionalidad>() {
		public Aa83bContadorNacionalidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83bContadorNacionalidad(
					resultSet.getInt("NACIONALIDAD_021"),
					resultSet.getInt("MES"), resultSet.getInt("ANYO"),
					resultSet.getInt("TOTAL"), resultSet.getString("DS_O"),
					resultSet.getString("DS_O"));
		}
	};
	/** The contadorTerritorios map. */
	private RowMapper<Aa83bContadorTerritorios> contrTMap = new RowMapper<Aa83bContadorTerritorios>() {
		public Aa83bContadorTerritorios mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83bContadorTerritorios(resultSet.getInt("mes"),
					resultSet.getInt("total"), resultSet.getInt("provincia"),
					resultSet.getString("ds_o"), resultSet.getString("ds_o"),
					resultSet.getString("desc_es"),
					resultSet.getString("desc_eu"));
		}
	};
	/** The contadorGraficos map. */
	private RowMapper<Aa83bContadorGraficos> contrGMap = new RowMapper<Aa83bContadorGraficos>() {
		public Aa83bContadorGraficos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83bContadorGraficos(resultSet.getInt("arraigo"),
					resultSet.getInt("adecuacion"),
					resultSet.getInt("esfuerzo"), resultSet.getInt("mes"),
					resultSet.getInt("anyo"));
		}
	};
	/** The dates */
	private RowMapper<Aa83bEstadisticasFechas> contrFMap = new RowMapper<Aa83bEstadisticasFechas>() {
		public Aa83bEstadisticasFechas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83bEstadisticasFechas(resultSet.getDate("MINACC"),
					resultSet.getDate("MAXACC"));
		}
	};

	public List<Aa83bContadorNacionalidad> contar(
			Aa83bContadorNacionalidad cont, JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();
		StringBuffer query = new StringBuffer(
				"SELECT COUNT(t1.NACIONALIDAD_021) AS TOTAL, NACIONALIDAD_021,  EXTRACT( MONTH FROM F_ACTU_006) AS MES, EXTRACT( YEAR FROM F_ACTU_006) AS ANYO, DS_O FROM AA83B21T00 t1, T17i.T17_PAIS, AA83B06T00 t6 "
						+ "WHERE T17_PAIS.ID = t1.NACIONALIDAD_021 AND t1.ID_021 = t6.ID_021_NUM_SOL AND t1.ID_ANO_021 = t6.ID_ANO_021 AND  t6.TIPO_MODIF_038 = 'A' GROUP BY NACIONALIDAD_021, DS_O, EXTRACT( MONTH FROM F_ACTU_006), EXTRACT( YEAR FROM F_ACTU_006) ORDER BY ANYO ASC, MES ASC, total DESC");
		return (List<Aa83bContadorNacionalidad>) this.jdbcTemplate.query(
				query.toString(), contrwMap, params.toArray());
	}

	public List<Aa83bContadorNacionalidad> contarADE(
			Aa83bContadorNacionalidad estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(t1.NACIONALIDAD_021) AS TOTAL, NACIONALIDAD_021,  EXTRACT( MONTH FROM F_ACTU_006) AS MES, EXTRACT( YEAR FROM F_ACTU_006) AS ANYO, DS_O");
		query.append(" FROM AA83B21T00 t1, T17i.T17_PAIS, AA83B06T00 t6 ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapContADE(estadBusq,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE T17_PAIS.ID = t1.NACIONALIDAD_021"
						+ " AND t1.ID_021 = t6.ID_021_NUM_SOL"
						+ " AND t1.ID_ANO_021 = t6.ID_ANO_021"
						+ " AND t6.TIPO_MODIF_038 = 'A'");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY NACIONALIDAD_021, DS_O, EXTRACT( MONTH FROM F_ACTU_006), EXTRACT( YEAR FROM F_ACTU_006) ORDER BY ANYO ASC, MES ASC, total DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bContadorNacionalidad>) this.jdbcTemplate.query(
				query.toString(), this.contrwMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMapContADE(
			Aa83bContadorNacionalidad estB, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t6.F_ACTU_006 >= trunc(to_date(?,'dd/mm/yyyy'))");

			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t6.F_ACTU_006 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t6.F_ACTU_006 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t6.F_ACTU_006 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bContadorNacionalidad> contarPorArraigo(
			Aa83bContadorNacionalidad estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(t1.NACIONALIDAD_025) AS TOTAL, NACIONALIDAD_025 AS NACIONALIDAD_021, EXTRACT( MONTH FROM F_ACTU_008) AS MES, EXTRACT( YEAR FROM F_ACTU_008) AS ANYO, DS_O");
		query.append(" FROM AA83B25T00 t1, T17i.T17_PAIS, AA83B08T00 t8");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapContArr(estadBusq,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE T17_PAIS.ID = t1.NACIONALIDAD_025"
						+ " AND t1.ID_025 = t8.ID_025_NUM_SOL"
						+ " AND t1.ID_ANO_025 = t8.ID_ANO_025"
						+ " AND  t8.TIPO_MODIF_038 = 'A'");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY NACIONALIDAD_025, DS_O, EXTRACT( MONTH FROM F_ACTU_008), EXTRACT( YEAR FROM F_ACTU_008) ORDER BY ANYO ASC, MES ASC, total DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bContadorNacionalidad>) this.jdbcTemplate.query(
				query.toString(), this.contrwMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMapContArr(
			Aa83bContadorNacionalidad estB, Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t8.F_ACTU_008 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t8.F_ACTU_008 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t8.F_ACTU_008 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t8.F_ACTU_008 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bContadorNacionalidad> contarPorIntegracion(
			Aa83bContadorNacionalidad estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(t1.NACIONALIDAD_023) AS TOTAL, NACIONALIDAD_023 AS NACIONALIDAD_021, EXTRACT( MONTH FROM F_ACTU_007) AS MES, EXTRACT( YEAR FROM F_ACTU_007) AS ANYO, DS_O ");
		query.append(" FROM AA83B23T00 t1, T17i.T17_PAIS, AA83B07T00 t7");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapContEsf(estadBusq,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE T17_PAIS.ID = t1.NACIONALIDAD_023"
						+ " AND t1.ID_023 = t7.ID_023_NUM_SOL"
						+ " AND t1.ID_ANO_023 = t7.ID_ANO_023"
						+ " AND  t7.TIPO_MODIF_038 = 'A' ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY NACIONALIDAD_023, DS_O, EXTRACT( MONTH FROM F_ACTU_007), EXTRACT( YEAR FROM F_ACTU_007) ORDER BY ANYO ASC, MES ASC, total DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bContadorNacionalidad>) this.jdbcTemplate.query(
				query.toString(), this.contrwMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMapContEsf(
			Aa83bContadorNacionalidad estB, Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t7.F_ACTU_007 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t7.F_ACTU_007 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t7.F_ACTU_007 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t7.F_ACTU_007 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	@SuppressWarnings("rawtypes")
	public List<Aa83bContadorNacionalidad> contarTodas(
			Aa83bContadorNacionalidad estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT count(NACIONALIDAD) AS TOTAL, NACIONALIDAD AS NACIONALIDAD_021,"
						+ " MES, ANYO, DS_O FROM ("
						+ " SELECT NACIONALIDAD_021 AS NACIONALIDAD,"
						+ " EXTRACT(MONTH FROM F_ACTU_006) AS MES,"
						+ " EXTRACT(YEAR FROM F_ACTU_006) AS ANYO, DS_O "
						+ " FROM AA83B21T00 t1, T17i.T17_PAIS, AA83B06T00 t6 ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapContTodas1(estadBusq,
				startsWith);
		Map<String, ?> mapaWhere2 = this.getWhereLikeMapContTodas2(estadBusq,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE T17_PAIS.ID = t1.NACIONALIDAD_021 "
						+ " AND t1.ID_021 = t6.ID_021_NUM_SOL "
						+ " AND t1.ID_ANO_021 = t6.ID_ANO_021 "
						+ " AND t6.TIPO_MODIF_038 = 'A' ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		StringBuilder query2 = new StringBuilder(
				" UNION ALL SELECT NACIONALIDAD_023 AS NACIONALIDAD,"
						+ " EXTRACT(MONTH FROM F_ACTU_007) AS MES,"
						+ " EXTRACT(YEAR FROM F_ACTU_007) AS ANYO, DS_O"
						+ " FROM AA83B23T00 t1, T17i.T17_PAIS, AA83B07T00 t7 ");
		StringBuilder where2 = new StringBuilder(
				" WHERE T17_PAIS.ID = t1.NACIONALIDAD_023"
						+ " AND t1.ID_023 = t7.ID_023_NUM_SOL"
						+ " AND t1.ID_ANO_023 = t7.ID_ANO_023"
						+ " AND t7.TIPO_MODIF_038 = 'A' ");
		where2.append(mapaWhere2.get("query"));
		query2.append(where2);

		StringBuilder query3 = new StringBuilder(
				" UNION ALL SELECT NACIONALIDAD_025 AS NACIONALIDAD,"
						+ " EXTRACT(MONTH FROM F_ACTU_008) AS MES,"
						+ " EXTRACT(YEAR FROM F_ACTU_008) AS ANYO, DS_O ");
		query3.append(" FROM AA83B25T00 t1, T17i.T17_PAIS, AA83B08T00 t8");
		StringBuilder where3 = new StringBuilder(
				" WHERE T17_PAIS.ID = t1.NACIONALIDAD_025"
						+ " AND t1.ID_025 = t8.ID_025_NUM_SOL"
						+ " AND t1.ID_ANO_025 = t8.ID_ANO_025"
						+ " AND t8.TIPO_MODIF_038 = 'A' ");
		Map<String, ?> mapaWhere3 = this.getWhereLikeMapContTodas3(estadBusq,
				startsWith);

		where3.append(mapaWhere3.get("query"));
		query3.append(where3);
		query2.append(query3);
		query.append(query2);
		query.append(") GROUP BY NACIONALIDAD, MES, ANYO, DS_O "
				+ " ORDER BY ANYO ASC, MES ASC");

		List<?> params = (List<?>) mapaWhere.get("params");
		List<?> params2 = (List<?>) mapaWhere2.get("params");
		List<?> params3 = (List<?>) mapaWhere3.get("params");
		List params4 = new ArrayList();
		params4.addAll(params);
		params4.addAll(params2);
		params4.addAll(params3);
		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bContadorNacionalidad>) this.jdbcTemplate.query(
				query.toString(), this.contrwMap, params4.toArray());

	}

	private Map<String, Object> getWhereLikeMapContTodas1(
			Aa83bContadorNacionalidad estB, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t6.F_ACTU_006 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t6.F_ACTU_006 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t6.F_ACTU_006 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t6.F_ACTU_006 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMapContTodas2(
			Aa83bContadorNacionalidad estB, Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t7.F_ACTU_007 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t7.F_ACTU_007 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t7.F_ACTU_007 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t7.F_ACTU_007 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMapContTodas3(
			Aa83bContadorNacionalidad estB, Boolean startsWith) {
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t8.F_ACTU_008 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t8.F_ACTU_008 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t8.F_ACTU_008 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t8.F_ACTU_008 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bContadorTerritorios> contTerritoriosHab(
			Aa83bContadorTerritorios estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"select count (*) AS TOTAL, PROV_EMP_021 AS PROVINCIA, t.DS_O, DESC_ES_017 AS DESC_ES, DESC_EU_017 AS DESC_EU, EXTRACT( MONTH FROM F_ACTU_006) AS MES"
						+ " from AA83B21T00 a, T17i.T17_provincia t, T17i.T17_PAIS, AA83B17T00 g, AA83B06T00 h");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapT(estadBusq, startsWith);
		StringBuilder where = new StringBuilder(" WHERE a.PROV_EMP_021 = t.ID"
				+ " AND T17_PAIS.ID = a.NACIONALIDAD_021"
				+ " AND a.ID_017_GENERO = g.ID_017 "
				+ "AND h.ID_ANO_021 = a.ID_ANO_021 "
				+ "AND h.ID_021_NUM_SOL = a.ID_021 "
				+ "AND h.TIPO_MODIF_038 = 'A' ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" group by PROV_EMP_021, t.DS_O, DESC_ES_017, DESC_EU_017, EXTRACT( MONTH FROM F_ACTU_006) "
				+ " ORDER BY MES ASC, PROV_EMP_021, DESC_ES_017, total DESC");

		List<?> params = (List<?>) mapaWhere.get("params");
		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bContadorTerritorios>) this.jdbcTemplate.query(
				query.toString(), this.contrTMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMapT(Aa83bContadorTerritorios estB,
			Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND  h.F_ACTU_006 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND  h.F_ACTU_006 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND  h.F_ACTU_006 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND  h.F_ACTU_006 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bContadorTerritorios> contTerritoriosArr(
			Aa83bContadorTerritorios estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"select count (*) AS TOTAL, PROV_EMP_025 AS PROVINCIA, t.DS_O, DESC_ES_017 AS DESC_ES, DESC_EU_017 AS DESC_EU, EXTRACT( MONTH FROM F_ACTU_008) AS MES "
						+ " from AA83B25T00 a, T17i.T17_provincia t,  T17i.T17_PAIS, AA83B17T00 g, AA83B08T00 h");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapTArr(estadBusq,
				startsWith);
		StringBuilder where = new StringBuilder(" where a.PROV_EMP_025 = t.ID"
				+ " AND T17_PAIS.ID = a.NACIONALIDAD_025"
				+ " AND a.ID_017_GENERO = g.ID_017"
				+ " AND h.ID_ANO_025 = a.ID_ANO_025"
				+ " AND h.ID_025_NUM_SOL = a.ID_025"
				+ " AND h.TIPO_MODIF_038 = 'A'");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" group by PROV_EMP_025,t.DS_O, DESC_ES_017, DESC_EU_017, EXTRACT( MONTH FROM F_ACTU_008) "
				+ " ORDER BY MES ASC, PROV_EMP_025, DESC_ES_017, total DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bContadorTerritorios>) this.jdbcTemplate.query(
				query.toString(), this.contrTMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMapTArr(
			Aa83bContadorTerritorios estB, Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND h.F_ACTU_008 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND h.F_ACTU_008 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND h.F_ACTU_008 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND h.F_ACTU_008 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bContadorTerritorios> contTerritoriosEsf(
			Aa83bContadorTerritorios estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"select count (*) AS TOTAL, PROV_EMP_023 AS PROVINCIA, t.DS_O, DESC_ES_017 AS DESC_ES, DESC_EU_017 AS DESC_EU, EXTRACT( MONTH FROM F_ACTU_007) AS MES "
						+ " from AA83B23T00 a, T17i.T17_provincia t, T17i.T17_PAIS, AA83B17T00 g, AA83B07T00 h");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapTEsf(estadBusq,
				startsWith);
		StringBuilder where = new StringBuilder(" where a.PROV_EMP_023 = t.ID"
				+ " AND T17_PAIS.ID = a.NACIONALIDAD_023"
				+ " AND a.ID_017_GENERO = g.ID_017"
				+ " AND h.ID_ANO_023 = a.ID_ANO_023"
				+ " AND h.ID_023_NUM_SOL = a.ID_023"
				+ " AND h.TIPO_MODIF_038 = 'A'");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" group by PROV_EMP_023,t.DS_O, DESC_ES_017, DESC_EU_017, EXTRACT( MONTH FROM F_ACTU_007) "
				+ " ORDER BY MES ASC, PROV_EMP_023, DESC_ES_017, total DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bContadorTerritorios>) this.jdbcTemplate.query(
				query.toString(), this.contrTMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMapTEsf(
			Aa83bContadorTerritorios estB, Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND h.F_ACTU_007 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND h.F_ACTU_007 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND h.F_ACTU_007 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND h.F_ACTU_007 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bContadorGraficos> contGraficos(Aa83bContadorGraficos cont,
			JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();
		StringBuffer query = new StringBuffer(
				"Select SUM(Arraigo) AS Arraigo, SUM(Ade) AS Adecuacion, SUM(Esf) As Esfuerzo, mes, anyo from(select count(h.ID_025_NUM_SOL) AS Arraigo, 0 as Ade, 0 AS Esf, EXTRACT( MONTH FROM F_ACTU_008) AS MES, EXTRACT( YEAR FROM F_ACTU_008) AS ANYO"
						+ " from AA83B25T00 a, AA83B08T00 h"
						+ " where h.ID_025_NUM_SOL = a.ID_025"
						+ " AND h.TIPO_MODIF_038 = 'A'"
						+ " group by EXTRACT( MONTH FROM F_ACTU_008),EXTRACT( YEAR FROM F_ACTU_008)"
						+ " union all"
						+ " select 0 AS Arraigo, count(i.ID_021_NUM_SOL) AS Ade, 0 AS Esf, EXTRACT( MONTH FROM F_ACTU_006) AS MES, EXTRACT( YEAR FROM F_ACTU_006) AS ANYO"
						+ " from AA83B21T00 b, AA83B06T00 i"
						+ " where i.ID_021_NUM_SOL = b.ID_021"
						+ " AND i.TIPO_MODIF_038 = 'A'"
						+ " group by EXTRACT( MONTH FROM F_ACTU_006),EXTRACT( YEAR FROM F_ACTU_006)"
						+ " union all"
						+ " select 0 AS Arraigo, 0 AS Ade, count(i.ID_023_NUM_SOL) AS Esf, EXTRACT( MONTH FROM F_ACTU_007) AS MES, EXTRACT( YEAR FROM F_ACTU_007) AS ANYO"
						+ " from AA83B23T00 b, AA83B07T00 i"
						+ " where i.ID_023_NUM_SOL = b.ID_023"
						+ " AND i.TIPO_MODIF_038 = 'A'"
						+ " group by EXTRACT( MONTH FROM F_ACTU_007), EXTRACT( YEAR FROM F_ACTU_007))"
						+ " group by mes,anyo ORDER BY  anyo asc, MES asc");
		return (List<Aa83bContadorGraficos>) this.jdbcTemplate.query(
				query.toString(), contrGMap, params.toArray());

	}

	public List<Aa83bEstadisticasBusqueda> estadBusquedaADE(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT 'HAB' AS tipo_Sol, t1.ID_ANO_021 As anyo, t1.ID_021 AS id, "
						+ " t17.DESC_ES_017 AS desc_es, t17.DESC_EU_017 as desc_eu, t6.F_ACTU_006 as f_actu, "
						+ " EXTRACT( MONTH FROM F_ACTU_006) AS mes,  T17I.T17_PROVINCIA.DS_O AS ds_o, T17i.T17_PAIS.DS_E AS ds_e_nacionalidad, T17i.T17_PAIS.DS_C AS ds_c_nacionalidad ");
		query.append(" FROM AA83B.AA83B21T00 t1, T17I.T17_PROVINCIA, AA83B.AA83B06T00 t6, AA83B.AA83B17T00 t17, T17i.T17_PAIS ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(estadBusq, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE T17_PROVINCIA.ID = t1.PROV_EMP_021 "
						+ " AND t1.ID_021 = t6.ID_021_NUM_SOL "
						+ " AND t1.ID_ANO_021 = t6.ID_ANO_021 "
						+ " AND t6.TIPO_MODIF_038 = 'A' "
						+ " AND t1.ID_017_GENERO = t17.ID_017 "
						+ " AND T17_PAIS.ID = t1.NACIONALIDAD_021 "
						+ " AND t6.ROWID IN ("
						+ " SELECT MAX(z.ROWID) FROM AA83B.AA83B06T00 z "
						+ " WHERE z.TIPO_MODIF_038 = 'A' "
						+ " GROUP BY z.ID_021_NUM_SOL)");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY F_ACTU_006 ASC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bEstadisticasBusqueda>) this.jdbcTemplate.query(
				query.toString(), this.contrSMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMap(Aa83bEstadisticasBusqueda estB,
			Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t6.F_ACTU_006 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t6.F_ACTU_006 <= trunc(to_date(?,'dd/mm/yyyy'))+1");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t6.F_ACTU_006 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t6.F_ACTU_006 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bEstadisticasBusqueda> estadBusquedaARR(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT 'ARR' AS TIPO_SOL, t1.ID_ANO_025 As anyo, t1.ID_025 AS ID, t17.DESC_ES_017 AS desc_es, t17.DESC_EU_017 as desc_eu, t8.F_ACTU_008 as f_actu, EXTRACT( MONTH FROM F_ACTU_008) AS MES, T17I.T17_PROVINCIA.DS_O AS ds_o, T17i.T17_PAIS.DS_E AS ds_e_nacionalidad, T17i.T17_PAIS.DS_C AS ds_c_nacionalidad");
		query.append(" FROM AA83B25T00 t1, T17I.T17_PROVINCIA, AA83B08T00 t8, AA83B17T00 t17, T17i.T17_PAIS");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapArr(estadBusq,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE T17_PROVINCIA.ID = t1.PROV_EMP_025 "
						+ " AND t1.ID_025 = t8.ID_025_NUM_SOL"
						+ " AND t1.ID_ANO_025 = t8.ID_ANO_025"
						+ " AND t8.TIPO_MODIF_038 = 'A'"
						+ " AND t1.ID_017_GENERO = t17.ID_017"
						+ " AND T17_PAIS.ID = t1.NACIONALIDAD_025 "
						+ " AND t8.ROWID IN ("
						+ " SELECT MAX(z.ROWID) FROM AA83B.AA83B08T00 z "
						+ " WHERE z.TIPO_MODIF_038 = 'A' "
						+ " GROUP BY z.ID_025_NUM_SOL)");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY F_ACTU_008 ASC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bEstadisticasBusqueda>) this.jdbcTemplate.query(
				query.toString(), this.contrSMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMapArr(
			Aa83bEstadisticasBusqueda estB, Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t8.F_ACTU_008 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t8.F_ACTU_008 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t8.F_ACTU_008 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t8.F_ACTU_008 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bEstadisticasBusqueda> estadBusquedaESF(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT 'ESF' AS TIPO_SOL, t1.ID_ANO_023 As anyo, t1.ID_023 AS ID, t17.DESC_ES_017 AS desc_es, t17.DESC_EU_017 as desc_eu, t7.F_ACTU_007 as f_actu, EXTRACT( MONTH FROM F_ACTU_007) AS MES, T17I.T17_PROVINCIA.DS_O AS ds_o, "
						+ "T17i.T17_PAIS.DS_E AS ds_e_nacionalidad, T17i.T17_PAIS.DS_C AS ds_c_nacionalidad");
		query.append(" FROM AA83B23T00 t1, T17I.T17_PROVINCIA, AA83B07T00 t7, AA83B17T00 t17, T17i.T17_PAIS");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapEsf(estadBusq,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE T17_PROVINCIA.ID = t1.PROV_EMP_023"
						+ " AND t1.ID_023 = t7.ID_023_NUM_SOL"
						+ " AND t1.ID_ANO_023 = t7.ID_ANO_023"
						+ " AND  t7.TIPO_MODIF_038 = 'A'"
						+ " AND t1.ID_017_GENERO = t17.ID_017"
						+ " AND T17_PAIS.ID = t1.NACIONALIDAD_023 "
						+ " AND t7.ROWID IN ("
						+ " SELECT MAX(z.ROWID) FROM AA83B.AA83B07T00 z "
						+ " WHERE z.TIPO_MODIF_038 = 'A' "
						+ " GROUP BY z.ID_023_NUM_SOL)");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY F_ACTU_007 ASC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83bEstadisticasBusqueda>) this.jdbcTemplate.query(
				query.toString(), this.contrSMap, params.toArray());

	}

	private Map<String, Object> getWhereLikeMapEsf(
			Aa83bEstadisticasBusqueda estB, Boolean startsWith) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(Aa83BConstants.ES_PATTERN);
		String fechaD2;
		String fechaH2;
		fechaD2 = formatoDelTexto.format(estB.getfDesde());
		fechaH2 = formatoDelTexto.format(estB.getfHasta());
		StringBuilder where = new StringBuilder(
				Aa83bEstadisticasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estB != null && estB.getfDesde() != null) {
			where.append(" AND t7.F_ACTU_007 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add(fechaD2);
		}
		if (estB != null && estB.getfHasta() != null) {
			where.append(" AND t7.F_ACTU_007 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add(fechaH2);

		}
		if (estB != null && estB.getfDesde() == null) {
			where.append(" AND t7.F_ACTU_007 >= trunc(to_date(?,'dd/mm/yyyy'))");
			params.add("01/01/2010");
		}
		if (estB != null && estB.getfHasta() == null) {
			where.append(" AND t7.F_ACTU_007 <= trunc(to_date(?,'dd/mm/yyyy'))+1 ");
			params.add("01/01/2020");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		return mapWhere;
	}

	public List<Aa83bEstadisticasFechas> fMinMax(Aa83bEstadisticasFechas cont,
			JQGridRequestDto jqGridRequestDto) {
		List<Object> params = new ArrayList<Object>();
		StringBuffer query = new StringBuffer(
				"select MIN (MINACC) AS MINACC, MAX (MAXACC) AS MAXACC FROM ("
						+ " select MIN(F_ACTU_006) AS MINACC, MAX(F_ACTU_006) AS MAXACC  from AA83B06T00"
						+ " where TIPO_MODIF_038 = 'A'"
						+ " UNION ALL"
						+ " select MIN(F_ACTU_007) AS MINACC, MAX(F_ACTU_007) AS MAXACC from AA83B07T00"
						+ " where TIPO_MODIF_038 = 'A'"
						+ " UNION ALL"
						+ " select MIN(F_ACTU_008) AS MINACC, MAX(F_ACTU_008) AS MAXACC from AA83B08T00"
						+ " where TIPO_MODIF_038 = 'A')");
		return (List<Aa83bEstadisticasFechas>) this.jdbcTemplate.query(
				query.toString(), contrFMap, params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
