package com.ejie.aa83b.dao;

import java.util.List;

import com.ejie.aa83b.model.Aa83bContadorGraficos;
import com.ejie.aa83b.model.Aa83bContadorNacionalidad;
import com.ejie.aa83b.model.Aa83bContadorTerritorios;
import com.ejie.aa83b.model.Aa83bEstadisticasBusqueda;
import com.ejie.aa83b.model.Aa83bEstadisticasFechas;
import com.ejie.x38.dto.JQGridRequestDto;

public interface Aa83bEstadisticasDao {
	/**
	 * Finds a List of countries.
	 * 
	 * @param a83bcomunidad
	 *            A83bComunidad
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa83bContadorNacionalidad> contar(Aa83bContadorNacionalidad cont,
			JQGridRequestDto jqGridRequestDto);

	List<Aa83bContadorNacionalidad> contarADE(Aa83bContadorNacionalidad cont,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finds a List of countries.
	 * 
	 * @param a83bcomunidad
	 *            A83bComunidad
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa83bContadorNacionalidad> contarPorArraigo(
			Aa83bContadorNacionalidad cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	List<Aa83bContadorNacionalidad> contarPorIntegracion(
			Aa83bContadorNacionalidad cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	List<Aa83bContadorNacionalidad> contarTodas(Aa83bContadorNacionalidad cont,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	List<Aa83bContadorTerritorios> contTerritoriosHab(
			Aa83bContadorTerritorios cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	List<Aa83bContadorTerritorios> contTerritoriosArr(
			Aa83bContadorTerritorios cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	List<Aa83bContadorTerritorios> contTerritoriosEsf(
			Aa83bContadorTerritorios cont, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	List<Aa83bContadorGraficos> contGraficos(Aa83bContadorGraficos cont,
			JQGridRequestDto jqGridRequestDto);

	List<Aa83bEstadisticasBusqueda> estadBusquedaADE(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	List<Aa83bEstadisticasBusqueda> estadBusquedaARR(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	List<Aa83bEstadisticasBusqueda> estadBusquedaESF(
			Aa83bEstadisticasBusqueda estadBusq,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	List<Aa83bEstadisticasFechas> fMinMax(Aa83bEstadisticasFechas estadBusq,
			JQGridRequestDto jqGridRequestDto);
}
