package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83bCierres;

/**
 * CierresDaoImpl generated by UDA, 13-mar-2017 13:44:14.
 * @author UDA
 */
 
@Repository
@Transactional
public class Aa83bCierresDaoImpl implements Aa83bCierresDao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83bCierres> rwMap = new RowMapper<Aa83bCierres>() {
		public Aa83bCierres mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Aa83bCierres(
               resultSet.getInt("IDHISTORIAL"), resultSet.getInt("ID001FASE"), resultSet.getInt("ID002TRAM"), resultSet.getInt("ID003TIPOSOL"), resultSet.getInt("IDSOL"), resultSet.getLong("IDANO"), resultSet.getDate("FACTU"), resultSet.getString("USUA"), resultSet.getDate("FREGSAL"), resultSet.getDate("FNOTIF"), resultSet.getDate("FEXPIR"), resultSet.getDate("FMODIF"), resultSet.getString("USUMOD"), resultSet.getDate("FTRAM")
           ); } } ;
           
	private RowMapper<Aa83bCierres> rwMapPK = new RowMapper<Aa83bCierres>() {
		public Aa83bCierres mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa83bCierres(
				resultSet.getInt("IDHISTORIAL"), resultSet.getInt("ID001FASE"), resultSet.getInt("ID002TRAM"), resultSet.getInt("ID003TIPOSOL"), resultSet.getInt("IDSOL"), resultSet.getLong("IDANO"), resultSet.getDate("FACTU"), resultSet.getString("USUA"), resultSet.getDate("FREGSAL"), resultSet.getDate("FNOTIF"), resultSet.getDate("FEXPIR"), resultSet.getDate("FMODIF"), resultSet.getString("USUMOD"), resultSet.getDate("FTRAM")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
     * @param dataSource DataSource
     * @return
     */
	private RowMapper<JerarquiaDto< Aa83bCierres>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83bCierres>>() {
		public JerarquiaDto<Aa83bCierres> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Aa83bCierres cierres = new Aa83bCierres(resultSet.getInt("IDHISTORIAL"), resultSet.getInt("ID001FASE"), resultSet.getInt("ID002TRAM"), resultSet.getInt("ID003TIPOSOL"), resultSet.getInt("IDSOL"), resultSet.getLong("IDANO"), resultSet.getDate("FACTU"), resultSet.getString("USUA"), resultSet.getDate("FREGSAL"), resultSet.getDate("FNOTIF"), resultSet.getDate("FEXPIR"), resultSet.getDate("FMODIF"), resultSet.getString("USUMOD"), resultSet.getDate("FTRAM"));

			JerarquiaDto<Aa83bCierres> jerarquia = new JerarquiaDto<Aa83bCierres>();
			jerarquia.setModel(cierres);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
     * Inserts a single row in the Cierres table.
     *
     * @param cierres Cierres
     * @return Cierres
     */
	public Aa83bCierres add(Aa83bCierres cierres) {
    	String query = "INSERT INTO CIERRES (ID_HISTORIAL, ID001FASE, ID002TRAM, ID003TIPOSOL, IDSOL, IDANO, FACTU, USUA, FREGSAL, FNOTIF, FEXPIR, FMODIF, USUMOD, FTRAM) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, cierres.getIdHistorial(), cierres.getId001fase(), cierres.getId002tram(), cierres.getId003tiposol(), cierres.getIdsol(), cierres.getIdano(), cierres.getFactu(), cierres.getUsua(), cierres.getFregsal(), cierres.getFnotif(), cierres.getFexpir(), cierres.getFmodif(), cierres.getUsumod(), cierres.getFtram());
		return cierres;
	}

    /**
     * Updates a single row in the Cierres table.
     *
     * @param cierres Cierres
     * @return Cierres
     */
    public Aa83bCierres update(Aa83bCierres cierres) {
		String query = "UPDATE CIERRES SET  WHERE ID_HISTORIAL=? AND ID001FASE=? AND ID002TRAM=? AND ID003TIPOSOL=? AND IDSOL=? AND IDANO=? AND FACTU=? AND USUA=? AND FREGSAL=? AND FNOTIF=? AND FEXPIR=? AND FMODIF=? AND USUMOD=? AND FTRAM=?";
		this.jdbcTemplate.update(query, cierres.getIdHistorial(), cierres.getId001fase(), cierres.getId002tram(), cierres.getId003tiposol(), cierres.getIdsol(), cierres.getIdano(), cierres.getFactu(), cierres.getUsua(), cierres.getFregsal(), cierres.getFnotif(), cierres.getFexpir(), cierres.getFmodif(), cierres.getUsumod(), cierres.getFtram());
		return cierres;
	}

    /**
     * Finds a single row in the Cierres table.
     *
     * @param cierres Cierres
     * @return Cierres
     */
    @Transactional (readOnly = true)
    public Aa83bCierres find(Aa83bCierres cierres) {
		String query = "SELECT t1.ID_HISTORIAL IDHISTORIAL, t1.ID001FASE ID001FASE, t1.ID002TRAM ID002TRAM, t1.ID003TIPOSOL ID003TIPOSOL, t1.IDSOL IDSOL, t1.IDANO IDANO, t1.FACTU FACTU, t1.USUA USUA, t1.FREGSAL FREGSAL, t1.FNOTIF FNOTIF, t1.FEXPIR FEXPIR, t1.FMODIF FMODIF, t1.USUMOD USUMOD, t1.FTRAM FTRAM FROM CIERRES t1  WHERE t1.ID_HISTORIAL = ?   AND t1.ID001FASE = ?   AND t1.ID002TRAM = ?   AND t1.ID003TIPOSOL = ?   AND t1.IDSOL = ?   AND t1.IDANO = ?   AND t1.FACTU = ?   AND t1.USUA = ?   AND t1.FREGSAL = ?   AND t1.FNOTIF = ?   AND t1.FEXPIR = ?   AND t1.FMODIF = ?   AND t1.USUMOD = ?   AND t1.FTRAM = ?  ";
		
		List<Aa83bCierres> cierresList = this.jdbcTemplate.query(query, this.rwMap, cierres.getIdHistorial() , cierres.getId001fase() , cierres.getId002tram() , cierres.getId003tiposol() , cierres.getIdsol() , cierres.getIdano() , cierres.getFactu() , cierres.getUsua() , cierres.getFregsal() , cierres.getFnotif() , cierres.getFexpir() , cierres.getFmodif() , cierres.getUsumod() , cierres.getFtram());
		return (Aa83bCierres) DataAccessUtils.uniqueResult(cierresList);
    }

    /**
     * Removes a single row in the Cierres table.
     *
     * @param cierres Cierres
     * @return
     */
    public void remove(Aa83bCierres cierres) {
		String query = "DELETE FROM CIERRES WHERE ID_HISTORIAL=? AND ID001FASE=? AND ID002TRAM=? AND ID003TIPOSOL=? AND IDSOL=? AND IDANO=? AND FACTU=? AND USUA=? AND FREGSAL=? AND FNOTIF=? AND FEXPIR=? AND FMODIF=? AND USUMOD=? AND FTRAM=?";
		this.jdbcTemplate.update(query, cierres.getIdHistorial() , cierres.getId001fase() , cierres.getId002tram() , cierres.getId003tiposol() , cierres.getIdsol() , cierres.getIdano() , cierres.getFactu() , cierres.getUsua() , cierres.getFregsal() , cierres.getFnotif() , cierres.getFexpir() , cierres.getFmodif() , cierres.getUsumod() , cierres.getFtram());
    }
    
   /**
    * Finds a list of rows in the Cierres table.
    * 
    * @param cierres Cierres
    * @param jqGridRequestDto JQGridRequestDto
    * @return List<Cierres> 
    */
	@Transactional (readOnly = true)
    public List<Aa83bCierres> findAll(Aa83bCierres cierres, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_HISTORIAL IDHISTORIAL,t1.ID001FASE ID001FASE,t1.ID002TRAM ID002TRAM,t1.ID003TIPOSOL ID003TIPOSOL,t1.IDSOL IDSOL,t1.IDANO IDANO,t1.FACTU FACTU,t1.USUA USUA,t1.FREGSAL FREGSAL,t1.FNOTIF FNOTIF,t1.FEXPIR FEXPIR,t1.FMODIF FMODIF,t1.USUMOD USUMOD,t1.FTRAM FTRAM "); 
		query.append("FROM CIERRES t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(cierres); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83bCierres>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the Cierres table using like.
     * 
     * @param cierres Cierres
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<Cierres>
     */
	@Transactional (readOnly = true)
    public List<Aa83bCierres> findAllLike(Aa83bCierres cierres, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_HISTORIAL IDHISTORIAL,t1.ID001FASE ID001FASE,t1.ID002TRAM ID002TRAM,t1.ID003TIPOSOL ID003TIPOSOL,t1.IDSOL IDSOL,t1.IDANO IDANO,t1.FACTU FACTU,t1.USUA USUA,t1.FREGSAL FREGSAL,t1.FNOTIF FNOTIF,t1.FEXPIR FEXPIR,t1.FMODIF FMODIF,t1.USUMOD USUMOD,t1.FTRAM FTRAM "); 
        query.append("FROM CIERRES t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(cierres,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83bCierres>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
     * Counts rows in the Cierres table.
     * 
     * @param cierres Cierres
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Aa83bCierres cierres) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CIERRES t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(cierres); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Cierres table using like.
     * 
     * @param cierres Cierres
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Aa83bCierres cierres, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CIERRES t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(cierres,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Cierres selected for rup_table
     * 
     * @param cierres Cierres
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Cierres>> 
     */
	@Override 
	public List<TableRowDto<Aa83bCierres>> reorderSelection(Aa83bCierres cierres, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_HISTORIAL IDHISTORIAL,t1.ID001FASE ID001FASE,t1.ID002TRAM ID002TRAM,t1.ID003TIPOSOL ID003TIPOSOL,t1.IDSOL IDSOL,t1.IDANO IDANO,t1.FACTU FACTU,t1.USUA USUA,t1.FREGSAL FREGSAL,t1.FNOTIF FNOTIF,t1.FEXPIR FEXPIR,t1.FMODIF FMODIF,t1.USUMOD USUMOD,t1.FTRAM FTRAM "); 
		// FROM
        query.append("FROM CIERRES t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(cierres,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Aa83bCierres.class, filterParamList, "ID_HISTORIAL,ID001FASE,ID002TRAM,ID003TIPOSOL,IDSOL,IDANO,FACTU,USUA,FREGSAL,FNOTIF,FEXPIR,FMODIF,USUMOD,FTRAM" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83bCierres>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
     * 
     * @param filterParams Cierres
     * @param searchParams Cierres
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Cierres>> 
     */
	@Override
	public List<TableRowDto<Aa83bCierres>> search(Aa83bCierres filterParams, Aa83bCierres searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_HISTORIAL IDHISTORIAL,t1.ID001FASE ID001FASE,t1.ID002TRAM ID002TRAM,t1.ID003TIPOSOL ID003TIPOSOL,t1.IDSOL IDSOL,t1.IDANO IDANO,t1.FACTU FACTU,t1.USUA USUA,t1.FREGSAL FREGSAL,t1.FNOTIF FNOTIF,t1.FEXPIR FEXPIR,t1.FMODIF FMODIF,t1.USUMOD USUMOD,t1.FTRAM FTRAM "); 
		// FROM
        query.append("FROM CIERRES t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Aa83bCierres.class, filterParamList, searchSQL, searchParamList, from_alias, "ID_HISTORIAL,ID001FASE,ID002TRAM,ID003TIPOSOL,IDSOL,IDANO,FACTU,USUA,FREGSAL,FNOTIF,FEXPIR,FMODIF,USUMOD,FTRAM");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83bCierres>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table
     * 
     * @param filtercierres Cierres
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean 
     */
	@Override
	public void removeMultiple(Aa83bCierres filtercierres, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.ID_HISTORIAL IDHISTORIAL,t1.ID001FASE ID001FASE,t1.ID002TRAM ID002TRAM,t1.ID003TIPOSOL ID003TIPOSOL,t1.IDSOL IDSOL,t1.IDANO IDANO,t1.FACTU FACTU,t1.USUA USUA,t1.FREGSAL FREGSAL,t1.FNOTIF FNOTIF,t1.FEXPIR FEXPIR,t1.FMODIF FMODIF,t1.USUMOD USUMOD,t1.FTRAM FTRAM "); 
		// FROM
        query.append("FROM CIERRES t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtercierres, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Aa83bCierres.class, query, params, "ID_HISTORIAL,ID001FASE,ID002TRAM,ID003TIPOSOL,IDSOL,IDANO,FACTU,USUA,FREGSAL,FNOTIF,FEXPIR,FMODIF,USUMOD,FTRAM");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Cierres table.
     * 
     * @param filterCierres Cierres
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<JerarquiaDto<Cierres>> 
     */
	@Override
	public List<JerarquiaDto<Aa83bCierres>> findAllLikeJerarquia(Aa83bCierres filterCierres, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_HISTORIAL IDHISTORIAL,t1.ID001FASE ID001FASE,t1.ID002TRAM ID002TRAM,t1.ID003TIPOSOL ID003TIPOSOL,t1.IDSOL IDSOL,t1.IDANO IDANO,t1.FACTU FACTU,t1.USUA USUA,t1.FREGSAL FREGSAL,t1.FNOTIF FNOTIF,t1.FEXPIR FEXPIR,t1.FMODIF FMODIF,t1.USUMOD USUMOD,t1.FTRAM FTRAM "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM CIERRES t1 ");
        List<String> from = new ArrayList<String>();
        from.add("CIERRES");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterCierres, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID_HISTORIAL,ID001FASE,ID002TRAM,ID003TIPOSOL,IDSOL,IDANO,FACTU,USUA,FREGSAL,FNOTIF,FEXPIR,FMODIF,USUMOD,FTRAM", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
     * 
     * @param filterCierres Cierres
     * @param jqGridRequestDto JQGridRequestDto
     * @return Long 
     */
	@Override
	public Long findAllLikeCountJerarquia(Aa83bCierres filterCierres, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM CIERRES t1 ");
        List<String> from = new ArrayList<String>();
        from.add("CIERRES");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterCierres, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID_HISTORIAL,ID001FASE,ID002TRAM,ID003TIPOSOL,IDSOL,IDANO,FACTU,USUA,FREGSAL,FNOTIF,FEXPIR,FMODIF,USUMOD,FTRAM", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
     * 
     * @param filterCierres Cierres
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<TableRowDto<Cierres>> 
     */
	@Override
	public List<TableRowDto<Aa83bCierres>> findAllChild(Aa83bCierres filterCierres, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM CIERRES t1 ");
        List<String> from = new ArrayList<String>();
        from.add("CIERRES");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterCierres, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID_HISTORIAL,ID001FASE,ID002TRAM,ID003TIPOSOL,IDSOL,IDANO,FACTU,USUA,FREGSAL,FNOTIF,FEXPIR,FMODIF,USUMOD,FTRAM", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Aa83bCierres>(this.rwMapPK, "ID_HISTORIAL,ID001FASE,ID002TRAM,ID003TIPOSOL,IDSOL,IDANO,FACTU,USUA,FREGSAL,FNOTIF,FEXPIR,FMODIF,USUMOD,FTRAM"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Cierres entity 
	 * 
	 * @param cierres Cierres
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Aa83bCierres cierres){
		
		StringBuilder where = new StringBuilder(Aa83bCierresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (cierres  != null  && cierres.getIdHistorial() != null ) {
			where.append(" AND t1.ID_HISTORIAL = ?");
			params.add(cierres.getIdHistorial());
		}
		if (cierres  != null  && cierres.getId001fase() != null ) {
			where.append(" AND t1.ID001FASE = ?");
			params.add(cierres.getId001fase());
		}
		if (cierres  != null  && cierres.getId002tram() != null ) {
			where.append(" AND t1.ID002TRAM = ?");
			params.add(cierres.getId002tram());
		}
		if (cierres  != null  && cierres.getId003tiposol() != null ) {
			where.append(" AND t1.ID003TIPOSOL = ?");
			params.add(cierres.getId003tiposol());
		}
		if (cierres  != null  && cierres.getIdsol() != null ) {
			where.append(" AND t1.IDSOL = ?");
			params.add(cierres.getIdsol());
		}
		if (cierres  != null  && cierres.getIdano() != null ) {
			where.append(" AND t1.IDANO = ?");
			params.add(cierres.getIdano());
		}
		if (cierres  != null  && cierres.getFactu() != null ) {
			where.append(" AND t1.FACTU = ?");
			params.add(cierres.getFactu());
		}
		if (cierres  != null  && cierres.getUsua() != null ) {
			where.append(" AND t1.USUA = ?");
			params.add(cierres.getUsua());
		}
		if (cierres  != null  && cierres.getFregsal() != null ) {
			where.append(" AND t1.FREGSAL = ?");
			params.add(cierres.getFregsal());
		}
		if (cierres  != null  && cierres.getFnotif() != null ) {
			where.append(" AND t1.FNOTIF = ?");
			params.add(cierres.getFnotif());
		}
		if (cierres  != null  && cierres.getFexpir() != null ) {
			where.append(" AND t1.FEXPIR = ?");
			params.add(cierres.getFexpir());
		}
		if (cierres  != null  && cierres.getFmodif() != null ) {
			where.append(" AND t1.FMODIF = ?");
			params.add(cierres.getFmodif());
		}
		if (cierres  != null  && cierres.getUsumod() != null ) {
			where.append(" AND t1.USUMOD = ?");
			params.add(cierres.getUsumod());
		}
		if (cierres  != null  && cierres.getFtram() != null ) {
			where.append(" AND t1.FTRAM = ?");
			params.add(cierres.getFtram());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Cierres entity 
	 * 
	 * @param cierres Cierres
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (Aa83bCierres cierres, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(Aa83bCierresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (cierres  != null  && cierres.getIdHistorial() != null ) {
			where.append(" AND t1.ID_HISTORIAL = ?");
			params.add(cierres.getIdHistorial());
	     }			
		if (cierres  != null  && cierres.getId001fase() != null ) {
			where.append(" AND t1.ID001FASE = ?");
			params.add(cierres.getId001fase());
	     }			
		if (cierres  != null  && cierres.getId002tram() != null ) {
			where.append(" AND t1.ID002TRAM = ?");
			params.add(cierres.getId002tram());
	     }			
		if (cierres  != null  && cierres.getId003tiposol() != null && cierres.getId003tiposol() != 0) {
			where.append(" AND t1.ID003TIPOSOL = ?");
			params.add(cierres.getId003tiposol());
	     }
		if (cierres  != null  && cierres.getIdsol() != null && cierres.getIdsol() != 0) {
			where.append(" AND t1.IDSOL = ?");
			params.add(cierres.getIdsol());
	     }			
		if (cierres  != null  && cierres.getIdano() != null ) {
			where.append(" AND t1.IDANO = ?");
			params.add(cierres.getIdano());
	     }			
		if (cierres  != null  && cierres.getFactu() != null ) {
			where.append(" AND t1.FACTU = ?");
			params.add(cierres.getFactu());
	     }			
		if (cierres  != null  && cierres.getUsua() != null ) {
			where.append(" AND UPPER(t1.USUA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(cierres.getUsua().toUpperCase() +"%");
			}else{
				params.add("%"+cierres.getUsua().toUpperCase() +"%");
			}
			where.append(" AND t1.USUA IS NOT NULL");
	     }			
		if (cierres  != null  && cierres.getFregsal() != null ) {
			where.append(" AND t1.FREGSAL = ?");
			params.add(cierres.getFregsal());
	     }			
		if (cierres  != null  && cierres.getFnotif() != null ) {
			where.append(" AND t1.FNOTIF = ?");
			params.add(cierres.getFnotif());
	     }			
		if (cierres  != null  && cierres.getFexpir() != null ) {
			where.append(" AND t1.FEXPIR = ?");
			params.add(cierres.getFexpir());
	     }			
		if (cierres  != null  && cierres.getFmodif() != null ) {
			where.append(" AND t1.FMODIF = ?");
			params.add(cierres.getFmodif());
	     }			
		if (cierres  != null  && cierres.getUsumod() != null ) {
			where.append(" AND UPPER(t1.USUMOD) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(cierres.getUsumod().toUpperCase() +"%");
			}else{
				params.add("%"+cierres.getUsumod().toUpperCase() +"%");
			}
			where.append(" AND t1.USUMOD IS NOT NULL");
	     }			
		if (cierres  != null  && cierres.getFtram() != null ) {
			where.append(" AND t1.FTRAM = ?");
			params.add(cierres.getFtram());
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

