package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83bBusquedaComunicaciones;
import com.ejie.aa83b.model.Aa83bCalle;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.x38.dto.JQGridRequestDto;

@Repository
@Transactional
public class Aa83bBusquedaComunicacionesDaoImpl implements
		Aa83bBusquedaComunicacionesDao {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bBusquedaComunicacionesDaoImpl.class);

	private JdbcTemplate jdbcTemplate;


	@Autowired
	private Aa83bNoraDao aa83bNoraDao;
	
	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public List<Aa83bBusquedaComunicaciones> findComunicaciones(
			Aa83bBusquedaComunicaciones aa83bfiltro,
			JQGridRequestDto jqGridRequestDto) {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT  ID_FASE, ID_TRAMITE, SOLICITUD, NOMBRE, APELLIDOS, FECHA, TRAMITE_ES, TRAMITE_EU FROM AA83B.AA83B02V00 V2 ");

		if (aa83bfiltro.getIdfase() != null) {

			if ("0".equals(aa83bfiltro.getIdfase()) ) {//se han seelccionado todos
				query.append(" WHERE (V2.ID_FASE = '").append(Aa83BConstants.COD_FASE_1).append("' AND ")
			         .append("        V2.ID_TRAMITE = '").append(Aa83BConstants.COD_TRAM_2).append("') OR ")
			         .append("       (V2.ID_FASE = '").append(Aa83BConstants.COD_FASE_2).append("' AND ")
			         .append("        V2.ID_TRAMITE = '").append(Aa83BConstants.COD_TRAM_1).append("') ") ;
			} else {
				query.append(" WHERE V2.ID_FASE = ").append(aa83bfiltro.getIdfase());
				params.add(aa83bfiltro.getIdfase());
		
				if (aa83bfiltro.getIdtramite() != null && !"0".equals(aa83bfiltro.getIdtramite())) {
					query.append(" AND V2.ID_TRAMITE = ").append(aa83bfiltro.getIdtramite());
					params.add(aa83bfiltro.getIdtramite());
				}				
			} 		}
		Aa83bBusquedaComunicacionesDaoImpl.logger.info("[Aa83bBusquedaComunicacionesDaoImpl] : query=" + query);

		return (List<Aa83bBusquedaComunicaciones>) this.jdbcTemplate.query(query.toString(), comunicacionrowMap);
	}
	
	
	@SuppressWarnings("rawtypes")
	public List<Aa83bBusquedaComunicaciones> findComunicacionesAcuses(
			ArrayList seleccionados, String fase, String tramite) {

		StringBuffer query = new StringBuffer(
				"SELECT  ID_SOL, SOLICITUD, REFERENCIA, RAZON, DOMICILIO, CPOSTAL, LOCALIDAD, PROVINCIA, TRAMITE_ES, TRAMITE_EU, ID_TRAMITE, ID_FASE FROM AA83B.AA83B04V00 V4 ");
		
		int total=seleccionados.size();
		String key= "";
		int cont=0;
		
		for(int i = 0; i < seleccionados.size(); i++){
			key= (String)seleccionados.get(i);
			cont++;
			
			//comparar la calle para saber si descripcin o id ANA
			
			Aa83bBusquedaComunicacionesDaoImpl.logger.info("[Aa83bBusquedaComunicacionesDaoImpl] : findComunicacionesAcuses key=" + key+"-"+ fase+"-"+ tramite+"-");
			if (i==0){
				//Es el primero
				query.append(" WHERE (V4.SOLICITUD = '").append(key).append("' ");
			}else if (cont < total){
				query.append(" OR V4.SOLICITUD = '").append(key).append("' ");
			}else{
				//es el ultimo
				query.append(" OR V4.SOLICITUD = '").append(key).append("' )");
			}
			//Si solo hay uno
			if (total==1){
				query.append(" ) ");
			}
			if (!("".equals(tramite)) && !("0".equals(fase)))
				query.append(" AND V4.ID_TRAMITE= '").append(tramite).append("' AND V4.ID_FASE= '").append(fase).append("' ");
			else
				query.append(" AND ((ID_FASE=1 AND ID_TRAMITE=2) OR (ID_FASE=2 AND ID_TRAMITE=1))");
		}

		Aa83bBusquedaComunicacionesDaoImpl.logger.info("[Aa83bBusquedaComunicacionesDaoImpl] : findComunicacionesAcuses query=" + query);

		return (List<Aa83bBusquedaComunicaciones>) this.jdbcTemplate.query(
				query.toString(), comunicacionAcusesrowMap);
	}
	

	/** The comunicacionrowMap map. */
	private RowMapper<Aa83bBusquedaComunicaciones> comunicacionrowMap = new RowMapper<Aa83bBusquedaComunicaciones>() {
		public Aa83bBusquedaComunicaciones mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			// Aa83bBusquedaComunicacionesDaoImpl.logger
			// .info("[Aa83bBusquedaComunicacionesDaoImpl] : rowNum="
			// + rowNum);

			return new Aa83bBusquedaComunicaciones(
					resultSet.getString("ID_FASE"),
					resultSet.getString("ID_TRAMITE"),
					resultSet.getString("SOLICITUD"),
					resultSet.getString("NOMBRE"),
					resultSet.getString("APELLIDOS"),
					resultSet.getString("FECHA"),
					resultSet.getString("TRAMITE_ES"),
					resultSet.getString("TRAMITE_EU"));
		}
	};
	
	private RowMapper<Aa83bBusquedaComunicaciones> comunicacionAcusesrowMap = new RowMapper<Aa83bBusquedaComunicaciones>() {
		public Aa83bBusquedaComunicaciones mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			 Aa83bBusquedaComunicacionesDaoImpl.logger.info("[Aa83bBusquedaComunicacionesDaoImpl] : rowNum=" + rowNum);
			Aa83bBusquedaComunicaciones acuse = new Aa83bBusquedaComunicaciones();
			acuse.setId_sol(resultSet.getString("ID_SOL"));
			acuse.setSolicitud(resultSet.getString("SOLICITUD"));
			acuse.setReferencia(resultSet.getString("REFERENCIA"));
			acuse.setRazon(resultSet.getString("RAZON"));
			String domicilio= resultSet.getString("DOMICILIO");
			String calle= domicilio.substring(0,domicilio.indexOf(" "));
			Aa83bCalle aa83bcalle= new Aa83bCalle();
			try{
				if (Long.valueOf(calle)!=null)
				{
				
				aa83bcalle.setCalle_cod(calle);
				aa83bcalle= aa83bNoraDao.findCalle(aa83bcalle, null);
				domicilio= aa83bcalle.getDs_o().concat(domicilio.substring(domicilio.indexOf(" ")));
				}
			}catch (NumberFormatException e) {
				// TODO: handle exception
			}
			acuse.setDomicilio(domicilio);
			acuse.setCpostal(resultSet.getString("CPOSTAL"));
			acuse.setLocalidad(resultSet.getString("LOCALIDAD"));
			acuse.setProvincia(resultSet.getString("PROVINCIA"));
			acuse.setDescTramiteEs(resultSet.getString("TRAMITE_ES"));
			acuse.setDescTramiteEu(resultSet.getString("TRAMITE_EU"));
			return acuse;				
		}
	};
	
	

}