package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b37t00;
import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Aa83b37t00DaoImpl generated by UDA, 05-may-2016 17:50:07.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b37t00DaoImpl implements Aa83b37t00Dao {
	private JdbcTemplate jdbcTemplate;
	
	private static final Logger logger = LoggerFactory.getLogger(Aa83b37t00DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b37t00> rwMap = new RowMapper<Aa83b37t00>() {
		public Aa83b37t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			String formato = Aa83BConstants.EU_PATTERN_HORA_24;

			if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
					.getLanguage())) {
				formato = Aa83BConstants.EU_PATTERN_HORA_24;
			}
			
			return new Aa83b37t00(resultSet.getInt("ID037"),
					resultSet.getString("TIPOSOL037"),
					resultSet.getLong("NUMANO037"),
					resultSet.getDate("FLECTURA037"),
					resultSet.getString("JMSID037"),
					resultSet.getString("NUMREG037"),
					// Cambio resultSet.getDate("FREGISTRO037") por String
					resultSet.getDate("FREGISTRO037"),
					(resultSet.getDate("FREGISTRO037").toString() + " " + resultSet
							.getTime("FREGISTRO037")),
					// fechaRegStr,
					resultSet.getString("MENSAJE037"), resultSet
							.getString("CODFASE037"), resultSet
							.getString("CODTRA037"), resultSet
							.getString("REMITENTENOM037"), resultSet
							.getString("SITUACION037"), resultSet
							.getString("REMITENTEID037"), resultSet
							.getString("SOLRELAC"));
		}
	};

	private RowMapper<Aa83b37t00> rwMapPK = new RowMapper<Aa83b37t00>() {
		public Aa83b37t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b37t00(resultSet.getInt("ID037"),
					resultSet.getString("TIPOSOL037"),
					resultSet.getLong("NUMANO037"),
					resultSet.getDate("FLECTURA037"),
					resultSet.getString("JMSID037"),
					resultSet.getString("NUMREG037"),
					resultSet.getDate("FREGISTRO037"),
					resultSet.getString("MENSAJE037"),
					resultSet.getString("CODFASE037"),
					resultSet.getString("CODTRA037"),
					resultSet.getString("REMITENTENOM037"),
					resultSet.getString("SITUACION037"),
					resultSet.getString("REMITENTEID037"),
					resultSet.getString("SOLRELAC"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b37t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b37t00>>() {
		public JerarquiaDto<Aa83b37t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa83b37t00 aa83b37t00 = new Aa83b37t00(resultSet.getInt("ID037"),
					resultSet.getString("TIPOSOL037"),
					resultSet.getLong("NUMANO037"),
					resultSet.getDate("FLECTURA037"),
					resultSet.getString("JMSID037"),
					resultSet.getString("NUMREG037"),
					resultSet.getDate("FREGISTRO037"),
					resultSet.getString("MENSAJE037"),
					resultSet.getString("CODFASE037"),
					resultSet.getString("CODTRA037"),
					resultSet.getString("REMITENTENOM037"),
					resultSet.getString("SITUACION037"),
					resultSet.getString("REMITENTEID037"),
					resultSet.getString("SOLRELAC"));

			JerarquiaDto<Aa83b37t00> jerarquia = new JerarquiaDto<Aa83b37t00>();
			jerarquia.setModel(aa83b37t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b37t00 table.
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @return Aa83b37t00
	 */
	public Aa83b37t00 add(Aa83b37t00 aa83b37t00) {
		aa83b37t00.setId037(jdbcTemplate
				.queryForInt("SELECT SEQ_AA83B37T00_ID_037.NEXTVAL FROM DUAL"));

		System.out.println("Aa83b37t00DaoImpl.add La fecha a insertar es: "
				+ aa83b37t00.getFregistro037());
		String query = "INSERT INTO AA83B37T00 (ID_037, TIPO_SOL_037, NUMANO_037, FLECTURA_037, "
				+ "JMSID_037, NUMREG_037, FREGISTRO_037, MENSAJE_037, CODFASE_037, CODTRA_037, REMITENTE_NOM_037, "
				+ "SITUACION_037, REMITENTE_ID_037, SOL_RELAC) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b37t00.getId037(),
				aa83b37t00.getTipoSol037(), aa83b37t00.getNumano037(),
				aa83b37t00.getFlectura037(), aa83b37t00.getJmsid037(),
				aa83b37t00.getNumreg037(), aa83b37t00.getFregistro037(),
				aa83b37t00.getMensaje037(), aa83b37t00.getCodfase037(),
				aa83b37t00.getCodtra037(), aa83b37t00.getRemitenteNom037(),
				aa83b37t00.getSituacion037(), aa83b37t00.getRemitenteId037(),
				aa83b37t00.getSolRelac());
		return aa83b37t00;
	}

	/**
	 * Updates a single row in the Aa83b37t00 table.
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @return Aa83b37t00
	 */
	public Aa83b37t00 update(Aa83b37t00 aa83b37t00) {
		String query = "UPDATE AA83B37T00 SET TIPO_SOL_037=? , NUMANO_037=? , FLECTURA_037=? , JMSID_037=? , NUMREG_037=? , FREGISTRO_037=? , MENSAJE_037=? , CODFASE_037=? , CODTRA_037=? , REMITENTE_NOM_037=? , SITUACION_037=? , REMITENTE_ID_037=? , SOL_RELAC=? WHERE ID_037=?";
		this.jdbcTemplate.update(query, aa83b37t00.getTipoSol037(),
				aa83b37t00.getNumano037(), aa83b37t00.getFlectura037(),
				aa83b37t00.getJmsid037(), aa83b37t00.getNumreg037(),
				aa83b37t00.getFregistro037(), aa83b37t00.getMensaje037(),
				aa83b37t00.getCodfase037(), aa83b37t00.getCodtra037(),
				aa83b37t00.getRemitenteNom037(), aa83b37t00.getSituacion037(),
				aa83b37t00.getRemitenteId037(), aa83b37t00.getSolRelac(),
				aa83b37t00.getId037());
		return aa83b37t00;
	}

	/**
	 * Finds a single row in the Aa83b37t00 table.
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @return Aa83b37t00
	 */
	@Transactional(readOnly = true)
	public Aa83b37t00 find(Aa83b37t00 aa83b37t00) {
		String query = "SELECT t1.ID_037 ID037, t1.TIPO_SOL_037 TIPOSOL037, t1.NUMANO_037 NUMANO037, t1.FLECTURA_037 FLECTURA037, t1.JMSID_037 JMSID037, t1.NUMREG_037 NUMREG037, t1.FREGISTRO_037 FREGISTRO037, t1.MENSAJE_037 MENSAJE037, t1.CODFASE_037 CODFASE037, t1.CODTRA_037 CODTRA037, t1.REMITENTE_NOM_037 REMITENTENOM037, t1.SITUACION_037 SITUACION037, t1.REMITENTE_ID_037 REMITENTEID037, t1.SOL_RELAC SOLRELAC FROM AA83B37T00 t1  WHERE t1.ID_037 = ?   AND t1.TIPO_SOL_037 = ?   AND t1.NUMANO_037 = ?   AND t1.FLECTURA_037 = ?   AND t1.JMSID_037 = ?   AND t1.NUMREG_037 = ?   AND t1.FREGISTRO_037 = ?   "
				// AND t1.MENSAJE_037 = ?
				+ "   AND t1.CODFASE_037 = ?   AND t1.CODTRA_037 = ?   AND t1.REMITENTE_NOM_037 = ?   AND t1.SITUACION_037 = ?   AND t1.REMITENTE_ID_037 = ?   AND t1.SOL_RELAC = ?  ";

		List<Aa83b37t00> aa83b37t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b37t00.getId037(), aa83b37t00.getTipoSol037(),
				aa83b37t00.getNumano037(), aa83b37t00.getFlectura037(),
				aa83b37t00.getJmsid037(),
				aa83b37t00.getNumreg037(),
				aa83b37t00.getFregistro037(),
				// aa83b37t00.getMensaje037(),
				aa83b37t00.getCodfase037(), aa83b37t00.getCodtra037(),
				aa83b37t00.getRemitenteNom037(), aa83b37t00.getSituacion037(),
				aa83b37t00.getRemitenteId037(), aa83b37t00.getSolRelac());
		return (Aa83b37t00) DataAccessUtils.uniqueResult(aa83b37t00List);
	}

	/**
	 * Removes a single row in the Aa83b37t00 table.
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @return
	 */
	public void remove(Aa83b37t00 aa83b37t00) {
		String query = "DELETE FROM AA83B37T00 WHERE ID_037=? AND TIPO_SOL_037=? AND NUMANO_037=? AND FLECTURA_037=? AND JMSID_037=? AND NUMREG_037=? AND FREGISTRO_037=? AND MENSAJE_037=? AND CODFASE_037=? AND CODTRA_037=? AND REMITENTE_NOM_037=? AND SITUACION_037=? AND REMITENTE_ID_037=? AND SOL_RELAC=?";
		this.jdbcTemplate.update(query, aa83b37t00.getId037(),
				aa83b37t00.getTipoSol037(), aa83b37t00.getNumano037(),
				aa83b37t00.getFlectura037(), aa83b37t00.getJmsid037(),
				aa83b37t00.getNumreg037(), aa83b37t00.getFregistro037(),
				aa83b37t00.getMensaje037(), aa83b37t00.getCodfase037(),
				aa83b37t00.getCodtra037(), aa83b37t00.getRemitenteNom037(),
				aa83b37t00.getSituacion037(), aa83b37t00.getRemitenteId037(),
				aa83b37t00.getSolRelac());
	}

	/**
	 * Finds a list of rows in the Aa83b37t00 table.
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b37t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b37t00> findAll(Aa83b37t00 aa83b37t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_037 ID037,t1.TIPO_SOL_037 TIPOSOL037,t1.NUMANO_037 NUMANO037,t1.FLECTURA_037 FLECTURA037,t1.JMSID_037 JMSID037,t1.NUMREG_037 NUMREG037,t1.FREGISTRO_037 FREGISTRO037,t1.MENSAJE_037 MENSAJE037,t1.CODFASE_037 CODFASE037,t1.CODTRA_037 CODTRA037,t1.REMITENTE_NOM_037 REMITENTENOM037,t1.SITUACION_037 SITUACION037,t1.REMITENTE_ID_037 REMITENTEID037,t1.SOL_RELAC SOLRELAC ");
		query.append("FROM AA83B37T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b37t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b37t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b37t00 table using like.
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b37t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b37t00> findAllLike(Aa83b37t00 aa83b37t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// this.jdbcTemplate
		// .execute("alter session set nls_date_format='yyyy-mm-dd hh24:mi:ss'");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_037 ID037,t1.TIPO_SOL_037 TIPOSOL037,t1.NUMANO_037 NUMANO037,t1.FLECTURA_037 FLECTURA037,t1.JMSID_037 JMSID037,t1.NUMREG_037 NUMREG037, t1.FREGISTRO_037 FREGISTRO037,t1.MENSAJE_037 MENSAJE037,t1.CODFASE_037 CODFASE037,t1.CODTRA_037 CODTRA037,t1.REMITENTE_NOM_037 REMITENTENOM037,t1.SITUACION_037 SITUACION037,t1.REMITENTE_ID_037 REMITENTEID037,t1.SOL_RELAC SOLRELAC ");
		query.append("FROM AA83B37T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b37t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		query.append(where);

		// order by
		query.append(" ORDER BY  t1.ID_037 ASC  ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b37t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b37t00 table.
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b37t00 aa83b37t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B37T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b37t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b37t00 table using like.
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b37t00 aa83b37t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B37T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b37t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b37t00 selected for rup_table
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b37t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b37t00>> reorderSelection(
			Aa83b37t00 aa83b37t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_037 ID037,t1.TIPO_SOL_037 TIPOSOL037,t1.NUMANO_037 NUMANO037,t1.FLECTURA_037 FLECTURA037,t1.JMSID_037 JMSID037,t1.NUMREG_037 NUMREG037,t1.FREGISTRO_037 FREGISTRO037,t1.MENSAJE_037 MENSAJE037,t1.CODFASE_037 CODFASE037,t1.CODTRA_037 CODTRA037,t1.REMITENTE_NOM_037 REMITENTENOM037,t1.SITUACION_037 SITUACION037,t1.REMITENTE_ID_037 REMITENTEID037,t1.SOL_RELAC SOLRELAC ");
		// FROM
		query.append("FROM AA83B37T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b37t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						Aa83b37t00.class,
						filterParamList,
						"ID_037,TIPO_SOL_037,NUMANO_037,FLECTURA_037,JMSID_037,NUMREG_037,FREGISTRO_037,MENSAJE_037,CODFASE_037,CODTRA_037,REMITENTE_NOM_037,SITUACION_037,REMITENTE_ID_037,SOL_RELAC");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b37t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b37t00
	 * @param searchParams
	 *            Aa83b37t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b37t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b37t00>> search(Aa83b37t00 filterParams,
			Aa83b37t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_037 ID037,t1.TIPO_SOL_037 TIPOSOL037,t1.NUMANO_037 NUMANO037,t1.FLECTURA_037 FLECTURA037,t1.JMSID_037 JMSID037,t1.NUMREG_037 NUMREG037,t1.FREGISTRO_037 FREGISTRO037,t1.MENSAJE_037 MENSAJE037,t1.CODFASE_037 CODFASE037,t1.CODTRA_037 CODTRA037,t1.REMITENTE_NOM_037 REMITENTENOM037,t1.SITUACION_037 SITUACION037,t1.REMITENTE_ID_037 REMITENTEID037,t1.SOL_RELAC SOLRELAC ");
		// FROM
		query.append("FROM AA83B37T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						Aa83b37t00.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"ID_037,TIPO_SOL_037,NUMANO_037,FLECTURA_037,JMSID_037,NUMREG_037,FREGISTRO_037,MENSAJE_037,CODFASE_037,CODTRA_037,REMITENTE_NOM_037,SITUACION_037,REMITENTE_ID_037,SOL_RELAC");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b37t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b37t00
	 *            Aa83b37t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b37t00 filteraa83b37t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_037 ID037,t1.TIPO_SOL_037 TIPOSOL037,t1.NUMANO_037 NUMANO037,t1.FLECTURA_037 FLECTURA037,t1.JMSID_037 JMSID037,t1.NUMREG_037 NUMREG037,t1.FREGISTRO_037 FREGISTRO037,t1.MENSAJE_037 MENSAJE037,t1.CODFASE_037 CODFASE037,t1.CODTRA_037 CODTRA037,t1.REMITENTE_NOM_037 REMITENTENOM037,t1.SITUACION_037 SITUACION037,t1.REMITENTE_ID_037 REMITENTEID037,t1.SOL_RELAC SOLRELAC ");
		// FROM
		query.append("FROM AA83B37T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b37t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						Aa83b37t00.class,
						query,
						params,
						"ID_037,TIPO_SOL_037,NUMANO_037,FLECTURA_037,JMSID_037,NUMREG_037,FREGISTRO_037,MENSAJE_037,CODFASE_037,CODTRA_037,REMITENTE_NOM_037,SITUACION_037,REMITENTE_ID_037,SOL_RELAC");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b37t00 table.
	 * 
	 * @param filterAa83b37t00
	 *            Aa83b37t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b37t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b37t00>> findAllLikeJerarquia(
			Aa83b37t00 filterAa83b37t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_037 ID037,t1.TIPO_SOL_037 TIPOSOL037,t1.NUMANO_037 NUMANO037,t1.FLECTURA_037 FLECTURA037,t1.JMSID_037 JMSID037,t1.NUMREG_037 NUMREG037,t1.FREGISTRO_037 FREGISTRO037,t1.MENSAJE_037 MENSAJE037,t1.CODFASE_037 CODFASE037,t1.CODTRA_037 CODTRA037,t1.REMITENTE_NOM_037 REMITENTENOM037,t1.SITUACION_037 SITUACION037,t1.REMITENTE_ID_037 REMITENTEID037,t1.SOL_RELAC SOLRELAC ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B37T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B37T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b37t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia
				.getQuery(
						jqGridRequestDto,
						query,
						mapaWhere,
						"ID_037,TIPO_SOL_037,NUMANO_037,FLECTURA_037,JMSID_037,NUMREG_037,FREGISTRO_037,MENSAJE_037,CODFASE_037,CODTRA_037,REMITENTE_NOM_037,SITUACION_037,REMITENTE_ID_037,SOL_RELAC",
						"ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b37t00
	 *            Aa83b37t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b37t00 filterAa83b37t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B37T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B37T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b37t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia
				.getQueryCount(
						jqGridRequestDto,
						mapaWhere,
						"ID_037,TIPO_SOL_037,NUMANO_037,FLECTURA_037,JMSID_037,NUMREG_037,FREGISTRO_037,MENSAJE_037,CODFASE_037,CODTRA_037,REMITENTE_NOM_037,SITUACION_037,REMITENTE_ID_037,SOL_RELAC",
						"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b37t00
	 *            Aa83b37t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b37t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b37t00>> findAllChild(
			Aa83b37t00 filterAa83b37t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B37T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B37T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b37t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia
				.getQueryChildren(
						jqGridRequestDto,
						mapaWhere,
						"ID_037,TIPO_SOL_037,NUMANO_037,FLECTURA_037,JMSID_037,NUMREG_037,FREGISTRO_037,MENSAJE_037,CODFASE_037,CODTRA_037,REMITENTE_NOM_037,SITUACION_037,REMITENTE_ID_037,SOL_RELAC",
						"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa83b37t00>(
								this.rwMapPK,
								"ID_037,TIPO_SOL_037,NUMANO_037,FLECTURA_037,JMSID_037,NUMREG_037,FREGISTRO_037,MENSAJE_037,CODFASE_037,CODTRA_037,REMITENTE_NOM_037,SITUACION_037,REMITENTE_ID_037,SOL_RELAC"),
						params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b37t00 entity
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b37t00 aa83b37t00) {

		StringBuilder where = new StringBuilder(
				Aa83b37t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b37t00 != null && aa83b37t00.getId037() != null) {
			where.append(" AND t1.ID_037 = ?");
			params.add(aa83b37t00.getId037());
		}
		if (aa83b37t00 != null && aa83b37t00.getTipoSol037() != null) {
			where.append(" AND t1.TIPO_SOL_037 = ?");
			params.add(aa83b37t00.getTipoSol037());
		}
		if (aa83b37t00 != null && aa83b37t00.getNumano037() != null) {
			where.append(" AND t1.NUMANO_037 = ?");
			params.add(aa83b37t00.getNumano037());
		}
		if (aa83b37t00 != null && aa83b37t00.getFlectura037() != null) {
			where.append(" AND t1.FLECTURA_037 = ?");
			params.add(aa83b37t00.getFlectura037());
		}
		if (aa83b37t00 != null && aa83b37t00.getJmsid037() != null) {
			where.append(" AND t1.JMSID_037 = ?");
			params.add(aa83b37t00.getJmsid037());
		}
		if (aa83b37t00 != null && aa83b37t00.getNumreg037() != null) {
			where.append(" AND t1.NUMREG_037 = ?");
			params.add(aa83b37t00.getNumreg037());
		}
		if (aa83b37t00 != null && aa83b37t00.getFregistro037() != null) {
			where.append(" AND t1.FREGISTRO_037 = ?");
			params.add(aa83b37t00.getFregistro037());
		}
		if (aa83b37t00 != null && aa83b37t00.getCodfase037() != null) {
			where.append(" AND t1.CODFASE_037 = ?");
			params.add(aa83b37t00.getCodfase037());
		}
		if (aa83b37t00 != null && aa83b37t00.getCodtra037() != null) {
			where.append(" AND t1.CODTRA_037 = ?");
			params.add(aa83b37t00.getCodtra037());
		}
		if (aa83b37t00 != null && aa83b37t00.getRemitenteNom037() != null) {
			where.append(" AND t1.REMITENTE_NOM_037 = ?");
			params.add(aa83b37t00.getRemitenteNom037());
		}
		if (aa83b37t00 != null && aa83b37t00.getSituacion037() != null) {
			where.append(" AND t1.SITUACION_037 = ?");
			params.add(aa83b37t00.getSituacion037());
		}
		if (aa83b37t00 != null && aa83b37t00.getRemitenteId037() != null) {
			where.append(" AND t1.REMITENTE_ID_037 = ?");
			params.add(aa83b37t00.getRemitenteId037());
		}
		if (aa83b37t00 != null && aa83b37t00.getSolRelac() != null) {
			where.append(" AND t1.SOL_RELAC = ?");
			params.add(aa83b37t00.getSolRelac());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b37t00 entity
	 * 
	 * @param aa83b37t00
	 *            Aa83b37t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b37t00 aa83b37t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b37t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b37t00 != null && aa83b37t00.getId037() != null) {
			where.append(" AND t1.ID_037 = ?");
			params.add(aa83b37t00.getId037());
		}
		if (aa83b37t00 != null && aa83b37t00.getTipoSol037() != null && !aa83b37t00.getTipoSol037().equals("0")) {
			where.append(" AND UPPER(t1.TIPO_SOL_037) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getTipoSol037().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getTipoSol037().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO_SOL_037 IS NOT NULL");
		}
		if (aa83b37t00 != null && aa83b37t00.getNumano037() != null) {
			where.append(" AND t1.NUMANO_037 = ?");
			params.add(aa83b37t00.getNumano037());
		}
		if (aa83b37t00 != null && aa83b37t00.getFlectura037() != null) {
			where.append(" AND t1.FLECTURA_037 = ?");
			params.add(aa83b37t00.getFlectura037());
		}
		if (aa83b37t00 != null && aa83b37t00.getJmsid037() != null) {
			where.append(" AND UPPER(t1.JMSID_037) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getJmsid037().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getJmsid037().toUpperCase() + "%");
			}
			where.append(" AND t1.JMSID_037 IS NOT NULL");
		}
		if (aa83b37t00 != null && aa83b37t00.getNumreg037() != null) {
			where.append(" AND UPPER(t1.NUMREG_037) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getNumreg037().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getNumreg037().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMREG_037 IS NOT NULL");
		}
		if (aa83b37t00 != null && aa83b37t00.getFregistro037() != null) {
			where.append(" AND t1.FREGISTRO_037 = ?");
			params.add(aa83b37t00.getFregistro037());
		}
		if (aa83b37t00 != null && aa83b37t00.getFregistro037Str() != null && !aa83b37t00.getFregistro037Str().equals("")) {
			where.append(" AND t1.FREGISTRO_037 > trunc(to_date(?,'dd/mm/yyyy'))");
			where.append(" AND t1.FREGISTRO_037 < trunc(to_date(?, 'dd/mm/yyyy'))+1");
			params.add(aa83b37t00.getFregistro037Str());
			params.add(aa83b37t00.getFregistro037Str());
		}
		if (aa83b37t00 != null && aa83b37t00.getCodfase037() != null && !aa83b37t00.getCodfase037().equals("0")) {
			where.append(" AND UPPER(t1.CODFASE_037) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getCodfase037().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getCodfase037().toUpperCase() + "%");
			}
			where.append(" AND t1.CODFASE_037 IS NOT NULL");
		}
		if (aa83b37t00 != null && aa83b37t00.getCodtra037() != null && !aa83b37t00.getCodtra037().equals("0")) {
			where.append(" AND UPPER(t1.CODTRA_037) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getCodtra037().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getCodtra037().toUpperCase() + "%");
			}
			where.append(" AND t1.CODTRA_037 IS NOT NULL");
		}
		if (aa83b37t00 != null && aa83b37t00.getRemitenteNom037() != null) {
			where.append(" AND UPPER(t1.REMITENTE_NOM_037) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getRemitenteNom037().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getRemitenteNom037().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.REMITENTE_NOM_037 IS NOT NULL");
		}
		if (aa83b37t00 != null && aa83b37t00.getSituacion037() != null) {
			where.append(" AND UPPER(t1.SITUACION_037) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getSituacion037().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getSituacion037().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SITUACION_037 IS NOT NULL");
		}
		if (aa83b37t00 != null && aa83b37t00.getRemitenteId037() != null) {
			where.append(" AND UPPER(t1.REMITENTE_ID_037) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getRemitenteId037().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getRemitenteId037().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.REMITENTE_ID_037 IS NOT NULL");
		}
		if (aa83b37t00 != null && aa83b37t00.getSolRelac() != null) {
			where.append(" AND UPPER(t1.SOL_RELAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b37t00.getSolRelac().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b37t00.getSolRelac().toUpperCase() + "%");
			}
			where.append(" AND t1.SOL_RELAC IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
