package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b01t00;
import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b03t00;
import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b34t00;
import com.ejie.aa83b.service.Aa83b01t00Service;
import com.ejie.aa83b.service.Aa83b02t00Service;
import com.ejie.aa83b.service.Aa83b03t00Service;
import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Aa83b34t00DaoImpl generated by UDA, 15-dic-2015 10:39:54.
 * 
 * @author UDA - DS
 */

@Repository
@Transactional
public class Aa83b34t00DaoImpl implements Aa83b34t00Dao {
	private JdbcTemplate jdbcTemplate;
	@Autowired
	private Aa83b03t00Service aa83b03t00Service;
	@Autowired
	private Aa83b02t00Service aa83b02t00Service;
	@Autowired
	private Aa83b01t00Service aa83b01t00Service;
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b34t00> rwMap = new RowMapper<Aa83b34t00>() {
		public Aa83b34t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			// buscamos el tramite y la fase
			Aa83b01t00 fase = new Aa83b01t00();
			fase.setId001(Integer.parseInt(resultSet.getString("CODFASE034")));
			fase.setIdTipoSol(Integer.parseInt(resultSet.getString("TIPSUB034")));
			fase = aa83b01t00Service.find(fase);

			Aa83b02t00 tramite = new Aa83b02t00();
			Aa83b03t00 tipoSol = new Aa83b03t00();
			tramite.setId002(Integer.parseInt(resultSet.getString("CODTRA034")));
			tramite.setId001Fase(fase.getId001());
			tramite.setId003TipoSol(Integer.parseInt(resultSet
					.getString("TIPSUB034")));
			tramite = aa83b02t00Service.find(tramite);

			tipoSol.setId003(Integer.parseInt(resultSet.getString("TIPSUB034")));

			List<Aa83b03t00> aa83b03t00List = aa83b03t00Service.findAllLike(
					tipoSol, null, false);

			Aa83b34t00 aa83b34t00 = new Aa83b34t00(
					resultSet.getLong("CODSOLIC034"),
					resultSet.getString("CODAPL034"),
					resultSet.getString("TIPSUB034"),
					resultSet.getLong("NUMANO034"),
					resultSet.getString("CODDEL034"),
					resultSet.getInt("NUMDEL034"),
					resultSet.getDate("FLECTURA034"),
					resultSet.getString("JMSID034"),
					resultSet.getString("NUMREG034"),

					(resultSet.getDate("FREGISTRO034").toString() + " " + resultSet
							.getTime("FREGISTRO034")), resultSet
							.getDate("FREGISTRO034"), resultSet
							.getString("QRCODE034"), resultSet
							.getString("MENSAJE034"), resultSet
							.getString("SITUACION034"), resultSet
							.getString("CODFASE034"), fase.getDescEs001(),
					aa83b03t00List.get(0).getTipoSol003(), aa83b03t00List.get(0).getTipoSol003()
					, fase.getDescEu001(), resultSet
							.getString("CODTRA034"), tramite.getDescEs002(),
					tramite.getDescEu002(), resultSet.getLong("CORTRA034"),
					resultSet.getInt("BLOQUEO034"), resultSet
							.getString("TIPO034"), resultSet
							.getString("REMITENTE034"));

			return aa83b34t00;
		}

	};

	private RowMapper<Aa83b34t00> rwMapPK = new RowMapper<Aa83b34t00>() {

		public Aa83b34t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b34t00(resultSet.getLong("CODSOLIC034"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b34t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b34t00>>() {
		public JerarquiaDto<Aa83b34t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			// buscamos el tramite y la fase
			Aa83b01t00 fase = new Aa83b01t00();
			fase.setId001(Integer.parseInt(resultSet.getString("CODFASE034")));
			fase.setIdTipoSol(Integer.parseInt(resultSet.getString("TIPSUB034")));
			fase = aa83b01t00Service.find(fase);

			Aa83b02t00 tramite = new Aa83b02t00();
			Aa83b03t00 tipoSol = new Aa83b03t00();
			tramite.setId002(Integer.parseInt(resultSet.getString("CODTRA034")));
			tramite.setId001Fase(fase.getId001());
			tramite.setId003TipoSol(Integer.parseInt(resultSet
					.getString("TIPSUB034")));
			tramite = aa83b02t00Service.find(tramite);

			tipoSol.setId003(Integer.parseInt(resultSet.getString("TIPSUB034")));

			List<Aa83b03t00> aa83b03t00List = aa83b03t00Service.findAllLike(
					tipoSol, null, false);

			Aa83b34t00 aa83b34t00 = new Aa83b34t00(
					resultSet.getLong("CODSOLIC034"),
					resultSet.getString("CODAPL034"),
					resultSet.getString("TIPSUB034"),
					resultSet.getLong("NUMANO034"),
					resultSet.getString("CODDEL034"),
					resultSet.getInt("NUMDEL034"),
					resultSet.getDate("FLECTURA034"),
					resultSet.getString("JMSID034"),
					resultSet.getString("NUMREG034"),

					// resultSet.getDate("FREGISTRO034"),

					(resultSet.getDate("FREGISTRO034").toString() + " " + resultSet
							.getTime("FREGISTRO034")), resultSet
							.getDate("FREGISTRO034"), resultSet
							.getString("QRCODE034"), resultSet
							.getString("MENSAJE034"), resultSet
							.getString("SITUACION034"), resultSet
							.getString("CODFASE034"), fase.getDescEs001(), fase
							.getDescEu001(), aa83b03t00List.get(0)
							.getDescEs003(), aa83b03t00List.get(0)
							.getDescEs003(), resultSet.getString("CODTRA034"),
					tramite.getDescEs002(), tramite.getDescEu002(), resultSet
							.getLong("CORTRA034"), resultSet
							.getInt("BLOQUEO034"), resultSet
							.getString("TIPO034"), resultSet
							.getString("REMITENTE034"));

			JerarquiaDto<Aa83b34t00> jerarquia = new JerarquiaDto<Aa83b34t00>();
			jerarquia.setModel(aa83b34t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));

			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b34t00 table.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @return Aa83b34t00
	 */
	public Aa83b34t00 add(Aa83b34t00 aa83b34t00) {
		final Integer nextId = jdbcTemplate
				.queryForInt("SELECT SEQ_AA83B34T00_CODSOLIC_034.NEXTVAL FROM DUAL");

		aa83b34t00.setCodsolic034(Long.parseLong(nextId.toString()));

		String query = "INSERT INTO AA83B34T00 (CODSOLIC_034, CODAPL_034, TIPSUB_034, NUMANO_034, CODDEL_034, NUMDEL_034, FLECTURA_034, JMSID_034, NUMREG_034, "
				+ "FREGISTRO_034, QRCODE_034, MENSAJE_034, SITUACION_034, CODFASE_034, CODTRA_034, CORTRA_034, BLOQUEO_034, TIPO_034, REMITENTE_034) "
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,TO_CLOB(?),?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b34t00.getCodsolic034(),
				aa83b34t00.getCodapl034(), aa83b34t00.getTipsub034(),
				aa83b34t00.getNumano034(),
				aa83b34t00.getCoddel034(),
				aa83b34t00.getNumdel034(),
				aa83b34t00.getFlectura034(),
				aa83b34t00.getJmsid034(),
				aa83b34t00.getNumreg034(),
				aa83b34t00.getFregistro034(),
				// "dd/mm/yyyy hh24:mi:ss",
				aa83b34t00.getQrcode034(), aa83b34t00.getMensaje034(),
				aa83b34t00.getSituacion034(), aa83b34t00.getCodfase034(),
				aa83b34t00.getCodtra034(), aa83b34t00.getCortra034(),
				aa83b34t00.getBloqueo034(), aa83b34t00.getTipo034(),
				aa83b34t00.getRemitente034());
		return aa83b34t00;
	}

	/**
	 * Updates a single row in the Aa83b34t00 table.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @return Aa83b34t00
	 */
	public Aa83b34t00 update(Aa83b34t00 aa83b34t00) {
		String query = "UPDATE AA83B34T00 SET CODAPL_034=?, TIPSUB_034=?, NUMANO_034=?, CODDEL_034=?, NUMDEL_034=?, FLECTURA_034=?, JMSID_034=?, NUMREG_034=?, FREGISTRO_034=?, QRCODE_034=?, MENSAJE_034=?, SITUACION_034=?, CODFASE_034=?, CODTRA_034=?, CORTRA_034=?, BLOQUEO_034=?, TIPO_034=?, REMITENTE_034=? WHERE CODSOLIC_034=?";
		this.jdbcTemplate.update(query, aa83b34t00.getCodapl034(),
				aa83b34t00.getTipsub034(), aa83b34t00.getNumano034(),
				aa83b34t00.getCoddel034(), aa83b34t00.getNumdel034(),
				aa83b34t00.getFlectura034(), aa83b34t00.getJmsid034(),
				aa83b34t00.getNumreg034(), aa83b34t00.getFregistro034(),
				aa83b34t00.getQrcode034(), aa83b34t00.getMensaje034(),
				aa83b34t00.getSituacion034(), aa83b34t00.getCodfase034(),
				aa83b34t00.getCodtra034(), aa83b34t00.getCortra034(),
				aa83b34t00.getBloqueo034(), aa83b34t00.getTipo034(),
				aa83b34t00.getRemitente034(), aa83b34t00.getCodsolic034());
		return aa83b34t00;
	}

	/**
	 * Updates a single row in the Aa83b34t00 table.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @return Aa83b34t00
	 */
	public Aa83b34t00 rechazarSolicitud(Aa83b34t00 aa83b34t00) {
		String query = "UPDATE AA83B34T00 SET SITUACION_034=? WHERE CODSOLIC_034=?";
		this.jdbcTemplate.update(query, Aa83BConstants.RECHAZADA,
				aa83b34t00.getCodsolic034());
		return aa83b34t00;
	}

	/**
	 * Updates a single row in the Aa83b34t00 table.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @return Aa83b34t00
	 */
	public Aa83b34t00 aceptarSolicitud(Aa83b34t00 aa83b34t00) {
		String query = "UPDATE AA83B34T00 SET SITUACION_034=? WHERE CODSOLIC_034=?";
		this.jdbcTemplate.update(query, Aa83BConstants.ACEPTADA,
				aa83b34t00.getCodsolic034());
		return aa83b34t00;
	}

	/**
	 * Finds a single row in the Aa83b34t00 table.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @return Aa83b34t00
	 */
	@Transactional(readOnly = true)
	public Aa83b34t00 find(Aa83b34t00 aa83b34t00) {
		String query = "SELECT t1.CODSOLIC_034 CODSOLIC034, t1.CODAPL_034 CODAPL034, t1.TIPSUB_034 TIPSUB034, t1.NUMANO_034 NUMANO034, t1.CODDEL_034 CODDEL034, t1.NUMDEL_034 NUMDEL034, t1.FLECTURA_034 FLECTURA034, t1.JMSID_034 JMSID034, t1.NUMREG_034 NUMREG034, t1.FREGISTRO_034 FREGISTRO034, t1.QRCODE_034 QRCODE034, t1.MENSAJE_034 MENSAJE034, t1.SITUACION_034 SITUACION034, t1.CODFASE_034 CODFASE034, t1.CODTRA_034 CODTRA034, t1.CORTRA_034 CORTRA034, t1.BLOQUEO_034 BLOQUEO034, t1.TIPO_034 TIPO034, t1.REMITENTE_034 REMITENTE034 FROM AA83B34T00 t1  WHERE t1.CODSOLIC_034 = ?  ";

		List<Aa83b34t00> aa83b34t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b34t00.getCodsolic034());
		return (Aa83b34t00) DataAccessUtils.uniqueResult(aa83b34t00List);
	}

	/**
	 * Removes a single row in the Aa83b34t00 table.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @return
	 */
	public void remove(Aa83b34t00 aa83b34t00) {
		String query = "DELETE FROM AA83B34T00 WHERE CODSOLIC_034=?";
		this.jdbcTemplate.update(query, aa83b34t00.getCodsolic034());
	}

	/**
	 * Finds a list of rows in the Aa83b34t00 table.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b34t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b34t00> findAll(Aa83b34t00 aa83b34t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODSOLIC_034 CODSOLIC034,t1.CODAPL_034 CODAPL034,t1.TIPSUB_034 TIPSUB034,t1.NUMANO_034 NUMANO034,t1.CODDEL_034 CODDEL034,t1.NUMDEL_034 NUMDEL034,t1.FLECTURA_034 FLECTURA034,t1.JMSID_034 JMSID034,t1.NUMREG_034 NUMREG034,t1.FREGISTRO_034 FREGISTRO034,t1.QRCODE_034 QRCODE034,t1.MENSAJE_034 MENSAJE034,t1.SITUACION_034 SITUACION034,t1.CODFASE_034 CODFASE034,t1.CODTRA_034 CODTRA034,t1.CORTRA_034 CORTRA034,t1.BLOQUEO_034 BLOQUEO034,t1.TIPO_034 TIPO034,t1.REMITENTE_034 REMITENTE034 ");
		query.append("FROM AA83B34T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b34t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b34t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b34t00 table using like.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b34t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b34t00> findAllLike(Aa83b34t00 aa83b34t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODSOLIC_034 CODSOLIC034,t1.CODAPL_034 CODAPL034,t1.TIPSUB_034 TIPSUB034,t1.NUMANO_034 NUMANO034,t1.CODDEL_034 CODDEL034,t1.NUMDEL_034 NUMDEL034,t1.FLECTURA_034 FLECTURA034,t1.JMSID_034 JMSID034,t1.NUMREG_034 NUMREG034,t1.FREGISTRO_034 FREGISTRO034,t1.QRCODE_034 QRCODE034,t1.MENSAJE_034 MENSAJE034,t1.SITUACION_034 SITUACION034,t1.CODFASE_034 CODFASE034,t1.CODTRA_034 CODTRA034,t1.CORTRA_034 CORTRA034,t1.BLOQUEO_034 BLOQUEO034,t1.TIPO_034 TIPO034,t1.REMITENTE_034 REMITENTE034 ");
		query.append("FROM AA83B34T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b34t00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND SITUACION_034 LIKE 'V'");

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY  t1.CODSOLIC_034 DESC  ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b34t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b34t00 table.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b34t00 aa83b34t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B34T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b34t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b34t00 table using like.
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b34t00 aa83b34t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B34T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b34t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b34t00 selected for rup_table
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b34t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b34t00>> reorderSelection(
			Aa83b34t00 aa83b34t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODSOLIC_034 CODSOLIC034,t1.CODAPL_034 CODAPL034,t1.TIPSUB_034 TIPSUB034,t1.NUMANO_034 NUMANO034,t1.CODDEL_034 CODDEL034,t1.NUMDEL_034 NUMDEL034,t1.FLECTURA_034 FLECTURA034,t1.JMSID_034 JMSID034,t1.NUMREG_034 NUMREG034,t1.FREGISTRO_034 FREGISTRO034,t1.QRCODE_034 QRCODE034,t1.MENSAJE_034 MENSAJE034,t1.SITUACION_034 SITUACION034,t1.CODFASE_034 CODFASE034,t1.CODTRA_034 CODTRA034,t1.CORTRA_034 CORTRA034,t1.BLOQUEO_034 BLOQUEO034,t1.TIPO_034 TIPO034,t1.REMITENTE_034 REMITENTE034 ");
		// FROM
		query.append("FROM AA83B34T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b34t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b34t00.class, filterParamList,
				"CODSOLIC_034");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b34t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b34t00
	 * @param searchParams
	 *            Aa83b34t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b34t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b34t00>> search(Aa83b34t00 filterParams,
			Aa83b34t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODSOLIC_034 CODSOLIC034,t1.CODAPL_034 CODAPL034,t1.TIPSUB_034 TIPSUB034,t1.NUMANO_034 NUMANO034,t1.CODDEL_034 CODDEL034,t1.NUMDEL_034 NUMDEL034,t1.FLECTURA_034 FLECTURA034,t1.JMSID_034 JMSID034,t1.NUMREG_034 NUMREG034,t1.FREGISTRO_034 FREGISTRO034,t1.QRCODE_034 QRCODE034,t1.MENSAJE_034 MENSAJE034,t1.SITUACION_034 SITUACION034,t1.CODFASE_034 CODFASE034,t1.CODTRA_034 CODTRA034,t1.CORTRA_034 CORTRA034,t1.BLOQUEO_034 BLOQUEO034,t1.TIPO_034 TIPO034,t1.REMITENTE_034 REMITENTE034 ");
		// FROM
		query.append("FROM AA83B34T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b34t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CODSOLIC_034");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b34t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b34t00
	 *            Aa83b34t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b34t00 filteraa83b34t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODSOLIC_034 CODSOLIC034,t1.CODAPL_034 CODAPL034,t1.TIPSUB_034 TIPSUB034,t1.NUMANO_034 NUMANO034,t1.CODDEL_034 CODDEL034,t1.NUMDEL_034 NUMDEL034,t1.FLECTURA_034 FLECTURA034,t1.JMSID_034 JMSID034,t1.NUMREG_034 NUMREG034,t1.FREGISTRO_034 FREGISTRO034,t1.QRCODE_034 QRCODE034,t1.MENSAJE_034 MENSAJE034,t1.SITUACION_034 SITUACION034,t1.CODFASE_034 CODFASE034,t1.CODTRA_034 CODTRA034,t1.CORTRA_034 CORTRA034,t1.BLOQUEO_034 BLOQUEO034,t1.TIPO_034 TIPO034,t1.REMITENTE_034 REMITENTE034 ");
		// FROM
		query.append("FROM AA83B34T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b34t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b34t00.class,
						query, params, "CODSOLIC_034");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b34t00 table.
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b34t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b34t00>> findAllLikeJerarquia(
			Aa83b34t00 filterAa83b34t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODSOLIC_034 CODSOLIC034,t1.CODAPL_034 CODAPL034,t1.TIPSUB_034 TIPSUB034,t1.NUMANO_034 NUMANO034,t1.CODDEL_034 CODDEL034,t1.NUMDEL_034 NUMDEL034,t1.FLECTURA_034 FLECTURA034,t1.JMSID_034 JMSID034,t1.NUMREG_034 NUMREG034,t1.FREGISTRO_034 FREGISTRO034,t1.QRCODE_034 QRCODE034,t1.MENSAJE_034 MENSAJE034,t1.SITUACION_034 SITUACION034,t1.CODFASE_034 CODFASE034,t1.CODTRA_034 CODTRA034,t1.CORTRA_034 CORTRA034,t1.BLOQUEO_034 BLOQUEO034,t1.TIPO_034 TIPO034,t1.REMITENTE_034 REMITENTE034 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B34T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B34T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b34t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CODSOLIC_034", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b34t00 filterAa83b34t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B34T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B34T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b34t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CODSOLIC_034", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b34t00
	 *            Aa83b34t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b34t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b34t00>> findAllChild(
			Aa83b34t00 filterAa83b34t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B34T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B34T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b34t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CODSOLIC_034", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa83b34t00>(this.rwMapPK,
						"CODSOLIC_034"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b34t00 entity
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b34t00 aa83b34t00) {

		StringBuilder where = new StringBuilder(
				Aa83b34t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b34t00 != null && aa83b34t00.getCodsolic034() != null) {
			where.append(" AND t1.CODSOLIC_034 = ?");
			params.add(aa83b34t00.getCodsolic034());
		}
		if (aa83b34t00 != null && aa83b34t00.getCodapl034() != null) {
			where.append(" AND t1.CODAPL_034 = ?");
			params.add(aa83b34t00.getCodapl034());
		}
		if (aa83b34t00 != null && aa83b34t00.getTipsub034() != null) {
			where.append(" AND t1.TIPSUB_034 = ?");
			params.add(aa83b34t00.getTipsub034());
		}
		if (aa83b34t00 != null && aa83b34t00.getNumano034() != null) {
			where.append(" AND t1.NUMANO_034 = ?");
			params.add(aa83b34t00.getNumano034());
		}
		if (aa83b34t00 != null && aa83b34t00.getCoddel034() != null) {
			where.append(" AND t1.CODDEL_034 = ?");
			params.add(aa83b34t00.getCoddel034());
		}
		if (aa83b34t00 != null && aa83b34t00.getNumdel034() != null) {
			where.append(" AND t1.NUMDEL_034 = ?");
			params.add(aa83b34t00.getNumdel034());
		}
		if (aa83b34t00 != null && aa83b34t00.getFlectura034() != null) {
			where.append(" AND t1.FLECTURA_034 = ?");
			params.add(aa83b34t00.getFlectura034());
		}
		if (aa83b34t00 != null && aa83b34t00.getJmsid034() != null) {
			where.append(" AND t1.JMSID_034 = ?");
			params.add(aa83b34t00.getJmsid034());
		}
		if (aa83b34t00 != null && aa83b34t00.getNumreg034() != null) {
			where.append(" AND t1.NUMREG_034 = ?");
			params.add(aa83b34t00.getNumreg034());
		}
		if (aa83b34t00 != null && aa83b34t00.getFregistro034() != null) {
			where.append(" AND t1.FREGISTRO_034 = ?");
			params.add(aa83b34t00.getFregistro034());
		}
		if (aa83b34t00 != null && aa83b34t00.getQrcode034() != null) {
			where.append(" AND t1.QRCODE_034 = ?");
			params.add(aa83b34t00.getQrcode034());
		}
		if (aa83b34t00 != null && aa83b34t00.getSituacion034() != null) {
			where.append(" AND t1.SITUACION_034 = ?");
			params.add(aa83b34t00.getSituacion034());
		}
		if (aa83b34t00 != null && aa83b34t00.getCodfase034() != null) {
			where.append(" AND t1.CODFASE_034 = ?");
			params.add(aa83b34t00.getCodfase034());
		}
		if (aa83b34t00 != null && aa83b34t00.getCodtra034() != null) {
			where.append(" AND t1.CODTRA_034 = ?");
			params.add(aa83b34t00.getCodtra034());
		}
		if (aa83b34t00 != null && aa83b34t00.getCortra034() != null) {
			where.append(" AND t1.CORTRA_034 = ?");
			params.add(aa83b34t00.getCortra034());
		}
		if (aa83b34t00 != null && aa83b34t00.getBloqueo034() != null) {
			where.append(" AND t1.BLOQUEO_034 = ?");
			params.add(aa83b34t00.getBloqueo034());
		}
		if (aa83b34t00 != null && aa83b34t00.getTipo034() != null) {
			where.append(" AND t1.TIPO_034 = ?");
			params.add(aa83b34t00.getTipo034());
		}
		if (aa83b34t00 != null && aa83b34t00.getRemitente034() != null) {
			where.append(" AND t1.REMITENTE_034 = ?");
			params.add(aa83b34t00.getRemitente034());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b34t00 entity
	 * 
	 * @param aa83b34t00
	 *            Aa83b34t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b34t00 aa83b34t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b34t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b34t00 != null && aa83b34t00.getCodsolic034() != null) {
			where.append(" AND t1.CODSOLIC_034 = ?");
			params.add(aa83b34t00.getCodsolic034());
		}
		if (aa83b34t00 != null && aa83b34t00.getCodapl034() != null) {
			where.append(" AND UPPER(t1.CODAPL_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getCodapl034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getCodapl034().toUpperCase() + "%");
			}
			where.append(" AND t1.CODAPL_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getTipsub034() != null && !aa83b34t00.getTipsub034().equals("0")) {
			where.append(" AND UPPER(t1.TIPSUB_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getTipsub034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getTipsub034().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPSUB_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getNumano034() != null) {
			where.append(" AND t1.NUMANO_034 = ?");
			params.add(aa83b34t00.getNumano034());
		}
		if (aa83b34t00 != null && aa83b34t00.getCoddel034() != null && !aa83b34t00.getCoddel034().equals("0")) {
			where.append(" AND UPPER(t1.CODDEL_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getCoddel034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getCoddel034().toUpperCase() + "%");
			}
			where.append(" AND t1.CODDEL_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getNumdel034() != null) {
			where.append(" AND t1.NUMDEL_034 = ?");
			params.add(aa83b34t00.getNumdel034());
		}
		if (aa83b34t00 != null && aa83b34t00.getFlectura034() != null) {
			where.append(" AND t1.FLECTURA_034 = ?");
			params.add(aa83b34t00.getFlectura034());
		}
		if (aa83b34t00 != null && aa83b34t00.getJmsid034() != null) {
			where.append(" AND UPPER(t1.JMSID_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getJmsid034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getJmsid034().toUpperCase() + "%");
			}
			where.append(" AND t1.JMSID_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getNumreg034() != null) {
			where.append(" AND UPPER(t1.NUMREG_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getNumreg034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getNumreg034().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMREG_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getFregistro034() != null) {
			SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
			String fechaStr = formato.format(aa83b34t00.getFregistro034());
			where.append(" AND t1.FREGISTRO_034 > trunc(to_date(?,'dd/mm/yyyy'))");
			where.append(" AND t1.FREGISTRO_034 < trunc(to_date(?, 'dd/mm/yyyy'))+1");
			params.add(fechaStr);
			params.add(fechaStr);
		}
		if (aa83b34t00 != null && aa83b34t00.getQrcode034() != null) {
			where.append(" AND UPPER(t1.QRCODE_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getQrcode034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getQrcode034().toUpperCase() + "%");
			}
			where.append(" AND t1.QRCODE_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getSituacion034() != null) {
			where.append(" AND UPPER(t1.SITUACION_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getSituacion034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getSituacion034().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SITUACION_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getCodfase034() != null && !aa83b34t00.getCodfase034().equals("0")) {
			where.append(" AND UPPER(t1.CODFASE_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getCodfase034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getCodfase034().toUpperCase() + "%");
			}
			where.append(" AND t1.CODFASE_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getCodtra034() != null && !aa83b34t00.getCodtra034().equals("0")) {
			where.append(" AND UPPER(t1.CODTRA_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getCodtra034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getCodtra034().toUpperCase() + "%");
			}
			where.append(" AND t1.CODTRA_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getCortra034() != null) {
			where.append(" AND t1.CORTRA_034 = ?");
			params.add(aa83b34t00.getCortra034());
		}
		if (aa83b34t00 != null && aa83b34t00.getBloqueo034() != null) {
			where.append(" AND t1.BLOQUEO_034 = ?");
			params.add(aa83b34t00.getBloqueo034());
		}
		if (aa83b34t00 != null && aa83b34t00.getTipo034() != null && !aa83b34t00.getTipo034().equals("0")) {
			where.append(" AND UPPER(t1.TIPO_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getTipo034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getTipo034().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO_034 IS NOT NULL");
		}
		if (aa83b34t00 != null && aa83b34t00.getRemitente034() != null) {
			where.append(" AND UPPER(t1.REMITENTE_034) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b34t00.getRemitente034().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b34t00.getRemitente034().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.REMITENTE_034 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Aa83b34t00 updateQR(Aa83b34t00 aa83b34t00) {
		// TODO Auto-generated method stub
		String query = "UPDATE AA83B34T00 SET QRCODE_034 =?, SITUACION_034 ='P'"
				+ " WHERE CODSOLIC_034=?  ";
		this.jdbcTemplate.update(query, aa83b34t00.getQrcode034(),
				aa83b34t00.getCodsolic034());
		System.out.println("updateQR Actualizado:: "
				+ aa83b34t00.getQrcode034());
		return aa83b34t00;
	}

	@Override
	public Aa83b34t00 updateProcesar(Aa83b34t00 aa83b34t00) {
		// TODO Auto-generated method stub
		String query = "UPDATE AA83B34T00 SET SITUACION_034 ='P'"
				+ " WHERE CODSOLIC_034=?  ";
		this.jdbcTemplate.update(query, aa83b34t00.getCodsolic034());
		System.out.println("updateProcesar Actualizado:: "
				+ aa83b34t00.getQrcode034());
		return aa83b34t00;
	}

}
