package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b31t00;
import com.ejie.aa83b.model.Aa83b31v01;

/**
 * Aa83b31t00DaoImpl generated by UDA, 23-nov-2016 16:44:45.
 * @author UDA
 */
 
@Repository
@Transactional
public class Aa83b31t00DaoImpl implements Aa83b31t00Dao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b31t00> rwMap = new RowMapper<Aa83b31t00>() {
		public Aa83b31t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Aa83b31t00 aa83b31t00= new Aa83b31t00(
               resultSet.getInt("ID031"), resultSet.getLong("IDANO021"), resultSet.getInt("ID030TIPDOCSOL"), resultSet.getInt("ID021NUMSOL"), resultSet.getString("OID031PAPEL0"), resultSet.getInt("ID009HISTOTRAM"), resultSet.getString("DESCOTROS031"), resultSet.getString("ORGDOCENTREGADO031"), resultSet.getString("NOMDOCENTREGADO031"), resultSet.getDate("FECDOCENTREGADO031"), resultSet.getString("TIPOAPORTACION031"));
			
			return aa83b31t00;
		} 
	} ;
	
	private RowMapper<Aa83b31t00> rwMapV31 = new RowMapper<Aa83b31t00>() {
		public Aa83b31t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Aa83b31t00 aa83b31t00= new Aa83b31t00(
               resultSet.getInt("ID031"), resultSet.getLong("IDANO021"), resultSet.getInt("ID030TIPDOCSOL"), resultSet.getInt("ID021NUMSOL"), resultSet.getString("OID031PAPEL0"), resultSet.getInt("ID009HISTOTRAM"), resultSet.getString("DESCOTROS031"), resultSet.getString("ORGDOCENTREGADO031"), resultSet.getString("NOMDOCENTREGADO031"), resultSet.getDate("FECDOCENTREGADO031"), resultSet.getString("TIPOAPORTACION031"));
			
			if (resultSet.getString("FASEDESCES001") != null ){
				aa83b31t00.setFaseDescEs(resultSet.getString("FASEDESCES001"));
			}
			if (resultSet.getString("FASEDESCEU001") != null ){
				aa83b31t00.setFaseDescEu(resultSet.getString("FASEDESCEU001"));
			}
			if (resultSet.getString("TRAMITEDESCES002") != null ){
				aa83b31t00.setTramiteDescEs(resultSet.getString("TRAMITEDESCES002"));
			}
			if (resultSet.getString("TRAMITEDESCEU002") != null ){
				aa83b31t00.setTramiteDescEu(resultSet.getString("TRAMITEDESCEU002"));
			}
			if (resultSet.getString("ID_TRAMITE_002") != null ){
				aa83b31t00.setIdTramite(resultSet.getInt("ID_TRAMITE_002"));
			}
			return aa83b31t00;
		} 
	} ;	
        
	private RowMapper<Aa83b31v01> rwMap2 = new RowMapper<Aa83b31v01>() {
		public Aa83b31v01 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Aa83b31v01(
               resultSet.getLong("IDANO021"), 
               resultSet.getInt("ID021NUMSOL"), 
               resultSet.getInt("ID030TIPDOCSOL"), 
               resultSet.getString("DESCES030"), 
               resultSet.getString("DESCEU030")
           ); } } ;
	
	private RowMapper<Aa83b31t00> rwMapPK = new RowMapper<Aa83b31t00>() {
		public Aa83b31t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa83b31t00(
				resultSet.getInt("ID031"), resultSet.getLong("IDANO021"), resultSet.getInt("ID030TIPDOCSOL"), resultSet.getInt("ID021NUMSOL"), resultSet.getString("OID031PAPEL0"), resultSet.getInt("ID009HISTOTRAM"), resultSet.getString("DESCOTROS031"), resultSet.getString("ORGDOCENTREGADO031"), resultSet.getString("NOMDOCENTREGADO031"), resultSet.getDate("FECDOCENTREGADO031"), resultSet.getString("TIPOAPORTACION031")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
     * @param dataSource DataSource
     * @return
     */
	private RowMapper<JerarquiaDto< Aa83b31t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b31t00>>() {
		public JerarquiaDto<Aa83b31t00> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Aa83b31t00 aa83b31t00 = new Aa83b31t00(resultSet.getInt("ID031"), resultSet.getLong("IDANO021"), resultSet.getInt("ID030TIPDOCSOL"), resultSet.getInt("ID021NUMSOL"), resultSet.getString("OID031PAPEL0"), resultSet.getInt("ID009HISTOTRAM"), resultSet.getString("DESCOTROS031"), resultSet.getString("ORGDOCENTREGADO031"), resultSet.getString("NOMDOCENTREGADO031"), resultSet.getDate("FECDOCENTREGADO031"), resultSet.getString("TIPOAPORTACION031"));

			JerarquiaDto<Aa83b31t00> jerarquia = new JerarquiaDto<Aa83b31t00>();
			jerarquia.setModel(aa83b31t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
     * Inserts a single row in the Aa83b31t00 table.
     *
     * @param aa83b31t00 Aa83b31t00
     * @return Aa83b31t00
     */
	public Aa83b31t00 add(Aa83b31t00 aa83b31t00) {
    	String query = "INSERT INTO AA83B31T00 (ID_031, ID_ANO_021, ID_030_TIP_DOC_SOL, ID_021_NUM_SOL, OID_031_PAPEL0, ID_009_HISTO_TRAM, DESC_OTROS_031, ORG_DOC_ENTREGADO_031, NOM_DOC_ENTREGADO_031, FEC_DOC_ENTREGADO_031, TIPO_APORTACION_031) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b31t00.getId031(), aa83b31t00.getIdAno021(), aa83b31t00.getId030TipDocSol(), aa83b31t00.getId021NumSol(), aa83b31t00.getOid031Papel0(), aa83b31t00.getId009HistoTram(), aa83b31t00.getDescOtros031(), aa83b31t00.getOrgDocEntregado031(), aa83b31t00.getNomDocEntregado031(), aa83b31t00.getFecDocEntregado031(), aa83b31t00.getTipoAportacion031());
		return aa83b31t00;
	}

    /**
     * Updates a single row in the Aa83b31t00 table.
     *
     * @param aa83b31t00 Aa83b31t00
     * @return Aa83b31t00
     */
    public Aa83b31t00 update(Aa83b31t00 aa83b31t00) {
		String query = "UPDATE AA83B31T00 SET ID_ANO_021=?, ID_030_TIP_DOC_SOL=?, ID_021_NUM_SOL=?, OID_031_PAPEL0=?, ID_009_HISTO_TRAM=?, DESC_OTROS_031=?, ORG_DOC_ENTREGADO_031=?, NOM_DOC_ENTREGADO_031=?, FEC_DOC_ENTREGADO_031=?, TIPO_APORTACION_031=? WHERE ID_031=?";
		this.jdbcTemplate.update(query, aa83b31t00.getIdAno021(), aa83b31t00.getId030TipDocSol(), aa83b31t00.getId021NumSol(), aa83b31t00.getOid031Papel0(), aa83b31t00.getId009HistoTram(), aa83b31t00.getDescOtros031(), aa83b31t00.getOrgDocEntregado031(), aa83b31t00.getNomDocEntregado031(), aa83b31t00.getFecDocEntregado031(), aa83b31t00.getTipoAportacion031(), aa83b31t00.getId031());
		return aa83b31t00;
	}

    /**
     * Finds a single row in the Aa83b31t00 table.
     *
     * @param aa83b31t00 Aa83b31t00
     * @return Aa83b31t00
     */
    @Transactional (readOnly = true)
    public Aa83b31t00 find(Aa83b31t00 aa83b31t00) {
		String query = "SELECT t1.ID_031 ID031, t1.ID_ANO_021 IDANO021, t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL, t1.ID_021_NUM_SOL ID021NUMSOL, t1.OID_031_PAPEL0 OID031PAPEL0, t1.ID_009_HISTO_TRAM ID009HISTOTRAM, t1.DESC_OTROS_031 DESCOTROS031, t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031, t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031, t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031, t1.TIPO_APORTACION_031 TIPOAPORTACION031 FROM AA83B31T00 t1  WHERE t1.ID_031 = ? ";
		
		List<Aa83b31t00> aa83b31t00List = this.jdbcTemplate.query(query, this.rwMap, aa83b31t00.getId031());
		return (Aa83b31t00) DataAccessUtils.uniqueResult(aa83b31t00List);
    }

    /**
     * Removes a single row in the Aa83b31t00 table.
     *
     * @param aa83b31t00 Aa83b31t00
     * @return
     */
    public void remove(Aa83b31t00 aa83b31t00) {
		String query = "DELETE FROM AA83B31T00 WHERE ID_031=?";
		this.jdbcTemplate.update(query, aa83b31t00.getId031());
    }
    
   /**
    * Finds a list of rows in the Aa83b31t00 table.
    * 
    * @param aa83b31t00 Aa83b31t00
    * @param jqGridRequestDto JQGridRequestDto
    * @return List<Aa83b31t00> 
    */
	@Transactional (readOnly = true)
    public List<Aa83b31t00> findAll(Aa83b31t00 aa83b31t00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_031 ID031,t1.ID_ANO_021 IDANO021,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_021_NUM_SOL ID021NUMSOL,t1.OID_031_PAPEL0 OID031PAPEL0,t1.ID_009_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_031 DESCOTROS031,t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031,t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031,t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031,t1.TIPO_APORTACION_031 TIPOAPORTACION031 "); 
		query.append("FROM AA83B31T00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b31t00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b31t00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    public List<Aa83b31v01> findDistinctAll(Aa83b31v01 aa83b31v01) {
		StringBuilder query = new StringBuilder("SELECT  t1.IDANO021 IDANO021,t1.ID021NUMSOL ID021NUMSOL,t1.ID030TIPDOCSOL ID030TIPDOCSOL,t1.DESCES030 DESCES030,t1.DESCEU030 DESCEU030 "); 
		query.append("FROM AA83B31V01 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b31v01); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa83b31v01>) this.jdbcTemplate.query(query.toString(), this.rwMap2, params.toArray());
	}
	
	/**
	 * Finds rows in the Aa83b31t00 table using like.
     * 
     * @param aa83b31t00 Aa83b31t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<Aa83b31t00>
     */
	@Transactional (readOnly = true)
    public List<Aa83b31t00> findAllLike(Aa83b31t00 aa83b31t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		StringBuilder query;
		
        if (aa83b31t00.isConFaseTramite()){
    		query = new StringBuilder("SELECT  t1.ID_031 ID031,t1.ID_ANO_021 IDANO021,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_021_NUM_SOL ID021NUMSOL,t1.OID_031_PAPEL0 OID031PAPEL0,t1.ID_009_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_031 DESCOTROS031,t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031,t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031,t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031,t1.TIPO_APORTACION_031 TIPOAPORTACION031 , t1.FASE_DESC_ES_001 FASEDESCES001, t1.FASE_DESC_EU_001 FASEDESCEU001, t1.TRAMITE_DESC_ES_002 TRAMITEDESCES002, t1.TRAMITE_DESC_EU_002 TRAMITEDESCEU002 , ID_TRAMITE_002 "); 
            query.append("FROM AA83B31V00 t1 ");        	
        } else {
    		query = new StringBuilder("SELECT  t1.ID_031 ID031,t1.ID_ANO_021 IDANO021,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_021_NUM_SOL ID021NUMSOL,t1.OID_031_PAPEL0 OID031PAPEL0,t1.ID_009_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_031 DESCOTROS031,t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031,t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031,t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031,t1.TIPO_APORTACION_031 TIPOAPORTACION031 "); 
            query.append("FROM AA83B31T00 t1 ");        	
        }
        
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b31t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		if (aa83b31t00.isConFaseTramite()){
			return (List<Aa83b31t00>) this.jdbcTemplate.query(query.toString(), this.rwMapV31, params.toArray());
		} else {
			return (List<Aa83b31t00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());			
		}
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
     * Counts rows in the Aa83b31t00 table.
     * 
     * @param aa83b31t00 Aa83b31t00
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Aa83b31t00 aa83b31t00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B31T00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b31t00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Aa83b31t00 table using like.
     * 
     * @param aa83b31t00 Aa83b31t00
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Aa83b31t00 aa83b31t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B31T00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b31t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b31t00 selected for rup_table
     * 
     * @param aa83b31t00 Aa83b31t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b31t00>> 
     */
	@Override 
	public List<TableRowDto<Aa83b31t00>> reorderSelection(Aa83b31t00 aa83b31t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_031 ID031,t1.ID_ANO_021 IDANO021,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_021_NUM_SOL ID021NUMSOL,t1.OID_031_PAPEL0 OID031PAPEL0,t1.ID_009_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_031 DESCOTROS031,t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031,t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031,t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031,t1.TIPO_APORTACION_031 TIPOAPORTACION031 "); 
		// FROM
        query.append("FROM AA83B31T00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b31t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Aa83b31t00.class, filterParamList, "ID_031,ID_ANO_021,ID_030_TIP_DOC_SOL,ID_021_NUM_SOL,OID_031_PAPEL0,ID_009_HISTO_TRAM,DESC_OTROS_031,ORG_DOC_ENTREGADO_031,NOM_DOC_ENTREGADO_031,FEC_DOC_ENTREGADO_031,TIPO_APORTACION_031" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b31t00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
     * 
     * @param filterParams Aa83b31t00
     * @param searchParams Aa83b31t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b31t00>> 
     */
	@Override
	public List<TableRowDto<Aa83b31t00>> search(Aa83b31t00 filterParams, Aa83b31t00 searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_031 ID031,t1.ID_ANO_021 IDANO021,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_021_NUM_SOL ID021NUMSOL,t1.OID_031_PAPEL0 OID031PAPEL0,t1.ID_009_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_031 DESCOTROS031,t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031,t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031,t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031,t1.TIPO_APORTACION_031 TIPOAPORTACION031 "); 
		// FROM
        query.append("FROM AA83B31T00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Aa83b31t00.class, filterParamList, searchSQL, searchParamList, from_alias, "ID_031,ID_ANO_021,ID_030_TIP_DOC_SOL,ID_021_NUM_SOL,OID_031_PAPEL0,ID_009_HISTO_TRAM,DESC_OTROS_031,ORG_DOC_ENTREGADO_031,NOM_DOC_ENTREGADO_031,FEC_DOC_ENTREGADO_031,TIPO_APORTACION_031");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b31t00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table
     * 
     * @param filteraa83b31t00 Aa83b31t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean 
     */
	@Override
	public void removeMultiple(Aa83b31t00 filteraa83b31t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.ID_031 ID031,t1.ID_ANO_021 IDANO021,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_021_NUM_SOL ID021NUMSOL,t1.OID_031_PAPEL0 OID031PAPEL0,t1.ID_009_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_031 DESCOTROS031,t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031,t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031,t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031,t1.TIPO_APORTACION_031 TIPOAPORTACION031 "); 
		// FROM
        query.append("FROM AA83B31T00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b31t00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Aa83b31t00.class, query, params, "ID_031,ID_ANO_021,ID_030_TIP_DOC_SOL,ID_021_NUM_SOL,OID_031_PAPEL0,ID_009_HISTO_TRAM,DESC_OTROS_031,ORG_DOC_ENTREGADO_031,NOM_DOC_ENTREGADO_031,FEC_DOC_ENTREGADO_031,TIPO_APORTACION_031");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b31t00 table.
     * 
     * @param filterAa83b31t00 Aa83b31t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<JerarquiaDto<Aa83b31t00>> 
     */
	@Override
	public List<JerarquiaDto<Aa83b31t00>> findAllLikeJerarquia(Aa83b31t00 filterAa83b31t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_031 ID031,t1.ID_ANO_021 IDANO021,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_021_NUM_SOL ID021NUMSOL,t1.OID_031_PAPEL0 OID031PAPEL0,t1.ID_009_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_031 DESCOTROS031,t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031,t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031,t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031,t1.TIPO_APORTACION_031 TIPOAPORTACION031 "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B31T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B31T00");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b31t00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID_031,ID_ANO_021,ID_030_TIP_DOC_SOL,ID_021_NUM_SOL,OID_031_PAPEL0,ID_009_HISTO_TRAM,DESC_OTROS_031,ORG_DOC_ENTREGADO_031,NOM_DOC_ENTREGADO_031,FEC_DOC_ENTREGADO_031,TIPO_APORTACION_031", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
     * 
     * @param filterAa83b31t00 Aa83b31t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return Long 
     */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b31t00 filterAa83b31t00, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B31T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B31T00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b31t00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID_031,ID_ANO_021,ID_030_TIP_DOC_SOL,ID_021_NUM_SOL,OID_031_PAPEL0,ID_009_HISTO_TRAM,DESC_OTROS_031,ORG_DOC_ENTREGADO_031,NOM_DOC_ENTREGADO_031,FEC_DOC_ENTREGADO_031,TIPO_APORTACION_031", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
     * 
     * @param filterAa83b31t00 Aa83b31t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<TableRowDto<Aa83b31t00>> 
     */
	@Override
	public List<TableRowDto<Aa83b31t00>> findAllChild(Aa83b31t00 filterAa83b31t00, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B31T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B31T00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b31t00, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID_031,ID_ANO_021,ID_030_TIP_DOC_SOL,ID_021_NUM_SOL,OID_031_PAPEL0,ID_009_HISTO_TRAM,DESC_OTROS_031,ORG_DOC_ENTREGADO_031,NOM_DOC_ENTREGADO_031,FEC_DOC_ENTREGADO_031,TIPO_APORTACION_031", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Aa83b31t00>(this.rwMapPK, "ID_031,ID_ANO_021,ID_030_TIP_DOC_SOL,ID_021_NUM_SOL,OID_031_PAPEL0,ID_009_HISTO_TRAM,DESC_OTROS_031,ORG_DOC_ENTREGADO_031,NOM_DOC_ENTREGADO_031,FEC_DOC_ENTREGADO_031,TIPO_APORTACION_031"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Aa83b31t00 entity 
	 * 
	 * @param aa83b31t00 Aa83b31t00
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Aa83b31t00 aa83b31t00){
		
		StringBuilder where = new StringBuilder(Aa83b31t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b31t00  != null  && aa83b31t00.getId031() != null ) {
			where.append(" AND t1.ID_031 = ?");
			params.add(aa83b31t00.getId031());
		}
		if (aa83b31t00  != null  && aa83b31t00.getIdAno021() != null ) {
			where.append(" AND t1.ID_ANO_021 = ?");
			params.add(aa83b31t00.getIdAno021());
		}
		if (aa83b31t00  != null  && aa83b31t00.getId030TipDocSol() != null ) {
			where.append(" AND t1.ID_030_TIP_DOC_SOL = ?");
			params.add(aa83b31t00.getId030TipDocSol());
		}
		if (aa83b31t00  != null  && aa83b31t00.getId021NumSol() != null ) {
			where.append(" AND t1.ID_021_NUM_SOL = ?");
			params.add(aa83b31t00.getId021NumSol());
		}
		if (aa83b31t00  != null  && aa83b31t00.getOid031Papel0() != null ) {
			where.append(" AND t1.OID_031_PAPEL0 = ?");
			params.add(aa83b31t00.getOid031Papel0());
		}
		if (aa83b31t00  != null  && aa83b31t00.getId009HistoTram() != null ) {
			where.append(" AND t1.ID_009_HISTO_TRAM = ?");
			params.add(aa83b31t00.getId009HistoTram());
		}
		if (aa83b31t00  != null  && aa83b31t00.getDescOtros031() != null ) {
			where.append(" AND t1.DESC_OTROS_031 = ?");
			params.add(aa83b31t00.getDescOtros031());
		}
		if (aa83b31t00  != null  && aa83b31t00.getOrgDocEntregado031() != null ) {
			where.append(" AND t1.ORG_DOC_ENTREGADO_031 = ?");
			params.add(aa83b31t00.getOrgDocEntregado031());
		}
		if (aa83b31t00  != null  && aa83b31t00.getNomDocEntregado031() != null ) {
			where.append(" AND t1.NOM_DOC_ENTREGADO_031 = ?");
			params.add(aa83b31t00.getNomDocEntregado031());
		}
		if (aa83b31t00  != null  && aa83b31t00.getFecDocEntregado031() != null ) {
			where.append(" AND t1.FEC_DOC_ENTREGADO_031 = ?");
			params.add(aa83b31t00.getFecDocEntregado031());
		}
		if (aa83b31t00  != null  && aa83b31t00.getTipoAportacion031() != null ) {
			where.append(" AND t1.TIPO_APORTACION_031 = ?");
			params.add(aa83b31t00.getTipoAportacion031());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	private Map<String, ?> getWhereMap (Aa83b31v01 aa83b31v01){
		
		StringBuilder where = new StringBuilder(Aa83b31t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b31v01  != null  && aa83b31v01.getIdano021() != null ) {
			where.append(" AND t1.IDANO021 = ?");
			params.add(aa83b31v01.getIdano021());
		}
		if (aa83b31v01  != null  && aa83b31v01.getId021numsol() != null ) {
			where.append(" AND t1.ID021NUMSOL = ?");
			params.add(aa83b31v01.getId021numsol());
		}
		if (aa83b31v01  != null  && aa83b31v01.getId030tipdocsol() != null ) {
			where.append(" AND t1.ID030TIPDOCSOL = ?");
			params.add(aa83b31v01.getId030tipdocsol());
		}
		if (aa83b31v01  != null  && aa83b31v01.getDesces030() != null ) {
			where.append(" AND t1.DESCES030 = ?");
			params.add(aa83b31v01.getDesces030());
		}
		if (aa83b31v01  != null  && aa83b31v01.getDesceu030() != null ) {
			where.append(" AND t1.DESCEU030 = ?");
			params.add(aa83b31v01.getDesceu030());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}	
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Aa83b31t00 entity 
	 * 
	 * @param aa83b31t00 Aa83b31t00
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (Aa83b31t00 aa83b31t00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(Aa83b31t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b31t00  != null  && aa83b31t00.getId031() != null ) {
			where.append(" AND t1.ID_031 = ?");
			params.add(aa83b31t00.getId031());
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getIdAno021() != null ) {
			where.append(" AND t1.ID_ANO_021 = ?");
			params.add(aa83b31t00.getIdAno021());
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getId030TipDocSol() != null ) {
			where.append(" AND t1.ID_030_TIP_DOC_SOL = ?");
			params.add(aa83b31t00.getId030TipDocSol());
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getId021NumSol() != null ) {
			where.append(" AND t1.ID_021_NUM_SOL = ?");
			params.add(aa83b31t00.getId021NumSol());
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getOid031Papel0() != null ) {
			where.append(" AND UPPER(t1.OID_031_PAPEL0) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b31t00.getOid031Papel0().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b31t00.getOid031Papel0().toUpperCase() +"%");
			}
			where.append(" AND t1.OID_031_PAPEL0 IS NOT NULL");
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getId009HistoTram() != null ) {
			where.append(" AND t1.ID_009_HISTO_TRAM = ?");
			params.add(aa83b31t00.getId009HistoTram());
	     }		
		if (aa83b31t00  != null  && aa83b31t00.getIdTramite() != null ) {
			where.append(" AND t1.ID_TRAMITE_002 = ?");
			params.add(aa83b31t00.getIdTramite());
		}
		
		if (aa83b31t00  != null  && aa83b31t00.getDescOtros031() != null ) {
			where.append(" AND UPPER(t1.DESC_OTROS_031) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b31t00.getDescOtros031().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b31t00.getDescOtros031().toUpperCase() +"%");
			}
			where.append(" AND t1.DESC_OTROS_031 IS NOT NULL");
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getOrgDocEntregado031() != null ) {
			where.append(" AND UPPER(t1.ORG_DOC_ENTREGADO_031) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b31t00.getOrgDocEntregado031().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b31t00.getOrgDocEntregado031().toUpperCase() +"%");
			}
			where.append(" AND t1.ORG_DOC_ENTREGADO_031 IS NOT NULL");
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getNomDocEntregado031() != null ) {
			where.append(" AND UPPER(t1.NOM_DOC_ENTREGADO_031) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b31t00.getNomDocEntregado031().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b31t00.getNomDocEntregado031().toUpperCase() +"%");
			}
			where.append(" AND t1.NOM_DOC_ENTREGADO_031 IS NOT NULL");
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getFecDocEntregado031() != null ) {
			where.append(" AND t1.FEC_DOC_ENTREGADO_031 = ?");
			params.add(aa83b31t00.getFecDocEntregado031());
	     }			
		if (aa83b31t00  != null  && aa83b31t00.getTipoAportacion031() != null ) {
			where.append(" AND UPPER(t1.TIPO_APORTACION_031) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b31t00.getTipoAportacion031().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b31t00.getTipoAportacion031().toUpperCase() +"%");
			}
			where.append(" AND t1.TIPO_APORTACION_031 IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

