package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b30t00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilidades;

/**
 * Aa83b30t00DaoImpl generated by UDA, 02-feb-2016 16:34:21.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b30t00DaoImpl implements Aa83b30t00Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b30t00> rwMap = new RowMapper<Aa83b30t00>() {
		public Aa83b30t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b30t00(
					resultSet.getInt("ID030"),
					resultSet.getInt("ID001FASE"),
					resultSet.getInt("ID002TRAM"),
					resultSet.getInt("ID003TIPOSOL"),
					Aa83bUtilidades.TildesHtml(resultSet.getString("DESCES030")),
					resultSet.getString("DESCEU030"), resultSet
							.getString("TDDOKUSI030"), resultSet
							.getString("SDDOKUSI030"));
		}
	};
	
	private RowMapper<Aa83b30t00> rwMapPK = new RowMapper<Aa83b30t00>() {
		public Aa83b30t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b30t00(resultSet.getInt("ID030"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b30t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b30t00>>() {
		public JerarquiaDto<Aa83b30t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa83b30t00 aa83b30t00 = new Aa83b30t00(resultSet.getInt("ID030"),
					resultSet.getInt("ID001FASE"),
					resultSet.getInt("ID002TRAM"),
					resultSet.getInt("ID003TIPOSOL"),
					resultSet.getString("DESCES030"),
					resultSet.getString("DESCEU030"),
					resultSet.getString("TDDOKUSI030"),
					resultSet.getString("SDDOKUSI030"));

			JerarquiaDto<Aa83b30t00> jerarquia = new JerarquiaDto<Aa83b30t00>();
			jerarquia.setModel(aa83b30t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b30t00 table.
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @return Aa83b30t00
	 */
	public Aa83b30t00 add(Aa83b30t00 aa83b30t00) {
		String query = "INSERT INTO AA83B30T00 (ID_030, ID_001_FASE, ID_002_TRAM, ID_003_TIPO_SOL, DESC_ES_030, DESC_EU_030, TD_DOKUSI_030, SD_DOKUSI_030) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b30t00.getId030(),
				aa83b30t00.getId001Fase(), aa83b30t00.getId002Tram(),
				aa83b30t00.getId003TipoSol(), aa83b30t00.getDescEs030(),
				aa83b30t00.getDescEu030(), aa83b30t00.getTdDokusi030(),
				aa83b30t00.getSdDokusi030());
		return aa83b30t00;
	}

	/**
	 * Updates a single row in the Aa83b30t00 table.
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @return Aa83b30t00
	 */
	public Aa83b30t00 update(Aa83b30t00 aa83b30t00) {
		String query = "UPDATE AA83B30T00 SET ID_001_FASE=?, ID_002_TRAM=?, ID_003_TIPO_SOL=?, DESC_ES_030=?, DESC_EU_030=?, TD_DOKUSI_030=?, SD_DOKUSI_030=? WHERE ID_030=?";
		this.jdbcTemplate.update(query, aa83b30t00.getId001Fase(),
				aa83b30t00.getId002Tram(), aa83b30t00.getId003TipoSol(),
				aa83b30t00.getDescEs030(), aa83b30t00.getDescEu030(),
				aa83b30t00.getTdDokusi030(), aa83b30t00.getSdDokusi030(),
				aa83b30t00.getId030());
		return aa83b30t00;
	}

	/**
	 * Finds a single row in the Aa83b30t00 table.
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @return Aa83b30t00
	 */
	@Transactional(readOnly = true)
	public Aa83b30t00 find(Aa83b30t00 aa83b30t00) {
		String query = "SELECT t1.ID_030 ID030, t1.ID_001_FASE ID001FASE, t1.ID_002_TRAM ID002TRAM, t1.ID_003_TIPO_SOL ID003TIPOSOL, t1.DESC_ES_030 DESCES030, t1.DESC_EU_030 DESCEU030, t1.TD_DOKUSI_030 TDDOKUSI030, t1.SD_DOKUSI_030 SDDOKUSI030 FROM AA83B30T00 t1  WHERE t1.ID_030 = ?  ";

		List<Aa83b30t00> aa83b30t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b30t00.getId030());
		return (Aa83b30t00) DataAccessUtils.uniqueResult(aa83b30t00List);
	}

	/**
	 * Removes a single row in the Aa83b30t00 table.
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @return
	 */
	public void remove(Aa83b30t00 aa83b30t00) {
		String query = "DELETE FROM AA83B30T00 WHERE ID_030=?";
		this.jdbcTemplate.update(query, aa83b30t00.getId030());
	}

	/**
	 * Finds a list of rows in the Aa83b30t00 table.
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b30t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b30t00> findAll(Aa83b30t00 aa83b30t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_030 ID030,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_030 DESCES030,t1.DESC_EU_030 DESCEU030,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		query.append("FROM AA83B30T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b30t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY t1.ID_030 ASC ");
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		return (List<Aa83b30t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b30t00 table using like.
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b30t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b30t00> findAllLike(Aa83b30t00 aa83b30t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_030 ID030,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_030 DESCES030,t1.DESC_EU_030 DESCEU030,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		query.append("FROM AA83B30T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b30t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY t1.ID_030 ASC ");
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b30t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
	
	/**
	 * Devuelve la lista de los documentos del tramite ordenados alfabeticamente
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @return List<Aa83b30t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b30t00> getDocumentosOrdenadosAlf(Aa83b30t00 aa83b30t00) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_030 ID030,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_030 DESCES030,t1.DESC_EU_030 DESCEU030,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		query.append("FROM AA83B30T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b30t00);
		StringBuilder where = new StringBuilder(" WHERE t1.TD_DOKUSI_030 <>(select id_codigo_036 from aa83b36t00 where desc_es_036 = 'ejgv_d_solicitud') ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
			query.append(" order by case when  UPPER(desc_es_030)='OTROS' then 'z'||desc_eu_030 else desc_eu_030 end ");
		} else {
			query.append(" order by case when  UPPER(desc_es_030)='OTROS' then 'z'||desc_es_030 else desc_es_030 end ");
		}
		
		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa83b30t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b30t00 table.
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b30t00 aa83b30t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B30T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b30t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b30t00 table using like.
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b30t00 aa83b30t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B30T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b30t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b30t00 selected for rup_table
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b30t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b30t00>> reorderSelection(
			Aa83b30t00 aa83b30t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_030 ID030,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_030 DESCES030,t1.DESC_EU_030 DESCEU030,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		// FROM
		query.append("FROM AA83B30T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b30t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b30t00.class, filterParamList,
				"ID_030");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b30t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b30t00
	 * @param searchParams
	 *            Aa83b30t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b30t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b30t00>> search(Aa83b30t00 filterParams,
			Aa83b30t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_030 ID030,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_030 DESCES030,t1.DESC_EU_030 DESCEU030,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		// FROM
		query.append("FROM AA83B30T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b30t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_030");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b30t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b30t00
	 *            Aa83b30t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b30t00 filteraa83b30t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_030 ID030,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_030 DESCES030,t1.DESC_EU_030 DESCEU030,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		// FROM
		query.append("FROM AA83B30T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b30t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b30t00.class,
						query, params, "ID_030");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b30t00 table.
	 * 
	 * @param filterAa83b30t00
	 *            Aa83b30t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b30t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b30t00>> findAllLikeJerarquia(
			Aa83b30t00 filterAa83b30t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_030 ID030,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_030 DESCES030,t1.DESC_EU_030 DESCEU030,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B30T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B30T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b30t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_030", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b30t00
	 *            Aa83b30t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b30t00 filterAa83b30t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B30T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B30T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b30t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_030", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b30t00
	 *            Aa83b30t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b30t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b30t00>> findAllChild(
			Aa83b30t00 filterAa83b30t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B30T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B30T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b30t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_030", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa83b30t00>(this.rwMapPK,
								"ID_030"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b30t00 entity
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b30t00 aa83b30t00) {

		StringBuilder where = new StringBuilder(
				Aa83b30t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b30t00 != null && aa83b30t00.getId030() != null) {
			where.append(" AND t1.ID_030 = ?");
			params.add(aa83b30t00.getId030());
		}
		if (aa83b30t00 != null && aa83b30t00.getId001Fase() != null) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b30t00.getId001Fase());
		}
		if (aa83b30t00 != null && aa83b30t00.getId002Tram() != null) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b30t00.getId002Tram());
		}
		if (aa83b30t00 != null && aa83b30t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b30t00.getId003TipoSol());
		}
		if (aa83b30t00 != null && aa83b30t00.getDescEs030() != null) {
			where.append(" AND t1.DESC_ES_030 = ?");
			params.add(aa83b30t00.getDescEs030());
		}
		if (aa83b30t00 != null && aa83b30t00.getDescEu030() != null) {
			where.append(" AND t1.DESC_EU_030 = ?");
			params.add(aa83b30t00.getDescEu030());
		}
		if (aa83b30t00 != null && aa83b30t00.getTdDokusi030() != null) {
			where.append(" AND t1.TD_DOKUSI_030 = ?");
			params.add(aa83b30t00.getTdDokusi030());
		}
		if (aa83b30t00 != null && aa83b30t00.getSdDokusi030() != null) {
			where.append(" AND t1.SD_DOKUSI_030 = ?");
			params.add(aa83b30t00.getSdDokusi030());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b30t00 entity
	 * 
	 * @param aa83b30t00
	 *            Aa83b30t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b30t00 aa83b30t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b30t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b30t00 != null && aa83b30t00.getId030() != null) {
			where.append(" AND t1.ID_030 = ?");
			params.add(aa83b30t00.getId030());
		}
		if (aa83b30t00 != null && aa83b30t00.getId001Fase() != null) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b30t00.getId001Fase());
		}
		if (aa83b30t00 != null && aa83b30t00.getId002Tram() != null) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b30t00.getId002Tram());
		}
		if (aa83b30t00 != null && aa83b30t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b30t00.getId003TipoSol());
		}
		if (aa83b30t00 != null && aa83b30t00.getDescEs030() != null) {
			where.append(" AND UPPER(t1.DESC_ES_030) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b30t00.getDescEs030().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b30t00.getDescEs030().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_ES_030 IS NOT NULL");
		}
		if (aa83b30t00 != null && aa83b30t00.getDescEu030() != null) {
			where.append(" AND UPPER(t1.DESC_EU_030) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b30t00.getDescEu030().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b30t00.getDescEu030().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_EU_030 IS NOT NULL");
		}
		if (aa83b30t00 != null && aa83b30t00.getTdDokusi030() != null) {
			where.append(" AND UPPER(t1.TD_DOKUSI_030) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b30t00.getTdDokusi030().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b30t00.getTdDokusi030().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TD_DOKUSI_030 IS NOT NULL");
		}
		if (aa83b30t00 != null && aa83b30t00.getSdDokusi030() != null) {
			where.append(" AND UPPER(t1.SD_DOKUSI_030) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b30t00.getSdDokusi030().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b30t00.getSdDokusi030().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SD_DOKUSI_030 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	
    @Transactional (readOnly = true)
    public String buscarDocumentosPorBloque(String bloque) {
		String query = "select tipo.ID_030 ID030,tipo.DESC_ES_030 from aa83b30t00 tipo "
				+"where tipo.ID_040_BLOQUE=? ";
		
		ArrayList<String> params = new ArrayList<String>();
		params.add(bloque);
		List<Map<String,Object>> lista=this.jdbcTemplate.queryForList(query, params.toArray());
		String resultado="#";
		for(int i=0;i<lista.size();i++){
			Map<String,Object> datos=lista.get(i);
			resultado=resultado+datos.get("ID030")+"-"+datos.get("DESC_ES_030")+"#";
		}
		return resultado;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
