package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b29t00;

/**
 * Aa83b29t00DaoImpl generated by UDA, 08-feb-2016 12:28:01.
 * @author UDA
 */
 

@Repository
@Transactional
public class Aa83b29t00DaoImpl implements Aa83b29t00Dao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b29t00> rwMap = new RowMapper<Aa83b29t00>() {
		public Aa83b29t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Aa83b29t00(
               resultSet.getInt("ID029"), resultSet.getInt("ID025NUMSOL"), resultSet.getLong("IDANO025"), resultSet.getString("NOMBRE029"), resultSet.getString("PARENTENSCO029"), resultSet.getString("RESIDENCIA029"), resultSet.getString("DNINIE029")
           ); } } ;
           
	private RowMapper<Aa83b29t00> rwMapPK = new RowMapper<Aa83b29t00>() {
		public Aa83b29t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa83b29t00(
				resultSet.getInt("ID029"), resultSet.getInt("ID025NUMSOL"), resultSet.getLong("IDANO025"), resultSet.getString("NOMBRE029"), resultSet.getString("PARENTENSCO029"), resultSet.getString("RESIDENCIA029"), resultSet.getString("DNINIE029")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
     * @param dataSource DataSource
     * @return
     */
	private RowMapper<JerarquiaDto< Aa83b29t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b29t00>>() {
		public JerarquiaDto<Aa83b29t00> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Aa83b29t00 aa83b29t00 = new Aa83b29t00(resultSet.getInt("ID029"), resultSet.getInt("ID025NUMSOL"), resultSet.getLong("IDANO025"), resultSet.getString("NOMBRE029"), resultSet.getString("PARENTENSCO029"), resultSet.getString("RESIDENCIA029"), resultSet.getString("DNINIE029"));

			JerarquiaDto<Aa83b29t00> jerarquia = new JerarquiaDto<Aa83b29t00>();
			jerarquia.setModel(aa83b29t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
     * Inserts a single row in the Aa83b29t00 table.
     *
     * @param aa83b29t00 Aa83b29t00
     * @return Aa83b29t00
     */
	public Aa83b29t00 add(Aa83b29t00 aa83b29t00) {
    	String query = "INSERT INTO AA83B29T00 (ID_029, ID_025_NUM_SOL, ID_ANO_025, NOMBRE_029, PARENTENSCO_029, RESIDENCIA_029, DNI_NIE_029) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b29t00.getId029(), aa83b29t00.getId025NumSol(), aa83b29t00.getIdAno025(), aa83b29t00.getNombre029(), aa83b29t00.getParentensco029(), aa83b29t00.getResidencia029(), aa83b29t00.getDniNie029());
		return aa83b29t00;
	}

    /**
     * Updates a single row in the Aa83b29t00 table.
     *
     * @param aa83b29t00 Aa83b29t00
     * @return Aa83b29t00
     */
    public Aa83b29t00 update(Aa83b29t00 aa83b29t00) {
		String query = "UPDATE AA83B29T00 SET  WHERE ID_029=? AND ID_025_NUM_SOL=? AND ID_ANO_025=? AND NOMBRE_029=? AND PARENTENSCO_029=? AND RESIDENCIA_029=? AND DNI_NIE_029=?";
		this.jdbcTemplate.update(query, aa83b29t00.getId029(), aa83b29t00.getId025NumSol(), aa83b29t00.getIdAno025(), aa83b29t00.getNombre029(), aa83b29t00.getParentensco029(), aa83b29t00.getResidencia029(), aa83b29t00.getDniNie029());
		return aa83b29t00;
	}

    /**
     * Finds a single row in the Aa83b29t00 table.
     *
     * @param aa83b29t00 Aa83b29t00
     * @return Aa83b29t00
     */
    @Transactional (readOnly = true)
    public Aa83b29t00 find(Aa83b29t00 aa83b29t00) {
		String query = "SELECT t1.ID_029 ID029, t1.ID_025_NUM_SOL ID025NUMSOL, t1.ID_ANO_025 IDANO025, t1.NOMBRE_029 NOMBRE029, t1.PARENTENSCO_029 PARENTENSCO029, t1.RESIDENCIA_029 RESIDENCIA029, t1.DNI_NIE_029 DNINIE029 FROM AA83B29T00 t1  WHERE t1.ID_029 = ?   AND t1.ID_025_NUM_SOL = ?   AND t1.ID_ANO_025 = ?   AND t1.NOMBRE_029 = ?   AND t1.PARENTENSCO_029 = ?   AND t1.RESIDENCIA_029 = ?   AND t1.DNI_NIE_029 = ?  ";
		
		List<Aa83b29t00> aa83b29t00List = this.jdbcTemplate.query(query, this.rwMap, aa83b29t00.getId029() , aa83b29t00.getId025NumSol() , aa83b29t00.getIdAno025() , aa83b29t00.getNombre029() , aa83b29t00.getParentensco029() , aa83b29t00.getResidencia029() , aa83b29t00.getDniNie029());
		return (Aa83b29t00) DataAccessUtils.uniqueResult(aa83b29t00List);
    }

    /**
     * Removes a single row in the Aa83b29t00 table.
     *
     * @param aa83b29t00 Aa83b29t00
     * @return
     */
    public void remove(Aa83b29t00 aa83b29t00) {
		String query = "DELETE FROM AA83B29T00 WHERE ID_029=? AND ID_025_NUM_SOL=? AND ID_ANO_025=? AND NOMBRE_029=? AND PARENTENSCO_029=? AND RESIDENCIA_029=? AND DNI_NIE_029=?";
		this.jdbcTemplate.update(query, aa83b29t00.getId029() , aa83b29t00.getId025NumSol() , aa83b29t00.getIdAno025() , aa83b29t00.getNombre029() , aa83b29t00.getParentensco029() , aa83b29t00.getResidencia029() , aa83b29t00.getDniNie029());
    }
    /**
     * Removes in the Aa83b29t00 table.
     *
     * @param aa83b29t00 Aa83b29t00
     * @return
     */
    public void removePorSolicitud(Aa83b29t00 aa83b29t00) {
		String query = "DELETE FROM AA83B29T00 WHERE ID_025_NUM_SOL=? AND ID_ANO_025=?";
		this.jdbcTemplate.update(query, aa83b29t00.getId025NumSol() , aa83b29t00.getIdAno025());
    }
   /**
    * Finds a list of rows in the Aa83b29t00 table.
    * 
    * @param aa83b29t00 Aa83b29t00
    * @param jqGridRequestDto JQGridRequestDto
    * @return List<Aa83b29t00> 
    */
	@Transactional (readOnly = true)
    public List<Aa83b29t00> findAll(Aa83b29t00 aa83b29t00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_029 ID029,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_025 IDANO025,t1.NOMBRE_029 NOMBRE029,t1.PARENTENSCO_029 PARENTENSCO029,t1.RESIDENCIA_029 RESIDENCIA029,t1.DNI_NIE_029 DNINIE029 "); 
		query.append("FROM AA83B29T00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b29t00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b29t00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the Aa83b29t00 table using like.
     * 
     * @param aa83b29t00 Aa83b29t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<Aa83b29t00>
     */
	@Transactional (readOnly = true)
    public List<Aa83b29t00> findAllLike(Aa83b29t00 aa83b29t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_029 ID029,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_025 IDANO025,t1.NOMBRE_029 NOMBRE029,t1.PARENTENSCO_029 PARENTENSCO029,t1.RESIDENCIA_029 RESIDENCIA029,t1.DNI_NIE_029 DNINIE029 "); 
        query.append("FROM AA83B29T00 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b29t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b29t00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
     * Counts rows in the Aa83b29t00 table.
     * 
     * @param aa83b29t00 Aa83b29t00
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Aa83b29t00 aa83b29t00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B29T00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b29t00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Aa83b29t00 table using like.
     * 
     * @param aa83b29t00 Aa83b29t00
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Aa83b29t00 aa83b29t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B29T00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b29t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b29t00 selected for rup_table
     * 
     * @param aa83b29t00 Aa83b29t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b29t00>> 
     */
	@Override 
	public List<TableRowDto<Aa83b29t00>> reorderSelection(Aa83b29t00 aa83b29t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_029 ID029,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_025 IDANO025,t1.NOMBRE_029 NOMBRE029,t1.PARENTENSCO_029 PARENTENSCO029,t1.RESIDENCIA_029 RESIDENCIA029,t1.DNI_NIE_029 DNINIE029 "); 
		// FROM
        query.append("FROM AA83B29T00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b29t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Aa83b29t00.class, filterParamList, "ID_029,ID_025_NUM_SOL,ID_ANO_025,NOMBRE_029,PARENTENSCO_029,RESIDENCIA_029,DNI_NIE_029" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b29t00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
     * 
     * @param filterParams Aa83b29t00
     * @param searchParams Aa83b29t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b29t00>> 
     */
	@Override
	public List<TableRowDto<Aa83b29t00>> search(Aa83b29t00 filterParams, Aa83b29t00 searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_029 ID029,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_025 IDANO025,t1.NOMBRE_029 NOMBRE029,t1.PARENTENSCO_029 PARENTENSCO029,t1.RESIDENCIA_029 RESIDENCIA029,t1.DNI_NIE_029 DNINIE029 "); 
		// FROM
        query.append("FROM AA83B29T00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Aa83b29t00.class, filterParamList, searchSQL, searchParamList, from_alias, "ID_029,ID_025_NUM_SOL,ID_ANO_025,NOMBRE_029,PARENTENSCO_029,RESIDENCIA_029,DNI_NIE_029");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b29t00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table
     * 
     * @param filteraa83b29t00 Aa83b29t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean 
     */
	@Override
	public void removeMultiple(Aa83b29t00 filteraa83b29t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.ID_029 ID029,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_025 IDANO025,t1.NOMBRE_029 NOMBRE029,t1.PARENTENSCO_029 PARENTENSCO029,t1.RESIDENCIA_029 RESIDENCIA029,t1.DNI_NIE_029 DNINIE029 "); 
		// FROM
        query.append("FROM AA83B29T00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b29t00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Aa83b29t00.class, query, params, "ID_029,ID_025_NUM_SOL,ID_ANO_025,NOMBRE_029,PARENTENSCO_029,RESIDENCIA_029,DNI_NIE_029");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b29t00 table.
     * 
     * @param filterAa83b29t00 Aa83b29t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<JerarquiaDto<Aa83b29t00>> 
     */
	@Override
	public List<JerarquiaDto<Aa83b29t00>> findAllLikeJerarquia(Aa83b29t00 filterAa83b29t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_029 ID029,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_025 IDANO025,t1.NOMBRE_029 NOMBRE029,t1.PARENTENSCO_029 PARENTENSCO029,t1.RESIDENCIA_029 RESIDENCIA029,t1.DNI_NIE_029 DNINIE029 "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B29T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B29T00");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b29t00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID_029,ID_025_NUM_SOL,ID_ANO_025,NOMBRE_029,PARENTENSCO_029,RESIDENCIA_029,DNI_NIE_029", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
     * 
     * @param filterAa83b29t00 Aa83b29t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return Long 
     */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b29t00 filterAa83b29t00, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B29T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B29T00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b29t00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID_029,ID_025_NUM_SOL,ID_ANO_025,NOMBRE_029,PARENTENSCO_029,RESIDENCIA_029,DNI_NIE_029", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
     * 
     * @param filterAa83b29t00 Aa83b29t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<TableRowDto<Aa83b29t00>> 
     */
	@Override
	public List<TableRowDto<Aa83b29t00>> findAllChild(Aa83b29t00 filterAa83b29t00, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B29T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B29T00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b29t00, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID_029,ID_025_NUM_SOL,ID_ANO_025,NOMBRE_029,PARENTENSCO_029,RESIDENCIA_029,DNI_NIE_029", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Aa83b29t00>(this.rwMapPK, "ID_029,ID_025_NUM_SOL,ID_ANO_025,NOMBRE_029,PARENTENSCO_029,RESIDENCIA_029,DNI_NIE_029"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Aa83b29t00 entity 
	 * 
	 * @param aa83b29t00 Aa83b29t00
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Aa83b29t00 aa83b29t00){
		
		StringBuilder where = new StringBuilder(Aa83b29t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b29t00  != null  && aa83b29t00.getId029() != null ) {
			where.append(" AND t1.ID_029 = ?");
			params.add(aa83b29t00.getId029());
		}
		if (aa83b29t00  != null  && aa83b29t00.getId025NumSol() != null ) {
			where.append(" AND t1.ID_025_NUM_SOL = ?");
			params.add(aa83b29t00.getId025NumSol());
		}
		if (aa83b29t00  != null  && aa83b29t00.getIdAno025() != null ) {
			where.append(" AND t1.ID_ANO_025 = ?");
			params.add(aa83b29t00.getIdAno025());
		}
		if (aa83b29t00  != null  && aa83b29t00.getNombre029() != null ) {
			where.append(" AND t1.NOMBRE_029 = ?");
			params.add(aa83b29t00.getNombre029());
		}
		if (aa83b29t00  != null  && aa83b29t00.getParentensco029() != null ) {
			where.append(" AND t1.PARENTENSCO_029 = ?");
			params.add(aa83b29t00.getParentensco029());
		}
		if (aa83b29t00  != null  && aa83b29t00.getResidencia029() != null ) {
			where.append(" AND t1.RESIDENCIA_029 = ?");
			params.add(aa83b29t00.getResidencia029());
		}
		if (aa83b29t00  != null  && aa83b29t00.getDniNie029() != null ) {
			where.append(" AND t1.DNI_NIE_029 = ?");
			params.add(aa83b29t00.getDniNie029());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Aa83b29t00 entity 
	 * 
	 * @param aa83b29t00 Aa83b29t00
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (Aa83b29t00 aa83b29t00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(Aa83b29t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b29t00  != null  && aa83b29t00.getId029() != null ) {
			where.append(" AND t1.ID_029 = ?");
			params.add(aa83b29t00.getId029());
	     }			
		if (aa83b29t00  != null  && aa83b29t00.getId025NumSol() != null ) {
			where.append(" AND t1.ID_025_NUM_SOL = ?");
			params.add(aa83b29t00.getId025NumSol());
	     }			
		if (aa83b29t00  != null  && aa83b29t00.getIdAno025() != null ) {
			where.append(" AND t1.ID_ANO_025 = ?");
			params.add(aa83b29t00.getIdAno025());
	     }			
		if (aa83b29t00  != null  && aa83b29t00.getNombre029() != null ) {
			where.append(" AND UPPER(t1.NOMBRE_029) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b29t00.getNombre029().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b29t00.getNombre029().toUpperCase() +"%");
			}
			where.append(" AND t1.NOMBRE_029 IS NOT NULL");
	     }			
		if (aa83b29t00  != null  && aa83b29t00.getParentensco029() != null ) {
			where.append(" AND UPPER(t1.PARENTENSCO_029) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b29t00.getParentensco029().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b29t00.getParentensco029().toUpperCase() +"%");
			}
			where.append(" AND t1.PARENTENSCO_029 IS NOT NULL");
	     }			
		if (aa83b29t00  != null  && aa83b29t00.getResidencia029() != null ) {
			where.append(" AND UPPER(t1.RESIDENCIA_029) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b29t00.getResidencia029().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b29t00.getResidencia029().toUpperCase() +"%");
			}
			where.append(" AND t1.RESIDENCIA_029 IS NOT NULL");
	     }			
		if (aa83b29t00  != null  && aa83b29t00.getDniNie029() != null ) {
			where.append(" AND UPPER(t1.DNI_NIE_029) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b29t00.getDniNie029().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b29t00.getDniNie029().toUpperCase() +"%");
			}
			where.append(" AND t1.DNI_NIE_029 IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

