package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b25t00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa83b25t00DaoImpl generated by UDA, 28-dic-2015 17:45:22.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b25t00DaoImpl implements Aa83b25t00Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger LOGGER = LoggerFactory.getLogger(Aa83b25t00DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b25t00> rwMap = new RowMapper<Aa83b25t00>() {
		public Aa83b25t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b25t00(resultSet.getInt("ID025"),
					resultSet.getLong("IDANO025"),
					resultSet.getString("TELFNOTIFICACION025"),
					resultSet.getString("NOMBRE025"),
					resultSet.getString("APEL1025"),
					resultSet.getString("APEL2025"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC025"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1025"),
					resultSet.getString("TELF2025"),
					resultSet.getString("EMAIL025"),
					resultSet.getString("FNAC025"),
					resultSet.getBigDecimal("NACIONALIDAD025"),
					resultSet.getString("LOCALIDADEMP025"),
					resultSet.getString("PROVEMP025"),
					resultSet.getInt("IDIOMACOMUNIC025"),
					resultSet.getString("PROVINCIACOMUNIC025"),
					resultSet.getString("MUNICIPCOMUNIC025"),
					resultSet.getString("CALLECOMUNIC025"),
					resultSet.getString("NUMEROCOMUNIC025"),
					resultSet.getString("BISCOMUNIC025"),
					resultSet.getString("PISOCOMUNIC025"),
					resultSet.getString("LETRACOMUNIC025"),
					resultSet.getString("CPOSTALCOMUNIC025"),
					resultSet.getString("CONSENTIMIENTOS025"),
					resultSet.getString("FEMPACTUAL025"),
					resultSet.getString("FENTRADAESP025"),
					resultSet.getString("F1EMPADRON025"),
					resultSet.getString("NOMBREREP025"),
					resultSet.getString("APEL1REP025"),
					resultSet.getString("APEL2REP025"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP025"),
					resultSet.getString("TELF1REP025"),
					resultSet.getString("TELF2REP025"),
					resultSet.getString("TIPONOTIFICACION025"),
					resultSet.getString("CONTRATANTE025"),
					resultSet.getString("CONTRATODESC025"),
					resultSet.getString("FECHAEMPADRON025"),
					resultSet.getString("PROVINCIAEMPADRON025"),
					resultSet.getString("MUNICIPIOEMPADRON025"),
					resultSet.getInt("RESOLFAVORABLE025"),
					resultSet.getString("DIRECCIONEMPADRON025"),
					resultSet.getString("FECHAEMISIONPADRON025"),
					resultSet.getString("SOLICERRADA025"),
					resultSet.getString("NOTIFLEIDA025"),
					resultSet.getString("REQLEIDO025")
				);

		}
	};
	private RowMapper<Aa83b25t00> rwMap2 = new RowMapper<Aa83b25t00>() {
		public Aa83b25t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b25t00(resultSet.getInt("ID025"),
					resultSet.getLong("IDANO025"),
					resultSet.getString("TELFNOTIFICACION025"),
					resultSet.getString("NUMREG025"),
					resultSet.getString("FECHA025"),
					resultSet.getString("NOMBRE025"),
					resultSet.getString("APEL1025"),
					resultSet.getString("APEL2025"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC025"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1025"),
					resultSet.getString("TELF2025"),
					resultSet.getString("EMAIL025"),
					resultSet.getString("FNAC025"),
					resultSet.getBigDecimal("NACIONALIDAD025"),
					resultSet.getString("LOCALIDADEMP025"),
					resultSet.getString("PROVEMP025"),
					resultSet.getInt("IDIOMACOMUNIC025"),
					resultSet.getString("PROVINCIACOMUNIC025"),
					resultSet.getString("MUNICIPCOMUNIC025"),
					resultSet.getString("CALLECOMUNIC025"),
					resultSet.getString("NUMEROCOMUNIC025"),
					resultSet.getString("BISCOMUNIC025"),
					resultSet.getString("PISOCOMUNIC025"),
					resultSet.getString("LETRACOMUNIC025"),
					resultSet.getString("CPOSTALCOMUNIC025"),
					resultSet.getString("CONSENTIMIENTOS025"),
					resultSet.getString("FEMPACTUAL025"),
					resultSet.getString("FENTRADAESP025"),
					resultSet.getString("F1EMPADRON025"),
					resultSet.getString("NOMBREREP025"),
					resultSet.getString("APEL1REP025"),
					resultSet.getString("APEL2REP025"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP025"),
					resultSet.getString("TELF1REP025"),
					resultSet.getString("TELF2REP025"),
					resultSet.getString("TIPONOTIFICACION025"),
					resultSet.getString("CONTRATANTE025"),
					resultSet.getString("CONTRATODESC025"),
					resultSet.getString("FECHAEMPADRON025"),
					resultSet.getString("PROVINCIAEMPADRON025"),
					resultSet.getString("MUNICIPIOEMPADRON025"),
					resultSet.getInt("RESOLFAVORABLE025"),
					resultSet.getString("DIRECCIONEMPADRON025"),
					resultSet.getString("FECHAEMISIONPADRON025"),
					resultSet.getString("SOLICERRADA025"),
					resultSet.getString("NOTIFLEIDA025"),
					resultSet.getString("REQLEIDO025"),
					resultSet.getString("OBSERVACIONES025")
				);
		}
	};
	private RowMapper<Aa83b25t00> rwMap3 = new RowMapper<Aa83b25t00>() {
		public Aa83b25t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b25t00(resultSet.getInt("ID025"),
					resultSet.getLong("IDANO025"),
					resultSet.getString("NOMBRE025"));
		}
	};
	private RowMapper<Aa83b25t00> rwMapPK = new RowMapper<Aa83b25t00>() {
		public Aa83b25t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b25t00(resultSet.getInt("ID025"),
					resultSet.getLong("IDANO025"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b25t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b25t00>>() {
		public JerarquiaDto<Aa83b25t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa83b25t00 aa83b25t00 = new Aa83b25t00(resultSet.getInt("ID025"),
					resultSet.getLong("IDANO025"),
					resultSet.getString("TELFNOTIFICACION025"),
					resultSet.getString("NOMBRE025"),
					resultSet.getString("APEL1025"),
					resultSet.getString("APEL2025"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC025"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1025"),
					resultSet.getString("TELF2025"),
					resultSet.getString("EMAIL025"),
					resultSet.getString("FNAC025"),
					resultSet.getBigDecimal("NACIONALIDAD025"),
					resultSet.getString("LOCALIDADEMP025"),
					resultSet.getString("PROVEMP025"),
					resultSet.getInt("IDIOMACOMUNIC025"),
					resultSet.getString("PROVINCIACOMUNIC025"),
					resultSet.getString("MUNICIPCOMUNIC025"),
					resultSet.getString("CALLECOMUNIC025"),
					resultSet.getString("NUMEROCOMUNIC025"),
					resultSet.getString("BISCOMUNIC025"),
					resultSet.getString("PISOCOMUNIC025"),
					resultSet.getString("LETRACOMUNIC025"),
					resultSet.getString("CPOSTALCOMUNIC025"),
					resultSet.getString("CONSENTIMIENTOS025"),
					resultSet.getString("FEMPACTUAL025"),
					resultSet.getString("FENTRADAESP025"),
					resultSet.getString("F1EMPADRON025"),
					resultSet.getString("NOMBREREP025"),
					resultSet.getString("APEL1REP025"),
					resultSet.getString("APEL2REP025"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP025"),
					resultSet.getString("TELF1REP025"),
					resultSet.getString("TELF2REP025"),
					resultSet.getString("TIPONOTIFICACION025"),
					resultSet.getString("CONTRATANTE025"),
					resultSet.getString("CONTRATODESC025"),
					resultSet.getString("FECHAEMPADRON025"),
					resultSet.getString("PROVINCIAEMPADRON025"),
					resultSet.getString("MUNICIPIOEMPADRON025"),
					resultSet.getInt("RESOLFAVORABLE025"),
					resultSet.getString("DIRECCIONEMPADRON025"),
					resultSet.getString("FECHAEMISIONPADRON025"),
					resultSet.getString("SOLICERRADA025"),
					resultSet.getString("NOTIFLEIDA025"),
					resultSet.getString("REQLEIDO025")
				);

			JerarquiaDto<Aa83b25t00> jerarquia = new JerarquiaDto<Aa83b25t00>();
			jerarquia.setModel(aa83b25t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	public Aa83b25t00 add(Aa83b25t00 aa83b25t00) {
		final int nextId = jdbcTemplate
				.queryForInt("SELECT SEQ_AA83B25T00_ID_025_"
						+ aa83b25t00.getIdAno025() + ".NEXTVAL FROM DUAL");
		aa83b25t00.setId025(nextId);
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String query = "INSERT INTO AA83B25T00 (ID_025, ID_ANO_025, TELF_NOTIFICACION_025, NUM_REG_025, FEC_REG_025, NOMBRE_025, APEL1_025, APEL2_025, ID_012_TIPO_DOC, NUM_DOC_025, ID_017_GENERO, TELF1_025, TELF2_025, EMAIL_025, F_NAC_025, NACIONALIDAD_025, LOCALIDAD_EMP_025, PROV_EMP_025, IDIOMA_COMUNIC_025, PROVINCIA_COMUNIC_025, MUNICIP_COMUNIC_025, CALLE_COMUNIC_025, NUMERO_COMUNIC_025, BIS_COMUNIC_025, PISO_COMUNIC_025, LETRA_COMUNIC_025, CPOSTAL_COMUNIC_025, CONSENTIMIENTOS_025, F_EMP_ACTUAL_025, F_ENTRADA_ESP_025, F_1_EMPADRON_025, NOMBRE_REP_025, APEL1_REP_025, APEL2_REP_025, ID_012_REP, NUM_DOC_REP_025, TELF1_REP_025, TELF2_REP_025, TIPO_NOTIFICACION_025,CONTRATANTE_025,CONTRATODESC_025,FECHA_EMPADRON_025,PROVINCIA_EMPADRON_025,MUNICIPIO_EMPADRON_025,DIRECCION_EMPADRON_025,FECHA_EMISIONPADRON_025, SOLI_CERRADA_025, NOTIF_LEIDA_025, OBSERVACIONES_025) VALUES (?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,?,?,?,?,to_date(?,?),to_date(?,?),to_date(?,?),?,?,?,?,?,?,?,?,?,?,to_date(?,?),?,?,?,to_date(?,?),?,?,?)";
		this.jdbcTemplate.update(query, aa83b25t00.getId025(),
				aa83b25t00.getIdAno025(),
				aa83b25t00.getTelf_notificacion_025(),
				aa83b25t00.getNumReg025(), aa83b25t00.getFecha025(),
				"dd/mm/yyyy HH24:mi:ss", aa83b25t00.getNombre025(),
				aa83b25t00.getApel1025(), aa83b25t00.getApel2025(),
				aa83b25t00.getId012TipoDoc(), aa83b25t00.getNumDoc025(),
				aa83b25t00.getId017Genero(), aa83b25t00.getTelf1025(),
				aa83b25t00.getTelf2025(), aa83b25t00.getEmail025(),
				aa83b25t00.getFNac025(), formato,
				aa83b25t00.getNacionalidad025(),
				aa83b25t00.getLocalidadEmp025(), aa83b25t00.getProvEmp025(),
				aa83b25t00.getIdiomaComunic025(),
				aa83b25t00.getProvinciaComunic025(),
				aa83b25t00.getMunicipComunic025(),
				aa83b25t00.getCalleComunic025(),
				aa83b25t00.getNumeroComunic025(),
				aa83b25t00.getBisComunic025(),
				aa83b25t00.getPisoComunic025(),
				aa83b25t00.getLetraComunic025(),
				aa83b25t00.getCpostalComunic025(),
				aa83b25t00.getConsentimientos025(),
				aa83b25t00.getfEmpActual025(), formato,
				aa83b25t00.getfEntradaEsp025(), formato,
				aa83b25t00.getF1Empadron025(), formato,
				aa83b25t00.getNombreRep025(), aa83b25t00.getApel1Rep025(),
				aa83b25t00.getApel2Rep025(), aa83b25t00.getId012Rep(),
				aa83b25t00.getNumDocRep025(), aa83b25t00.getTelf1Rep025(),
				aa83b25t00.getTelf2Rep025(),
				aa83b25t00.getTipoNotificacion025(),
				aa83b25t00.getContratante025(),
				aa83b25t00.getContratoDesc025(),
				aa83b25t00.getFechaEmpadron025(), formato,
				aa83b25t00.getProvinciaEmpadron025(),
				aa83b25t00.getMunicipioEmpadron025(),
				aa83b25t00.getDireccionEmpadron025(),
				aa83b25t00.getFechaEmisionPadron025(), formato,
				aa83b25t00.getSolicerrada025(), aa83b25t00.getNotifLeida025(), 
				aa83b25t00.getObservaciones025()
				);
		return aa83b25t00;
	}

	/**
	 * Updates a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	public Aa83b25t00 update(Aa83b25t00 aa83b25t00) {
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}

		// String query =
		// "UPDATE AA83B25T00 SET NOMBRE_025=?, APEL1_025=?, APEL2_025=?, ID_012_TIPO_DOC=?, NUM_DOC_025=?, ID_017_GENERO=?, TELF1_025=?, TELF2_025=?, EMAIL_025=?, F_NAC_025=to_date(?,?), NACIONALIDAD_025=?, LOCALIDAD_EMP_025=?, PROV_EMP_025=?, IDIOMA_COMUNIC_025=?, PROVINCIA_COMUNIC_025=?, MUNICIP_COMUNIC_025=?, CALLE_COMUNIC_025=?, NUMERO_COMUNIC_025=?, PISO_COMUNIC_025=?, LETRA_COMUNIC_025=?, CPOSTAL_COMUNIC_025=?, CONSENTIMIENTOS_025=?, F_EMP_ACTUAL_025=to_date(?,?), F_ENTRADA_ESP_025=to_date(?,?), F_1_EMPADRON_025=to_date(?,?), NOMBRE_REP_025=?, APEL1_REP_025=?, APEL2_REP_025=?, ID_012_REP=?, NUM_DOC_REP_025=?, TELF1_REP_025=?, TELF2_REP_025=?,PROVINCIA_EMPADRON_025=?,MUNICIPIO_EMPADRON_025=?, TIPO_NOTIFICACION_025=?, RESOL_FAVORABLE_025=?,DIRECCION_EMPADRON_025=?,FECHA_EMISIONPADRON_025=to_date(?,?), SOLI_CERRADA_025=?, NOTIF_LEIDA_025=? WHERE ID_025=? AND ID_ANO_025=?";
		String query = "UPDATE AA83B25T00 SET NOMBRE_025=?, APEL1_025=?, APEL2_025=?, ID_012_TIPO_DOC=?, NUM_DOC_025=?, ID_017_GENERO=?, TELF1_025=?, TELF2_025=?, EMAIL_025=?, F_NAC_025=to_date(?,?)"
				+ ", NACIONALIDAD_025=?, LOCALIDAD_EMP_025=?, PROV_EMP_025=?, IDIOMA_COMUNIC_025=?, PROVINCIA_COMUNIC_025=?, MUNICIP_COMUNIC_025=?, CALLE_COMUNIC_025=?,"
				+ " NUMERO_COMUNIC_025=?, BIS_COMUNIC_025=?, PISO_COMUNIC_025=?, LETRA_COMUNIC_025=?, CPOSTAL_COMUNIC_025=?, CONSENTIMIENTOS_025=?, F_EMP_ACTUAL_025=to_date(?,?),"
				+ " F_ENTRADA_ESP_025=to_date(?,?), F_1_EMPADRON_025=to_date(?,?), NOMBRE_REP_025=?, APEL1_REP_025=?, APEL2_REP_025=?, ID_012_REP=?,"
				+ " NUM_DOC_REP_025=?, TELF1_REP_025=?, TELF2_REP_025=?, CONTRATANTE_025=?,CONTRATODESC_025=?,FECHA_EMPADRON_025=to_date(?,?),PROVINCIA_EMPADRON_025=?,MUNICIPIO_EMPADRON_025=?,TIPO_NOTIFICACION_025=?,"
				+ " RESOL_FAVORABLE_025=?,DIRECCION_EMPADRON_025=?,FECHA_EMISIONPADRON_025=to_date(?,?), SOLI_CERRADA_025=?, NOTIF_LEIDA_025=?, OBSERVACIONES_025=?  WHERE ID_025=? AND ID_ANO_025=?";
		this.jdbcTemplate.update(query, aa83b25t00.getNombre025(),
				aa83b25t00.getApel1025(), aa83b25t00.getApel2025(),
				aa83b25t00.getId012TipoDoc(), aa83b25t00.getNumDoc025(),
				aa83b25t00.getId017Genero(), aa83b25t00.getTelf1025(),
				aa83b25t00.getTelf2025(), aa83b25t00.getEmail025(),
				aa83b25t00.getFNac025(), formato,
				aa83b25t00.getNacionalidad025(),
				aa83b25t00.getLocalidadEmp025(), aa83b25t00.getProvEmp025(),
				aa83b25t00.getIdiomaComunic025(),
				aa83b25t00.getProvinciaComunic025(),
				aa83b25t00.getMunicipComunic025(),
				aa83b25t00.getCalleComunic025(),
				aa83b25t00.getNumeroComunic025(),
				aa83b25t00.getBisComunic025(),
				aa83b25t00.getPisoComunic025(),
				aa83b25t00.getLetraComunic025(),
				aa83b25t00.getCpostalComunic025(),
				aa83b25t00.getConsentimientos025(),
				aa83b25t00.getfEmpActual025(), formato,
				aa83b25t00.getfEntradaEsp025(), formato,
				aa83b25t00.getF1Empadron025(), formato,
				aa83b25t00.getNombreRep025(), aa83b25t00.getApel1Rep025(),
				aa83b25t00.getApel2Rep025(), aa83b25t00.getId012Rep(),
				aa83b25t00.getNumDocRep025(), aa83b25t00.getTelf1Rep025(),
				aa83b25t00.getTelf2Rep025(), aa83b25t00.getContratante025(),
				aa83b25t00.getContratoDesc025(),
				aa83b25t00.getFechaEmpadron025(), formato,
				aa83b25t00.getProvinciaEmpadron025(),
				aa83b25t00.getMunicipioEmpadron025(),
				aa83b25t00.getTipoNotificacion025(),
				aa83b25t00.getResolFavorable025(),
				aa83b25t00.getDireccionEmpadron025(),
				aa83b25t00.getFechaEmisionPadron025(), formato,
				aa83b25t00.getSolicerrada025(), aa83b25t00.getNotifLeida025(),
				aa83b25t00.getObservaciones025(),
				aa83b25t00.getId025(), aa83b25t00.getIdAno025());
		return aa83b25t00;
	}

	public void updateResolFavorable(Aa83b25t00 aa83b25t00) {
		String query = "UPDATE AA83B25T00 SET RESOL_FAVORABLE_025=? WHERE ID_025=? AND ID_ANO_025=?";
		this.jdbcTemplate.update(query, aa83b25t00.getResolFavorable025(),
				aa83b25t00.getId025(), aa83b25t00.getIdAno025());
	}

	/**
	 * Finds a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Aa83b25t00
	 */
	@Transactional(readOnly = true)
	public Aa83b25t00 find(Aa83b25t00 aa83b25t00) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		String formatoHora = Aa83BConstants.ES_PATTERN_HORA_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
			formatoHora = Aa83BConstants.EU_PATTERN_HORA_COMPLETA;
		}
		String query = "SELECT t1.ID_025 ID025, t1.ID_ANO_025 IDANO025, t1.TELF_NOTIFICACION_025 TELFNOTIFICACION025, NUM_REG_025 NUMREG025, TO_CHAR(FEC_REG_025,"
				+ formatoHora
				+ ") FECHA025, t1.NOMBRE_025 NOMBRE025, t1.APEL1_025 APEL1025, t1.APEL2_025 APEL2025, t1.ID_012_TIPO_DOC ID012TIPODOC, t1.NUM_DOC_025 NUMDOC025, t1.ID_017_GENERO ID017GENERO, t1.TELF1_025 TELF1025, t1.TELF2_025 TELF2025, t1.EMAIL_025 EMAIL025, TO_CHAR(t1.F_NAC_025,"
				+ formato
				+ ") FNAC025, t1.NACIONALIDAD_025 NACIONALIDAD025, t1.LOCALIDAD_EMP_025 LOCALIDADEMP025, t1.PROV_EMP_025 PROVEMP025, t1.IDIOMA_COMUNIC_025 IDIOMACOMUNIC025, t1.PROVINCIA_COMUNIC_025 PROVINCIACOMUNIC025, t1.MUNICIP_COMUNIC_025 MUNICIPCOMUNIC025, t1.CALLE_COMUNIC_025 CALLECOMUNIC025, t1.NUMERO_COMUNIC_025 NUMEROCOMUNIC025, t1.BIS_COMUNIC_025 BISCOMUNIC025, t1.PISO_COMUNIC_025 PISOCOMUNIC025, t1.LETRA_COMUNIC_025 LETRACOMUNIC025, t1.CPOSTAL_COMUNIC_025 CPOSTALCOMUNIC025, t1.CONSENTIMIENTOS_025 CONSENTIMIENTOS025, TO_CHAR(t1.F_EMP_ACTUAL_025,"
				+ formato
				+ ") FEMPACTUAL025, TO_CHAR(t1.F_ENTRADA_ESP_025,"
				+ formato
				+ ") FENTRADAESP025, TO_CHAR(t1.F_1_EMPADRON_025,"
				+ formato
				+ ") F1EMPADRON025, t1.NOMBRE_REP_025 NOMBREREP025, t1.APEL1_REP_025 APEL1REP025, t1.APEL2_REP_025 APEL2REP025, t1.ID_012_REP ID012REP, t1.NUM_DOC_REP_025 NUMDOCREP025, t1.TELF1_REP_025 TELF1REP025, t1.TELF2_REP_025 TELF2REP025, t1.TIPO_NOTIFICACION_025 TIPONOTIFICACION025, "
				+ " CONTRATANTE_025 CONTRATANTE025,CONTRATODESC_025 CONTRATODESC025,to_char(FECHA_EMPADRON_025,"
				+ formato
				+ ") FECHAEMPADRON025,PROVINCIA_EMPADRON_025 PROVINCIAEMPADRON025,MUNICIPIO_EMPADRON_025 MUNICIPIOEMPADRON025,nvl(t1.RESOL_FAVORABLE_025,9) RESOLFAVORABLE025"
				+ " ,t1.DIRECCION_EMPADRON_025 DIRECCIONEMPADRON025,TO_CHAR(t1.FECHA_EMISIONPADRON_025,"
				+ formato
				+ ") FECHAEMISIONPADRON025, "
				+ " t1.SOLI_CERRADA_025 SOLICERRADA025, "
				+ " t1.NOTIF_LEIDA_025 NOTIFLEIDA025, t1.REQ_LEIDO_025 REQLEIDO025, t1.OBSERVACIONES_025 OBSERVACIONES025 "
				+ " FROM AA83B25T00 t1  WHERE t1.ID_025 = ?   AND t1.ID_ANO_025 = ?  ";

		List<Aa83b25t00> aa83b25t00List = this.jdbcTemplate.query(query,
				this.rwMap2, aa83b25t00.getId025(), aa83b25t00.getIdAno025());
		return (Aa83b25t00) DataAccessUtils.uniqueResult(aa83b25t00List);
	}

	/**
	 * Removes a single row in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return
	 */
	public void remove(Aa83b25t00 aa83b25t00) {
		String query = "DELETE FROM AA83B25T00 WHERE ID_025=? AND ID_ANO_025=?";
		this.jdbcTemplate.update(query, aa83b25t00.getId025(),
				aa83b25t00.getIdAno025());
	}

	/**
	 * Finds a list of rows in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b25t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b25t00> findAll(Aa83b25t00 aa83b25t00,
			JQGridRequestDto jqGridRequestDto) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_025 ID025,t1.ID_ANO_025 IDANO025, t1.TELF_NOTIFICACION_025 TELFNOTIFICACION025, t1.NOMBRE_025 NOMBRE025,t1.APEL1_025 APEL1025,t1.APEL2_025 APEL2025,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_025 NUMDOC025,t1.ID_017_GENERO ID017GENERO,t1.TELF1_025 TELF1025,t1.TELF2_025 TELF2025,t1.EMAIL_025 EMAIL025,TO_CHAR(t1.F_NAC_025,"
						+ formato
						+ ") FNAC025,t1.NACIONALIDAD_025 NACIONALIDAD025,t1.LOCALIDAD_EMP_025 LOCALIDADEMP025,t1.PROV_EMP_025 PROVEMP025,t1.IDIOMA_COMUNIC_025 IDIOMACOMUNIC025,t1.PROVINCIA_COMUNIC_025 PROVINCIACOMUNIC025,t1.MUNICIP_COMUNIC_025 MUNICIPCOMUNIC025,t1.CALLE_COMUNIC_025 CALLECOMUNIC025,t1.NUMERO_COMUNIC_025 NUMEROCOMUNIC025,t1.BIS_COMUNIC_025 BISCOMUNIC025,t1.PISO_COMUNIC_025 PISOCOMUNIC025,t1.LETRA_COMUNIC_025 LETRACOMUNIC025,t1.CPOSTAL_COMUNIC_025 CPOSTALCOMUNIC025,t1.CONSENTIMIENTOS_025 CONSENTIMIENTOS025,TO_CHAR(t1.F_EMP_ACTUAL_025,"
						+ formato
						+ ") FEMPACTUAL025,TO_CHAR(t1.F_ENTRADA_ESP_025,"
						+ formato
						+ ") FENTRADAESP025,TO_CHAR(t1.F_1_EMPADRON_025,"
						+ formato
						+ ") F1EMPADRON025,t1.NOMBRE_REP_025 NOMBREREP025,t1.APEL1_REP_025 APEL1REP025,t1.APEL2_REP_025 APEL2REP025,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_025 NUMDOCREP025,t1.TELF1_REP_025 TELF1REP025,t1.TELF2_REP_025 TELF2REP025,t1.TIPO_NOTIFICACION_025 TIPONOTIFICACION025, "
						+ " CONTRATANTE_025 CONTRATANTE025,CONTRATODESC_025 CONTRATODESC025,to_char(FECHA_EMPADRON_025,"
						+ formato
						+ ") FECHAEMPADRON025,PROVINCIA_EMPADRON_025 PROVINCIAEMPADRON025,MUNICIPIO_EMPADRON_025 MUNICIPIOEMPADRON025,nvl(t1.RESOL_FAVORABLE_025,9) RESOLFAVORABLE025"
						+ " ,t1.DIRECCION_EMPADRON_025 DIRECCIONEMPADRON025,TO_CHAR(t1.FECHA_EMISIONPADRON_025,"
						+ formato
						+ ") FECHAEMISIONPADRON025, "
						+ " t1.SOLI_CERRADA_025 SOLICERRADA025, "
						+ " t1.NOTIF_LEIDA_025 NOTIFLEIDA025, t1.REQ_LEIDO_025 REQLEIDO025 ");
		query.append(" FROM AA83B25T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b25t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b25t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b25t00 table using like.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b25t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b25t00> findAllLike(Aa83b25t00 aa83b25t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		String formatoHora = Aa83BConstants.ES_PATTERN_HORA_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
			formatoHora = Aa83BConstants.EU_PATTERN_HORA_COMPLETA;
		}
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_025 ID025,t1.ID_ANO_025 IDANO025, TELF_NOTIFICACION_025 TELFNOTIFICACION025, t1.NUM_REG_025 NUMREG025, TO_CHAR(t1.FEC_REG_025,"
						+ formatoHora
						+ ") FECHA025, t1.NOMBRE_025 NOMBRE025,t1.APEL1_025 APEL1025,t1.APEL2_025 APEL2025,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_025 NUMDOC025,t1.ID_017_GENERO ID017GENERO,t1.TELF1_025 TELF1025,t1.TELF2_025 TELF2025,t1.EMAIL_025 EMAIL025,TO_CHAR(t1.F_NAC_025,"
						+ formato
						+ ") FNAC025,t1.NACIONALIDAD_025 NACIONALIDAD025,t1.LOCALIDAD_EMP_025 LOCALIDADEMP025,t1.PROV_EMP_025 PROVEMP025,t1.IDIOMA_COMUNIC_025 IDIOMACOMUNIC025,t1.PROVINCIA_COMUNIC_025 PROVINCIACOMUNIC025,t1.MUNICIP_COMUNIC_025 MUNICIPCOMUNIC025,t1.CALLE_COMUNIC_025 CALLECOMUNIC025,t1.NUMERO_COMUNIC_025 NUMEROCOMUNIC025,t1.BIS_COMUNIC_025 BISCOMUNIC025,t1.PISO_COMUNIC_025 PISOCOMUNIC025,t1.LETRA_COMUNIC_025 LETRACOMUNIC025,t1.CPOSTAL_COMUNIC_025 CPOSTALCOMUNIC025,t1.CONSENTIMIENTOS_025 CONSENTIMIENTOS025,TO_CHAR(t1.F_EMP_ACTUAL_025,"
						+ formato
						+ ") FEMPACTUAL025,TO_CHAR(t1.F_ENTRADA_ESP_025,"
						+ formato
						+ ") FENTRADAESP025,TO_CHAR(t1.F_1_EMPADRON_025,"
						+ formato
						+ ") F1EMPADRON025,t1.NOMBRE_REP_025 NOMBREREP025,t1.APEL1_REP_025 APEL1REP025,t1.APEL2_REP_025 APEL2REP025,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_025 NUMDOCREP025,t1.TELF1_REP_025 TELF1REP025,t1.TELF2_REP_025 TELF2REP025,t1.TIPO_NOTIFICACION_025 TIPONOTIFICACION025, "
						+ " CONTRATANTE_025 CONTRATANTE025,CONTRATODESC_025 CONTRATODESC025,to_char(FECHA_EMPADRON_025,"
						+ formato
						+ ") FECHAEMPADRON025,PROVINCIA_EMPADRON_025 PROVINCIAEMPADRON025,MUNICIPIO_EMPADRON_025 MUNICIPIOEMPADRON025,nvl(t1.RESOL_FAVORABLE_025,9) RESOLFAVORABLE025"
						+ " ,t1.DIRECCION_EMPADRON_025 DIRECCIONEMPADRON025,TO_CHAR(t1.FECHA_EMISIONPADRON_025,"
						+ formato
						+ ") FECHAEMISIONPADRON025, "
						+ " t1.SOLI_CERRADA_025 SOLICERRADA025, "
						+ " t1.NOTIF_LEIDA_025 NOTIFLEIDA025, t1.REQ_LEIDO_025 REQLEIDO025, t1.OBSERVACIONES_025 OBSERVACIONES025");
		query.append(" FROM AA83B25T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b25t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY t1.ID_025 DESC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa83b25t00DaoImpl.LOGGER.info("[Aa83b25t00DaoImpl] : BusquedaControler.findAllLike.  SQL:" + query.toString());
		Aa83b25t00DaoImpl.LOGGER.info("[Aa83b25t00DaoImpl] : BusquedaControler.findAllLike.  Parametros:" + params.toArray());
		
		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b25t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap2, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b25t00 table.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b25t00 aa83b25t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B25T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b25t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b25t00 table using like.
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b25t00 aa83b25t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B25T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b25t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b25t00 selected for rup_table
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b25t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b25t00>> reorderSelection(
			Aa83b25t00 aa83b25t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_025 ID025,t1.ID_ANO_025 IDANO025, t1.TELF_NOTIFICACION_025 TELFNOTIFICACION025, t1.NOMBRE_025 NOMBRE025,t1.APEL1_025 APEL1025,t1.APEL2_025 APEL2025,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_025 NUMDOC025,t1.ID_017_GENERO ID017GENERO,t1.TELF1_025 TELF1025,t1.TELF2_025 TELF2025,t1.EMAIL_025 EMAIL025,TO_CHAR(t1.F_NAC_025,"
						+ formato
						+ ") FNAC025,t1.NACIONALIDAD_025 NACIONALIDAD025,t1.LOCALIDAD_EMP_025 LOCALIDADEMP025,t1.PROV_EMP_025 PROVEMP025,t1.IDIOMA_COMUNIC_025 IDIOMACOMUNIC025,t1.PROVINCIA_COMUNIC_025 PROVINCIACOMUNIC025,t1.MUNICIP_COMUNIC_025 MUNICIPCOMUNIC025,t1.CALLE_COMUNIC_025 CALLECOMUNIC025,t1.NUMERO_COMUNIC_025 NUMEROCOMUNIC025,t1.BIS_COMUNIC_025 BISCOMUNIC025,t1.PISO_COMUNIC_025 PISOCOMUNIC025,t1.LETRA_COMUNIC_025 LETRACOMUNIC025,t1.CPOSTAL_COMUNIC_025 CPOSTALCOMUNIC025,t1.CONSENTIMIENTOS_025 CONSENTIMIENTOS025,TO_CHAR(t1.F_EMP_ACTUAL_025,"
						+ formato
						+ ") FEMPACTUAL025,TO_CHAR(t1.F_ENTRADA_ESP_025,"
						+ formato
						+ ") FENTRADAESP025,TO_CHAR(t1.F_1_EMPADRON_025,"
						+ formato
						+ ") F1EMPADRON025,t1.NOMBRE_REP_025 NOMBREREP025,t1.APEL1_REP_025 APEL1REP025,t1.APEL2_REP_025 APEL2REP025,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_025 NUMDOCREP025,t1.TELF1_REP_025 TELF1REP025,t1.TELF2_REP_025 TELF2REP025,t1.TIPO_NOTIFICACION_025 TIPONOTIFICACION025, "
						+ " CONTRATANTE_025 CONTRATANTE025,CONTRATODESC_025 CONTRATODESC025,to_char(FECHA_EMPADRON_025,"
						+ formato
						+ ") FECHAEMPADRON025,PROVINCIA_EMPADRON_025 PROVINCIAEMPADRON025,MUNICIPIO_EMPADRON_025 MUNICIPIOEMPADRON025"
						+ " ,t1.DIRECCION_EMPADRON_025 DIRECCIONEMPADRON025,TO_CHAR(t1.FECHA_EMISIONPADRON_025,"
						+ formato
						+ ") FECHAEMISIONPADRON025, "
						+ " t1.SOLI_CERRADA_025 SOLICERRADA025, "
						+ " t1.NOTIF_LEIDA_025 NOTIFLEIDA025 ");
		// FROM
		query.append(" FROM AA83B25T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b25t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b25t00.class, filterParamList,
				"ID_025,ID_ANO_025");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b25t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b25t00
	 * @param searchParams
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b25t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b25t00>> search(Aa83b25t00 filterParams,
			Aa83b25t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_025 ID025,t1.ID_ANO_025 IDANO025, t1.TELF_NOTIFICACION_025 TELFNOTIFICACION025, t1.NOMBRE_025 NOMBRE025,t1.APEL1_025 APEL1025,t1.APEL2_025 APEL2025,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_025 NUMDOC025,t1.ID_017_GENERO ID017GENERO,t1.TELF1_025 TELF1025,t1.TELF2_025 TELF2025,t1.EMAIL_025 EMAIL025,TO_CHAR(t1.F_NAC_025,"
						+ formato
						+ ") FNAC025,t1.NACIONALIDAD_025 NACIONALIDAD025,t1.LOCALIDAD_EMP_025 LOCALIDADEMP025,t1.PROV_EMP_025 PROVEMP025,t1.IDIOMA_COMUNIC_025 IDIOMACOMUNIC025,t1.PROVINCIA_COMUNIC_025 PROVINCIACOMUNIC025,t1.MUNICIP_COMUNIC_025 MUNICIPCOMUNIC025,t1.CALLE_COMUNIC_025 CALLECOMUNIC025,t1.NUMERO_COMUNIC_025 NUMEROCOMUNIC025,t1.BIS_COMUNIC_025 BISCOMUNIC025,t1.PISO_COMUNIC_025 PISOCOMUNIC025,t1.LETRA_COMUNIC_025 LETRACOMUNIC025,t1.CPOSTAL_COMUNIC_025 CPOSTALCOMUNIC025,t1.CONSENTIMIENTOS_025 CONSENTIMIENTOS025,TO_CHAR(t1.F_EMP_ACTUAL_025,"
						+ formato
						+ ") FEMPACTUAL025,TO_CHAR(t1.F_ENTRADA_ESP_025,"
						+ formato
						+ ") FENTRADAESP025,TO_CHAR(t1.F_1_EMPADRON_025,"
						+ formato
						+ ") F1EMPADRON025,t1.NOMBRE_REP_025 NOMBREREP025,t1.APEL1_REP_025 APEL1REP025,t1.APEL2_REP_025 APEL2REP025,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_025 NUMDOCREP025,t1.TELF1_REP_025 TELF1REP025,t1.TELF2_REP_025 TELF2REP025,t1.TIPO_NOTIFICACION_025 TIPONOTIFICACION025, "
						+ " CONTRATANTE_025 CONTRATANTE025,CONTRATODESC_025 CONTRATODESC025,to_char(FECHA_EMPADRON_025,"
						+ formato
						+ ") FECHAEMPADRON025,PROVINCIA_EMPADRON_025 PROVINCIAEMPADRON025,MUNICIPIO_EMPADRON_025 MUNICIPIOEMPADRON025"
						+ " ,t1.DIRECCION_EMPADRON_025 DIRECCIONEMPADRON025,TO_CHAR(t1.FECHA_EMISIONPADRON_025,"
						+ formato + ") FECHAEMISIONPADRON025");
		// FROM
		query.append(" FROM AA83B25T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b25t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_025,ID_ANO_025");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b25t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b25t00 filteraa83b25t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_025 ID025,t1.ID_ANO_025 IDANO025, t1.TELF_NOTIFICACION_025 TELFNOTIFICACION025, t1.NOMBRE_025 NOMBRE025,t1.APEL1_025 APEL1025,t1.APEL2_025 APEL2025,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_025 NUMDOC025,t1.ID_017_GENERO ID017GENERO,t1.TELF1_025 TELF1025,t1.TELF2_025 TELF2025,t1.EMAIL_025 EMAIL025,TO_CHAR(t1.F_NAC_025,"
						+ formato
						+ ") FNAC025,t1.NACIONALIDAD_025 NACIONALIDAD025,t1.LOCALIDAD_EMP_025 LOCALIDADEMP025,t1.PROV_EMP_025 PROVEMP025,t1.IDIOMA_COMUNIC_025 IDIOMACOMUNIC025,t1.PROVINCIA_COMUNIC_025 PROVINCIACOMUNIC025,t1.MUNICIP_COMUNIC_025 MUNICIPCOMUNIC025,t1.CALLE_COMUNIC_025 CALLECOMUNIC025,t1.NUMERO_COMUNIC_025 NUMEROCOMUNIC025,t1.BIS_COMUNIC_025 BISCOMUNIC025,t1.PISO_COMUNIC_025 PISOCOMUNIC025,t1.LETRA_COMUNIC_025 LETRACOMUNIC025,t1.CPOSTAL_COMUNIC_025 CPOSTALCOMUNIC025,t1.CONSENTIMIENTOS_025 CONSENTIMIENTOS025,TO_CHAR(t1.F_EMP_ACTUAL_025,"
						+ formato
						+ ") FEMPACTUAL025,TO_CHAR(t1.F_ENTRADA_ESP_025,"
						+ formato
						+ ") FENTRADAESP025,TO_CHAR(t1.F_1_EMPADRON_025,"
						+ formato
						+ ") F1EMPADRON025,t1.NOMBRE_REP_025 NOMBREREP025,t1.APEL1_REP_025 APEL1REP025,t1.APEL2_REP_025 APEL2REP025,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_025 NUMDOCREP025,t1.TELF1_REP_025 TELF1REP025,t1.TELF2_REP_025 TELF2REP025,t1.TIPO_NOTIFICACION_025 TIPONOTIFICACION025, "
						+ " CONTRATANTE_025 CONTRATANTE025,CONTRATODESC_025 CONTRATODESC025,to_char(FECHA_EMPADRON_025,"
						+ formato
						+ ") FECHAEMPADRON025,PROVINCIA_EMPADRON_025 PROVINCIAEMPADRON025,MUNICIPIO_EMPADRON_025 MUNICIPIOEMPADRON025"
						+ " ,t1.DIRECCION_EMPADRON_025 DIRECCIONEMPADRON025,TO_CHAR(t1.FECHA_EMISIONPADRON_025,"
						+ formato + ") FECHAEMISIONPADRON025");
		// FROM
		query.append(" FROM AA83B25T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b25t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b25t00.class,
						query, params, "ID_025,ID_ANO_025");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b25t00 table.
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b25t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b25t00>> findAllLikeJerarquia(
			Aa83b25t00 filterAa83b25t00, JQGridRequestDto jqGridRequestDto) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_025 ID025,t1.ID_ANO_025 IDANO025, t1.TELF_NOTIFICACION_025 TELFNOTIFICACION025, t1.NOMBRE_025 NOMBRE025,t1.APEL1_025 APEL1025,t1.APEL2_025 APEL2025,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_025 NUMDOC025,t1.ID_017_GENERO ID017GENERO,t1.TELF1_025 TELF1025,t1.TELF2_025 TELF2025,t1.EMAIL_025 EMAIL025,TO_CHAR(t1.F_NAC_025,"
						+ formato
						+ ") FNAC025,t1.NACIONALIDAD_025 NACIONALIDAD025,t1.LOCALIDAD_EMP_025 LOCALIDADEMP025,t1.PROV_EMP_025 PROVEMP025,t1.IDIOMA_COMUNIC_025 IDIOMACOMUNIC025,t1.PROVINCIA_COMUNIC_025 PROVINCIACOMUNIC025,t1.MUNICIP_COMUNIC_025 MUNICIPCOMUNIC025,t1.CALLE_COMUNIC_025 CALLECOMUNIC025,t1.NUMERO_COMUNIC_025 NUMEROCOMUNIC025,t1.BIS_COMUNIC_025 BISCOMUNIC025,t1.PISO_COMUNIC_025 PISOCOMUNIC025,t1.LETRA_COMUNIC_025 LETRACOMUNIC025,t1.CPOSTAL_COMUNIC_025 CPOSTALCOMUNIC025,t1.CONSENTIMIENTOS_025 CONSENTIMIENTOS025,t1.F_EMP_ACTUAL_025 FEMPACTUAL025,TO_CHAR(t1.F_ENTRADA_ESP_025,"
						+ formato
						+ ") FENTRADAESP025,TO_CHAR(t1.F_1_EMPADRON_025,"
						+ formato
						+ ") F1EMPADRON025,t1.NOMBRE_REP_025 NOMBREREP025,t1.APEL1_REP_025 APEL1REP025,t1.APEL2_REP_025 APEL2REP025,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_025 NUMDOCREP025,t1.TELF1_REP_025 TELF1REP025,t1.TELF2_REP_025 TELF2REP025,t1.TIPO_NOTIFICACION_025 TIPONOTIFICACION025 "
						+ " CONTRATANTE_025 CONTRATANTE025,CONTRATODESC_025 CONTRATODESC025,to_char(FECHA_EMPADRON_025,"
						+ formato
						+ ") FECHAEMPADRON025,PROVINCIA_EMPADRON_025 PROVINCIAEMPADRON025,MUNICIPIO_EMPADRON_025 MUNICIPIOEMPADRON025"
						+ " ,t1.DIRECCION_EMPADRON_025 DIRECCIONEMPADRON025,TO_CHAR(t1.FECHA_EMISIONPADRON_025,"
						+ formato + ") FECHAEMISIONPADRON025, t1.REQ_LEIDO_025 REQLEIDO025");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B25T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B25T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b25t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_025,ID_ANO_025", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b25t00 filterAa83b25t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B25T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B25T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b25t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_025,ID_ANO_025", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b25t00
	 *            Aa83b25t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b25t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b25t00>> findAllChild(
			Aa83b25t00 filterAa83b25t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B25T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B25T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b25t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_025,ID_ANO_025", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa83b25t00>(this.rwMapPK,
						"ID_025,ID_ANO_025"), params.toArray());
	}

	public Aa83b25t00 validarSolicitud(Aa83b25t00 aa83b25t00) {
		StringBuffer sql = new StringBuffer();
		sql.append("SELECT SOL.ID_025 ID025,SOL.ID_ANO_025 IDANO025,SOL.NOMBRE_025 NOMBRE025 FROM AA83B25T00 SOL INNER JOIN AA83B11T00 TRAM");
		sql.append(" ON SOL.ID_025=TRAM.ID_025_NUM_SOL AND SOL.ID_ANO_025=TRAM.ID_ANO_SOL_025");
		sql.append(" WHERE TRAM.ID_001_FASE='1' AND TRAM.ID_002_TRAM='3'");
		sql.append(" AND SOL.ID_025=? AND SOL.ID_ANO_025=?");
		ArrayList<String> params = new ArrayList<String>();
		params.add(String.valueOf(aa83b25t00.getId025()));
		params.add(String.valueOf(aa83b25t00.getIdAno025()));
		List<Aa83b25t00> lista = (List<Aa83b25t00>) this.jdbcTemplate.query(
				sql.toString(), this.rwMap3, params.toArray());
		if (!lista.isEmpty()) {
			aa83b25t00 = lista.get(0);
		}
		return aa83b25t00;
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b25t00 entity
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b25t00 aa83b25t00) {

		StringBuilder where = new StringBuilder(
				Aa83b25t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b25t00 != null && aa83b25t00.getId025() != null) {
			where.append(" AND t1.ID_025 = ?");
			params.add(aa83b25t00.getId025());
		}
		if (aa83b25t00 != null && aa83b25t00.getIdAno025() != null) {
			where.append(" AND t1.ID_ANO_025 = ?");
			params.add(aa83b25t00.getIdAno025());
		}
		if (aa83b25t00 != null && aa83b25t00.getNombre025() != null) {
			where.append(" AND t1.NOMBRE_025 = ?");
			params.add(aa83b25t00.getNombre025());
		}
		if (aa83b25t00 != null && aa83b25t00.getApel1025() != null) {
			where.append(" AND t1.APEL1_025 = ?");
			params.add(aa83b25t00.getApel1025());
		}
		if (aa83b25t00 != null && aa83b25t00.getApel2025() != null) {
			where.append(" AND t1.APEL2_025 = ?");
			params.add(aa83b25t00.getApel2025());
		}
		if (aa83b25t00 != null && aa83b25t00.getNumReg025() != null) {
			where.append(" AND t1.NUM_REG_025 = ?");
			params.add(aa83b25t00.getNumReg025());
		}
		if (aa83b25t00 != null && aa83b25t00.getId012TipoDoc() != null) {
			where.append(" AND t1.ID_012_TIPO_DOC = ?");
			params.add(aa83b25t00.getId012TipoDoc());
		}
		if (aa83b25t00 != null && aa83b25t00.getNumDoc025() != null) {
			where.append(" AND t1.NUM_DOC_025 = ?");
			params.add(aa83b25t00.getNumDoc025());
		}
		if (aa83b25t00 != null && aa83b25t00.getId017Genero() != null) {
			where.append(" AND t1.ID_017_GENERO = ?");
			params.add(aa83b25t00.getId017Genero());
		}
		if (aa83b25t00 != null && aa83b25t00.getTelf1025() != null) {
			where.append(" AND t1.TELF1_025 = ?");
			params.add(aa83b25t00.getTelf1025());
		}
		if (aa83b25t00 != null && aa83b25t00.getTelf2025() != null) {
			where.append(" AND t1.TELF2_025 = ?");
			params.add(aa83b25t00.getTelf2025());
		}
		if (aa83b25t00 != null && aa83b25t00.getEmail025() != null) {
			where.append(" AND t1.EMAIL_025 = ?");
			params.add(aa83b25t00.getEmail025());
		}
		if (aa83b25t00 != null && aa83b25t00.getFNac025() != null) {
			where.append(" AND t1.F_NAC_025 = ?");
			params.add(aa83b25t00.getFNac025());
		}
		if (aa83b25t00 != null && aa83b25t00.getNacionalidad025() != null) {
			where.append(" AND t1.NACIONALIDAD_025 = ?");
			params.add(aa83b25t00.getNacionalidad025());
		}
		if (aa83b25t00 != null && aa83b25t00.getLocalidadEmp025() != null) {
			where.append(" AND t1.LOCALIDAD_EMP_025 = ?");
			params.add(aa83b25t00.getLocalidadEmp025());
		}
		if (aa83b25t00 != null && aa83b25t00.getProvEmp025() != null) {
			where.append(" AND t1.PROV_EMP_025 = ?");
			params.add(aa83b25t00.getProvEmp025());
		}
		if (aa83b25t00 != null && aa83b25t00.getIdiomaComunic025() != null) {
			where.append(" AND t1.IDIOMA_COMUNIC_025 = ?");
			params.add(aa83b25t00.getIdiomaComunic025());
		}
		if (aa83b25t00 != null && aa83b25t00.getProvinciaComunic025() != null) {
			where.append(" AND t1.PROVINCIA_COMUNIC_025 = ?");
			params.add(aa83b25t00.getProvinciaComunic025());
		}
		if (aa83b25t00 != null && aa83b25t00.getMunicipComunic025() != null) {
			where.append(" AND t1.MUNICIP_COMUNIC_025 = ?");
			params.add(aa83b25t00.getMunicipComunic025());
		}
		if (aa83b25t00 != null && aa83b25t00.getCalleComunic025() != null) {
			where.append(" AND t1.CALLE_COMUNIC_025 = ?");
			params.add(aa83b25t00.getCalleComunic025());
		}
		if (aa83b25t00 != null && aa83b25t00.getNumeroComunic025() != null) {
			where.append(" AND t1.NUMERO_COMUNIC_025 = ?");
			params.add(aa83b25t00.getNumeroComunic025());
		}
		if (aa83b25t00 != null && aa83b25t00.getPisoComunic025() != null) {
			where.append(" AND t1.PISO_COMUNIC_025 = ?");
			params.add(aa83b25t00.getPisoComunic025());
		}
		if (aa83b25t00 != null && aa83b25t00.getLetraComunic025() != null) {
			where.append(" AND t1.LETRA_COMUNIC_025 = ?");
			params.add(aa83b25t00.getLetraComunic025());
		}
		if (aa83b25t00 != null && aa83b25t00.getCpostalComunic025() != null) {
			where.append(" AND t1.CPOSTAL_COMUNIC_025 = ?");
			params.add(aa83b25t00.getCpostalComunic025());
		}
		if (aa83b25t00 != null && aa83b25t00.getConsentimientos025() != null) {
			where.append(" AND t1.CONSENTIMIENTOS_025 = ?");
			params.add(aa83b25t00.getConsentimientos025());
		}
		if (aa83b25t00 != null && aa83b25t00.getfEmpActual025() != null) {
			where.append(" AND t1.F_EMP_ACTUAL_025 = ?");
			params.add(aa83b25t00.getfEmpActual025());
		}
		if (aa83b25t00 != null && aa83b25t00.getfEntradaEsp025() != null) {
			where.append(" AND t1.F_ENTRADA_ESP_025 = ?");
			params.add(aa83b25t00.getfEntradaEsp025());
		}
		if (aa83b25t00 != null && aa83b25t00.getF1Empadron025() != null) {
			where.append(" AND t1.F_1_EMPADRON_025 = ?");
			params.add(aa83b25t00.getF1Empadron025());
		}
		if (aa83b25t00 != null && aa83b25t00.getNombreRep025() != null) {
			where.append(" AND t1.NOMBRE_REP_025 = ?");
			params.add(aa83b25t00.getNombreRep025());
		}
		if (aa83b25t00 != null && aa83b25t00.getApel1Rep025() != null) {
			where.append(" AND t1.APEL1_REP_025 = ?");
			params.add(aa83b25t00.getApel1Rep025());
		}
		if (aa83b25t00 != null && aa83b25t00.getApel2Rep025() != null) {
			where.append(" AND t1.APEL2_REP_025 = ?");
			params.add(aa83b25t00.getApel2Rep025());
		}
		if (aa83b25t00 != null && aa83b25t00.getId012Rep() != null) {
			where.append(" AND t1.ID_012_REP = ?");
			params.add(aa83b25t00.getId012Rep());
		}
		if (aa83b25t00 != null && aa83b25t00.getNumDocRep025() != null) {
			where.append(" AND t1.NUM_DOC_REP_025 = ?");
			params.add(aa83b25t00.getNumDocRep025());
		}
		if (aa83b25t00 != null && aa83b25t00.getTelf1Rep025() != null) {
			where.append(" AND t1.TELF1_REP_025 = ?");
			params.add(aa83b25t00.getTelf1Rep025());
		}
		if (aa83b25t00 != null && aa83b25t00.getTelf2Rep025() != null) {
			where.append(" AND t1.TELF2_REP_025 = ?");
			params.add(aa83b25t00.getTelf2Rep025());
		}
		if (aa83b25t00 != null && aa83b25t00.getTipoNotificacion025() != null) {
			where.append(" AND t1.TIPO_NOTIFICACION_025 = ?");
			params.add(aa83b25t00.getTipoNotificacion025());
		}

		if (aa83b25t00 != null && aa83b25t00.getSolicerrada025() != null) {
			where.append(" AND t1.SOLI_CERRADA025_025 = ?");
			params.add(aa83b25t00.getSolicerrada025());
		}
		if (aa83b25t00 != null && aa83b25t00.getNotifLeida025() != null) {
			where.append(" AND t1.NOTIF_LEIDA_025 = ?");
			params.add(aa83b25t00.getNotifLeida025());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b25t00 entity
	 * 
	 * @param aa83b25t00
	 *            Aa83b25t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b25t00 aa83b25t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b25t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b25t00 != null) {
			if (aa83b25t00.getId025() != null) {
				where.append(" AND t1.ID_025 = ?");
				params.add(aa83b25t00.getId025());
			}
			if (aa83b25t00.getIdAno025() != null) {
				where.append(" AND t1.ID_ANO_025 = ?");
				params.add(aa83b25t00.getIdAno025());
			}
			if (aa83b25t00.getNombre025() != null) {

				where.append(" AND UPPER(TRANSLATE(t1.NOMBRE_025,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b25t00
							.getNombre025().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b25t00
									.getNombre025().toUpperCase()) + "%");
				}
				where.append(" AND t1.NOMBRE_025 IS NOT NULL");
			}
			if (aa83b25t00.getApel1025() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.APEL1_025,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b25t00
							.getApel1025().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b25t00
									.getApel1025().toUpperCase()) + "%");
				}
				where.append(" AND t1.APEL1_025 IS NOT NULL");
			}
			if (aa83b25t00.getApel2025() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.APEL2_025,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b25t00
							.getApel2025().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b25t00
									.getApel2025().toUpperCase()) + "%");
				}
				where.append(" AND t1.APEL2_025 IS NOT NULL");
			}
			if (aa83b25t00.getNumReg025() != null) {
				where.append(" AND UPPER(t1.NUM_REG_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getNumReg025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getNumReg025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUM_REG_025 IS NOT NULL");
			}
			if (aa83b25t00.getId012TipoDoc() != null) {
				where.append(" AND t1.ID_012_TIPO_DOC = ?");
				params.add(aa83b25t00.getId012TipoDoc());
			}
			if (aa83b25t00.getNumDoc025() != null) {
				where.append(" AND UPPER(t1.NUM_DOC_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getNumDoc025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getNumDoc025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUM_DOC_025 IS NOT NULL");
			}
			if (aa83b25t00.getId017Genero() != null) {
				where.append(" AND t1.ID_017_GENERO = ?");
				params.add(aa83b25t00.getId017Genero());
			}
			if (aa83b25t00.getTelf1025() != null) {
				where.append(" AND UPPER(t1.TELF1_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getTelf1025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getTelf1025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF1_025 IS NOT NULL");
			}
			if (aa83b25t00.getTelf2025() != null) {
				where.append(" AND UPPER(t1.TELF2_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getTelf2025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getTelf2025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF2_025 IS NOT NULL");
			}
			if (aa83b25t00.getEmail025() != null) {
				where.append(" AND UPPER(t1.EMAIL_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getEmail025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getEmail025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.EMAIL_025 IS NOT NULL");
			}
			if (aa83b25t00.getFNac025() != null) {
				where.append(" AND t1.F_NAC_025 = ?");
				params.add(aa83b25t00.getFNac025());
			}
			if (aa83b25t00.getNacionalidad025() != null) {
				where.append(" AND t1.NACIONALIDAD_025 = ?");
				params.add(aa83b25t00.getNacionalidad025());
			}
			if (aa83b25t00.getLocalidadEmp025() != null) {
				where.append(" AND t1.LOCALIDAD_EMP_025 = ?");
				params.add(aa83b25t00.getLocalidadEmp025());
			}
			if (aa83b25t00.getProvEmp025() != null) {
				where.append(" AND t1.PROV_EMP_025 = ?");
				params.add(aa83b25t00.getProvEmp025());
			}
			if (aa83b25t00.getIdiomaComunic025() != null) {
				where.append(" AND t1.IDIOMA_COMUNIC_025 = ?");
				params.add(aa83b25t00.getIdiomaComunic025());
			}
			if (aa83b25t00.getProvinciaComunic025() != null) {
				where.append(" AND t1.PROVINCIA_COMUNIC_025 = ?");
				params.add(aa83b25t00.getProvinciaComunic025());
			}
			if (aa83b25t00.getMunicipComunic025() != null) {
				where.append(" AND t1.MUNICIP_COMUNIC_025 = ?");
				params.add(aa83b25t00.getMunicipComunic025());
			}
			if (aa83b25t00.getCalleComunic025() != null) {
				where.append(" AND UPPER(t1.CALLE_COMUNIC_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getCalleComunic025().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b25t00.getCalleComunic025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CALLE_COMUNIC_025 IS NOT NULL");
			}
			if (aa83b25t00.getNumeroComunic025() != null) {
				where.append(" AND UPPER(t1.NUMERO_COMUNIC_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getNumeroComunic025().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b25t00.getNumeroComunic025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUMERO_COMUNIC_025 IS NOT NULL");
			}
			if (aa83b25t00.getPisoComunic025() != null) {
				where.append(" AND UPPER(t1.PISO_COMUNIC_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getPisoComunic025().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b25t00.getPisoComunic025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.PISO_COMUNIC_025 IS NOT NULL");
			}
			if (aa83b25t00.getLetraComunic025() != null) {
				where.append(" AND UPPER(t1.LETRA_COMUNIC_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getLetraComunic025().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b25t00.getLetraComunic025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.LETRA_COMUNIC_025 IS NOT NULL");
			}
			if (aa83b25t00.getCpostalComunic025() != null) {
				where.append(" AND t1.CPOSTAL_COMUNIC_025 = ?");
				params.add(aa83b25t00.getCpostalComunic025());
			}
			if (aa83b25t00.getConsentimientos025() != null) {
				where.append(" AND UPPER(t1.CONSENTIMIENTOS_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getConsentimientos025().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b25t00.getConsentimientos025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CONSENTIMIENTOS_025 IS NOT NULL");
			}
			if (aa83b25t00.getfEmpActual025() != null) {
				where.append(" AND t1.F_EMP_ACTUAL_025 = ?");
				params.add(aa83b25t00.getfEmpActual025());
			}
			if (aa83b25t00.getfEntradaEsp025() != null) {
				where.append(" AND t1.F_ENTRADA_ESP_025 = ?");
				params.add(aa83b25t00.getfEntradaEsp025());
			}
			if (aa83b25t00.getF1Empadron025() != null) {
				where.append(" AND t1.F_1_EMPADRON_025 = ?");
				params.add(aa83b25t00.getF1Empadron025());
			}
			if (aa83b25t00.getNombreRep025() != null) {
				where.append(" AND UPPER(t1.NOMBRE_REP_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getNombreRep025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getNombreRep025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NOMBRE_REP_025 IS NOT NULL");
			}
			if (aa83b25t00.getApel1Rep025() != null) {
				where.append(" AND UPPER(t1.APEL1_REP_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getApel1Rep025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getApel1Rep025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.APEL1_REP_025 IS NOT NULL");
			}
			if (aa83b25t00.getApel2Rep025() != null) {
				where.append(" AND UPPER(t1.APEL2_REP_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getApel2Rep025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getApel2Rep025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.APEL2_REP_025 IS NOT NULL");
			}
			if (aa83b25t00.getId012Rep() != null) {
				where.append(" AND t1.ID_012_REP = ?");
				params.add(aa83b25t00.getId012Rep());
			}
			if (aa83b25t00.getNumDocRep025() != null) {
				where.append(" AND UPPER(t1.NUM_DOC_REP_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getNumDocRep025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getNumDocRep025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUM_DOC_REP_025 IS NOT NULL");
			}
			if (aa83b25t00.getTelf1Rep025() != null) {
				where.append(" AND UPPER(t1.TELF1_REP_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getTelf1Rep025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getTelf1Rep025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF1_REP_025 IS NOT NULL");
			}
			if (aa83b25t00.getTelf2Rep025() != null) {
				where.append(" AND UPPER(t1.TELF2_REP_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getTelf2Rep025().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b25t00.getTelf2Rep025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF2_REP_025 IS NOT NULL");
			}
			if (aa83b25t00.getTipoNotificacion025() != null) {
				where.append(" AND UPPER(t1.TIPO_NOTIFICACION_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getTipoNotificacion025()
							.toUpperCase() + "%");
				} else {
					params.add("%"
							+ aa83b25t00.getTipoNotificacion025().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TIPO_NOTIFICACION_025 IS NOT NULL");
			}

			// Si el campo soli_cerrada_025 = 'N' o Nulo significa que esta
			// abierta la solicitud
			Aa83b25t00DaoImpl.LOGGER.info("[Aa83b25t00DaoImpl] : getWhereLikeMap  aa83b25t00.getSolicerrada025():" + aa83b25t00.getSolicerrada025());
			
			if ("N".equalsIgnoreCase(aa83b25t00.getSolicerrada025())) {
				Aa83b25t00DaoImpl.LOGGER.info("[Aa83b25t00DaoImpl] :getWhereLikeMap  entra porque esta chequeada la casilla y solo quiero las abiertas");				
				// where.append(" AND UPPER(t1.SOLI_CERRADA_023) like ? ESCAPE  '\\'");
				where.append(" AND UPPER(nvl(t1.SOLI_CERRADA_025,'N')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getSolicerrada025().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b25t00.getSolicerrada025().toUpperCase()
							+ "%");
				}
				// where.append(" AND t1.SOLI_CERRADA_025 IS NOT NULL");
			}

			if (aa83b25t00.getNotifLeida025() != null) {
				where.append(" AND UPPER(t1.NOTIF_LEIDA_025) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b25t00.getNotifLeida025().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b25t00.getNotifLeida025().toUpperCase() + "%");
				}
				where.append(" AND t1.NOTIF_LEIDA_025 IS NOT NULL");
			}
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	@Override
	public Aa83b25t00 marcarNotifLeida(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub

		String query = "UPDATE AA83B25T00 SET NOTIF_LEIDA_025 = ? "
				+ "WHERE ID_ANO_025=? AND ID_025=? ";

		this.jdbcTemplate.update(query, "S", aa83b25t00.getIdAno025(),
				aa83b25t00.getId025());
		return aa83b25t00;
	}
	
	@Override
	public Aa83b25t00 marcarReqSubsanaLeido025(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub

		String query = "UPDATE AA83B25T00 SET REQ_LEIDO_025 = ? "
				+ "WHERE ID_ANO_025=? AND ID_025=? ";
		this.jdbcTemplate.update(query, "S", aa83b25t00.getIdAno025(),
				aa83b25t00.getId025());
		return aa83b25t00;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Aa83b25t00 cerrarExp(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub
		String query = "UPDATE AA83B25T00 SET NOTIF_LEIDA_025 = ?, SOLI_CERRADA_025 = ? "
				+ " WHERE ID_ANO_025=? AND ID_025=? ";

		this.jdbcTemplate.update(query, "S", "S", aa83b25t00.getIdAno025(),
				aa83b25t00.getId025());
		return aa83b25t00;
	}

	@Override
	public Aa83b25t00 cerrarExpReq(Aa83b25t00 aa83b25t00) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		String query = "UPDATE AA83B25T00 SET NOTIF_LEIDA_025 = ?, SOLI_CERRADA_025 = ?, RESOL_FAVORABLE_025 = ? "
				+ " WHERE ID_ANO_025= ?  AND ID_025 = ? ";

		this.jdbcTemplate.update(query, "S", "S", "0",
				aa83b25t00.getIdAno025(), aa83b25t00.getId025());
		return aa83b25t00;
	}

}
