package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b24t00;

/**
 * Aa83b24t00DaoImpl generated by UDA, 23-dic-2015 11:25:40.
 * @author UDA
 */
 
@Repository
@Transactional
public class Aa83b24t00DaoImpl implements Aa83b24t00Dao {
    private JdbcTemplate jdbcTemplate;
	
    
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b24t00> rwMap = new RowMapper<Aa83b24t00>() {
		public Aa83b24t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Aa83b24t00(
               resultSet.getInt("ID024"), resultSet.getInt("IDNUMSOL025"), resultSet.getLong("IDANO025"), resultSet.getInt("ID004TIPODOCG"), resultSet.getInt("ID011HISTOTRAM"), resultSet.getString("IDPIF024"), resultSet.getString("OID024")
           ); } } ;
           
	private RowMapper<Aa83b24t00> rwMapPK = new RowMapper<Aa83b24t00>() {
		public Aa83b24t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa83b24t00(
				resultSet.getInt("ID024")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
     * @param dataSource DataSource
     * @return
     */
	private RowMapper<JerarquiaDto< Aa83b24t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b24t00>>() {
		public JerarquiaDto<Aa83b24t00> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Aa83b24t00 aa83b24t00 = new Aa83b24t00(resultSet.getInt("ID024"), resultSet.getInt("IDNUMSOL025"), resultSet.getLong("IDANO025"), resultSet.getInt("ID004TIPODOCG"), resultSet.getInt("ID011HISTOTRAM"), resultSet.getString("IDPIF024"), resultSet.getString("OID024"));

			JerarquiaDto<Aa83b24t00> jerarquia = new JerarquiaDto<Aa83b24t00>();
			jerarquia.setModel(aa83b24t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
     * Inserts a single row in the Aa83b24t00 table.
     *
     * @param aa83b24t00 Aa83b24t00
     * @return Aa83b24t00
     */
	public Aa83b24t00 add(Aa83b24t00 aa83b24t00) {
		final int nextId = jdbcTemplate
		.queryForInt("SELECT SEQ_AA83B24T00_ID_024.NEXTVAL FROM DUAL");
		aa83b24t00.setId024(nextId);
    	String query = "INSERT INTO AA83B24T00 (ID_024, ID_NUM_SOL_025, ID_ANO_025, ID_004_TIPO_DOC_G, ID_011_HISTO_TRAM, ID_PIF_024, OID_024) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b24t00.getId024(), aa83b24t00.getIdNumSol025(), aa83b24t00.getIdAno025(), aa83b24t00.getId004TipoDocG(), aa83b24t00.getId011HistoTram(), aa83b24t00.getIdPif024(), aa83b24t00.getOid024());
		return aa83b24t00;
	}

    /**
     * Updates a single row in the Aa83b24t00 table.
     *
     * @param aa83b24t00 Aa83b24t00
     * @return Aa83b24t00
     */
    public Aa83b24t00 update(Aa83b24t00 aa83b24t00) {
		String query = "UPDATE AA83B24T00 SET ID_NUM_SOL_025=?, ID_ANO_025=?, ID_004_TIPO_DOC_G=?, ID_011_HISTO_TRAM=?, ID_PIF_024=?, OID_024=? WHERE ID_024=?";
		this.jdbcTemplate.update(query, aa83b24t00.getIdNumSol025(), aa83b24t00.getIdAno025(), aa83b24t00.getId004TipoDocG(), aa83b24t00.getId011HistoTram(), aa83b24t00.getIdPif024(), aa83b24t00.getOid024(), aa83b24t00.getId024());
		return aa83b24t00;
	}

    /**
     * Finds a single row in the Aa83b24t00 table.
     *
     * @param aa83b24t00 Aa83b24t00
     * @return Aa83b24t00
     */
    @Transactional (readOnly = true)
    public Aa83b24t00 find(Aa83b24t00 aa83b24t00) {
		String query = "SELECT t1.ID_024 ID024, t1.ID_NUM_SOL_025 IDNUMSOL025, t1.ID_ANO_025 IDANO025, t1.ID_004_TIPO_DOC_G ID004TIPODOCG, t1.ID_011_HISTO_TRAM ID011HISTOTRAM, t1.ID_PIF_024 IDPIF024, t1.OID_024 OID024 FROM AA83B24T00 t1  WHERE t1.ID_024 = ?  ";
		
		List<Aa83b24t00> aa83b24t00List = this.jdbcTemplate.query(query, this.rwMap, aa83b24t00.getId024());
		return (Aa83b24t00) DataAccessUtils.uniqueResult(aa83b24t00List);
    }

    /**
     * Removes a single row in the Aa83b24t00 table.
     *
     * @param aa83b24t00 Aa83b24t00
     * @return
     */
    public void remove(Aa83b24t00 aa83b24t00) {
		String query = "DELETE FROM AA83B24T00 WHERE ID_024=?";
		this.jdbcTemplate.update(query, aa83b24t00.getId024());
    }
    
   /**
    * Finds a list of rows in the Aa83b24t00 table.
    * 
    * @param aa83b24t00 Aa83b24t00
    * @param jqGridRequestDto JQGridRequestDto
    * @return List<Aa83b24t00> 
    */
	@Transactional (readOnly = true)
    public List<Aa83b24t00> findAll(Aa83b24t00 aa83b24t00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_024 ID024,t1.ID_NUM_SOL_025 IDNUMSOL025,t1.ID_ANO_025 IDANO025,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_011_HISTO_TRAM ID011HISTOTRAM,t1.ID_PIF_024 IDPIF024,t1.OID_024 OID024 "); 
		query.append("FROM AA83B24T00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b24t00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b24t00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the Aa83b24t00 table using like.
     * 
     * @param aa83b24t00 Aa83b24t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<Aa83b24t00>
     */
	@Transactional (readOnly = true)
    public List<Aa83b24t00> findAllLike(Aa83b24t00 aa83b24t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_024 ID024,t1.ID_NUM_SOL_025 IDNUMSOL025,t1.ID_ANO_025 IDANO025,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_011_HISTO_TRAM ID011HISTOTRAM,t1.ID_PIF_024 IDPIF024,t1.OID_024 OID024 "); 
        query.append("FROM AA83B24T00 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b24t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b24t00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
     * Counts rows in the Aa83b24t00 table.
     * 
     * @param aa83b24t00 Aa83b24t00
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Aa83b24t00 aa83b24t00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B24T00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b24t00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Aa83b24t00 table using like.
     * 
     * @param aa83b24t00 Aa83b24t00
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Aa83b24t00 aa83b24t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B24T00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b24t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b24t00 selected for rup_table
     * 
     * @param aa83b24t00 Aa83b24t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b24t00>> 
     */
	@Override 
	public List<TableRowDto<Aa83b24t00>> reorderSelection(Aa83b24t00 aa83b24t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_024 ID024,t1.ID_NUM_SOL_025 IDNUMSOL025,t1.ID_ANO_025 IDANO025,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_011_HISTO_TRAM ID011HISTOTRAM,t1.ID_PIF_024 IDPIF024,t1.OID_024 OID024 "); 
		// FROM
        query.append("FROM AA83B24T00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b24t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Aa83b24t00.class, filterParamList, "ID_024" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b24t00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
     * 
     * @param filterParams Aa83b24t00
     * @param searchParams Aa83b24t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b24t00>> 
     */
	@Override
	public List<TableRowDto<Aa83b24t00>> search(Aa83b24t00 filterParams, Aa83b24t00 searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_024 ID024,t1.ID_NUM_SOL_025 IDNUMSOL025,t1.ID_ANO_025 IDANO025,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_011_HISTO_TRAM ID011HISTOTRAM,t1.ID_PIF_024 IDPIF024,t1.OID_024 OID024 "); 
		// FROM
        query.append("FROM AA83B24T00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Aa83b24t00.class, filterParamList, searchSQL, searchParamList, from_alias, "ID_024");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b24t00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table
     * 
     * @param filteraa83b24t00 Aa83b24t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean 
     */
	@Override
	public void removeMultiple(Aa83b24t00 filteraa83b24t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.ID_024 ID024,t1.ID_NUM_SOL_025 IDNUMSOL025,t1.ID_ANO_025 IDANO025,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_011_HISTO_TRAM ID011HISTOTRAM,t1.ID_PIF_024 IDPIF024,t1.OID_024 OID024 "); 
		// FROM
        query.append("FROM AA83B24T00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b24t00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Aa83b24t00.class, query, params, "ID_024");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b24t00 table.
     * 
     * @param filterAa83b24t00 Aa83b24t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<JerarquiaDto<Aa83b24t00>> 
     */
	@Override
	public List<JerarquiaDto<Aa83b24t00>> findAllLikeJerarquia(Aa83b24t00 filterAa83b24t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_024 ID024,t1.ID_NUM_SOL_025 IDNUMSOL025,t1.ID_ANO_025 IDANO025,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_011_HISTO_TRAM ID011HISTOTRAM,t1.ID_PIF_024 IDPIF024,t1.OID_024 OID024 "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B24T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B24T00");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b24t00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID_024", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
     * 
     * @param filterAa83b24t00 Aa83b24t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return Long 
     */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b24t00 filterAa83b24t00, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B24T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B24T00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b24t00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID_024", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
     * 
     * @param filterAa83b24t00 Aa83b24t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<TableRowDto<Aa83b24t00>> 
     */
	@Override
	public List<TableRowDto<Aa83b24t00>> findAllChild(Aa83b24t00 filterAa83b24t00, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B24T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B24T00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b24t00, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID_024", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Aa83b24t00>(this.rwMapPK, "ID_024"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Aa83b24t00 entity 
	 * 
	 * @param aa83b24t00 Aa83b24t00
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Aa83b24t00 aa83b24t00){
		
		StringBuilder where = new StringBuilder(Aa83b24t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b24t00  != null  && aa83b24t00.getId024() != null ) {
			where.append(" AND t1.ID_024 = ?");
			params.add(aa83b24t00.getId024());
		}
		if (aa83b24t00  != null  && aa83b24t00.getIdNumSol025() != null ) {
			where.append(" AND t1.ID_NUM_SOL_025 = ?");
			params.add(aa83b24t00.getIdNumSol025());
		}
		if (aa83b24t00  != null  && aa83b24t00.getIdAno025() != null ) {
			where.append(" AND t1.ID_ANO_025 = ?");
			params.add(aa83b24t00.getIdAno025());
		}
		if (aa83b24t00  != null  && aa83b24t00.getId004TipoDocG() != null ) {
			where.append(" AND t1.ID_004_TIPO_DOC_G = ?");
			params.add(aa83b24t00.getId004TipoDocG());
		}
		if (aa83b24t00  != null  && aa83b24t00.getId011HistoTram() != null ) {
			where.append(" AND t1.ID_011_HISTO_TRAM = ?");
			params.add(aa83b24t00.getId011HistoTram());
		}
		if (aa83b24t00  != null  && aa83b24t00.getIdPif024() != null ) {
			where.append(" AND t1.ID_PIF_024 = ?");
			params.add(aa83b24t00.getIdPif024());
		}
		if (aa83b24t00  != null  && aa83b24t00.getOid024() != null ) {
			where.append(" AND t1.OID_024 = ?");
			params.add(aa83b24t00.getOid024());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Aa83b24t00 entity 
	 * 
	 * @param aa83b24t00 Aa83b24t00
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (Aa83b24t00 aa83b24t00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(Aa83b24t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b24t00  != null  && aa83b24t00.getId024() != null ) {
			where.append(" AND t1.ID_024 = ?");
			params.add(aa83b24t00.getId024());
	     }			
		if (aa83b24t00  != null  && aa83b24t00.getIdNumSol025() != null ) {
			where.append(" AND t1.ID_NUM_SOL_025 = ?");
			params.add(aa83b24t00.getIdNumSol025());
	     }			
		if (aa83b24t00  != null  && aa83b24t00.getIdAno025() != null ) {
			where.append(" AND t1.ID_ANO_025 = ?");
			params.add(aa83b24t00.getIdAno025());
	     }			
		if (aa83b24t00  != null  && aa83b24t00.getId004TipoDocG() != null ) {
			where.append(" AND t1.ID_004_TIPO_DOC_G = ?");
			params.add(aa83b24t00.getId004TipoDocG());
	     }			
		if (aa83b24t00  != null  && aa83b24t00.getId011HistoTram() != null ) {
			where.append(" AND t1.ID_011_HISTO_TRAM = ?");
			params.add(aa83b24t00.getId011HistoTram());
	     }			
		if (aa83b24t00  != null  && aa83b24t00.getIdPif024() != null ) {
			where.append(" AND UPPER(t1.ID_PIF_024) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b24t00.getIdPif024().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b24t00.getIdPif024().toUpperCase() +"%");
			}
			where.append(" AND t1.ID_PIF_024 IS NOT NULL");
	     }			
		if (aa83b24t00  != null  && aa83b24t00.getOid024() != null ) {
			where.append(" AND UPPER(t1.OID_024) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b24t00.getOid024().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b24t00.getOid024().toUpperCase() +"%");
			}
			where.append(" AND t1.OID_024 IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

