package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b23t00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa83b23t00DaoImpl generated by UDA, 28-dic-2015 17:33:46.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b23t00DaoImpl implements Aa83b23t00Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b23t00> rwMap = new RowMapper<Aa83b23t00>() {
		public Aa83b23t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b23t00(resultSet.getInt("ID023"),
					resultSet.getLong("IDANO023"),
					resultSet.getString("TELFNOTIFICACION023"),
					resultSet.getString("NOMBRE023"),
					resultSet.getString("APEL1023"),
					resultSet.getString("APEL2023"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC023"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1023"),
					resultSet.getString("TELF2023"),
					resultSet.getString("EMAIL023"),
					resultSet.getString("FNAC023"),
					resultSet.getInt("NACIONALIDAD023"),
					resultSet.getString("LOCALIDADEMP023"),
					resultSet.getString("PROVEMP023"),
					resultSet.getInt("IDIOMACOMUNIC023"),
					resultSet.getString("PROVINCIACOMUNIC023"),
					resultSet.getString("MUNICIPCOMUNIC023"),
					resultSet.getString("CALLECOMUNIC023"),
					resultSet.getString("NUMEROCOMUNIC023"),
					resultSet.getString("BISCOMUNIC023"),					
					resultSet.getString("PISOCOMUNIC023"),
					resultSet.getString("LETRACOMUNIC023"),
					resultSet.getString("CPOSTALCOMUNIC023"),
					resultSet.getString("CONSENTIMIENTOS023"),
					resultSet.getInt("ID026MOTIVOS"),
					resultSet.getString("FECCADTARJETA023"),
					resultSet.getString("SITUACIONCOMPENSAR023"),
					resultSet.getInt("ID027ESTADOSESF"),
					resultSet.getString("FECHANOTIFTRAMITE023"),
					resultSet.getString("TRESIMANIFESTADO023"),
					resultSet.getString("TRESIACREDITADO023"),
					resultSet.getInt("TOTALDIASACTIVO023"),
					resultSet.getInt("TOTALDIASBUSQUEDA023"),
					resultSet.getString("CONTRATO023"),
					resultSet.getString("OFERTA023"),
					resultSet.getString("PRESTACION023"),
					resultSet.getString("NOMBREREP023"),
					resultSet.getString("APEL1REP023"),
					resultSet.getString("APEL2REP023"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP023"),
					resultSet.getString("TELF1REP023"),
					resultSet.getString("TELF2REP023"),
					resultSet.getString("TIPONOTIFICACION023"),
					resultSet.getString("CONTRATANTE023"),
					resultSet.getString("CONTRATODESC023"),
					resultSet.getString("FECHAEMPADRON023"),
					resultSet.getString("PROVINCIAEMPADRON023"),
					resultSet.getString("MUNICIPIOEMPADRON023"),
					resultSet.getString("DIRECCIONEMPADRON023"),
					resultSet.getString("FECHAEMISIONPADRON023"),
					resultSet.getString("SOLICERRADA023"),
					resultSet.getString("NOTIFLEIDA023"),
					resultSet.getString("REQLEIDO023")
				);
		}
	};
	private RowMapper<Aa83b23t00> rwMap2 = new RowMapper<Aa83b23t00>() {
		public Aa83b23t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b23t00(resultSet.getInt("ID023"),
					resultSet.getLong("IDANO023"),
					resultSet.getString("TELFNOTIFICACION023"),
					resultSet.getString("NUMREG023"),
					resultSet.getString("FECHA023"),
					resultSet.getString("NOMBRE023"),
					resultSet.getString("APEL1023"),
					resultSet.getString("APEL2023"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC023"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1023"),
					resultSet.getString("TELF2023"),
					resultSet.getString("EMAIL023"),
					resultSet.getString("FNAC023"),
					resultSet.getInt("NACIONALIDAD023"),
					resultSet.getString("LOCALIDADEMP023"),
					resultSet.getString("PROVEMP023"),
					resultSet.getInt("IDIOMACOMUNIC023"),
					resultSet.getString("PROVINCIACOMUNIC023"),
					resultSet.getString("MUNICIPCOMUNIC023"),
					resultSet.getString("CALLECOMUNIC023"),
					resultSet.getString("NUMEROCOMUNIC023"),
					resultSet.getString("BISCOMUNIC023"),
					resultSet.getString("PISOCOMUNIC023"),
					resultSet.getString("LETRACOMUNIC023"),
					resultSet.getString("CPOSTALCOMUNIC023"),
					resultSet.getString("CONSENTIMIENTOS023"),
					resultSet.getInt("ID026MOTIVOS"),
					resultSet.getString("FECCADTARJETA023"),
					resultSet.getString("SITUACIONCOMPENSAR023"),
					resultSet.getInt("ID027ESTADOSESF"),
					resultSet.getString("FECHANOTIFTRAMITE023"),
					resultSet.getString("TRESIMANIFESTADO023"),
					resultSet.getString("TRESIACREDITADO023"),
					resultSet.getInt("TOTALDIASACTIVO023"),
					resultSet.getInt("TOTALDIASBUSQUEDA023"),
					resultSet.getString("CONTRATO023"),
					resultSet.getString("OFERTA023"),
					resultSet.getString("PRESTACION023"),
					resultSet.getString("NOMBREREP023"),
					resultSet.getString("APEL1REP023"),
					resultSet.getString("APEL2REP023"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP023"),
					resultSet.getString("TELF1REP023"),
					resultSet.getString("TELF2REP023"),
					resultSet.getString("TIPONOTIFICACION023"),
					resultSet.getString("CONTRATANTE023"),
					resultSet.getString("CONTRATODESC023"),
					resultSet.getString("FECHAEMPADRON023"),
					resultSet.getString("PROVINCIAEMPADRON023"),
					resultSet.getString("MUNICIPIOEMPADRON023"),
					resultSet.getString("DIRECCIONEMPADRON023"),
					resultSet.getString("FECHAEMISIONPADRON023"),
					resultSet.getInt("RESOLFAVORABLE023"),
					resultSet.getString("SOLICERRADA023"),
					resultSet.getString("NOTIFLEIDA023"),
					resultSet.getString("REQLEIDO023"),
					resultSet.getString("OBSERVACIONES23")
			);
		}
	};
	private RowMapper<Aa83b23t00> rwMap3 = new RowMapper<Aa83b23t00>() {
		public Aa83b23t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b23t00(resultSet.getInt("ID023"),
					resultSet.getLong("IDANO023"),
					resultSet.getString("TELFNOTIFICACION023"),
					resultSet.getString("NUMREG023"),
					resultSet.getString("FECHA023"),
					resultSet.getString("NOMBRE023"),
					resultSet.getString("APEL1023"),
					resultSet.getString("APEL2023"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC023"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1023"),
					resultSet.getString("TELF2023"),
					resultSet.getString("EMAIL023"),
					resultSet.getString("FNAC023"),
					resultSet.getInt("NACIONALIDAD023"),
					resultSet.getString("LOCALIDADEMP023"),
					resultSet.getString("PROVEMP023"),
					resultSet.getInt("IDIOMACOMUNIC023"),
					resultSet.getString("PROVINCIACOMUNIC023"),
					resultSet.getString("MUNICIPCOMUNIC023"),
					resultSet.getString("CALLECOMUNIC023"),
					resultSet.getString("NUMEROCOMUNIC023"),
					resultSet.getString("BISCOMUNIC023"),
					resultSet.getString("PISOCOMUNIC023"),
					resultSet.getString("LETRACOMUNIC023"),
					resultSet.getString("CPOSTALCOMUNIC023"),
					resultSet.getString("CONSENTIMIENTOS023"),
					resultSet.getInt("ID026MOTIVOS"),
					resultSet.getString("FECCADTARJETA023"),
					resultSet.getString("SITUACIONCOMPENSAR023"),
					resultSet.getInt("ID027ESTADOSESF"),
					resultSet.getString("FECHANOTIFTRAMITE023"),
					resultSet.getString("TRESIMANIFESTADO023"),
					resultSet.getString("TRESIACREDITADO023"),
					resultSet.getInt("TOTALDIASACTIVO023"),
					resultSet.getInt("TOTALDIASBUSQUEDA023"),
					resultSet.getString("CONTRATO023"),
					resultSet.getString("OFERTA023"),
					resultSet.getString("PRESTACION023"),
					resultSet.getString("NOMBREREP023"),
					resultSet.getString("APEL1REP023"),
					resultSet.getString("APEL2REP023"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP023"),
					resultSet.getString("TELF1REP023"),
					resultSet.getString("TELF2REP023"),
					resultSet.getString("TIPONOTIFICACION023"),
					resultSet.getString("CONTRATANTE023"),
					resultSet.getString("CONTRATODESC023"),
					resultSet.getString("FECHAEMPADRON023"),
					resultSet.getString("PROVINCIAEMPADRON023"),
					resultSet.getString("MUNICIPIOEMPADRON023"),
					resultSet.getInt("RESOLFAVORABLE023"),
					resultSet.getString("DIRECCIONEMPADRON023"),
					resultSet.getString("FECHAEMISIONPADRON023"),
					resultSet.getString("SOLICERRADA023"),
					resultSet.getString("NOTIFLEIDA023"),
					resultSet.getString("REQLEIDO023")
					);
		}
	};
	private RowMapper<Aa83b23t00> rwMap4 = new RowMapper<Aa83b23t00>() {
		public Aa83b23t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b23t00(resultSet.getInt("ID023"),
					resultSet.getLong("IDANO023"),
					resultSet.getString("NOMBRE023"));
		}
	};
	private RowMapper<Aa83b23t00> rwMapPK = new RowMapper<Aa83b23t00>() {
		public Aa83b23t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b23t00(resultSet.getInt("ID023"),
					resultSet.getLong("IDANO023"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b23t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b23t00>>() {
		public JerarquiaDto<Aa83b23t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa83b23t00 aa83b23t00 = new Aa83b23t00(resultSet.getInt("ID023"),
					resultSet.getLong("IDANO023"),
					resultSet.getString("TELFNOTIFICACION023"),
					resultSet.getString("NOMBRE023"),
					resultSet.getString("APEL1023"),
					resultSet.getString("APEL2023"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC023"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1023"),
					resultSet.getString("TELF2023"),
					resultSet.getString("EMAIL023"),
					resultSet.getString("FNAC023"),
					resultSet.getInt("NACIONALIDAD023"),
					resultSet.getString("LOCALIDADEMP023"),
					resultSet.getString("PROVEMP023"),
					resultSet.getInt("IDIOMACOMUNIC023"),
					resultSet.getString("PROVINCIACOMUNIC023"),
					resultSet.getString("MUNICIPCOMUNIC023"),
					resultSet.getString("CALLECOMUNIC023"),
					resultSet.getString("NUMEROCOMUNIC023"),
					resultSet.getString("BISCOMUNIC023"),
					resultSet.getString("PISOCOMUNIC023"),
					resultSet.getString("LETRACOMUNIC023"),
					resultSet.getString("CPOSTALCOMUNIC023"),
					resultSet.getString("CONSENTIMIENTOS023"),
					resultSet.getInt("ID026MOTIVOS"),
					resultSet.getString("FECCADTARJETA023"),
					resultSet.getString("SITUACIONCOMPENSAR023"),
					resultSet.getInt("ID027ESTADOSESF"),
					resultSet.getString("FECHANOTIFTRAMITE023"),
					resultSet.getString("TRESIMANIFESTADO023"),
					resultSet.getString("TRESIACREDITADO023"),
					resultSet.getInt("TOTALDIASACTIVO023"),
					resultSet.getInt("TOTALDIASBUSQUEDA023"),
					resultSet.getString("CONTRATO023"),
					resultSet.getString("OFERTA023"),
					resultSet.getString("PRESTACION023"),
					resultSet.getString("NOMBREREP023"),
					resultSet.getString("APEL1REP023"),
					resultSet.getString("APEL2REP023"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP023"),
					resultSet.getString("TELF1REP023"),
					resultSet.getString("TELF2REP023"),
					resultSet.getString("TIPONOTIFICACION023"),
					resultSet.getString("CONTRATANTE023"),
					resultSet.getString("CONTRATODESC023"),
					resultSet.getString("FECHAEMPADRON023"),
					resultSet.getString("PROVINCIAEMPADRON023"),
					resultSet.getString("MUNICIPIOEMPADRON023"),
					resultSet.getString("DIRECCIONEMPADRON023"),
					resultSet.getString("FECHAEMISIONPADRON023"),
					resultSet.getString("SOLICERRADA023"),
					resultSet.getString("NOTIFLEIDA023"),
					resultSet.getString("REQLEIDO023"));

			JerarquiaDto<Aa83b23t00> jerarquia = new JerarquiaDto<Aa83b23t00>();
			jerarquia.setModel(aa83b23t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Aa83b23t00
	 */
	public Aa83b23t00 add(Aa83b23t00 aa83b23t00) {
		final int nextId = jdbcTemplate
				.queryForInt("SELECT SEQ_AA83B23T00_ID_023_"
						+ aa83b23t00.getIdAno023() + ".NEXTVAL FROM DUAL");
		aa83b23t00.setId023(nextId);
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String query = "INSERT INTO AA83B23T00 (ID_023, ID_ANO_023, TELF_NOTIFICACION_023, NUM_REG_023, FEC_REG_023, NOMBRE_023, APEL1_023, APEL2_023, ID_012_TIPO_DOC, NUM_DOC_023, ID_017_GENERO, TELF1_023, TELF2_023, EMAIL_023, F_NAC_023, NACIONALIDAD_023, LOCALIDAD_EMP_023, PROV_EMP_023, IDIOMA_COMUNIC_023, PROVINCIA_COMUNIC_023, MUNICIP_COMUNIC_023, CALLE_COMUNIC_023, NUMERO_COMUNIC_023, BIS_COMUNIC_023, PISO_COMUNIC_023, LETRA_COMUNIC_023, CPOSTAL_COMUNIC_023, CONSENTIMIENTOS_023, ID_026_MOTIVOS, FEC_CAD_TARJETA_023, SITUACION_COMPENSAR_023, ID_027_ESTADOS_ESF, FECHA_NOTIF_TRAMITE_023, T_RESI_MANIFESTADO_023, T_RESI_ACREDITADO_023, TOTAL_DIAS_ACTIVO_023, TOTAL_DIAS_BUSQUEDA_023, CONTRATO_023, OFERTA_023, PRESTACION_023, NOMBRE_REP_023, APEL1_REP_023, APEL2_REP_023, ID_012_REP, NUM_DOC_REP_023, TELF1_REP_023, TELF2_REP_023, TIPO_NOTIFICACION_023,CONTRATANTE_023,CONTRATODESC_023,FECHA_EMPADRON_023,PROVINCIA_EMPADRON_023,MUNICIPIO_EMPADRON_023,DIRECCION_EMPADRON_023,FECHA_EMISIONPADRON_023, SOLI_CERRADA_023, NOTIF_LEIDA_023, OBSERVACIONES_023) VALUES (?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,to_date(?,?),?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,to_date(?,?),?,?,?,to_date(?,?),?,?,?)";
		this.jdbcTemplate.update(query, aa83b23t00.getId023(),

		aa83b23t00.getIdAno023(), aa83b23t00.getTelf_notificacion_023(),
				aa83b23t00.getNumReg023(), aa83b23t00.getFecha023(),
				"dd/mm/yyyy HH24:mi:ss", aa83b23t00.getNombre023(),
				aa83b23t00.getApel1023(), aa83b23t00.getApel2023(),
				aa83b23t00.getId012TipoDoc(), aa83b23t00.getNumDoc023(),
				aa83b23t00.getId017Genero(), aa83b23t00.getTelf1023(),
				aa83b23t00.getTelf2023(), aa83b23t00.getEmail023(),
				aa83b23t00.getFNac023(), formato,
				aa83b23t00.getNacionalidad023(),
				aa83b23t00.getLocalidadEmp023(), aa83b23t00.getProvEmp023(),
				aa83b23t00.getIdiomaComunic023(),
				aa83b23t00.getProvinciaComunic023(),
				aa83b23t00.getMunicipComunic023(),
				aa83b23t00.getCalleComunic023(),
				aa83b23t00.getNumeroComunic023(),
				aa83b23t00.getBisComunic023(),
				aa83b23t00.getPisoComunic023(),
				aa83b23t00.getLetraComunic023(),
				aa83b23t00.getCpostalComunic023(),
				aa83b23t00.getConsentimientos023(),
				aa83b23t00.getId026Motivos(), aa83b23t00.getFecCadTarjeta023(),
				formato, aa83b23t00.getSituacionCompensar023(),
				aa83b23t00.getId027EstadosEsf(),
				aa83b23t00.getFechaNotifTramite023(), formato,
				aa83b23t00.getTResiManifestado023(),
				aa83b23t00.getTResiAcreditado023(),
				aa83b23t00.getTotalDiasActivo023(),
				aa83b23t00.getTotalDiasBusqueda023(),
				aa83b23t00.getContrato023(), aa83b23t00.getOferta023(),
				aa83b23t00.getPrestacion023(), aa83b23t00.getNombreRep023(),
				aa83b23t00.getApel1Rep023(), aa83b23t00.getApel2Rep023(),
				aa83b23t00.getId012Rep(), aa83b23t00.getNumDocRep023(),
				aa83b23t00.getTelf1Rep023(), aa83b23t00.getTelf2Rep023(),
				aa83b23t00.getTipoNotificacion023(),
				aa83b23t00.getContratante023(),
				aa83b23t00.getContratoDesc023(),
				aa83b23t00.getFechaEmpadron023(), formato,
				aa83b23t00.getProvinciaEmpadron023(),
				aa83b23t00.getMunicipioEmpadron023(),
				aa83b23t00.getDireccionEmpadron023(),
				aa83b23t00.getFechaEmisionPadron023(), formato,
				aa83b23t00.getSolicerrada023(), aa83b23t00.getNotifLeida023(), aa83b23t00.getObservaciones023());
		return aa83b23t00;
	}

	/**
	 * Updates a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Aa83b23t00
	 */
	public Aa83b23t00 update(Aa83b23t00 aa83b23t00) {
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}

		String query = "UPDATE AA83B23T00 SET NOMBRE_023=?, APEL1_023=?, APEL2_023=?, ID_012_TIPO_DOC=?, NUM_DOC_023=?, ID_017_GENERO=?, TELF1_023=?, TELF2_023=?, EMAIL_023=?, F_NAC_023=to_date(?,?), NACIONALIDAD_023=?, LOCALIDAD_EMP_023=?, PROV_EMP_023=?, IDIOMA_COMUNIC_023=?, PROVINCIA_COMUNIC_023=?, MUNICIP_COMUNIC_023=?, CALLE_COMUNIC_023=?, NUMERO_COMUNIC_023=?, BIS_COMUNIC_023=?, PISO_COMUNIC_023=?, LETRA_COMUNIC_023=?, CPOSTAL_COMUNIC_023=?, CONSENTIMIENTOS_023=?, ID_026_MOTIVOS=?, FEC_CAD_TARJETA_023=to_date(?,?), SITUACION_COMPENSAR_023=?, ID_027_ESTADOS_ESF=?, FECHA_NOTIF_TRAMITE_023=to_date(?,?), T_RESI_MANIFESTADO_023=?, T_RESI_ACREDITADO_023=?, TOTAL_DIAS_ACTIVO_023=?, TOTAL_DIAS_BUSQUEDA_023=?, CONTRATO_023=?, OFERTA_023=?, PRESTACION_023=?, NOMBRE_REP_023=?, APEL1_REP_023=?, APEL2_REP_023=?, ID_012_REP=?, NUM_DOC_REP_023=?, TELF1_REP_023=?, TELF2_REP_023=?, TIPO_NOTIFICACION_023=?, CONTRATANTE_023=?, CONTRATODESC_023=?,RESOL_FAVORABLE_023=?,FECHA_EMPADRON_023=to_date(?,?),DIRECCION_EMPADRON_023=?,FECHA_EMISIONPADRON_023=to_date(?,?) ,PROVINCIA_EMPADRON_023=?, MUNICIPIO_EMPADRON_023=?, SOLI_CERRADA_023 =?, NOTIF_LEIDA_023 = ?, OBSERVACIONES_023 = ? WHERE ID_023=? AND ID_ANO_023=?";
		// String query =
		// "UPDATE AA83B23T00 SET NOMBRE_023=?, APEL1_023=?, APEL2_023=?, ID_012_TIPO_DOC=?, NUM_DOC_023=?, ID_017_GENERO=?, TELF1_023=?, TELF2_023=?, EMAIL_023=?, F_NAC_023=to_date(?,?), NACIONALIDAD_023=?, LOCALIDAD_EMP_023=?, PROV_EMP_023=?, IDIOMA_COMUNIC_023=?, PROVINCIA_COMUNIC_023=?, MUNICIP_COMUNIC_023=?, CALLE_COMUNIC_023=?, NUMERO_COMUNIC_023=?, PISO_COMUNIC_023=?, LETRA_COMUNIC_023=?, CPOSTAL_COMUNIC_023=?, CONSENTIMIENTOS_023=?, ID_026_MOTIVOS=?, FEC_CAD_TARJETA_023=to_date(?,?), SITUACION_COMPENSAR_023=?, ID_027_ESTADOS_ESF=?, FECHA_NOTIF_TRAMITE_023=to_date(?,?), T_RESI_MANIFESTADO_023=?, T_RESI_ACREDITADO_023=?, TOTAL_DIAS_ACTIVO_023=?, TOTAL_DIAS_BUSQUEDA_023=?, CONTRATO_023=?, OFERTA_023=?, PRESTACION_023=?, NOMBRE_REP_023=?, APEL1_REP_023=?, APEL2_REP_023=?, ID_012_REP=?, NUM_DOC_REP_023=?, TELF1_REP_023=?, TELF2_REP_023=?, TIPO_NOTIFICACION_023=?, CONTRATANTE_023=?, CONTRATODESC_023=?, FECHA_EMPADRON_023=to_date(?,?), PROVINCIA_EMPADRON_023=?, MUNICIPIO_EMPADRON_023=?, RESOL_FAVORABLE_023=? WHERE ID_023=? AND ID_ANO_023=?";
		this.jdbcTemplate.update(
				query,
				aa83b23t00.getNombre023(),
				aa83b23t00.getApel1023(),
				aa83b23t00.getApel2023(),
				aa83b23t00.getId012TipoDoc(),
				aa83b23t00.getNumDoc023(),
				aa83b23t00.getId017Genero(),
				aa83b23t00.getTelf1023(),
				aa83b23t00.getTelf2023(),
				aa83b23t00.getEmail023(),
				aa83b23t00.getFNac023(),
				formato,
				aa83b23t00.getNacionalidad023(),
				aa83b23t00.getLocalidadEmp023(),
				aa83b23t00.getProvEmp023(),
				aa83b23t00.getIdiomaComunic023(),
				aa83b23t00.getProvinciaComunic023(),
				aa83b23t00.getMunicipComunic023(),
				aa83b23t00.getCalleComunic023(),
				aa83b23t00.getNumeroComunic023(),
				aa83b23t00.getBisComunic023(),
				aa83b23t00.getPisoComunic023(),
				aa83b23t00.getLetraComunic023(),
				aa83b23t00.getCpostalComunic023(),
				aa83b23t00.getConsentimientos023(),
				aa83b23t00.getId026Motivos(),
				aa83b23t00.getFecCadTarjeta023(),
				formato,
				aa83b23t00.getSituacionCompensar023(),
				aa83b23t00.getId027EstadosEsf(),
				aa83b23t00.getFechaNotifTramite023(),
				formato,
				aa83b23t00.getTResiManifestado023(),
				aa83b23t00.getTResiAcreditado023(),
				aa83b23t00.getTotalDiasActivo023(),
				aa83b23t00.getTotalDiasBusqueda023(),
				aa83b23t00.getContrato023(),
				aa83b23t00.getOferta023(),
				aa83b23t00.getPrestacion023(),
				aa83b23t00.getNombreRep023(),
				aa83b23t00.getApel1Rep023(),
				aa83b23t00.getApel2Rep023(),
				aa83b23t00.getId012Rep(),
				aa83b23t00.getNumDocRep023(),
				aa83b23t00.getTelf1Rep023(),
				aa83b23t00.getTelf2Rep023(),
				aa83b23t00.getTipoNotificacion023(),
				aa83b23t00.getContratante023(),
				aa83b23t00.getContratoDesc023(),
				//
				// aa83b23t00.getProvinciaEmpadron023(),
				// aa83b23t00.getMunicipioEmpadron023(),
				aa83b23t00.getResolFavorable023(),
				aa83b23t00.getFechaEmpadron023(), formato,
				aa83b23t00.getDireccionEmpadron023(),
				aa83b23t00.getFechaEmisionPadron023(), formato,
				aa83b23t00.getProvinciaEmpadron023(),
				aa83b23t00.getMunicipioEmpadron023(),
				aa83b23t00.getSolicerrada023(), aa83b23t00.getNotifLeida023(),
				aa83b23t00.getObservaciones023(), 
				aa83b23t00.getId023(), aa83b23t00.getIdAno023());
		return aa83b23t00;
	}

	public void updateResolFavorable(Aa83b23t00 aa83b23t00) {
		String query = "UPDATE AA83B23T00 SET RESOL_FAVORABLE_023=? WHERE ID_023=? AND ID_ANO_023=?";
		this.jdbcTemplate.update(query, aa83b23t00.getResolFavorable023(),
				aa83b23t00.getId023(), aa83b23t00.getIdAno023());
	}

	/**
	 * Finds a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Aa83b23t00
	 */
	@Transactional(readOnly = true)
	public Aa83b23t00 find(Aa83b23t00 aa83b23t00) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		String formatoHora = Aa83BConstants.ES_PATTERN_HORA_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
			formatoHora = Aa83BConstants.EU_PATTERN_HORA_COMPLETA;
		}
		String query = "SELECT t1.ID_023 ID023, t1.ID_ANO_023 IDANO023, "
				+ "NUM_REG_023 NUMREG023, t1.TELF_NOTIFICACION_023 TELFNOTIFICACION023, "
				+ "TO_CHAR(FEC_REG_023,"
				+ formatoHora
				+ ") FECHA023, t1.NOMBRE_023 NOMBRE023, t1.APEL1_023 APEL1023, t1.APEL2_023 APEL2023, t1.ID_012_TIPO_DOC ID012TIPODOC, t1.NUM_DOC_023 NUMDOC023, t1.ID_017_GENERO ID017GENERO, t1.TELF1_023 TELF1023, t1.TELF2_023 TELF2023, t1.EMAIL_023 EMAIL023, to_char(t1.F_NAC_023,"
				+ formato
				+ ") FNAC023, t1.NACIONALIDAD_023 NACIONALIDAD023, t1.LOCALIDAD_EMP_023 LOCALIDADEMP023, t1.PROV_EMP_023 PROVEMP023, t1.IDIOMA_COMUNIC_023 IDIOMACOMUNIC023, t1.PROVINCIA_COMUNIC_023 PROVINCIACOMUNIC023, t1.MUNICIP_COMUNIC_023 MUNICIPCOMUNIC023, t1.CALLE_COMUNIC_023 CALLECOMUNIC023, t1.NUMERO_COMUNIC_023 NUMEROCOMUNIC023, t1.BIS_COMUNIC_023 BISCOMUNIC023, t1.PISO_COMUNIC_023 PISOCOMUNIC023, t1.LETRA_COMUNIC_023 LETRACOMUNIC023, t1.CPOSTAL_COMUNIC_023 CPOSTALCOMUNIC023, t1.CONSENTIMIENTOS_023 CONSENTIMIENTOS023, t1.ID_026_MOTIVOS ID026MOTIVOS, TO_CHAR(t1.FEC_CAD_TARJETA_023,"
				+ formato
				+ ") FECCADTARJETA023, t1.SITUACION_COMPENSAR_023 SITUACIONCOMPENSAR023, t1.ID_027_ESTADOS_ESF ID027ESTADOSESF, to_char(t1.FECHA_NOTIF_TRAMITE_023,"
				+ formato
				+ ") FECHANOTIFTRAMITE023, t1.T_RESI_MANIFESTADO_023 TRESIMANIFESTADO023, t1.T_RESI_ACREDITADO_023 TRESIACREDITADO023, t1.TOTAL_DIAS_ACTIVO_023 TOTALDIASACTIVO023, t1.TOTAL_DIAS_BUSQUEDA_023 TOTALDIASBUSQUEDA023, t1.CONTRATO_023 CONTRATO023, t1.OFERTA_023 OFERTA023, t1.PRESTACION_023 PRESTACION023, t1.NOMBRE_REP_023 NOMBREREP023, t1.APEL1_REP_023 APEL1REP023, t1.APEL2_REP_023 APEL2REP023, t1.ID_012_REP ID012REP, t1.NUM_DOC_REP_023 NUMDOCREP023, t1.TELF1_REP_023 TELF1REP023, t1.TELF2_REP_023 TELF2REP023, t1.TIPO_NOTIFICACION_023 TIPONOTIFICACION023,"
				+ " CONTRATANTE_023 CONTRATANTE023,CONTRATODESC_023 CONTRATODESC023,to_char(FECHA_EMPADRON_023,"
				+ formato
				+ ") FECHAEMPADRON023,PROVINCIA_EMPADRON_023 PROVINCIAEMPADRON023,MUNICIPIO_EMPADRON_023 MUNICIPIOEMPADRON023, nvl(RESOL_FAVORABLE_023,9) RESOLFAVORABLE023 "
				+ " ,t1.DIRECCION_EMPADRON_023 DIRECCIONEMPADRON023,TO_CHAR(t1.FECHA_EMISIONPADRON_023,"
				+ formato
				+ ") FECHAEMISIONPADRON023, "
				+ " t1.SOLI_CERRADA_023 SOLICERRADA023, "
				+ " t1.NOTIF_LEIDA_023 NOTIFLEIDA023, t1.REQ_LEIDO_023 REQLEIDO023, t1.OBSERVACIONES_023 OBSERVACIONES23 "
				+ " FROM AA83B23T00 t1  WHERE t1.ID_023 = ?   AND t1.ID_ANO_023 = ?  ";

		List<Aa83b23t00> aa83b23t00List = this.jdbcTemplate.query(query,
				this.rwMap2, aa83b23t00.getId023(), aa83b23t00.getIdAno023());

		return (Aa83b23t00) DataAccessUtils.uniqueResult(aa83b23t00List);
	}

	/**
	 * Removes a single row in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return
	 */
	public void remove(Aa83b23t00 aa83b23t00) {
		String query = "DELETE FROM AA83B23T00 WHERE ID_023=? AND ID_ANO_023=?";
		this.jdbcTemplate.update(query, aa83b23t00.getId023(),
				aa83b23t00.getIdAno023());
	}

	/**
	 * Finds a list of rows in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b23t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b23t00> findAll(Aa83b23t00 aa83b23t00,
			JQGridRequestDto jqGridRequestDto) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_023 ID023,t1.ID_ANO_023 IDANO023,t1.TELF_NOTIFICACION_023 TELFNOTIFICACION023,t1.NOMBRE_023 NOMBRE023,t1.APEL1_023 APEL1023,t1.APEL2_023 APEL2023,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_023 NUMDOC023,t1.ID_017_GENERO ID017GENERO,t1.TELF1_023 TELF1023,t1.TELF2_023 TELF2023,t1.EMAIL_023 EMAIL023,to_char(t1.F_NAC_023,"
						+ formato
						+ ") FNAC023,t1.NACIONALIDAD_023 NACIONALIDAD023,t1.LOCALIDAD_EMP_023 LOCALIDADEMP023,t1.PROV_EMP_023 PROVEMP023,t1.IDIOMA_COMUNIC_023 IDIOMACOMUNIC023,t1.PROVINCIA_COMUNIC_023 PROVINCIACOMUNIC023,t1.MUNICIP_COMUNIC_023 MUNICIPCOMUNIC023,t1.CALLE_COMUNIC_023 CALLECOMUNIC023,t1.NUMERO_COMUNIC_023 NUMEROCOMUNIC023, t1.BIS_COMUNIC_023 BISCOMUNIC023, t1.PISO_COMUNIC_023 PISOCOMUNIC023,t1.LETRA_COMUNIC_023 LETRACOMUNIC023,t1.CPOSTAL_COMUNIC_023 CPOSTALCOMUNIC023,t1.CONSENTIMIENTOS_023 CONSENTIMIENTOS023,t1.ID_026_MOTIVOS ID026MOTIVOS,to_char(t1.FEC_CAD_TARJETA_023,"
						+ formato
						+ ") FECCADTARJETA023,t1.SITUACION_COMPENSAR_023 SITUACIONCOMPENSAR023,t1.ID_027_ESTADOS_ESF ID027ESTADOSESF,to_char(t1.FECHA_NOTIF_TRAMITE_023,"
						+ formato
						+ ") FECHANOTIFTRAMITE023,t1.T_RESI_MANIFESTADO_023 TRESIMANIFESTADO023,t1.T_RESI_ACREDITADO_023 TRESIACREDITADO023,t1.TOTAL_DIAS_ACTIVO_023 TOTALDIASACTIVO023,t1.TOTAL_DIAS_BUSQUEDA_023 TOTALDIASBUSQUEDA023,t1.CONTRATO_023 CONTRATO023,t1.OFERTA_023 OFERTA023,t1.PRESTACION_023 PRESTACION023,t1.NOMBRE_REP_023 NOMBREREP023,t1.APEL1_REP_023 APEL1REP023,t1.APEL2_REP_023 APEL2REP023,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_023 NUMDOCREP023,t1.TELF1_REP_023 TELF1REP023,t1.TELF2_REP_023 TELF2REP023,t1.TIPO_NOTIFICACION_023 TIPONOTIFICACION023, "
						+ " CONTRATANTE_023 CONTRATANTE023,CONTRATODESC_023 CONTRATODESC023,to_char(FECHA_EMPADRON_023,"
						+ formato
						+ ") FECHAEMPADRON023,PROVINCIA_EMPADRON_023 PROVINCIAEMPADRON023,MUNICIPIO_EMPADRON_023 MUNICIPIOEMPADRON023, nvl(RESOL_FAVORABLE_023,9) RESOLFAVORABLE023 "
						+ " ,t1.DIRECCION_EMPADRON_023 DIRECCIONEMPADRON023,TO_CHAR(t1.FECHA_EMISIONPADRON_023,"
						+ formato
						+ ") FECHAEMISIONPADRON023, "
						+ " t1.SOLI_CERRADA_023 SOLICERRADA023, "
						+ " t1.NOTIF_LEIDA_023 NOTIFLEIDA023, t1.REQ_LEIDO_023 REQLEIDO023 ");
		query.append(" FROM AA83B23T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b23t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b23t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b23t00 table using like.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b23t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b23t00> findAllLike(Aa83b23t00 aa83b23t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		String formatoHora = Aa83BConstants.ES_PATTERN_HORA_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
			formatoHora = Aa83BConstants.EU_PATTERN_HORA_COMPLETA;
		}
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_023 ID023,t1.ID_ANO_023 IDANO023, t1.TELF_NOTIFICACION_023 TELFNOTIFICACION023, t1.NUM_REG_023 NUMREG023, TO_CHAR(t1.FEC_REG_023,"
						+ formatoHora
						+ ") FECHA023, t1.NOMBRE_023 NOMBRE023,t1.APEL1_023 APEL1023,t1.APEL2_023 APEL2023,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_023 NUMDOC023,t1.ID_017_GENERO ID017GENERO,t1.TELF1_023 TELF1023,t1.TELF2_023 TELF2023,t1.EMAIL_023 EMAIL023,to_char(t1.F_NAC_023,"
						+ formato
						+ ") FNAC023,t1.NACIONALIDAD_023 NACIONALIDAD023,t1.LOCALIDAD_EMP_023 LOCALIDADEMP023,t1.PROV_EMP_023 PROVEMP023,t1.IDIOMA_COMUNIC_023 IDIOMACOMUNIC023,t1.PROVINCIA_COMUNIC_023 PROVINCIACOMUNIC023,t1.MUNICIP_COMUNIC_023 MUNICIPCOMUNIC023,t1.CALLE_COMUNIC_023 CALLECOMUNIC023,t1.NUMERO_COMUNIC_023 NUMEROCOMUNIC023, t1.BIS_COMUNIC_023 BISCOMUNIC023, t1.PISO_COMUNIC_023 PISOCOMUNIC023,t1.LETRA_COMUNIC_023 LETRACOMUNIC023,t1.CPOSTAL_COMUNIC_023 CPOSTALCOMUNIC023,t1.CONSENTIMIENTOS_023 CONSENTIMIENTOS023,t1.ID_026_MOTIVOS ID026MOTIVOS,to_char(t1.FEC_CAD_TARJETA_023,"
						+ formato
						+ ") FECCADTARJETA023,t1.SITUACION_COMPENSAR_023 SITUACIONCOMPENSAR023,t1.ID_027_ESTADOS_ESF ID027ESTADOSESF,to_char(t1.FECHA_NOTIF_TRAMITE_023,"
						+ formato
						+ ") FECHANOTIFTRAMITE023,t1.T_RESI_MANIFESTADO_023 TRESIMANIFESTADO023,t1.T_RESI_ACREDITADO_023 TRESIACREDITADO023,t1.TOTAL_DIAS_ACTIVO_023 TOTALDIASACTIVO023,t1.TOTAL_DIAS_BUSQUEDA_023 TOTALDIASBUSQUEDA023,t1.CONTRATO_023 CONTRATO023,t1.OFERTA_023 OFERTA023,t1.PRESTACION_023 PRESTACION023,t1.NOMBRE_REP_023 NOMBREREP023,t1.APEL1_REP_023 APEL1REP023,t1.APEL2_REP_023 APEL2REP023,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_023 NUMDOCREP023,t1.TELF1_REP_023 TELF1REP023,t1.TELF2_REP_023 TELF2REP023,t1.TIPO_NOTIFICACION_023 TIPONOTIFICACION023, "
						+ " CONTRATANTE_023 CONTRATANTE023,CONTRATODESC_023 CONTRATODESC023,to_char(FECHA_EMPADRON_023,"
						+ formato
						+ ") FECHAEMPADRON023,PROVINCIA_EMPADRON_023 PROVINCIAEMPADRON023,MUNICIPIO_EMPADRON_023 MUNICIPIOEMPADRON023, nvl(RESOL_FAVORABLE_023,9) RESOLFAVORABLE023 "
						+ " ,t1.DIRECCION_EMPADRON_023 DIRECCIONEMPADRON023,TO_CHAR(t1.FECHA_EMISIONPADRON_023,"
						+ formato
						+ ") FECHAEMISIONPADRON023, "
						+ " t1.SOLI_CERRADA_023 SOLICERRADA023, "
						+ " t1.NOTIF_LEIDA_023 NOTIFLEIDA023, t1.REQ_LEIDO_023 REQLEIDO023 ");
		query.append(" FROM AA83B23T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b23t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY t1.ID_023 DESC ");
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		return (List<Aa83b23t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap3, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b23t00 table.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b23t00 aa83b23t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B23T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b23t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b23t00 table using like.
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b23t00 aa83b23t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B23T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b23t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b23t00 selected for rup_table
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b23t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b23t00>> reorderSelection(
			Aa83b23t00 aa83b23t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_023 ID023,t1.ID_ANO_023 IDANO023,t1.NOMBRE_023 NOMBRE023,t1.APEL1_023 APEL1023,t1.APEL2_023 APEL2023,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_023 NUMDOC023,t1.ID_017_GENERO ID017GENERO,t1.TELF1_023 TELF1023,t1.TELF2_023 TELF2023,t1.EMAIL_023 EMAIL023,to_char(t1.F_NAC_023,"
						+ formato
						+ ") FNAC023,t1.NACIONALIDAD_023 NACIONALIDAD023,t1.LOCALIDAD_EMP_023 LOCALIDADEMP023,t1.PROV_EMP_023 PROVEMP023,t1.IDIOMA_COMUNIC_023 IDIOMACOMUNIC023,t1.PROVINCIA_COMUNIC_023 PROVINCIACOMUNIC023,t1.MUNICIP_COMUNIC_023 MUNICIPCOMUNIC023,t1.CALLE_COMUNIC_023 CALLECOMUNIC023,t1.NUMERO_COMUNIC_023 NUMEROCOMUNIC023,t1.BIS_COMUNIC_023 BISCOMUNIC023,t1.PISO_COMUNIC_023 PISOCOMUNIC023,t1.LETRA_COMUNIC_023 LETRACOMUNIC023,t1.CPOSTAL_COMUNIC_023 CPOSTALCOMUNIC023,t1.CONSENTIMIENTOS_023 CONSENTIMIENTOS023,t1.ID_026_MOTIVOS ID026MOTIVOS,to_char(t1.FEC_CAD_TARJETA_023,"
						+ formato
						+ ") FECCADTARJETA023,t1.SITUACION_COMPENSAR_023 SITUACIONCOMPENSAR023,t1.ID_027_ESTADOS_ESF ID027ESTADOSESF,to_char(t1.FECHA_NOTIF_TRAMITE_023,"
						+ formato
						+ ") FECHANOTIFTRAMITE023,t1.T_RESI_MANIFESTADO_023 TRESIMANIFESTADO023,t1.T_RESI_ACREDITADO_023 TRESIACREDITADO023,t1.TOTAL_DIAS_ACTIVO_023 TOTALDIASACTIVO023,t1.TOTAL_DIAS_BUSQUEDA_023 TOTALDIASBUSQUEDA023,t1.CONTRATO_023 CONTRATO023,t1.OFERTA_023 OFERTA023,t1.PRESTACION_023 PRESTACION023,t1.NOMBRE_REP_023 NOMBREREP023,t1.APEL1_REP_023 APEL1REP023,t1.APEL2_REP_023 APEL2REP023,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_023 NUMDOCREP023,t1.TELF1_REP_023 TELF1REP023,t1.TELF2_REP_023 TELF2REP023,t1.TIPO_NOTIFICACION_023 TIPONOTIFICACION023, "
						+ " CONTRATANTE_023 CONTRATANTE023,CONTRATODESC_023 CONTRATODESC023,to_char(FECHA_EMPADRON_023,"
						+ formato
						+ ") FECHAEMPADRON023,PROVINCIA_EMPADRON_023 PROVINCIAEMPADRON023,MUNICIPIO_EMPADRON_023 MUNICIPIOEMPADRON023 "
						+ " ,t1.DIRECCION_EMPADRON_023 DIRECCIONEMPADRON023,TO_CHAR(t1.FECHA_EMISIONPADRON_023,"
						+ formato + ") FECHAEMISIONPADRON023");

		// FROM
		query.append(" FROM AA83B23T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b23t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b23t00.class, filterParamList,
				"ID_023,ID_ANO_023");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b23t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b23t00
	 * @param searchParams
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b23t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b23t00>> search(Aa83b23t00 filterParams,
			Aa83b23t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_023 ID023,t1.ID_ANO_023 IDANO023,t1.NOMBRE_023 NOMBRE023,t1.APEL1_023 APEL1023,t1.APEL2_023 APEL2023,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_023 NUMDOC023,t1.ID_017_GENERO ID017GENERO,t1.TELF1_023 TELF1023,t1.TELF2_023 TELF2023,t1.EMAIL_023 EMAIL023,to_char(t1.F_NAC_023,"
						+ formato
						+ ") FNAC023,t1.NACIONALIDAD_023 NACIONALIDAD023,t1.LOCALIDAD_EMP_023 LOCALIDADEMP023,t1.PROV_EMP_023 PROVEMP023,t1.IDIOMA_COMUNIC_023 IDIOMACOMUNIC023,t1.PROVINCIA_COMUNIC_023 PROVINCIACOMUNIC023,t1.MUNICIP_COMUNIC_023 MUNICIPCOMUNIC023,t1.CALLE_COMUNIC_023 CALLECOMUNIC023,t1.NUMERO_COMUNIC_023 NUMEROCOMUNIC023,t1.BIS_COMUNIC_023 BISCOMUNIC023,t1.PISO_COMUNIC_023 PISOCOMUNIC023,t1.LETRA_COMUNIC_023 LETRACOMUNIC023,t1.CPOSTAL_COMUNIC_023 CPOSTALCOMUNIC023,t1.CONSENTIMIENTOS_023 CONSENTIMIENTOS023,t1.ID_026_MOTIVOS ID026MOTIVOS,to_char(t1.FEC_CAD_TARJETA_023,"
						+ formato
						+ ") FECCADTARJETA023,t1.SITUACION_COMPENSAR_023 SITUACIONCOMPENSAR023,t1.ID_027_ESTADOS_ESF ID027ESTADOSESF,to_char(t1.FECHA_NOTIF_TRAMITE_023,"
						+ formato
						+ ") FECHANOTIFTRAMITE023,t1.T_RESI_MANIFESTADO_023 TRESIMANIFESTADO023,t1.T_RESI_ACREDITADO_023 TRESIACREDITADO023,t1.TOTAL_DIAS_ACTIVO_023 TOTALDIASACTIVO023,t1.TOTAL_DIAS_BUSQUEDA_023 TOTALDIASBUSQUEDA023,t1.CONTRATO_023 CONTRATO023,t1.OFERTA_023 OFERTA023,t1.PRESTACION_023 PRESTACION023,t1.NOMBRE_REP_023 NOMBREREP023,t1.APEL1_REP_023 APEL1REP023,t1.APEL2_REP_023 APEL2REP023,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_023 NUMDOCREP023,t1.TELF1_REP_023 TELF1REP023,t1.TELF2_REP_023 TELF2REP023,t1.TIPO_NOTIFICACION_023 TIPONOTIFICACION023, "
						+ " CONTRATANTE_023 CONTRATANTE023,CONTRATODESC_023 CONTRATODESC023,to_char(FECHA_EMPADRON_023,"
						+ formato
						+ ") FECHAEMPADRON023,PROVINCIA_EMPADRON_023 PROVINCIAEMPADRON023,MUNICIPIO_EMPADRON_023 MUNICIPIOEMPADRON023 "
						+ " ,t1.DIRECCION_EMPADRON_023 DIRECCIONEMPADRON023,TO_CHAR(t1.FECHA_EMISIONPADRON_023,"
						+ formato + ") FECHAEMISIONPADRON023");
		// FROM
		query.append(" FROM AA83B23T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b23t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_023,ID_ANO_023");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b23t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b23t00 filteraa83b23t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_023 ID023,t1.ID_ANO_023 IDANO023,t1.NOMBRE_023 NOMBRE023,t1.APEL1_023 APEL1023,t1.APEL2_023 APEL2023,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_023 NUMDOC023,t1.ID_017_GENERO ID017GENERO,t1.TELF1_023 TELF1023,t1.TELF2_023 TELF2023,t1.EMAIL_023 EMAIL023,to_char(t1.F_NAC_023,"
						+ formato
						+ ") FNAC023,t1.NACIONALIDAD_023 NACIONALIDAD023,t1.LOCALIDAD_EMP_023 LOCALIDADEMP023,t1.PROV_EMP_023 PROVEMP023,t1.IDIOMA_COMUNIC_023 IDIOMACOMUNIC023,t1.PROVINCIA_COMUNIC_023 PROVINCIACOMUNIC023,t1.MUNICIP_COMUNIC_023 MUNICIPCOMUNIC023,t1.CALLE_COMUNIC_023 CALLECOMUNIC023,t1.NUMERO_COMUNIC_023 NUMEROCOMUNIC023,t1.BIS_COMUNIC_023 BISCOMUNIC023,t1.PISO_COMUNIC_023 PISOCOMUNIC023,t1.LETRA_COMUNIC_023 LETRACOMUNIC023,t1.CPOSTAL_COMUNIC_023 CPOSTALCOMUNIC023,t1.CONSENTIMIENTOS_023 CONSENTIMIENTOS023,t1.ID_026_MOTIVOS ID026MOTIVOS,to_char(t1.FEC_CAD_TARJETA_023,"
						+ formato
						+ ") FECCADTARJETA023,t1.SITUACION_COMPENSAR_023 SITUACIONCOMPENSAR023,t1.ID_027_ESTADOS_ESF ID027ESTADOSESF,to_char(t1.FECHA_NOTIF_TRAMITE_023,"
						+ formato
						+ ") FECHANOTIFTRAMITE023,t1.T_RESI_MANIFESTADO_023 TRESIMANIFESTADO023,t1.T_RESI_ACREDITADO_023 TRESIACREDITADO023,t1.TOTAL_DIAS_ACTIVO_023 TOTALDIASACTIVO023,t1.TOTAL_DIAS_BUSQUEDA_023 TOTALDIASBUSQUEDA023,t1.CONTRATO_023 CONTRATO023,t1.OFERTA_023 OFERTA023,t1.PRESTACION_023 PRESTACION023,t1.NOMBRE_REP_023 NOMBREREP023,t1.APEL1_REP_023 APEL1REP023,t1.APEL2_REP_023 APEL2REP023,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_023 NUMDOCREP023,t1.TELF1_REP_023 TELF1REP023,t1.TELF2_REP_023 TELF2REP023,t1.TIPO_NOTIFICACION_023 TIPONOTIFICACION023, "
						+ " CONTRATANTE_023 CONTRATANTE023,CONTRATODESC_023 CONTRATODESC023,to_char(FECHA_EMPADRON_023,"
						+ formato
						+ ") FECHAEMPADRON023,PROVINCIA_EMPADRON_023 PROVINCIAEMPADRON023,MUNICIPIO_EMPADRON_023 MUNICIPIOEMPADRON023 "
						+ " ,t1.DIRECCION_EMPADRON_023 DIRECCIONEMPADRON023,TO_CHAR(t1.FECHA_EMISIONPADRON_023,"
						+ formato + ") FECHAEMISIONPADRON023");
		// FROM
		query.append(" FROM AA83B23T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b23t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b23t00.class,
						query, params, "ID_023,ID_ANO_023");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b23t00 table.
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b23t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b23t00>> findAllLikeJerarquia(
			Aa83b23t00 filterAa83b23t00, JQGridRequestDto jqGridRequestDto) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_023 ID023,t1.ID_ANO_023 IDANO023,    t1.TELF_NOTIFICACION_023 TELFNOTIFICACION023, t1.NOMBRE_023 NOMBRE023,t1.APEL1_023 APEL1023,t1.APEL2_023 APEL2023,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_023 NUMDOC023,t1.ID_017_GENERO ID017GENERO,t1.TELF1_023 TELF1023,t1.TELF2_023 TELF2023,t1.EMAIL_023 EMAIL023,to_char(t1.F_NAC_023,"
						+ formato
						+ ") FNAC023,t1.NACIONALIDAD_023 NACIONALIDAD023,t1.LOCALIDAD_EMP_023 LOCALIDADEMP023,t1.PROV_EMP_023 PROVEMP023,t1.IDIOMA_COMUNIC_023 IDIOMACOMUNIC023,t1.PROVINCIA_COMUNIC_023 PROVINCIACOMUNIC023,t1.MUNICIP_COMUNIC_023 MUNICIPCOMUNIC023,t1.CALLE_COMUNIC_023 CALLECOMUNIC023,t1.NUMERO_COMUNIC_023 NUMEROCOMUNIC023,t1.BIS_COMUNIC_023 BISCOMUNIC023,t1.PISO_COMUNIC_023 PISOCOMUNIC023,t1.LETRA_COMUNIC_023 LETRACOMUNIC023,t1.CPOSTAL_COMUNIC_023 CPOSTALCOMUNIC023,t1.CONSENTIMIENTOS_023 CONSENTIMIENTOS023,t1.ID_026_MOTIVOS ID026MOTIVOS,to_char(t1.FEC_CAD_TARJETA_023,"
						+ formato
						+ ") FECCADTARJETA023,t1.SITUACION_COMPENSAR_023 SITUACIONCOMPENSAR023,t1.ID_027_ESTADOS_ESF ID027ESTADOSESF,to_char(t1.FECHA_NOTIF_TRAMITE_023,"
						+ formato
						+ ") FECHANOTIFTRAMITE023,t1.T_RESI_MANIFESTADO_023 TRESIMANIFESTADO023,t1.T_RESI_ACREDITADO_023 TRESIACREDITADO023,t1.TOTAL_DIAS_ACTIVO_023 TOTALDIASACTIVO023,t1.TOTAL_DIAS_BUSQUEDA_023 TOTALDIASBUSQUEDA023,t1.CONTRATO_023 CONTRATO023,t1.OFERTA_023 OFERTA023,t1.PRESTACION_023 PRESTACION023,t1.NOMBRE_REP_023 NOMBREREP023,t1.APEL1_REP_023 APEL1REP023,t1.APEL2_REP_023 APEL2REP023,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_023 NUMDOCREP023,t1.TELF1_REP_023 TELF1REP023,t1.TELF2_REP_023 TELF2REP023,t1.TIPO_NOTIFICACION_023 TIPONOTIFICACION023, "
						+ " CONTRATANTE_023 CONTRATANTE023,CONTRATODESC_023 CONTRATODESC023,to_char(FECHA_EMPADRON_023,"
						+ formato
						+ ") FECHAEMPADRON023,PROVINCIA_EMPADRON_023 PROVINCIAEMPADRON023,MUNICIPIO_EMPADRON_023 MUNICIPIOEMPADRON023 "
						+ " ,t1.DIRECCION_EMPADRON_023 DIRECCIONEMPADRON023,TO_CHAR(t1.FECHA_EMISIONPADRON_023,"
						+ formato + ") FECHAEMISIONPADRON023, t1.REQ_LEIDO_023 REQLEIDO023");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B23T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B23T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b23t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_023,ID_ANO_023", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b23t00 filterAa83b23t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B23T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B23T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b23t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_023,ID_ANO_023", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b23t00
	 *            Aa83b23t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b23t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b23t00>> findAllChild(
			Aa83b23t00 filterAa83b23t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B23T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B23T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b23t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_023,ID_ANO_023", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa83b23t00>(this.rwMapPK,
						"ID_023,ID_ANO_023"), params.toArray());
	}

	public Aa83b23t00 validarSolicitud(Aa83b23t00 aa83b23t00) {
		StringBuffer sql = new StringBuffer();
		sql.append("SELECT SOL.ID_023 ID023,SOL.ID_ANO_023 IDANO023,SOL.NOMBRE_023 NOMBRE023 FROM AA83B23T00 SOL INNER JOIN AA83B10T00 TRAM");
		sql.append(" ON SOL.ID_023=TRAM.ID_023_NUM_SOL AND SOL.ID_ANO_023=TRAM.ID_ANO_023");
		sql.append(" WHERE TRAM.ID_001_FASE='1' AND TRAM.ID_002_TRAM='3'");
		sql.append(" AND SOL.ID_023=? AND SOL.ID_ANO_023=?");
		ArrayList<String> params = new ArrayList<String>();
		params.add(String.valueOf(aa83b23t00.getId023()));
		params.add(String.valueOf(aa83b23t00.getIdAno023()));
		List<Aa83b23t00> lista = (List<Aa83b23t00>) this.jdbcTemplate.query(
				sql.toString(), this.rwMap4, params.toArray());
		if (!lista.isEmpty()) {
			aa83b23t00 = lista.get(0);
		}
		return aa83b23t00;
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b23t00 entity
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b23t00 aa83b23t00) {

		StringBuilder where = new StringBuilder(
				Aa83b23t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b23t00 != null && aa83b23t00.getId023() != null) {
			where.append(" AND t1.ID_023 = ?");
			params.add(aa83b23t00.getId023());
		}
		if (aa83b23t00 != null && aa83b23t00.getIdAno023() != null) {
			where.append(" AND t1.ID_ANO_023 = ?");
			params.add(aa83b23t00.getIdAno023());
		}
		if (aa83b23t00 != null && aa83b23t00.getNombre023() != null) {
			where.append(" AND t1.NOMBRE_023 = ?");
			params.add(aa83b23t00.getNombre023());
		}
		if (aa83b23t00 != null && aa83b23t00.getApel1023() != null) {
			where.append(" AND t1.APEL1_023 = ?");
			params.add(aa83b23t00.getApel1023());
		}
		if (aa83b23t00 != null && aa83b23t00.getApel2023() != null) {
			where.append(" AND t1.APEL2_023 = ?");
			params.add(aa83b23t00.getApel2023());
		}
		if (aa83b23t00 != null && aa83b23t00.getNumReg023() != null) {
			where.append(" AND t1.NUM_REG_023 = ?");
			params.add(aa83b23t00.getNumReg023());
		}
		if (aa83b23t00 != null && aa83b23t00.getId012TipoDoc() != null) {
			where.append(" AND t1.ID_012_TIPO_DOC = ?");
			params.add(aa83b23t00.getId012TipoDoc());
		}
		if (aa83b23t00 != null && aa83b23t00.getNumDoc023() != null) {
			where.append(" AND t1.NUM_DOC_023 = ?");
			params.add(aa83b23t00.getNumDoc023());
		}
		if (aa83b23t00 != null && aa83b23t00.getId017Genero() != null) {
			where.append(" AND t1.ID_017_GENERO = ?");
			params.add(aa83b23t00.getId017Genero());
		}
		if (aa83b23t00 != null && aa83b23t00.getTelf1023() != null) {
			where.append(" AND t1.TELF1_023 = ?");
			params.add(aa83b23t00.getTelf1023());
		}
		if (aa83b23t00 != null && aa83b23t00.getTelf2023() != null) {
			where.append(" AND t1.TELF2_023 = ?");
			params.add(aa83b23t00.getTelf2023());
		}
		if (aa83b23t00 != null && aa83b23t00.getEmail023() != null) {
			where.append(" AND t1.EMAIL_023 = ?");
			params.add(aa83b23t00.getEmail023());
		}
		if (aa83b23t00 != null && aa83b23t00.getFNac023() != null) {
			where.append(" AND t1.F_NAC_023 = ?");
			params.add(aa83b23t00.getFNac023());
		}
		if (aa83b23t00 != null && aa83b23t00.getNacionalidad023() != null) {
			where.append(" AND t1.NACIONALIDAD_023 = ?");
			params.add(aa83b23t00.getNacionalidad023());
		}
		if (aa83b23t00 != null && aa83b23t00.getLocalidadEmp023() != null) {
			where.append(" AND t1.LOCALIDAD_EMP_023 = ?");
			params.add(aa83b23t00.getLocalidadEmp023());
		}
		if (aa83b23t00 != null && aa83b23t00.getProvEmp023() != null) {
			where.append(" AND t1.PROV_EMP_023 = ?");
			params.add(aa83b23t00.getProvEmp023());
		}
		if (aa83b23t00 != null && aa83b23t00.getIdiomaComunic023() != null) {
			where.append(" AND t1.IDIOMA_COMUNIC_023 = ?");
			params.add(aa83b23t00.getIdiomaComunic023());
		}
		if (aa83b23t00 != null && aa83b23t00.getProvinciaComunic023() != null) {
			where.append(" AND t1.PROVINCIA_COMUNIC_023 = ?");
			params.add(aa83b23t00.getProvinciaComunic023());
		}
		if (aa83b23t00 != null && aa83b23t00.getMunicipComunic023() != null) {
			where.append(" AND t1.MUNICIP_COMUNIC_023 = ?");
			params.add(aa83b23t00.getMunicipComunic023());
		}
		if (aa83b23t00 != null && aa83b23t00.getCalleComunic023() != null) {
			where.append(" AND t1.CALLE_COMUNIC_023 = ?");
			params.add(aa83b23t00.getCalleComunic023());
		}
		if (aa83b23t00 != null && aa83b23t00.getNumeroComunic023() != null) {
			where.append(" AND t1.NUMERO_COMUNIC_023 = ?");
			params.add(aa83b23t00.getNumeroComunic023());
		}
		if (aa83b23t00 != null && aa83b23t00.getPisoComunic023() != null) {
			where.append(" AND t1.PISO_COMUNIC_023 = ?");
			params.add(aa83b23t00.getPisoComunic023());
		}
		if (aa83b23t00 != null && aa83b23t00.getLetraComunic023() != null) {
			where.append(" AND t1.LETRA_COMUNIC_023 = ?");
			params.add(aa83b23t00.getLetraComunic023());
		}
		if (aa83b23t00 != null && aa83b23t00.getCpostalComunic023() != null) {
			where.append(" AND t1.CPOSTAL_COMUNIC_023 = ?");
			params.add(aa83b23t00.getCpostalComunic023());
		}
		if (aa83b23t00 != null && aa83b23t00.getConsentimientos023() != null) {
			where.append(" AND t1.CONSENTIMIENTOS_023 = ?");
			params.add(aa83b23t00.getConsentimientos023());
		}
		if (aa83b23t00 != null && aa83b23t00.getId026Motivos() != null) {
			where.append(" AND t1.ID_026_MOTIVOS = ?");
			params.add(aa83b23t00.getId026Motivos());
		}
		if (aa83b23t00 != null && aa83b23t00.getFecCadTarjeta023() != null) {
			where.append(" AND t1.FEC_CAD_TARJETA_023 = ?");
			params.add(aa83b23t00.getFecCadTarjeta023());
		}
		if (aa83b23t00 != null && aa83b23t00.getSituacionCompensar023() != null) {
			where.append(" AND t1.SITUACION_COMPENSAR_023 = ?");
			params.add(aa83b23t00.getSituacionCompensar023());
		}
		if (aa83b23t00 != null && aa83b23t00.getId027EstadosEsf() != null) {
			where.append(" AND t1.ID_027_ESTADOS_ESF = ?");
			params.add(aa83b23t00.getId027EstadosEsf());
		}
		if (aa83b23t00 != null && aa83b23t00.getFechaNotifTramite023() != null) {
			where.append(" AND t1.FECHA_NOTIF_TRAMITE_023 = ?");
			params.add(aa83b23t00.getFechaNotifTramite023());
		}
		if (aa83b23t00 != null && aa83b23t00.getTResiManifestado023() != null) {
			where.append(" AND t1.T_RESI_MANIFESTADO_023 = ?");
			params.add(aa83b23t00.getTResiManifestado023());
		}
		if (aa83b23t00 != null && aa83b23t00.getTResiAcreditado023() != null) {
			where.append(" AND t1.T_RESI_ACREDITADO_023 = ?");
			params.add(aa83b23t00.getTResiAcreditado023());
		}
		if (aa83b23t00 != null && aa83b23t00.getTotalDiasActivo023() != null) {
			where.append(" AND t1.TOTAL_DIAS_ACTIVO_023 = ?");
			params.add(aa83b23t00.getTotalDiasActivo023());
		}
		if (aa83b23t00 != null && aa83b23t00.getTotalDiasBusqueda023() != null) {
			where.append(" AND t1.TOTAL_DIAS_BUSQUEDA_023 = ?");
			params.add(aa83b23t00.getTotalDiasBusqueda023());
		}
		if (aa83b23t00 != null && aa83b23t00.getContrato023() != null) {
			where.append(" AND t1.CONTRATO_023 = ?");
			params.add(aa83b23t00.getContrato023());
		}
		if (aa83b23t00 != null && aa83b23t00.getOferta023() != null) {
			where.append(" AND t1.OFERTA_023 = ?");
			params.add(aa83b23t00.getOferta023());
		}
		if (aa83b23t00 != null && aa83b23t00.getPrestacion023() != null) {
			where.append(" AND t1.PRESTACION_023 = ?");
			params.add(aa83b23t00.getPrestacion023());
		}
		if (aa83b23t00 != null && aa83b23t00.getNombreRep023() != null) {
			where.append(" AND t1.NOMBRE_REP_023 = ?");
			params.add(aa83b23t00.getNombreRep023());
		}
		if (aa83b23t00 != null && aa83b23t00.getApel1Rep023() != null) {
			where.append(" AND t1.APEL1_REP_023 = ?");
			params.add(aa83b23t00.getApel1Rep023());
		}
		if (aa83b23t00 != null && aa83b23t00.getApel2Rep023() != null) {
			where.append(" AND t1.APEL2_REP_023 = ?");
			params.add(aa83b23t00.getApel2Rep023());
		}
		if (aa83b23t00 != null && aa83b23t00.getId012Rep() != null) {
			where.append(" AND t1.ID_012_REP = ?");
			params.add(aa83b23t00.getId012Rep());
		}
		if (aa83b23t00 != null && aa83b23t00.getNumDocRep023() != null) {
			where.append(" AND t1.NUM_DOC_REP_023 = ?");
			params.add(aa83b23t00.getNumDocRep023());
		}
		if (aa83b23t00 != null && aa83b23t00.getTelf1Rep023() != null) {
			where.append(" AND t1.TELF1_REP_023 = ?");
			params.add(aa83b23t00.getTelf1Rep023());
		}
		if (aa83b23t00 != null && aa83b23t00.getTelf2Rep023() != null) {
			where.append(" AND t1.TELF2_REP_023 = ?");
			params.add(aa83b23t00.getTelf2Rep023());
		}
		if (aa83b23t00 != null && aa83b23t00.getTipoNotificacion023() != null) {
			where.append(" AND t1.TIPO_NOTIFICACION_023 = ?");
			params.add(aa83b23t00.getTipoNotificacion023());
		}
		if (aa83b23t00 != null && aa83b23t00.getSolicerrada023() != null) {
			where.append(" AND t1.SOLI_CERRADA_023 = ?");
			params.add(aa83b23t00.getSolicerrada023());
		}
		if (aa83b23t00 != null && aa83b23t00.getNotifLeida023() != null) {
			where.append(" AND t1.NOTIF_LEIDA_023 = ?");
			params.add(aa83b23t00.getNotifLeida023());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b23t00 entity
	 * 
	 * @param aa83b23t00
	 *            Aa83b23t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b23t00 aa83b23t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b23t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b23t00 != null) {
			if (aa83b23t00.getId023() != null) {
				where.append(" AND t1.ID_023 = ?");
				params.add(aa83b23t00.getId023());
			}
			if (aa83b23t00 != null && aa83b23t00.getIdAno023() != null) {
				where.append(" AND t1.ID_ANO_023 = ?");
				params.add(aa83b23t00.getIdAno023());
			}
			if (aa83b23t00.getNombre023() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.NOMBRE_023,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b23t00
							.getNombre023().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b23t00
									.getNombre023().toUpperCase()) + "%");
				}
				where.append(" AND t1.NOMBRE_023 IS NOT NULL");
			}
			if (aa83b23t00.getApel1023() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.APEL1_023,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b23t00
							.getApel1023().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b23t00
									.getApel1023().toUpperCase()) + "%");
				}
				where.append(" AND t1.APEL1_023 IS NOT NULL");
			}
			if (aa83b23t00.getApel2023() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.APEL2_023,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b23t00
							.getApel2023().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b23t00
									.getApel2023().toUpperCase()) + "%");
				}
				where.append(" AND t1.APEL2_023 IS NOT NULL");
			}
			if (aa83b23t00.getNumReg023() != null) {
				where.append(" AND UPPER(t1.NUM_REG_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getNumReg023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getNumReg023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUM_REG_023 IS NOT NULL");
			}
			if (aa83b23t00.getId012TipoDoc() != null) {
				where.append(" AND t1.ID_012_TIPO_DOC = ?");
				params.add(aa83b23t00.getId012TipoDoc());
			}
			if (aa83b23t00.getNumDoc023() != null) {
				where.append(" AND UPPER(t1.NUM_DOC_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getNumDoc023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getNumDoc023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUM_DOC_023 IS NOT NULL");
			}
			if (aa83b23t00.getId017Genero() != null) {
				where.append(" AND t1.ID_017_GENERO = ?");
				params.add(aa83b23t00.getId017Genero());
			}
			if (aa83b23t00.getTelf1023() != null) {
				where.append(" AND UPPER(t1.TELF1_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getTelf1023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getTelf1023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF1_023 IS NOT NULL");
			}
			if (aa83b23t00.getTelf2023() != null) {
				where.append(" AND UPPER(t1.TELF2_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getTelf2023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getTelf2023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF2_023 IS NOT NULL");
			}
			if (aa83b23t00.getEmail023() != null) {
				where.append(" AND UPPER(t1.EMAIL_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getEmail023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getEmail023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.EMAIL_023 IS NOT NULL");
			}
			if (aa83b23t00.getFNac023() != null) {
				where.append(" AND t1.F_NAC_023 = ?");
				params.add(aa83b23t00.getFNac023());
			}
			if (aa83b23t00.getNacionalidad023() != null) {
				where.append(" AND t1.NACIONALIDAD_023 = ?");
				params.add(aa83b23t00.getNacionalidad023());
			}
			if (aa83b23t00.getLocalidadEmp023() != null) {
				where.append(" AND t1.LOCALIDAD_EMP_023 = ?");
				params.add(aa83b23t00.getLocalidadEmp023());
			}
			if (aa83b23t00.getProvEmp023() != null) {
				where.append(" AND t1.PROV_EMP_023 = ?");
				params.add(aa83b23t00.getProvEmp023());
			}
			if (aa83b23t00.getIdiomaComunic023() != null) {
				where.append(" AND t1.IDIOMA_COMUNIC_023 = ?");
				params.add(aa83b23t00.getIdiomaComunic023());
			}
			if (aa83b23t00.getProvinciaComunic023() != null) {
				where.append(" AND t1.PROVINCIA_COMUNIC_023 = ?");
				params.add(aa83b23t00.getProvinciaComunic023());
			}
			if (aa83b23t00.getMunicipComunic023() != null) {
				where.append(" AND t1.MUNICIP_COMUNIC_023 = ?");
				params.add(aa83b23t00.getMunicipComunic023());
			}
			if (aa83b23t00.getCalleComunic023() != null) {
				where.append(" AND UPPER(t1.CALLE_COMUNIC_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getCalleComunic023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getCalleComunic023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CALLE_COMUNIC_023 IS NOT NULL");
			}
			if (aa83b23t00.getNumeroComunic023() != null) {
				where.append(" AND UPPER(t1.NUMERO_COMUNIC_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getNumeroComunic023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getNumeroComunic023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUMERO_COMUNIC_023 IS NOT NULL");
			}
			if (aa83b23t00.getPisoComunic023() != null) {
				where.append(" AND UPPER(t1.PISO_COMUNIC_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getPisoComunic023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getPisoComunic023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.PISO_COMUNIC_023 IS NOT NULL");
			}
			if (aa83b23t00.getLetraComunic023() != null) {
				where.append(" AND UPPER(t1.LETRA_COMUNIC_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getLetraComunic023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getLetraComunic023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.LETRA_COMUNIC_023 IS NOT NULL");
			}
			if (aa83b23t00.getCpostalComunic023() != null) {
				where.append(" AND t1.CPOSTAL_COMUNIC_023 = ?");
				params.add(aa83b23t00.getCpostalComunic023());
			}
			if (aa83b23t00.getConsentimientos023() != null) {
				where.append(" AND UPPER(t1.CONSENTIMIENTOS_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getConsentimientos023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getConsentimientos023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CONSENTIMIENTOS_023 IS NOT NULL");
			}
			if (aa83b23t00.getId026Motivos() != null) {
				where.append(" AND t1.ID_026_MOTIVOS = ?");
				params.add(aa83b23t00.getId026Motivos());
			}
			if (aa83b23t00.getFecCadTarjeta023() != null) {
				where.append(" AND t1.FEC_CAD_TARJETA_023 = ?");
				params.add(aa83b23t00.getFecCadTarjeta023());
			}
			if (aa83b23t00.getSituacionCompensar023() != null) {
				where.append(" AND UPPER(t1.SITUACION_COMPENSAR_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getSituacionCompensar023()
							.toUpperCase() + "%");
				} else {
					params.add("%"
							+ aa83b23t00.getSituacionCompensar023()
									.toUpperCase() + "%");
				}
				where.append(" AND t1.SITUACION_COMPENSAR_023 IS NOT NULL");
			}
			if (aa83b23t00.getId027EstadosEsf() != null) {
				where.append(" AND t1.ID_027_ESTADOS_ESF = ?");
				params.add(aa83b23t00.getId027EstadosEsf());
			}
			if (aa83b23t00.getFechaNotifTramite023() != null) {
				where.append(" AND t1.FECHA_NOTIF_TRAMITE_023 = ?");
				params.add(aa83b23t00.getFechaNotifTramite023());
			}
			if (aa83b23t00.getTResiManifestado023() != null) {
				where.append(" AND UPPER(t1.T_RESI_MANIFESTADO_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getTResiManifestado023()
							.toUpperCase() + "%");
				} else {
					params.add("%"
							+ aa83b23t00.getTResiManifestado023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.T_RESI_MANIFESTADO_023 IS NOT NULL");
			}
			if (aa83b23t00.getTResiAcreditado023() != null) {
				where.append(" AND UPPER(t1.T_RESI_ACREDITADO_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getTResiAcreditado023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getTResiAcreditado023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.T_RESI_ACREDITADO_023 IS NOT NULL");
			}
			if (aa83b23t00.getTotalDiasActivo023() != null) {
				where.append(" AND t1.TOTAL_DIAS_ACTIVO_023 = ?");
				params.add(aa83b23t00.getTotalDiasActivo023());
			}
			if (aa83b23t00.getTotalDiasBusqueda023() != null) {
				where.append(" AND t1.TOTAL_DIAS_BUSQUEDA_023 = ?");
				params.add(aa83b23t00.getTotalDiasBusqueda023());
			}
			if (aa83b23t00.getContrato023() != null) {
				where.append(" AND UPPER(t1.CONTRATO_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getContrato023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getContrato023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CONTRATO_023 IS NOT NULL");
			}
			if (aa83b23t00.getOferta023() != null) {
				where.append(" AND UPPER(t1.OFERTA_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getOferta023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getOferta023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.OFERTA_023 IS NOT NULL");
			}
			if (aa83b23t00.getPrestacion023() != null) {
				where.append(" AND UPPER(t1.PRESTACION_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getPrestacion023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getPrestacion023().toUpperCase() + "%");
				}
				where.append(" AND t1.PRESTACION_023 IS NOT NULL");
			}
			if (aa83b23t00.getNombreRep023() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.NOMBRE_REP_023,'����������������������������������������������','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b23t00
							.getNombreRep023().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b23t00
									.getNombreRep023().toUpperCase()) + "%");
				}
				where.append(" AND t1.NOMBRE_REP_023 IS NOT NULL");
			}
			if (aa83b23t00.getApel1Rep023() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.APEL1_REP_023,'����������������������������������������������','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b23t00
							.getApel1Rep023().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b23t00
									.getApel1Rep023().toUpperCase()) + "%");
				}
				where.append(" AND t1.APEL1_REP_023 IS NOT NULL");
			}
			if (aa83b23t00.getApel2Rep023() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.APEL2_REP_023,'����������������������������������������������','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b23t00
							.getApel2Rep023().toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b23t00
									.getApel2Rep023().toUpperCase()) + "%");
				}
				where.append(" AND t1.APEL2_REP_023 IS NOT NULL");
			}
			if (aa83b23t00.getId012Rep() != null) {
				where.append(" AND t1.ID_012_REP = ?");
				params.add(aa83b23t00.getId012Rep());
			}
			if (aa83b23t00.getNumDocRep023() != null) {
				where.append(" AND UPPER(t1.NUM_DOC_REP_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getNumDocRep023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getNumDocRep023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUM_DOC_REP_023 IS NOT NULL");
			}
			if (aa83b23t00.getTelf1Rep023() != null) {
				where.append(" AND UPPER(t1.TELF1_REP_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getTelf1Rep023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getTelf1Rep023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF1_REP_023 IS NOT NULL");
			}
			if (aa83b23t00.getTelf2Rep023() != null) {
				where.append(" AND UPPER(t1.TELF2_REP_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getTelf2Rep023().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b23t00.getTelf2Rep023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF2_REP_023 IS NOT NULL");
			}
			if (aa83b23t00.getTipoNotificacion023() != null) {
				where.append(" AND UPPER(t1.TIPO_NOTIFICACION_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getTipoNotificacion023()
							.toUpperCase() + "%");
				} else {
					params.add("%"
							+ aa83b23t00.getTipoNotificacion023().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TIPO_NOTIFICACION_023 IS NOT NULL");
			}

			// Si el campo soli_cerrada_023 = 'N' o Nulo significa que esta
			// abierta la solicitud
			if ("N".equalsIgnoreCase(aa83b23t00.getSolicerrada023())) {
				// where.append(" AND UPPER(t1.SOLI_CERRADA_023) like ? ESCAPE  '\\'");
				where.append(" AND UPPER(nvl(t1.SOLI_CERRADA_023,'N')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getSolicerrada023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getSolicerrada023().toUpperCase()
							+ "%");
				}
				// where.append(" AND t1.SOLI_CERRADA_023 IS NOT NULL");
			}
			if (aa83b23t00.getNotifLeida023() != null) {
				where.append(" AND UPPER(t1.NOTIF_LEIDA_023) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b23t00.getNotifLeida023().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b23t00.getNotifLeida023().toUpperCase() + "%");
				}
				where.append(" AND t1.NOTIF_LEIDA_023 IS NOT NULL");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Aa83b23t00 marcarNotifLeida(Aa83b23t00 aa83b23t00) {
		// TODO Auto-generated method stub

		String query = "UPDATE AA83B23T00 SET NOTIF_LEIDA_023 = ? "
				+ "WHERE ID_ANO_023=? AND ID_023=? ";

		this.jdbcTemplate.update(query, "S", aa83b23t00.getIdAno023(),
				aa83b23t00.getId023());
		return aa83b23t00;
	}
	
	@Override
	public Aa83b23t00 marcarReqSubsanaLeido023(Aa83b23t00 aa83b23t00) {
		// TODO Auto-generated method stub

		String query = "UPDATE AA83B23T00 SET REQ_LEIDO_023 = ? "
				+ "WHERE ID_ANO_023=? AND ID_023=? ";
		this.jdbcTemplate.update(query, "S", aa83b23t00.getIdAno023(),
				aa83b23t00.getId023());
		return aa83b23t00;
	}

	@Override
	public Aa83b23t00 cerrarExp(Aa83b23t00 aa83b23t00) {
		// TODO Auto-generated method stub
		String query = "UPDATE AA83B23T00 SET NOTIF_LEIDA_023 = ?, SOLI_CERRADA_023 = ? "
				+ "WHERE ID_ANO_023=? AND ID_023=? ";

		this.jdbcTemplate.update(query, "S", "S", aa83b23t00.getIdAno023(),
				aa83b23t00.getId023());
		return aa83b23t00;
	}

	@Override
	public Aa83b23t00 cerrarExpReq(Aa83b23t00 solicitudESF) {
		// TODO Auto-generated method stub
		String query = "UPDATE AA83B23T00 SET NOTIF_LEIDA_023 = ?, SOLI_CERRADA_023 = ?, RESOL_FAVORABLE_023=0 "
				+ " WHERE ID_ANO_023=? AND ID_023=? ";

		this.jdbcTemplate.update(query, "S", "S", solicitudESF.getIdAno023(),
				solicitudESF.getId023());
		return solicitudESF;
	}
}
