package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b22t00;

/**
 * Aa83b22t00DaoImpl generated by UDA, 15-feb-2016 13:30:59.
 * @author UDA
 */
 

@Repository
@Transactional
public class Aa83b22t00DaoImpl implements Aa83b22t00Dao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b22t00> rwMap = new RowMapper<Aa83b22t00>() {
		public Aa83b22t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Aa83b22t00(
               resultSet.getInt("ID022"), resultSet.getInt("ID023SOLESF"), resultSet.getLong("IDANO023"), resultSet.getInt("ID004TIPODOCG"), resultSet.getInt("ID010HISTOTRAM"), resultSet.getString("IDPIF022"), resultSet.getString("OID022")
           ); } } ;
           
	private RowMapper<Aa83b22t00> rwMapPK = new RowMapper<Aa83b22t00>() {
		public Aa83b22t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa83b22t00(
				resultSet.getInt("ID022")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
     * @param dataSource DataSource
     * @return
     */
	private RowMapper<JerarquiaDto< Aa83b22t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b22t00>>() {
		public JerarquiaDto<Aa83b22t00> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Aa83b22t00 aa83b22t00 = new Aa83b22t00(resultSet.getInt("ID022"), resultSet.getInt("ID023SOLESF"), resultSet.getLong("IDANO023"), resultSet.getInt("ID004TIPODOCG"), resultSet.getInt("ID010HISTOTRAM"), resultSet.getString("IDPIF022"), resultSet.getString("OID022"));

			JerarquiaDto<Aa83b22t00> jerarquia = new JerarquiaDto<Aa83b22t00>();
			jerarquia.setModel(aa83b22t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
     * Inserts a single row in the Aa83b22t00 table.
     *
     * @param aa83b22t00 Aa83b22t00
     * @return Aa83b22t00
     */
	public Aa83b22t00 add(Aa83b22t00 aa83b22t00) {
		final int nextId = jdbcTemplate
		.queryForInt("SELECT SEQ_AA83B22T00_ID_022.NEXTVAL FROM DUAL");
		aa83b22t00.setId022(nextId);
		
    	String query = "INSERT INTO AA83B22T00 (ID_022, ID_023_SOL_ESF, ID_ANO_023, ID_004_TIPO_DOC_G, ID_010_HISTO_TRAM, ID_PIF_022, OID_022) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b22t00.getId022(), aa83b22t00.getId023SolEsf(), aa83b22t00.getIdAno023(), aa83b22t00.getId004TipoDocG(), aa83b22t00.getId010HistoTram(), aa83b22t00.getIdPif022(), aa83b22t00.getOid022());
		return aa83b22t00;
	}

    /**
     * Updates a single row in the Aa83b22t00 table.
     *
     * @param aa83b22t00 Aa83b22t00
     * @return Aa83b22t00
     */
    public Aa83b22t00 update(Aa83b22t00 aa83b22t00) {
		String query = "UPDATE AA83B22T00 SET ID_023_SOL_ESF=?, ID_ANO_023=?, ID_004_TIPO_DOC_G=?, ID_010_HISTO_TRAM=?, ID_PIF_022=?, OID_022=? WHERE ID_022=?";
		this.jdbcTemplate.update(query, aa83b22t00.getId023SolEsf(), aa83b22t00.getIdAno023(), aa83b22t00.getId004TipoDocG(), aa83b22t00.getId010HistoTram(), aa83b22t00.getIdPif022(), aa83b22t00.getOid022(), aa83b22t00.getId022());
		return aa83b22t00;
	}

    /**
     * Finds a single row in the Aa83b22t00 table.
     *
     * @param aa83b22t00 Aa83b22t00
     * @return Aa83b22t00
     */
    @Transactional (readOnly = true)
    public Aa83b22t00 find(Aa83b22t00 aa83b22t00) {
		String query = "SELECT t1.ID_022 ID022, t1.ID_023_SOL_ESF ID023SOLESF, t1.ID_ANO_023 IDANO023, t1.ID_004_TIPO_DOC_G ID004TIPODOCG, t1.ID_010_HISTO_TRAM ID010HISTOTRAM, t1.ID_PIF_022 IDPIF022, t1.OID_022 OID022 FROM AA83B22T00 t1  WHERE t1.ID_022 = ?  ";
		
		List<Aa83b22t00> aa83b22t00List = this.jdbcTemplate.query(query, this.rwMap, aa83b22t00.getId022());
		return (Aa83b22t00) DataAccessUtils.uniqueResult(aa83b22t00List);
    }

    /**
     * Removes a single row in the Aa83b22t00 table.
     *
     * @param aa83b22t00 Aa83b22t00
     * @return
     */
    public void remove(Aa83b22t00 aa83b22t00) {
		String query = "DELETE FROM AA83B22T00 WHERE ID_022=?";
		this.jdbcTemplate.update(query, aa83b22t00.getId022());
    }
    
   /**
    * Finds a list of rows in the Aa83b22t00 table.
    * 
    * @param aa83b22t00 Aa83b22t00
    * @param jqGridRequestDto JQGridRequestDto
    * @return List<Aa83b22t00> 
    */
	@Transactional (readOnly = true)
    public List<Aa83b22t00> findAll(Aa83b22t00 aa83b22t00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_022 ID022,t1.ID_023_SOL_ESF ID023SOLESF,t1.ID_ANO_023 IDANO023,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_010_HISTO_TRAM ID010HISTOTRAM,t1.ID_PIF_022 IDPIF022,t1.OID_022 OID022 "); 
		query.append("FROM AA83B22T00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b22t00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b22t00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the Aa83b22t00 table using like.
     * 
     * @param aa83b22t00 Aa83b22t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<Aa83b22t00>
     */
	@Transactional (readOnly = true)
    public List<Aa83b22t00> findAllLike(Aa83b22t00 aa83b22t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_022 ID022,t1.ID_023_SOL_ESF ID023SOLESF,t1.ID_ANO_023 IDANO023,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_010_HISTO_TRAM ID010HISTOTRAM,t1.ID_PIF_022 IDPIF022,t1.OID_022 OID022 "); 
        query.append("FROM AA83B22T00 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b22t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b22t00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
     * Counts rows in the Aa83b22t00 table.
     * 
     * @param aa83b22t00 Aa83b22t00
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Aa83b22t00 aa83b22t00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B22T00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b22t00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Aa83b22t00 table using like.
     * 
     * @param aa83b22t00 Aa83b22t00
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Aa83b22t00 aa83b22t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B22T00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b22t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b22t00 selected for rup_table
     * 
     * @param aa83b22t00 Aa83b22t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b22t00>> 
     */
	@Override 
	public List<TableRowDto<Aa83b22t00>> reorderSelection(Aa83b22t00 aa83b22t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_022 ID022,t1.ID_023_SOL_ESF ID023SOLESF,t1.ID_ANO_023 IDANO023,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_010_HISTO_TRAM ID010HISTOTRAM,t1.ID_PIF_022 IDPIF022,t1.OID_022 OID022 "); 
		// FROM
        query.append("FROM AA83B22T00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b22t00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Aa83b22t00.class, filterParamList, "ID_022" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b22t00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
     * 
     * @param filterParams Aa83b22t00
     * @param searchParams Aa83b22t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b22t00>> 
     */
	@Override
	public List<TableRowDto<Aa83b22t00>> search(Aa83b22t00 filterParams, Aa83b22t00 searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_022 ID022,t1.ID_023_SOL_ESF ID023SOLESF,t1.ID_ANO_023 IDANO023,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_010_HISTO_TRAM ID010HISTOTRAM,t1.ID_PIF_022 IDPIF022,t1.OID_022 OID022 "); 
		// FROM
        query.append("FROM AA83B22T00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Aa83b22t00.class, filterParamList, searchSQL, searchParamList, from_alias, "ID_022");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b22t00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table
     * 
     * @param filteraa83b22t00 Aa83b22t00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean 
     */
	@Override
	public void removeMultiple(Aa83b22t00 filteraa83b22t00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.ID_022 ID022,t1.ID_023_SOL_ESF ID023SOLESF,t1.ID_ANO_023 IDANO023,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_010_HISTO_TRAM ID010HISTOTRAM,t1.ID_PIF_022 IDPIF022,t1.OID_022 OID022 "); 
		// FROM
        query.append("FROM AA83B22T00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b22t00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Aa83b22t00.class, query, params, "ID_022");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b22t00 table.
     * 
     * @param filterAa83b22t00 Aa83b22t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<JerarquiaDto<Aa83b22t00>> 
     */
	@Override
	public List<JerarquiaDto<Aa83b22t00>> findAllLikeJerarquia(Aa83b22t00 filterAa83b22t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_022 ID022,t1.ID_023_SOL_ESF ID023SOLESF,t1.ID_ANO_023 IDANO023,t1.ID_004_TIPO_DOC_G ID004TIPODOCG,t1.ID_010_HISTO_TRAM ID010HISTOTRAM,t1.ID_PIF_022 IDPIF022,t1.OID_022 OID022 "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B22T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B22T00");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b22t00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID_022", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
     * 
     * @param filterAa83b22t00 Aa83b22t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return Long 
     */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b22t00 filterAa83b22t00, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B22T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B22T00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b22t00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID_022", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
     * 
     * @param filterAa83b22t00 Aa83b22t00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<TableRowDto<Aa83b22t00>> 
     */
	@Override
	public List<TableRowDto<Aa83b22t00>> findAllChild(Aa83b22t00 filterAa83b22t00, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B22T00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B22T00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b22t00, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID_022", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Aa83b22t00>(this.rwMapPK, "ID_022"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Aa83b22t00 entity 
	 * 
	 * @param aa83b22t00 Aa83b22t00
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Aa83b22t00 aa83b22t00){
		
		StringBuilder where = new StringBuilder(Aa83b22t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b22t00  != null  && aa83b22t00.getId022() != null ) {
			where.append(" AND t1.ID_022 = ?");
			params.add(aa83b22t00.getId022());
		}
		if (aa83b22t00  != null  && aa83b22t00.getId023SolEsf() != null ) {
			where.append(" AND t1.ID_023_SOL_ESF = ?");
			params.add(aa83b22t00.getId023SolEsf());
		}
		if (aa83b22t00  != null  && aa83b22t00.getIdAno023() != null ) {
			where.append(" AND t1.ID_ANO_023 = ?");
			params.add(aa83b22t00.getIdAno023());
		}
		if (aa83b22t00  != null  && aa83b22t00.getId004TipoDocG() != null ) {
			where.append(" AND t1.ID_004_TIPO_DOC_G = ?");
			params.add(aa83b22t00.getId004TipoDocG());
		}
		if (aa83b22t00  != null  && aa83b22t00.getId010HistoTram() != null ) {
			where.append(" AND t1.ID_010_HISTO_TRAM = ?");
			params.add(aa83b22t00.getId010HistoTram());
		}
		if (aa83b22t00  != null  && aa83b22t00.getIdPif022() != null ) {
			where.append(" AND t1.ID_PIF_022 = ?");
			params.add(aa83b22t00.getIdPif022());
		}
		if (aa83b22t00  != null  && aa83b22t00.getOid022() != null ) {
			where.append(" AND t1.OID_022 = ?");
			params.add(aa83b22t00.getOid022());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Aa83b22t00 entity 
	 * 
	 * @param aa83b22t00 Aa83b22t00
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (Aa83b22t00 aa83b22t00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(Aa83b22t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b22t00  != null  && aa83b22t00.getId022() != null ) {
			where.append(" AND t1.ID_022 = ?");
			params.add(aa83b22t00.getId022());
	     }			
		if (aa83b22t00  != null  && aa83b22t00.getId023SolEsf() != null ) {
			where.append(" AND t1.ID_023_SOL_ESF = ?");
			params.add(aa83b22t00.getId023SolEsf());
	     }			
		if (aa83b22t00  != null  && aa83b22t00.getIdAno023() != null ) {
			where.append(" AND t1.ID_ANO_023 = ?");
			params.add(aa83b22t00.getIdAno023());
	     }			
		if (aa83b22t00  != null  && aa83b22t00.getId004TipoDocG() != null ) {
			where.append(" AND t1.ID_004_TIPO_DOC_G = ?");
			params.add(aa83b22t00.getId004TipoDocG());
	     }			
		if (aa83b22t00  != null  && aa83b22t00.getId010HistoTram() != null ) {
			where.append(" AND t1.ID_010_HISTO_TRAM = ?");
			params.add(aa83b22t00.getId010HistoTram());
	     }			
		if (aa83b22t00  != null  && aa83b22t00.getIdPif022() != null ) {
			where.append(" AND UPPER(t1.ID_PIF_022) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b22t00.getIdPif022().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b22t00.getIdPif022().toUpperCase() +"%");
			}
			where.append(" AND t1.ID_PIF_022 IS NOT NULL");
	     }			
		if (aa83b22t00  != null  && aa83b22t00.getOid022() != null ) {
			where.append(" AND UPPER(t1.OID_022) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b22t00.getOid022().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b22t00.getOid022().toUpperCase() +"%");
			}
			where.append(" AND t1.OID_022 IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

