package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b21t00;
import com.ejie.aa83b.model.Aa83b21v00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa83b21t00DaoImpl generated by UDA, 28-dic-2015 17:45:22.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b21t00DaoImpl implements Aa83b21t00Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b21t00> rwMap = new RowMapper<Aa83b21t00>() {
		public Aa83b21t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b21t00(resultSet.getLong("IDANO021"),
					resultSet.getInt("ID021"),
					resultSet.getString("TELFNOTIFICACION021"),
					resultSet.getString("NOMBRE021"),
					resultSet.getString("APEL1021"),
					resultSet.getString("APEL2021"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC021"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1021"),
					resultSet.getString("TELF2021"),
					resultSet.getString("EMAIL021"),
					resultSet.getString("FNAC021"),
					resultSet.getInt("NACIONALIDAD021"),
					resultSet.getString("LOCALIDADEMP021"),
					resultSet.getString("PROVEMP021"),
					resultSet.getInt("IDIOMACOMUNIC021"),
					resultSet.getString("PROVINCIACOMUNIC021"),
					resultSet.getString("MUNICIPCOMUNIC021"),
					resultSet.getString("CALLECOMUNIC021"),
					resultSet.getString("NUMEROCOMUNIC021"),
					resultSet.getString("BISCOMUNIC021"),					
					resultSet.getString("PISOCOMUNIC021"),
					resultSet.getString("LETRACOMUNIC021"),
					resultSet.getString("CPOSTALCOMUNIC021"),
					resultSet.getString("CONSENTIMIENTOS021"),
					resultSet.getString("CONSENTIMIENTOS2021"),
					resultSet.getString("MOTIVOOTROS021"),
					resultSet.getInt("ID015MOTIVOSSOL"),
					resultSet.getInt("ID014TITULARIDADVIV"),
					resultSet.getInt("ID016DERECHOSOCUP"),
					resultSet.getString("DERECHOOCOTROS021"),
					resultSet.getString("CALLE021"),
					resultSet.getString("NUMCALLE021"),
					resultSet.getString("BIS021"),
					resultSet.getString("PISO021"),
					resultSet.getString("LETRA021"),
					resultSet.getString("CP021"),
					resultSet.getString("MUNICIPIO021"),
					resultSet.getString("PROVINCIA021"),
					resultSet.getLong("NUMPERSREAGRUPAR021"),
					resultSet.getLong("NUMPERSHABITAN021"),
					resultSet.getLong("UDSFAMHABITAN021"),
					resultSet.getLong("NUMMENORESHABITAN021"),
					resultSet.getLong("NUMADULTHABITAN021"),
					resultSet.getString("NOMBREREP021"),
					resultSet.getString("APEL1REP021"),
					resultSet.getString("APEL2REP021"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP021"),
					resultSet.getString("TELF1REP021"),
					resultSet.getString("TELF2REP021"),
					resultSet.getString("TIPONOTIFICACION021"),
					resultSet.getString("PASEVIVIENDA021"),
					resultSet.getString("SOLICERRADA021"),
					resultSet.getString("NOTIFLEIDA021")
					,resultSet.getString("REQLEIDO021")
			);
		}
	};
	private RowMapper<Aa83b21t00> rwMap3 = new RowMapper<Aa83b21t00>() {
		public Aa83b21t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b21t00(resultSet.getLong("IDANO021"),
					resultSet.getInt("ID021"),
					resultSet.getString("TELFNOTIFICACION021"),
					resultSet.getString("NUMREG021"),
					resultSet.getString("FECHA021"),
					resultSet.getString("NOMBRE021"),
					resultSet.getString("APEL1021"),
					resultSet.getString("APEL2021"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC021"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1021"),
					resultSet.getString("TELF2021"),
					resultSet.getString("EMAIL021"),
					resultSet.getString("FNAC021"),
					resultSet.getInt("NACIONALIDAD021"),
					resultSet.getString("LOCALIDADEMP021"),
					resultSet.getString("PROVEMP021"),
					resultSet.getInt("IDIOMACOMUNIC021"),
					resultSet.getString("PROVINCIACOMUNIC021"),
					resultSet.getString("MUNICIPCOMUNIC021"),
					resultSet.getString("CALLECOMUNIC021"),
					resultSet.getString("NUMEROCOMUNIC021"),
					resultSet.getString("PISOCOMUNIC021"),
					resultSet.getString("LETRACOMUNIC021"),
					resultSet.getString("CPOSTALCOMUNIC021"),
					resultSet.getString("CONSENTIMIENTOS021"),
					resultSet.getString("CONSENTIMIENTOS2021"),
					resultSet.getString("MOTIVOOTROS021"),
					resultSet.getInt("ID015MOTIVOSSOL"),
					resultSet.getInt("ID014TITULARIDADVIV"),
					resultSet.getInt("ID016DERECHOSOCUP"),
					resultSet.getString("DERECHOOCOTROS021"),
					resultSet.getString("CALLE021"),
					resultSet.getString("NUMCALLE021"),
					resultSet.getString("PISO021"),
					resultSet.getString("LETRA021"),
					resultSet.getString("CP021"),
					resultSet.getString("MUNICIPIO021"),
					resultSet.getString("PROVINCIA021"),
					resultSet.getLong("NUMPERSREAGRUPAR021"),
					resultSet.getLong("NUMPERSHABITAN021"),
					resultSet.getLong("UDSFAMHABITAN021"),
					resultSet.getLong("NUMMENORESHABITAN021"),
					resultSet.getLong("NUMADULTHABITAN021"),
					resultSet.getString("NOMBREREP021"),
					resultSet.getString("APEL1REP021"),
					resultSet.getString("APEL2REP021"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP021"),
					resultSet.getString("TELF1REP021"),
					resultSet.getString("TELF2REP021"),
					resultSet.getString("TIPONOTIFICACION021"),
					resultSet.getString("PASEVIVIENDA021"),
					resultSet.getString("SOLICERRADA021"),
					resultSet.getString("NOTIFLEIDA021")
					,resultSet.getString("REQLEIDO021")
					);
		}
	};
	private RowMapper<Aa83b21t00> rwMap4 = new RowMapper<Aa83b21t00>() {
		public Aa83b21t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b21t00(resultSet.getLong("IDANO021"),
					resultSet.getInt("ID021"),
					resultSet.getString("TELFNOTIFICACION021"),
					resultSet.getString("NUMREG021"),
					resultSet.getString("FECHA021"),
					resultSet.getString("NOMBRE021"),
					resultSet.getString("APEL1021"),
					resultSet.getString("APEL2021"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC021"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1021"),
					resultSet.getString("TELF2021"),
					resultSet.getString("EMAIL021"),
					resultSet.getString("FNAC021"),
					resultSet.getInt("NACIONALIDAD021"),
					resultSet.getString("LOCALIDADEMP021"),
					resultSet.getString("PROVEMP021"),
					resultSet.getInt("IDIOMACOMUNIC021"),
					resultSet.getString("PROVINCIACOMUNIC021"),
					resultSet.getString("MUNICIPCOMUNIC021"),
					resultSet.getString("CALLECOMUNIC021"),
					resultSet.getString("NUMEROCOMUNIC021"),
					resultSet.getString("BISCOMUNIC021"),
					resultSet.getString("PISOCOMUNIC021"),
					resultSet.getString("LETRACOMUNIC021"),
					resultSet.getString("CPOSTALCOMUNIC021"),
					resultSet.getString("CONSENTIMIENTOS021"),
					resultSet.getString("CONSENTIMIENTOS2021"),
					resultSet.getString("MOTIVOOTROS021"),
					resultSet.getInt("ID015MOTIVOSSOL"),
					resultSet.getInt("ID014TITULARIDADVIV"),
					resultSet.getInt("ID016DERECHOSOCUP"),
					resultSet.getString("DERECHOOCOTROS021"),
					resultSet.getString("CALLE021"),
					resultSet.getString("NUMCALLE021"),
					resultSet.getString("BIS021"),
					resultSet.getString("PISO021"),
					resultSet.getString("LETRA021"),
					resultSet.getString("CP021"),
					resultSet.getString("MUNICIPIO021"),
					resultSet.getString("PROVINCIA021"),
					resultSet.getLong("NUMPERSREAGRUPAR021"),
					resultSet.getLong("NUMPERSHABITAN021"),
					resultSet.getLong("UDSFAMHABITAN021"),
					resultSet.getLong("NUMMENORESHABITAN021"),
					resultSet.getLong("NUMADULTHABITAN021"),
					resultSet.getString("NOMBREREP021"),
					resultSet.getString("APEL1REP021"),
					resultSet.getString("APEL2REP021"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP021"),
					resultSet.getString("TELF1REP021"),
					resultSet.getString("TELF2REP021"),
					resultSet.getString("TIPONOTIFICACION021"),
					resultSet.getInt("RESOLFAVORABLE021"),
					resultSet.getString("PASEVIVIENDA021"),
					resultSet.getString("SOLICERRADA021"),
					resultSet.getString("NOTIFLEIDA021"),
					resultSet.getString("REQLEIDO021"),
					resultSet.getString("OBSERVACIONES021")
					);
		}
	};

	private RowMapper<Aa83b21t00> rwMap5 = new RowMapper<Aa83b21t00>() {
		public Aa83b21t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b21t00(resultSet.getLong("IDANO021"),
					resultSet.getInt("ID021"),
					resultSet.getString("NOMBRE021"),
					resultSet.getString("FECREG021"),
					resultSet.getString("NUMREG021"));
		}
	};
	
	private RowMapper<Aa83b21v00> rwMapFicha = new RowMapper<Aa83b21v00>() {
		public Aa83b21v00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Aa83b21v00(
        		   resultSet.getInt("ID021"), 
        		   resultSet.getLong("IDANO021"), 
        		   resultSet.getDate("FECREG021"), 
        		   resultSet.getInt("ID015MOTIVOSSOL"), 
        		   resultSet.getString("MOTIVOES015"), 
        		   resultSet.getString("MOTIVOEU015"), 
        		   resultSet.getString("CONSENTIMIENTOS2021"), 
        		   resultSet.getString("NOMBRE021"), 
        		   resultSet.getString("APEL1021"), 
        		   resultSet.getString("APEL2021"), 
        		   resultSet.getString("TELF1021"), 
        		   resultSet.getString("TELF2021"), 
        		   resultSet.getString("EMAIL021"), 
        		   resultSet.getString("CALLECOMUNIC021"), 
        		   resultSet.getString("NUMEROCOMUNIC021"), 
        		   resultSet.getString("BISCOMUNIC021"),
        		   resultSet.getString("PISOCOMUNIC021"), 
        		   resultSet.getString("LETRACOMUNIC021"), 
        		   resultSet.getString("CPOSTALCOMUNIC021"), 
        		   resultSet.getString("PROVINCIACOMUNIC021"), 
        		   resultSet.getString("PROVCOMUNIC"), 
        		   resultSet.getString("MUNICIPCOMUNIC021"), 
        		   resultSet.getString("MUNICOMUNIC"), 
        		   resultSet.getString("NUMDOC021"), 
        		   resultSet.getInt("NACIONALIDAD021"), 
        		   resultSet.getString("PAISDS"), 
        		   resultSet.getString("CALLE021"), 
        		   resultSet.getString("NUMCALLE021"), 
        		   resultSet.getString("BIS021"),
        		   resultSet.getString("PISO021"), 
        		   resultSet.getString("LETRA021"), 
        		   resultSet.getString("CP021"), 
        		   resultSet.getString("PROVINCIA021"), 
        		   resultSet.getString("PROVINS"), 
        		   resultSet.getString("MUNICIPIO021"), 
        		   resultSet.getString("MUNIDSINS"), 
        		   resultSet.getInt("ID014TITULARIDADVIV"), 
        		   resultSet.getString("DESCES014"), 
        		   resultSet.getString("DESCEU014"), 
        		   resultSet.getInt("ID016DERECHOSOCUP"), 
        		   resultSet.getString("DESCES016"), 
        		   resultSet.getString("DESCEU016"), 
        		   resultSet.getLong("NUMPERSHABITAN021"), 
        		   resultSet.getLong("NUMPERSREAGRUPAR021"),
        		   resultSet.getString("OBSERVACIONES021")
           ); } } ;	
	
	private RowMapper<Aa83b21t00> rwMapPK = new RowMapper<Aa83b21t00>() {
		public Aa83b21t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b21t00(resultSet.getLong("IDANO021"),
					resultSet.getInt("ID021"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b21t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b21t00>>() {
		public JerarquiaDto<Aa83b21t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa83b21t00 aa83b21t00 = new Aa83b21t00(
					resultSet.getLong("IDANO021"), resultSet.getInt("ID021"),
					resultSet.getString("TELFNOTIFICACION021"),
					resultSet.getString("NOMBRE021"),
					resultSet.getString("APEL1021"),
					resultSet.getString("APEL2021"),
					resultSet.getInt("ID012TIPODOC"),
					resultSet.getString("NUMDOC021"),
					resultSet.getInt("ID017GENERO"),
					resultSet.getString("TELF1021"),
					resultSet.getString("TELF2021"),
					resultSet.getString("EMAIL021"),
					resultSet.getString("FNAC021"),
					resultSet.getInt("NACIONALIDAD021"),
					resultSet.getString("LOCALIDADEMP021"),
					resultSet.getString("PROVEMP021"),
					resultSet.getInt("IDIOMACOMUNIC021"),
					resultSet.getString("PROVINCIACOMUNIC021"),
					resultSet.getString("MUNICIPCOMUNIC021"),
					resultSet.getString("CALLECOMUNIC021"),
					resultSet.getString("NUMEROCOMUNIC021"),
					resultSet.getString("BISCOMUNIC021"),
					resultSet.getString("PISOCOMUNIC021"),
					resultSet.getString("LETRACOMUNIC021"),
					resultSet.getString("CPOSTALCOMUNIC021"),
					resultSet.getString("CONSENTIMIENTOS021"),
					resultSet.getString("CONSENTIMIENTOS2021"),
					resultSet.getString("MOTIVOOTROS021"),
					resultSet.getInt("ID015MOTIVOSSOL"),
					resultSet.getInt("ID014TITULARIDADVIV"),
					resultSet.getInt("ID016DERECHOSOCUP"),
					resultSet.getString("DERECHOOCOTROS021"),
					resultSet.getString("CALLE021"),
					resultSet.getString("NUMCALLE021"),
					resultSet.getString("BIS21"),
					resultSet.getString("PISO021"),
					resultSet.getString("LETRA021"),
					resultSet.getString("CP021"),
					resultSet.getString("MUNICIPIO021"),
					resultSet.getString("PROVINCIA021"),
					resultSet.getLong("NUMPERSREAGRUPAR021"),
					resultSet.getLong("NUMPERSHABITAN021"),
					resultSet.getLong("UDSFAMHABITAN021"),
					resultSet.getLong("NUMMENORESHABITAN021"),
					resultSet.getLong("NUMADULTHABITAN021"),
					resultSet.getString("NOMBREREP021"),
					resultSet.getString("APEL1REP021"),
					resultSet.getString("APEL2REP021"),
					resultSet.getInt("ID012REP"),
					resultSet.getString("NUMDOCREP021"),
					resultSet.getString("TELF1REP021"),
					resultSet.getString("TELF2REP021"),
					resultSet.getString("TIPONOTIFICACION021"),
					resultSet.getString("PASEVIVIENDA021"),
					resultSet.getString("SOLICERRADA021"),
					resultSet.getString("NOTIFLEIDA021"),
					resultSet.getString("REQLEIDO021")
					);

			JerarquiaDto<Aa83b21t00> jerarquia = new JerarquiaDto<Aa83b21t00>();
			jerarquia.setModel(aa83b21t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	public Aa83b21t00 add(Aa83b21t00 aa83b21t00) {
		final int nextId = jdbcTemplate
				.queryForInt("SELECT SEQ_AA83B21T00_ID_021_"
						+ aa83b21t00.getIdAno021() + ".NEXTVAL FROM DUAL");

		aa83b21t00.setId021(nextId);
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String query = "INSERT INTO AA83B21T00 (ID_ANO_021, ID_021, TELF_NOTIFICACION_021, NUM_REG_021, "
				+ "FEC_REG_021, NOMBRE_021, APEL1_021, APEL2_021, ID_012_TIPO_DOC, NUM_DOC_021, "
				+ "ID_017_GENERO, TELF1_021, TELF2_021, EMAIL_021, F_NAC_021, NACIONALIDAD_021, "
				+ "LOCALIDAD_EMP_021, PROV_EMP_021, IDIOMA_COMUNIC_021, PROVINCIA_COMUNIC_021, "
				+ "MUNICIP_COMUNIC_021, CALLE_COMUNIC_021, NUMERO_COMUNIC_021, BIS_COMUNIC_021, PISO_COMUNIC_021, "
				+ "LETRA_COMUNIC_021, CPOSTAL_COMUNIC_021, CONSENTIMIENTOS_021, CONSENTIMIENTOS2_021, "
				+ "MOTIVO_OTROS_021, ID_015_MOTIVOS_SOL, ID_014_TITULARIDAD_VIV, ID_016_DERECHOS_OCUP, "
				+ "DERECHO_OC_OTROS_021, CALLE_021, NUM_CALLE_021, BIS_021, PISO_021, LETRA_021, CP_021, MUNICIPIO_021, "
				+ "PROVINCIA_021, NUM_PERS_REAGRUPAR_021, NUM_PERS_HABITAN_021, UDS_FAM_HABITAN_021, "
				+ "NUM_MENORES_HABITAN_021, NUM_ADULT_HABITAN_021, NOMBRE_REP_021, APEL1_REP_021, APEL2_REP_021, "
				+ "ID_012_REP, NUM_DOC_REP_021, TELF1_REP_021, TELF2_REP_021, TIPO_NOTIFICACION_021, RESOL_FAVORABLE_021, "
				+ "PASE_VIVIENDA_021, SOLI_CERRADA_021, NOTIF_LEIDA_021, OBSERVACIONES_021) "
				+ "VALUES (?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b21t00.getIdAno021(),
				aa83b21t00.getId021(), aa83b21t00.getTelf_notificacion_021(),
				aa83b21t00.getNumReg021(), aa83b21t00.getFecha021(),
				"dd/mm/yyyy HH24:mi:ss", aa83b21t00.getNombre021(),
				aa83b21t00.getApel1021(), aa83b21t00.getApel2021(),
				aa83b21t00.getId012TipoDoc(), aa83b21t00.getNumDoc021(),
				aa83b21t00.getId017Genero(), aa83b21t00.getTelf1021(),
				aa83b21t00.getTelf2021(), aa83b21t00.getEmail021(),
				aa83b21t00.getfNac021(), formato,
				aa83b21t00.getNacionalidad021(),
				aa83b21t00.getLocalidadEmp021(), aa83b21t00.getProvEmp021(),
				aa83b21t00.getIdiomaComunic021(),
				aa83b21t00.getProvinciaComunic021(),
				aa83b21t00.getMunicipComunic021(),
				aa83b21t00.getCalleComunic021(),
				aa83b21t00.getNumeroComunic021(),
				aa83b21t00.getBisComunic021(),
				aa83b21t00.getPisoComunic021(),
				aa83b21t00.getLetraComunic021(),
				aa83b21t00.getCpostalComunic021(),
				aa83b21t00.getConsentimientos021(),
				aa83b21t00.getConsentimientos2021(),
				aa83b21t00.getMotivoOtros021(),
				aa83b21t00.getId015MotivosSol(),
				aa83b21t00.getId014TitularidadViv(),
				aa83b21t00.getId016DerechosOcup(),
				aa83b21t00.getDerechoOcOtros021(), aa83b21t00.getCalle021(),
				aa83b21t00.getNumCalle021(), aa83b21t00.getBis021(), aa83b21t00.getPiso021(),
				aa83b21t00.getLetra021(), aa83b21t00.getCp021(),
				aa83b21t00.getMunicipio021(), aa83b21t00.getProvincia021(),
				aa83b21t00.getNumPersReagrupar021(),
				aa83b21t00.getNumPersHabitan021(),
				aa83b21t00.getUdsFamHabitan021(),
				aa83b21t00.getNumMenoresHabitan021(),
				aa83b21t00.getNumAdultHabitan021(),
				aa83b21t00.getNombreRep021(), aa83b21t00.getApel1Rep021(),
				aa83b21t00.getApel2Rep021(), aa83b21t00.getId012Rep(),
				aa83b21t00.getNumDocRep021(), aa83b21t00.getTelf1Rep021(),
				aa83b21t00.getTelf2Rep021(),
				aa83b21t00.getTipoNotificacion021(),
				aa83b21t00.getResolFavorable021(), "N", "N", "N", aa83b21t00.getObservaciones021());
		return aa83b21t00;
	}

	/**
	 * Updates a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	public Aa83b21t00 update(Aa83b21t00 aa83b21t00) {
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String query = "UPDATE AA83B21T00 SET NOMBRE_021=?, APEL1_021=?, APEL2_021=?, ID_012_TIPO_DOC=?, NUM_DOC_021=?, ID_017_GENERO=?, TELF1_021=?, TELF2_021=?, "
				+ "EMAIL_021=?, F_NAC_021=to_date(?,?), NACIONALIDAD_021=?, LOCALIDAD_EMP_021=?, PROV_EMP_021=?, IDIOMA_COMUNIC_021=?, PROVINCIA_COMUNIC_021=?, "
				+ "MUNICIP_COMUNIC_021=?, CALLE_COMUNIC_021=?, NUMERO_COMUNIC_021=?, BIS_COMUNIC_021=?, PISO_COMUNIC_021=?, LETRA_COMUNIC_021=?, CPOSTAL_COMUNIC_021=?, "
				+ "CONSENTIMIENTOS_021=?, CONSENTIMIENTOS2_021=?, MOTIVO_OTROS_021=?, ID_015_MOTIVOS_SOL=?, ID_014_TITULARIDAD_VIV=?, ID_016_DERECHOS_OCUP=?, "
				+ "DERECHO_OC_OTROS_021=?, CALLE_021=?, NUM_CALLE_021=?, BIS_021=?, PISO_021=?, LETRA_021=?, CP_021=?, MUNICIPIO_021=?, PROVINCIA_021=?, "
				+ "NUM_PERS_REAGRUPAR_021=?, NUM_PERS_HABITAN_021=?, UDS_FAM_HABITAN_021=?, NUM_MENORES_HABITAN_021=?, NUM_ADULT_HABITAN_021=?, "
				+ "NOMBRE_REP_021=?, APEL1_REP_021=?, APEL2_REP_021=?, ID_012_REP=?, NUM_DOC_REP_021=?, TELF1_REP_021=?, TELF2_REP_021=?, TIPO_NOTIFICACION_021=?, "
				+ "RESOL_FAVORABLE_021=?, "
				+ "PASE_VIVIENDA_021=?, "
				+ "SOLI_CERRADA_021=?, "
				+ "NOTIF_LEIDA_021=?, "
				+ "OBSERVACIONES_021=? "
				+ "WHERE ID_ANO_021=? AND ID_021=?";
		this.jdbcTemplate.update(query, aa83b21t00.getNombre021(),
				aa83b21t00.getApel1021(), aa83b21t00.getApel2021(),
				aa83b21t00.getId012TipoDoc(), aa83b21t00.getNumDoc021(),
				aa83b21t00.getId017Genero(), aa83b21t00.getTelf1021(),
				aa83b21t00.getTelf2021(), aa83b21t00.getEmail021(),
				aa83b21t00.getfNac021(), formato,
				aa83b21t00.getNacionalidad021(),
				aa83b21t00.getLocalidadEmp021(), aa83b21t00.getProvEmp021(),
				aa83b21t00.getIdiomaComunic021(),
				aa83b21t00.getProvinciaComunic021(),
				aa83b21t00.getMunicipComunic021(),
				aa83b21t00.getCalleComunic021(),
				aa83b21t00.getNumeroComunic021(),
				aa83b21t00.getBisComunic021(),
				aa83b21t00.getPisoComunic021(),
				aa83b21t00.getLetraComunic021(),
				aa83b21t00.getCpostalComunic021(),
				aa83b21t00.getConsentimientos021(),
				aa83b21t00.getConsentimientos2021(),
				aa83b21t00.getMotivoOtros021(),
				aa83b21t00.getId015MotivosSol(),
				aa83b21t00.getId014TitularidadViv(),
				aa83b21t00.getId016DerechosOcup(),
				aa83b21t00.getDerechoOcOtros021(), aa83b21t00.getCalle021(),
				aa83b21t00.getNumCalle021(), aa83b21t00.getBis021(), aa83b21t00.getPiso021(),
				aa83b21t00.getLetra021(), aa83b21t00.getCp021(),
				aa83b21t00.getMunicipio021(), aa83b21t00.getProvincia021(),
				aa83b21t00.getNumPersReagrupar021(),
				aa83b21t00.getNumPersHabitan021(),
				aa83b21t00.getUdsFamHabitan021(),
				aa83b21t00.getNumMenoresHabitan021(),
				aa83b21t00.getNumAdultHabitan021(),
				aa83b21t00.getNombreRep021(), aa83b21t00.getApel1Rep021(),
				aa83b21t00.getApel2Rep021(), aa83b21t00.getId012Rep(),
				aa83b21t00.getNumDocRep021(), aa83b21t00.getTelf1Rep021(),
				aa83b21t00.getTelf2Rep021(),
				aa83b21t00.getTipoNotificacion021(),
				aa83b21t00.getResolFavorable021(),
				aa83b21t00.getPasarvivienda021(),
				aa83b21t00.getSolicerrada021(), aa83b21t00.getNotifLeida021(),
				aa83b21t00.getObservaciones021(), 
				aa83b21t00.getIdAno021(), aa83b21t00.getId021());
		return aa83b21t00;
	}

	/**
	 * Finds a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	@Transactional(readOnly = true)
	public Aa83b21t00 find(Aa83b21t00 aa83b21t00) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		String formatoHora = Aa83BConstants.ES_PATTERN_HORA_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
			formatoHora = Aa83BConstants.EU_PATTERN_HORA_COMPLETA;
			;
		}
		String query = "SELECT t1.ID_ANO_021 IDANO021, t1.ID_021 ID021, t1.TELF_NOTIFICACION_021 TELFNOTIFICACION021, t1.NUM_REG_021 NUMREG021, TO_CHAR(t1.FEC_REG_021,"
				+ formatoHora
				+ ") FECHA021, t1.NOMBRE_021 NOMBRE021, t1.APEL1_021 APEL1021, t1.APEL2_021 APEL2021, t1.ID_012_TIPO_DOC ID012TIPODOC, t1.NUM_DOC_021 NUMDOC021, t1.ID_017_GENERO ID017GENERO, t1.TELF1_021 TELF1021, t1.TELF2_021 TELF2021, t1.EMAIL_021 EMAIL021, to_char(t1.F_NAC_021,"
				+ formato
				+ ") FNAC021, t1.NACIONALIDAD_021 NACIONALIDAD021, t1.LOCALIDAD_EMP_021 LOCALIDADEMP021, t1.PROV_EMP_021 PROVEMP021, t1.IDIOMA_COMUNIC_021 IDIOMACOMUNIC021, "
				+ "t1.PROVINCIA_COMUNIC_021 PROVINCIACOMUNIC021, t1.MUNICIP_COMUNIC_021 MUNICIPCOMUNIC021, t1.CALLE_COMUNIC_021 CALLECOMUNIC021,"
				+ "t1.NUMERO_COMUNIC_021 NUMEROCOMUNIC021, t1.BIS_COMUNIC_021 BISCOMUNIC021, t1.PISO_COMUNIC_021 PISOCOMUNIC021, t1.LETRA_COMUNIC_021 LETRACOMUNIC021, "
				+ "t1.CPOSTAL_COMUNIC_021 CPOSTALCOMUNIC021, t1.CONSENTIMIENTOS_021 CONSENTIMIENTOS021, t1.CONSENTIMIENTOS2_021 CONSENTIMIENTOS2021, "
				+ "t1.MOTIVO_OTROS_021 MOTIVOOTROS021, t1.ID_015_MOTIVOS_SOL ID015MOTIVOSSOL, t1.ID_014_TITULARIDAD_VIV ID014TITULARIDADVIV, "
				+ "t1.ID_016_DERECHOS_OCUP ID016DERECHOSOCUP, t1.DERECHO_OC_OTROS_021 DERECHOOCOTROS021, t1.CALLE_021 CALLE021, t1.NUM_CALLE_021 NUMCALLE021, t1.BIS_021 BIS021, " 
				+ "t1.PISO_021 PISO021, t1.LETRA_021 LETRA021, t1.CP_021 CP021, t1.MUNICIPIO_021 MUNICIPIO021, t1.PROVINCIA_021 PROVINCIA021, "
				+ "t1.NUM_PERS_REAGRUPAR_021 NUMPERSREAGRUPAR021, t1.NUM_PERS_HABITAN_021 NUMPERSHABITAN021, t1.UDS_FAM_HABITAN_021 UDSFAMHABITAN021, "
				+ "t1.NUM_MENORES_HABITAN_021 NUMMENORESHABITAN021, t1.NUM_ADULT_HABITAN_021 NUMADULTHABITAN021, t1.NOMBRE_REP_021 NOMBREREP021, "
				+ "t1.APEL1_REP_021 APEL1REP021, t1.APEL2_REP_021 APEL2REP021, t1.ID_012_REP ID012REP, t1.NUM_DOC_REP_021 NUMDOCREP021, t1.TELF1_REP_021 TELF1REP021, "
				+ "t1.TELF2_REP_021 TELF2REP021, t1.TIPO_NOTIFICACION_021 TIPONOTIFICACION021, nvl(t1.RESOL_FAVORABLE_021,9) RESOLFAVORABLE021, "
				+ "t1.PASE_VIVIENDA_021 PASEVIVIENDA021, t1.SOLI_CERRADA_021 SOLICERRADA021 , t1.NOTIF_LEIDA_021 NOTIFLEIDA021, t1.REQ_LEIDO_021 REQLEIDO021, "
				+ "t1.OBSERVACIONES_021 OBSERVACIONES021 "				
				+ "FROM AA83B21T00 t1  " +
						"WHERE t1.ID_ANO_021 = ?   AND t1.ID_021 = ?  ";
		List<Aa83b21t00> aa83b21t00List = this.jdbcTemplate.query(query,
				this.rwMap4, aa83b21t00.getIdAno021(), aa83b21t00.getId021());
		return (Aa83b21t00) DataAccessUtils.uniqueResult(aa83b21t00List);
	}
	
	/**
	 * Finds a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Aa83b21t00
	 */
	@Transactional(readOnly = true)
	public Aa83b21v00 findFicha(Aa83b21v00 aa83b21v00) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		String formatoHora = Aa83BConstants.ES_PATTERN_HORA_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
			formatoHora = Aa83BConstants.EU_PATTERN_HORA_COMPLETA;
			;
		}
		String query = "SELECT t1.ID021 ID021, t1.IDANO021 IDANO021, t1.FECREG021 FECREG021, t1.ID015MOTIVOS_SOL ID015MOTIVOSSOL, " +
				"t1.MOTIVOES015 MOTIVOES015, t1.MOTIVOEU015 MOTIVOEU015, t1.CONSENTIMIENTOS2021 CONSENTIMIENTOS2021, " +
				"t1.NOMBRE021 NOMBRE021, t1.APEL1021 APEL1021, t1.APEL2021 APEL2021, t1.TELF1021 TELF1021, t1.TELF2021 TELF2021, " +
				"t1.EMAIL021 EMAIL021, t1.CALLECOMUNIC021 CALLECOMUNIC021, t1.NUMEROCOMUNIC021 NUMEROCOMUNIC021, t1.BISCOMUNIC021 BISCOMUNIC021," +
				"t1.PISOCOMUNIC021 PISOCOMUNIC021, t1.LETRACOMUNIC021 LETRACOMUNIC021, t1.CPOSTALCOMUNIC021 CPOSTALCOMUNIC021, " +
				"t1.PROVINCIACOMUNIC021 PROVINCIACOMUNIC021, t1.PROVCOMUNIC PROVCOMUNIC, t1.MUNICIPCOMUNIC021 MUNICIPCOMUNIC021, " +
				"t1.MUNICOMUNIC MUNICOMUNIC, t1.NUMDOC021 NUMDOC021, t1.NACIONALIDAD021 NACIONALIDAD021, t1.PAISDS PAISDS, " +
				"t1.CALLE021 CALLE021, t1.NUMCALLE021 NUMCALLE021, t1.BIS021 BIS021, t1.PISO021 PISO021, t1.LETRA021 LETRA021, t1.CP021 CP021, " +
				"t1.PROVINCIA021 PROVINCIA021, t1.PROVINS PROVINS, t1.MUNICIPIO021 MUNICIPIO021, t1.MUNIDSINS MUNIDSINS, " +
				"t1.ID014TITULARIDADVIV ID014TITULARIDADVIV, t1.DESCES014 DESCES014, t1.DESCEU014 DESCEU014, " +
				"t1.ID016DERECHOSOCUP ID016DERECHOSOCUP, t1.DESCES016 DESCES016, t1.DESCEU016 DESCEU016, " +
				"t1.NUMPERSHABITAN021 NUMPERSHABITAN021, t1.NUMPERSREAGRUPAR021 NUMPERSREAGRUPAR021, t1.OBSERVACIONES021 OBSERVACIONES021  " +
				"FROM AA83B21V00 t1  " +
				"WHERE t1.ID021 = ?   AND t1.IDANO021 = ?   ";
		List<Aa83b21v00> aa83b21v00List = this.jdbcTemplate.query(query,
				this.rwMapFicha, aa83b21v00.getId021(), aa83b21v00.getIdano021());
		return (Aa83b21v00) DataAccessUtils.uniqueResult(aa83b21v00List);
	}

	/**
	 * Removes a single row in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return
	 */
	public void remove(Aa83b21t00 aa83b21t00) {
		String query = "DELETE FROM AA83B21T00 WHERE ID_ANO_021=? AND ID_021=?";
		this.jdbcTemplate.update(query, aa83b21t00.getIdAno021(),
				aa83b21t00.getId021());
	}

	/**
	 * Finds a list of rows in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b21t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b21t00> findAll(Aa83b21t00 aa83b21t00,
			JQGridRequestDto jqGridRequestDto) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_ANO_021 IDANO021,t1.ID_021 ID021,t1.TELF_NOTIFICACION_021 TELFNOTIFICACION021,t1.NOMBRE_021 NOMBRE021,t1.APEL1_021 APEL1021,"
						+ "t1.APEL2_021 APEL2021,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_021 NUMDOC021,t1.ID_017_GENERO ID017GENERO,t1.TELF1_021 TELF1021,t1.TELF2_021 TELF2021,"
						+ "t1.EMAIL_021 EMAIL021,TO_CHAR(t1.F_NAC_021,"
						+ formato
						+ ") FNAC021,t1.NACIONALIDAD_021 NACIONALIDAD021,t1.LOCALIDAD_EMP_021 LOCALIDADEMP021,t1.PROV_EMP_021 PROVEMP021,"
						+ "t1.IDIOMA_COMUNIC_021 IDIOMACOMUNIC021,t1.PROVINCIA_COMUNIC_021 PROVINCIACOMUNIC021,t1.MUNICIP_COMUNIC_021 MUNICIPCOMUNIC021,"
						+ "t1.CALLE_COMUNIC_021 CALLECOMUNIC021,t1.NUMERO_COMUNIC_021 NUMEROCOMUNIC021, t1.BIS_COMUNIC_021 BISCOMUNIC021, t1.PISO_COMUNIC_021 PISOCOMUNIC021,"
						+ "t1.LETRA_COMUNIC_021 LETRACOMUNIC021,t1.CPOSTAL_COMUNIC_021 CPOSTALCOMUNIC021,t1.CONSENTIMIENTOS_021 CONSENTIMIENTOS021,"
						+ "t1.CONSENTIMIENTOS2_021 CONSENTIMIENTOS2021,t1.MOTIVO_OTROS_021 MOTIVOOTROS021,t1.ID_015_MOTIVOS_SOL ID015MOTIVOSSOL,"
						+ "t1.ID_014_TITULARIDAD_VIV ID014TITULARIDADVIV,t1.ID_016_DERECHOS_OCUP ID016DERECHOSOCUP,t1.DERECHO_OC_OTROS_021 DERECHOOCOTROS021,"
						+ "t1.CALLE_021 CALLE021,t1.NUM_CALLE_021 NUMCALLE021,t1.BIS_021 BIS021, t1.PISO_021 PISO021,t1.LETRA_021 LETRA021,t1.CP_021 CP021,t1.MUNICIPIO_021 MUNICIPIO021,"
						+ "t1.PROVINCIA_021 PROVINCIA021,t1.NUM_PERS_REAGRUPAR_021 NUMPERSREAGRUPAR021,t1.NUM_PERS_HABITAN_021 NUMPERSHABITAN021,"
						+ "t1.UDS_FAM_HABITAN_021 UDSFAMHABITAN021,t1.NUM_MENORES_HABITAN_021 NUMMENORESHABITAN021,t1.NUM_ADULT_HABITAN_021 NUMADULTHABITAN021,"
						+ "t1.NOMBRE_REP_021 NOMBREREP021,t1.APEL1_REP_021 APEL1REP021,t1.APEL2_REP_021 APEL2REP021,t1.ID_012_REP ID012REP,"
						+ "t1.NUM_DOC_REP_021 NUMDOCREP021,t1.TELF1_REP_021 TELF1REP021,t1.TELF2_REP_021 TELF2REP021,t1.TIPO_NOTIFICACION_021 TIPONOTIFICACION021, "
						+ "nvl(t1.RESOL_FAVORABLE_021,9) RESOLFAVORABLE021, "
						+ "t1.PASE_VIVIENDA_021 PASEVIVIENDA021, t1.SOLI_CERRADA_021 SOLICERRADA021, t1.NOTIF_LEIDA_021 NOTIFLEIDA021, t1.REQ_LEIDO_021 REQLEIDO021 ");
		query.append("FROM AA83B21T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b21t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b21t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b21t00 table using like.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b21t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b21t00> findAllLike(Aa83b21t00 aa83b21t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		String formatoHora = Aa83BConstants.ES_PATTERN_HORA_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
			formatoHora = Aa83BConstants.EU_PATTERN_HORA_COMPLETA;
		}
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_ANO_021 IDANO021, t1.ID_021 ID021, t1.TELF_NOTIFICACION_021 TELFNOTIFICACION021, t1.NUM_REG_021 NUMREG021, TO_CHAR(t1.FEC_REG_021,"
						+ formatoHora
						+ ") FECHA021, t1.NOMBRE_021 NOMBRE021, t1.APEL1_021 APEL1021, t1.APEL2_021 APEL2021, t1.ID_012_TIPO_DOC ID012TIPODOC, t1.NUM_DOC_021 NUMDOC021, t1.ID_017_GENERO ID017GENERO, t1.TELF1_021 TELF1021, t1.TELF2_021 TELF2021, t1.EMAIL_021 EMAIL021, to_char(t1.F_NAC_021,"
						+ formato
						+ ") FNAC021, t1.NACIONALIDAD_021 NACIONALIDAD021, t1.LOCALIDAD_EMP_021 LOCALIDADEMP021, t1.PROV_EMP_021 PROVEMP021, "
						+ "t1.IDIOMA_COMUNIC_021 IDIOMACOMUNIC021, t1.PROVINCIA_COMUNIC_021 PROVINCIACOMUNIC021, t1.MUNICIP_COMUNIC_021 MUNICIPCOMUNIC021, "
						+ "t1.CALLE_COMUNIC_021 CALLECOMUNIC021, t1.NUMERO_COMUNIC_021 NUMEROCOMUNIC021, t1.BIS_COMUNIC_021 BISCOMUNIC021, t1.PISO_COMUNIC_021 PISOCOMUNIC021, "
						+ "t1.LETRA_COMUNIC_021 LETRACOMUNIC021, t1.CPOSTAL_COMUNIC_021 CPOSTALCOMUNIC021, t1.CONSENTIMIENTOS_021 CONSENTIMIENTOS021, "
						+ "t1.CONSENTIMIENTOS2_021 CONSENTIMIENTOS2021, t1.MOTIVO_OTROS_021 MOTIVOOTROS021, t1.ID_015_MOTIVOS_SOL ID015MOTIVOSSOL, "
						+ "t1.ID_014_TITULARIDAD_VIV ID014TITULARIDADVIV, t1.ID_016_DERECHOS_OCUP ID016DERECHOSOCUP, t1.DERECHO_OC_OTROS_021 DERECHOOCOTROS021, "
						+ "t1.CALLE_021 CALLE021, t1.NUM_CALLE_021 NUMCALLE021, t1.BIS_021 BIS021, t1.PISO_021 PISO021, t1.LETRA_021 LETRA021, t1.CP_021 CP021, "
						+ "t1.MUNICIPIO_021 MUNICIPIO021, t1.PROVINCIA_021 PROVINCIA021, t1.NUM_PERS_REAGRUPAR_021 NUMPERSREAGRUPAR021, "
						+ "t1.NUM_PERS_HABITAN_021 NUMPERSHABITAN021, t1.UDS_FAM_HABITAN_021 UDSFAMHABITAN021, t1.NUM_MENORES_HABITAN_021 NUMMENORESHABITAN021, "
						+ "t1.NUM_ADULT_HABITAN_021 NUMADULTHABITAN021, t1.NOMBRE_REP_021 NOMBREREP021, t1.APEL1_REP_021 APEL1REP021, t1.APEL2_REP_021 APEL2REP021, "
						+ "t1.ID_012_REP ID012REP, t1.NUM_DOC_REP_021 NUMDOCREP021, t1.TELF1_REP_021 TELF1REP021, t1.TELF2_REP_021 TELF2REP021, "
						+ "t1.TIPO_NOTIFICACION_021 TIPONOTIFICACION021, nvl(t1.RESOL_FAVORABLE_021,9) RESOLFAVORABLE021, t1.OBSERVACIONES_021 OBSERVACIONES021, "
						+ "t1.PASE_VIVIENDA_021 PASEVIVIENDA021, t1.SOLI_CERRADA_021 SOLICERRADA021, t1.NOTIF_LEIDA_021 NOTIFLEIDA021 , t1.REQ_LEIDO_021 REQLEIDO021  ");
		query.append("FROM AA83B21T00 t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b21t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY t1.ID_021 DESC ");
		List<?> params = (List<?>) mapaWhere.get("params");
		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		return (List<Aa83b21t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap4, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b21t00 table.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b21t00 aa83b21t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B21T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b21t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b21t00 table using like.
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b21t00 aa83b21t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B21T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b21t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b21t00 selected for rup_table
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b21t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b21t00>> reorderSelection(
			Aa83b21t00 aa83b21t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_ANO_021 IDANO021,t1.ID_021 ID021,t1.NOMBRE_021 NOMBRE021,t1.APEL1_021 APEL1021,t1.APEL2_021 APEL2021," +
				"t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_021 NUMDOC021,t1.ID_017_GENERO ID017GENERO,t1.TELF1_021 TELF1021," +
				"t1.TELF2_021 TELF2021,t1.EMAIL_021 EMAIL021,TO_CHAR(t1.F_NAC_021,"+ formato+ ") FNAC021,t1.NACIONALIDAD_021 NACIONALIDAD021," +
				"t1.LOCALIDAD_EMP_021 LOCALIDADEMP021,t1.PROV_EMP_021 PROVEMP021,t1.IDIOMA_COMUNIC_021 IDIOMACOMUNIC021," +
				"t1.PROVINCIA_COMUNIC_021 PROVINCIACOMUNIC021,t1.MUNICIP_COMUNIC_021 MUNICIPCOMUNIC021,t1.CALLE_COMUNIC_021 CALLECOMUNIC021," +
				"t1.NUMERO_COMUNIC_021 NUMEROCOMUNIC021,t1.BIS_COMUNIC_021 BISCOMUNIC021,t1.PISO_COMUNIC_021 PISOCOMUNIC021," +
				"t1.LETRA_COMUNIC_021 LETRACOMUNIC021,t1.CPOSTAL_COMUNIC_021 CPOSTALCOMUNIC021,t1.CONSENTIMIENTOS_021 CONSENTIMIENTOS021," +
				"t1.CONSENTIMIENTOS2_021 CONSENTIMIENTOS2021,t1.MOTIVO_OTROS_021 MOTIVOOTROS021,t1.ID_015_MOTIVOS_SOL ID015MOTIVOSSOL," +
				"t1.ID_014_TITULARIDAD_VIV ID014TITULARIDADVIV,t1.ID_016_DERECHOS_OCUP ID016DERECHOSOCUP," +
				"t1.DERECHO_OC_OTROS_021 DERECHOOCOTROS021,t1.CALLE_021 CALLE021,t1.NUM_CALLE_021 NUMCALLE021,t1.BIS_021 BIS021, " +
				"t1.PISO_021 PISO021,t1.LETRA_021 LETRA021,t1.CP_021 CP021,t1.MUNICIPIO_021 MUNICIPIO021,t1.PROVINCIA_021 PROVINCIA021," +
				"t1.NUM_PERS_REAGRUPAR_021 NUMPERSREAGRUPAR021,t1.NUM_PERS_HABITAN_021 NUMPERSHABITAN021," +
				"t1.UDS_FAM_HABITAN_021 UDSFAMHABITAN021,t1.NUM_MENORES_HABITAN_021 NUMMENORESHABITAN021," +
				"t1.NUM_ADULT_HABITAN_021 NUMADULTHABITAN021,t1.NOMBRE_REP_021 NOMBREREP021,t1.APEL1_REP_021 APEL1REP021," +
				"t1.APEL2_REP_021 APEL2REP021,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_021 NUMDOCREP021,t1.TELF1_REP_021 TELF1REP021," +
				"t1.TELF2_REP_021 TELF2REP021,t1.TIPO_NOTIFICACION_021 TIPONOTIFICACION021 ");
		// FROM
		query.append("FROM AA83B21T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b21t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b21t00.class, filterParamList,
				"ID_ANO_021,ID_021");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b21t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b21t00
	 * @param searchParams
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b21t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b21t00>> search(Aa83b21t00 filterParams,
			Aa83b21t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_ANO_021 IDANO021,t1.ID_021 ID021,t1.NOMBRE_021 NOMBRE021,t1.APEL1_021 APEL1021,t1.APEL2_021 APEL2021," +
				"t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_021 NUMDOC021,t1.ID_017_GENERO ID017GENERO,t1.TELF1_021 TELF1021," +
				"t1.TELF2_021 TELF2021,t1.EMAIL_021 EMAIL021,TO_CHAR(t1.F_NAC_021,"+ formato+ ") FNAC021,t1.NACIONALIDAD_021 NACIONALIDAD021," +
				"t1.LOCALIDAD_EMP_021 LOCALIDADEMP021,t1.PROV_EMP_021 PROVEMP021,t1.IDIOMA_COMUNIC_021 IDIOMACOMUNIC021," +
				"t1.PROVINCIA_COMUNIC_021 PROVINCIACOMUNIC021,t1.MUNICIP_COMUNIC_021 MUNICIPCOMUNIC021,t1.CALLE_COMUNIC_021 CALLECOMUNIC021," +
				"t1.NUMERO_COMUNIC_021 NUMEROCOMUNIC021,t1.BIS_COMUNIC_021 BISCOMUNIC021,t1.PISO_COMUNIC_021 PISOCOMUNIC021," +
				"t1.LETRA_COMUNIC_021 LETRACOMUNIC021,t1.CPOSTAL_COMUNIC_021 CPOSTALCOMUNIC021,t1.CONSENTIMIENTOS_021 CONSENTIMIENTOS021," +
				"t1.CONSENTIMIENTOS2_021 CONSENTIMIENTOS2021,t1.MOTIVO_OTROS_021 MOTIVOOTROS021,t1.ID_015_MOTIVOS_SOL ID015MOTIVOSSOL," +
				"t1.ID_014_TITULARIDAD_VIV ID014TITULARIDADVIV,t1.ID_016_DERECHOS_OCUP ID016DERECHOSOCUP," +
				"t1.DERECHO_OC_OTROS_021 DERECHOOCOTROS021,t1.CALLE_021 CALLE021,t1.NUM_CALLE_021 NUMCALLE021,t1.BIS_021 BIS021," +
				"t1.PISO_021 PISO021,t1.LETRA_021 LETRA021,t1.CP_021 CP021,t1.MUNICIPIO_021 MUNICIPIO021,t1.PROVINCIA_021 PROVINCIA021," +
				"t1.NUM_PERS_REAGRUPAR_021 NUMPERSREAGRUPAR021,t1.NUM_PERS_HABITAN_021 NUMPERSHABITAN021," +
				"t1.UDS_FAM_HABITAN_021 UDSFAMHABITAN021,t1.NUM_MENORES_HABITAN_021 NUMMENORESHABITAN021," +
				"t1.NUM_ADULT_HABITAN_021 NUMADULTHABITAN021,t1.NOMBRE_REP_021 NOMBREREP021,t1.APEL1_REP_021 APEL1REP021," +
				"t1.APEL2_REP_021 APEL2REP021,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_021 NUMDOCREP021,t1.TELF1_REP_021 TELF1REP021," +
				"t1.TELF2_REP_021 TELF2REP021,t1.TIPO_NOTIFICACION_021 TIPONOTIFICACION021 ");
		// FROM
		query.append("FROM AA83B21T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b21t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_ANO_021,ID_021");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b21t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b21t00 filteraa83b21t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_ANO_021 IDANO021,t1.ID_021 ID021,t1.NOMBRE_021 NOMBRE021,t1.APEL1_021 APEL1021,t1.APEL2_021 APEL2021,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_021 NUMDOC021,t1.ID_017_GENERO ID017GENERO,t1.TELF1_021 TELF1021,t1.TELF2_021 TELF2021,t1.EMAIL_021 EMAIL021,TO_CHAR(t1.F_NAC_021,"
						+ formato
						+ ") FNAC021,t1.NACIONALIDAD_021 NACIONALIDAD021,t1.LOCALIDAD_EMP_021 LOCALIDADEMP021,t1.PROV_EMP_021 PROVEMP021,t1.IDIOMA_COMUNIC_021 IDIOMACOMUNIC021,t1.PROVINCIA_COMUNIC_021 PROVINCIACOMUNIC021,t1.MUNICIP_COMUNIC_021 MUNICIPCOMUNIC021,t1.CALLE_COMUNIC_021 CALLECOMUNIC021,t1.NUMERO_COMUNIC_021 NUMEROCOMUNIC021,t1.PISO_COMUNIC_021 PISOCOMUNIC021,t1.LETRA_COMUNIC_021 LETRACOMUNIC021,t1.CPOSTAL_COMUNIC_021 CPOSTALCOMUNIC021,t1.CONSENTIMIENTOS_021 CONSENTIMIENTOS021,t1.CONSENTIMIENTOS2_021 CONSENTIMIENTOS2021,t1.MOTIVO_OTROS_021 MOTIVOOTROS021,t1.ID_015_MOTIVOS_SOL ID015MOTIVOSSOL,t1.ID_014_TITULARIDAD_VIV ID014TITULARIDADVIV,t1.ID_016_DERECHOS_OCUP ID016DERECHOSOCUP,t1.DERECHO_OC_OTROS_021 DERECHOOCOTROS021,t1.CALLE_021 CALLE021,t1.NUM_CALLE_021 NUMCALLE021,t1.PISO_021 PISO021,t1.LETRA_021 LETRA021,t1.CP_021 CP021,t1.MUNICIPIO_021 MUNICIPIO021,t1.PROVINCIA_021 PROVINCIA021,t1.NUM_PERS_REAGRUPAR_021 NUMPERSREAGRUPAR021,t1.NUM_PERS_HABITAN_021 NUMPERSHABITAN021,t1.UDS_FAM_HABITAN_021 UDSFAMHABITAN021,t1.NUM_MENORES_HABITAN_021 NUMMENORESHABITAN021,t1.NUM_ADULT_HABITAN_021 NUMADULTHABITAN021,t1.NOMBRE_REP_021 NOMBREREP021,t1.APEL1_REP_021 APEL1REP021,t1.APEL2_REP_021 APEL2REP021,t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_021 NUMDOCREP021,t1.TELF1_REP_021 TELF1REP021,t1.TELF2_REP_021 TELF2REP021,t1.TIPO_NOTIFICACION_021 TIPONOTIFICACION021 ");
		// FROM
		query.append("FROM AA83B21T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b21t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b21t00.class,
						query, params, "ID_ANO_021,ID_021");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b21t00 table.
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b21t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b21t00>> findAllLikeJerarquia(
			Aa83b21t00 filterAa83b21t00, JQGridRequestDto jqGridRequestDto) {
		String formato = Aa83BConstants.ES_PATTERN_COMPLETA;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_COMPLETA;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_ANO_021 IDANO021, t1.ID_021 ID021, t1.TELF_NOTIFICACION_021 TELFNOTIFICACION021, t1.NOMBRE_021 NOMBRE021,t1.APEL1_021 APEL1021,t1.APEL2_021 APEL2021,t1.ID_012_TIPO_DOC ID012TIPODOC,t1.NUM_DOC_021 NUMDOC021,t1.ID_017_GENERO ID017GENERO,t1.TELF1_021 TELF1021,t1.TELF2_021 TELF2021,t1.EMAIL_021 EMAIL021,TO_CHAR(t1.F_NAC_021,"
						+ formato
						+ ") FNAC021,t1.NACIONALIDAD_021 NACIONALIDAD021,t1.LOCALIDAD_EMP_021 LOCALIDADEMP021,t1.PROV_EMP_021 PROVEMP021,t1.IDIOMA_COMUNIC_021 IDIOMACOMUNIC021,t1.PROVINCIA_COMUNIC_021 PROVINCIACOMUNIC021,t1.MUNICIP_COMUNIC_021 MUNICIPCOMUNIC021,t1.CALLE_COMUNIC_021 CALLECOMUNIC021,t1.NUMERO_COMUNIC_021 NUMEROCOMUNIC021,t1.PISO_COMUNIC_021 PISOCOMUNIC021," +
								"t1.LETRA_COMUNIC_021 LETRACOMUNIC021,t1.CPOSTAL_COMUNIC_021 CPOSTALCOMUNIC021," +
								"t1.CONSENTIMIENTOS_021 CONSENTIMIENTOS021,t1.CONSENTIMIENTOS2_021 CONSENTIMIENTOS2021,t1.MOTIVO_OTROS_021 MOTIVOOTROS021,t1.ID_015_MOTIVOS_SOL ID015MOTIVOSSOL,t1.ID_014_TITULARIDAD_VIV ID014TITULARIDADVIV,t1.ID_016_DERECHOS_OCUP ID016DERECHOSOCUP,t1.DERECHO_OC_OTROS_021 DERECHOOCOTROS021,t1.CALLE_021 CALLE021,t1.NUM_CALLE_021 NUMCALLE021,t1.PISO_021 PISO021," +
								"t1.LETRA_021 LETRA021,t1.CP_021 CP021,t1.MUNICIPIO_021 MUNICIPIO021,t1.PROVINCIA_021 PROVINCIA021,t1.NUM_PERS_REAGRUPAR_021 NUMPERSREAGRUPAR021,t1.NUM_PERS_HABITAN_021 NUMPERSHABITAN021,t1.UDS_FAM_HABITAN_021 UDSFAMHABITAN021,t1.NUM_MENORES_HABITAN_021 NUMMENORESHABITAN021,t1.NUM_ADULT_HABITAN_021 NUMADULTHABITAN021,t1.NOMBRE_REP_021 NOMBREREP021,t1.APEL1_REP_021 APEL1REP021,t1.APEL2_REP_021 APEL2REP021," +
								"t1.ID_012_REP ID012REP,t1.NUM_DOC_REP_021 NUMDOCREP021,t1.TELF1_REP_021 TELF1REP021,t1.TELF2_REP_021 TELF2REP021," +
								"t1.TIPO_NOTIFICACION_021 TIPONOTIFICACION021, t1.NOTIF_LEIDA_021 NOTIFLEIDA021, t1.REQ_LEIDO_021 REQLEIDO021");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B21T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B21T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b21t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_ANO_021,ID_021", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b21t00 filterAa83b21t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B21T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B21T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b21t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_ANO_021,ID_021", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b21t00
	 *            Aa83b21t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b21t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b21t00>> findAllChild(
			Aa83b21t00 filterAa83b21t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B21T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B21T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b21t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_ANO_021,ID_021", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa83b21t00>(this.rwMapPK,
						"ID_ANO_021,ID_021"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b21t00 entity
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b21t00 aa83b21t00) {

		StringBuilder where = new StringBuilder(
				Aa83b21t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b21t00 != null && aa83b21t00.getIdAno021() != null) {
			where.append(" AND t1.ID_ANO_021 = ?");
			params.add(aa83b21t00.getIdAno021());
		}
		if (aa83b21t00 != null && aa83b21t00.getId021() != null) {
			where.append(" AND t1.ID_021 = ?");
			params.add(aa83b21t00.getId021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNombre021() != null) {
			where.append(" AND t1.NOMBRE_021 = ?");
			params.add(aa83b21t00.getNombre021());
		}
		if (aa83b21t00 != null && aa83b21t00.getApel1021() != null) {
			where.append(" AND t1.APEL1_021 = ?");
			params.add(aa83b21t00.getApel1021());
		}
		if (aa83b21t00 != null && aa83b21t00.getApel2021() != null) {
			where.append(" AND t1.APEL2_021 = ?");
			params.add(aa83b21t00.getApel2021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumReg021() != null) {
			where.append(" AND t1.NUM_REG_021 = ?");
			params.add(aa83b21t00.getNumReg021());
		}
		if (aa83b21t00 != null && aa83b21t00.getId012TipoDoc() != null) {
			where.append(" AND t1.ID_012_TIPO_DOC = ?");
			params.add(aa83b21t00.getId012TipoDoc());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumDoc021() != null) {
			where.append(" AND t1.NUM_DOC_021 = ?");
			params.add(aa83b21t00.getNumDoc021());
		}
		if (aa83b21t00 != null && aa83b21t00.getId017Genero() != null) {
			where.append(" AND t1.ID_017_GENERO = ?");
			params.add(aa83b21t00.getId017Genero());
		}
		if (aa83b21t00 != null && aa83b21t00.getTelf1021() != null) {
			where.append(" AND t1.TELF1_021 = ?");
			params.add(aa83b21t00.getTelf1021());
		}
		if (aa83b21t00 != null && aa83b21t00.getTelf2021() != null) {
			where.append(" AND t1.TELF2_021 = ?");
			params.add(aa83b21t00.getTelf2021());
		}
		if (aa83b21t00 != null && aa83b21t00.getEmail021() != null) {
			where.append(" AND t1.EMAIL_021 = ?");
			params.add(aa83b21t00.getEmail021());
		}
		if (aa83b21t00 != null && aa83b21t00.getfNac021() != null) {
			where.append(" AND t1.F_NAC_021 = ?");
			params.add(aa83b21t00.getfNac021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNacionalidad021() != null) {
			where.append(" AND t1.NACIONALIDAD_021 = ?");
			params.add(aa83b21t00.getNacionalidad021());
		}
		if (aa83b21t00 != null && aa83b21t00.getLocalidadEmp021() != null) {
			where.append(" AND t1.LOCALIDAD_EMP_021 = ?");
			params.add(aa83b21t00.getLocalidadEmp021());
		}
		if (aa83b21t00 != null && aa83b21t00.getProvEmp021() != null) {
			where.append(" AND t1.PROV_EMP_021 = ?");
			params.add(aa83b21t00.getProvEmp021());
		}
		if (aa83b21t00 != null && aa83b21t00.getIdiomaComunic021() != null) {
			where.append(" AND t1.IDIOMA_COMUNIC_021 = ?");
			params.add(aa83b21t00.getIdiomaComunic021());
		}
		if (aa83b21t00 != null && aa83b21t00.getProvinciaComunic021() != null) {
			where.append(" AND t1.PROVINCIA_COMUNIC_021 = ?");
			params.add(aa83b21t00.getProvinciaComunic021());
		}
		if (aa83b21t00 != null && aa83b21t00.getMunicipComunic021() != null) {
			where.append(" AND t1.MUNICIP_COMUNIC_021 = ?");
			params.add(aa83b21t00.getMunicipComunic021());
		}
		if (aa83b21t00 != null && aa83b21t00.getCalleComunic021() != null) {
			where.append(" AND t1.CALLE_COMUNIC_021 = ?");
			params.add(aa83b21t00.getCalleComunic021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumeroComunic021() != null) {
			where.append(" AND t1.NUMERO_COMUNIC_021 = ?");
			params.add(aa83b21t00.getNumeroComunic021());
		}
		if (aa83b21t00 != null && aa83b21t00.getPisoComunic021() != null) {
			where.append(" AND t1.PISO_COMUNIC_021 = ?");
			params.add(aa83b21t00.getPisoComunic021());
		}
		if (aa83b21t00 != null && aa83b21t00.getLetraComunic021() != null) {
			where.append(" AND t1.LETRA_COMUNIC_021 = ?");
			params.add(aa83b21t00.getLetraComunic021());
		}
		if (aa83b21t00 != null && aa83b21t00.getCpostalComunic021() != null) {
			where.append(" AND t1.CPOSTAL_COMUNIC_021 = ?");
			params.add(aa83b21t00.getCpostalComunic021());
		}
		if (aa83b21t00 != null && aa83b21t00.getConsentimientos021() != null) {
			where.append(" AND t1.CONSENTIMIENTOS_021 = ?");
			params.add(aa83b21t00.getConsentimientos021());
		}
		if (aa83b21t00 != null && aa83b21t00.getConsentimientos2021() != null) {
			where.append(" AND t1.CONSENTIMIENTOS2_021 = ?");
			params.add(aa83b21t00.getConsentimientos2021());
		}
		if (aa83b21t00 != null && aa83b21t00.getMotivoOtros021() != null) {
			where.append(" AND t1.MOTIVO_OTROS_021 = ?");
			params.add(aa83b21t00.getMotivoOtros021());
		}
		if (aa83b21t00 != null && aa83b21t00.getId015MotivosSol() != null) {
			where.append(" AND t1.ID_015_MOTIVOS_SOL = ?");
			params.add(aa83b21t00.getId015MotivosSol());
		}
		if (aa83b21t00 != null && aa83b21t00.getId014TitularidadViv() != null) {
			where.append(" AND t1.ID_014_TITULARIDAD_VIV = ?");
			params.add(aa83b21t00.getId014TitularidadViv());
		}
		if (aa83b21t00 != null && aa83b21t00.getId016DerechosOcup() != null) {
			where.append(" AND t1.ID_016_DERECHOS_OCUP = ?");
			params.add(aa83b21t00.getId016DerechosOcup());
		}
		if (aa83b21t00 != null && aa83b21t00.getDerechoOcOtros021() != null) {
			where.append(" AND t1.DERECHO_OC_OTROS_021 = ?");
			params.add(aa83b21t00.getDerechoOcOtros021());
		}
		if (aa83b21t00 != null && aa83b21t00.getCalle021() != null) {
			where.append(" AND t1.CALLE_021 = ?");
			params.add(aa83b21t00.getCalle021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumCalle021() != null) {
			where.append(" AND t1.NUM_CALLE_021 = ?");
			params.add(aa83b21t00.getNumCalle021());
		}
		if (aa83b21t00 != null && aa83b21t00.getPiso021() != null) {
			where.append(" AND t1.PISO_021 = ?");
			params.add(aa83b21t00.getPiso021());
		}
		if (aa83b21t00 != null && aa83b21t00.getLetra021() != null) {
			where.append(" AND t1.LETRA_021 = ?");
			params.add(aa83b21t00.getLetra021());
		}
		if (aa83b21t00 != null && aa83b21t00.getCp021() != null) {
			where.append(" AND t1.CP_021 = ?");
			params.add(aa83b21t00.getCp021());
		}
		if (aa83b21t00 != null && aa83b21t00.getMunicipio021() != null) {
			where.append(" AND t1.MUNICIPIO_021 = ?");
			params.add(aa83b21t00.getMunicipio021());
		}
		if (aa83b21t00 != null && aa83b21t00.getProvincia021() != null) {
			where.append(" AND t1.PROVINCIA_021 = ?");
			params.add(aa83b21t00.getProvincia021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumPersReagrupar021() != null) {
			where.append(" AND t1.NUM_PERS_REAGRUPAR_021 = ?");
			params.add(aa83b21t00.getNumPersReagrupar021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumPersHabitan021() != null) {
			where.append(" AND t1.NUM_PERS_HABITAN_021 = ?");
			params.add(aa83b21t00.getNumPersHabitan021());
		}
		if (aa83b21t00 != null && aa83b21t00.getUdsFamHabitan021() != null) {
			where.append(" AND t1.UDS_FAM_HABITAN_021 = ?");
			params.add(aa83b21t00.getUdsFamHabitan021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumMenoresHabitan021() != null) {
			where.append(" AND t1.NUM_MENORES_HABITAN_021 = ?");
			params.add(aa83b21t00.getNumMenoresHabitan021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumAdultHabitan021() != null) {
			where.append(" AND t1.NUM_ADULT_HABITAN_021 = ?");
			params.add(aa83b21t00.getNumAdultHabitan021());
		}
		if (aa83b21t00 != null && aa83b21t00.getNombreRep021() != null) {
			where.append(" AND t1.NOMBRE_REP_021 = ?");
			params.add(aa83b21t00.getNombreRep021());
		}
		if (aa83b21t00 != null && aa83b21t00.getApel1Rep021() != null) {
			where.append(" AND t1.APEL1_REP_021 = ?");
			params.add(aa83b21t00.getApel1Rep021());
		}
		if (aa83b21t00 != null && aa83b21t00.getApel2Rep021() != null) {
			where.append(" AND t1.APEL2_REP_021 = ?");
			params.add(aa83b21t00.getApel2Rep021());
		}
		if (aa83b21t00 != null && aa83b21t00.getId012Rep() != null) {
			where.append(" AND t1.ID_012_REP = ?");
			params.add(aa83b21t00.getId012Rep());
		}
		if (aa83b21t00 != null && aa83b21t00.getNumDocRep021() != null) {
			where.append(" AND t1.NUM_DOC_REP_021 = ?");
			params.add(aa83b21t00.getNumDocRep021());
		}
		if (aa83b21t00 != null && aa83b21t00.getTelf1Rep021() != null) {
			where.append(" AND t1.TELF1_REP_021 = ?");
			params.add(aa83b21t00.getTelf1Rep021());
		}
		if (aa83b21t00 != null && aa83b21t00.getTelf2Rep021() != null) {
			where.append(" AND t1.TELF2_REP_021 = ?");
			params.add(aa83b21t00.getTelf2Rep021());
		}
		if (aa83b21t00 != null && aa83b21t00.getTipoNotificacion021() != null) {
			where.append(" AND t1.TIPO_NOTIFICACION_021 = ?");
			params.add(aa83b21t00.getTipoNotificacion021());
		}

		if (aa83b21t00 != null && aa83b21t00.getTelf_notificacion_021() != null) {
			where.append(" AND t1.TELF_NOTIFICACION_021 = ?");
			params.add(aa83b21t00.getTelf_notificacion_021());
		}

		if (aa83b21t00 != null && aa83b21t00.getReqSubsanaLeido021() != null) {
			where.append(" AND t1.REQ_LEIDO_021 = ?");
			params.add(aa83b21t00.getReqSubsanaLeido021());
		}

		
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b21t00 entity
	 * 
	 * @param aa83b21t00
	 *            Aa83b21t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b21t00 aa83b21t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b21t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b21t00 != null) {
			if (aa83b21t00.getIdAno021() != null) {
				where.append(" AND t1.ID_ANO_021 = ?");
				params.add(aa83b21t00.getIdAno021());
			}
			if (aa83b21t00.getId021() != null) {
				where.append(" AND t1.ID_021 = ?");
				params.add(aa83b21t00.getId021());
			}
			if (aa83b21t00.getNombre021() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.NOMBRE_021,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b21t00.getNombre021()
							.toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b21t00.getNombre021()
									.toUpperCase()) + "%");
				}
				where.append(" AND t1.NOMBRE_021 IS NOT NULL");
			}
			if (aa83b21t00.getApel1021() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.APEL1_021,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b21t00.getApel1021()
							.toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b21t00.getApel1021()
									.toUpperCase()) + "%");
				}
				where.append(" AND t1.APEL1_021 IS NOT NULL");
			}
			if (aa83b21t00.getApel2021() != null) {
				where.append(" AND UPPER(TRANSLATE(t1.APEL2_021,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(Aa83bUtilidades.SinTildes(aa83b21t00.getApel2021()
							.toUpperCase()) + "%");
				} else {
					params.add("%"
							+ Aa83bUtilidades.SinTildes(aa83b21t00.getApel2021()
									.toUpperCase()) + "%");
				}
				where.append(" AND t1.APEL2_021 IS NOT NULL");
			}
			if (aa83b21t00.getNumReg021() != null) {
				where.append(" AND UPPER(t1.NUM_REG_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getNumReg021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getNumReg021().toUpperCase() + "%");
				}
				where.append(" AND t1.NUM_REG_021 IS NOT NULL");
			}
			if (aa83b21t00.getId012TipoDoc() != null) {
				where.append(" AND t1.ID_012_TIPO_DOC = ?");
				params.add(aa83b21t00.getId012TipoDoc());
			}
			if (aa83b21t00.getNumDoc021() != null) {
				where.append(" AND UPPER(t1.NUM_DOC_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getNumDoc021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getNumDoc021().toUpperCase() + "%");
				}
				where.append(" AND t1.NUM_DOC_021 IS NOT NULL");
			}
			if (aa83b21t00.getId017Genero() != null) {
				where.append(" AND t1.ID_017_GENERO = ?");
				params.add(aa83b21t00.getId017Genero());
			}
			if (aa83b21t00.getTelf1021() != null) {
				where.append(" AND UPPER(t1.TELF1_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getTelf1021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getTelf1021().toUpperCase() + "%");
				}
				where.append(" AND t1.TELF1_021 IS NOT NULL");
			}
			if (aa83b21t00.getTelf2021() != null) {
				where.append(" AND UPPER(t1.TELF2_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getTelf2021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getTelf2021().toUpperCase() + "%");
				}
				where.append(" AND t1.TELF2_021 IS NOT NULL");
			}
			if (aa83b21t00.getEmail021() != null) {
				where.append(" AND UPPER(t1.EMAIL_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getEmail021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getEmail021().toUpperCase() + "%");
				}
				where.append(" AND t1.EMAIL_021 IS NOT NULL");
			}
			if (aa83b21t00.getfNac021() != null) {
				where.append(" AND t1.F_NAC_021 = ?");
				params.add(aa83b21t00.getfNac021());
			}
			if (aa83b21t00.getNacionalidad021() != null) {
				where.append(" AND t1.NACIONALIDAD_021 = ?");
				params.add(aa83b21t00.getNacionalidad021());
			}
			if (aa83b21t00.getLocalidadEmp021() != null) {
				where.append(" AND t1.LOCALIDAD_EMP_021 = ?");
				params.add(aa83b21t00.getLocalidadEmp021());
			}
			if (aa83b21t00.getProvEmp021() != null) {
				where.append(" AND t1.PROV_EMP_021 = ?");
				params.add(aa83b21t00.getProvEmp021());
			}
			if (aa83b21t00.getIdiomaComunic021() != null) {
				where.append(" AND t1.IDIOMA_COMUNIC_021 = ?");
				params.add(aa83b21t00.getIdiomaComunic021());
			}
			if (aa83b21t00.getProvinciaComunic021() != null) {
				where.append(" AND t1.PROVINCIA_COMUNIC_021 = ?");
				params.add(aa83b21t00.getProvinciaComunic021());
			}
			if (aa83b21t00.getMunicipComunic021() != null) {
				where.append(" AND t1.MUNICIP_COMUNIC_021 = ?");
				params.add(aa83b21t00.getMunicipComunic021());
			}
			if (aa83b21t00.getCalleComunic021() != null) {
				where.append(" AND UPPER(t1.CALLE_COMUNIC_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getCalleComunic021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getCalleComunic021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CALLE_COMUNIC_021 IS NOT NULL");
			}
			if (aa83b21t00.getNumeroComunic021() != null) {
				where.append(" AND UPPER(t1.NUMERO_COMUNIC_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getNumeroComunic021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getNumeroComunic021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUMERO_COMUNIC_021 IS NOT NULL");
			}
			if (aa83b21t00.getPisoComunic021() != null) {
				where.append(" AND UPPER(t1.PISO_COMUNIC_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getPisoComunic021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getPisoComunic021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.PISO_COMUNIC_021 IS NOT NULL");
			}
			if (aa83b21t00.getLetraComunic021() != null) {
				where.append(" AND UPPER(t1.LETRA_COMUNIC_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getLetraComunic021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getLetraComunic021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.LETRA_COMUNIC_021 IS NOT NULL");
			}
			if (aa83b21t00.getCpostalComunic021() != null) {
				where.append(" AND t1.CPOSTAL_COMUNIC_021 = ?");
				params.add(aa83b21t00.getCpostalComunic021());
			}
			if (aa83b21t00.getConsentimientos021() != null) {
				where.append(" AND UPPER(t1.CONSENTIMIENTOS_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getConsentimientos021().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b21t00.getConsentimientos021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CONSENTIMIENTOS_021 IS NOT NULL");
			}
			if (aa83b21t00.getConsentimientos2021() != null) {
				where.append(" AND UPPER(t1.CONSENTIMIENTOS2_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getConsentimientos2021().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b21t00.getConsentimientos2021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CONSENTIMIENTOS2_021 IS NOT NULL");
			}
			if (aa83b21t00.getMotivoOtros021() != null) {
				where.append(" AND UPPER(t1.MOTIVO_OTROS_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getMotivoOtros021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getMotivoOtros021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.MOTIVO_OTROS_021 IS NOT NULL");
			}
			if (aa83b21t00.getId015MotivosSol() != null) {
				where.append(" AND t1.ID_015_MOTIVOS_SOL = ?");
				params.add(aa83b21t00.getId015MotivosSol());
			}
			if (aa83b21t00.getId014TitularidadViv() != null) {
				where.append(" AND t1.ID_014_TITULARIDAD_VIV = ?");
				params.add(aa83b21t00.getId014TitularidadViv());
			}
			if (aa83b21t00.getId016DerechosOcup() != null) {
				where.append(" AND t1.ID_016_DERECHOS_OCUP = ?");
				params.add(aa83b21t00.getId016DerechosOcup());
			}
			if (aa83b21t00.getDerechoOcOtros021() != null) {
				where.append(" AND UPPER(t1.DERECHO_OC_OTROS_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getDerechoOcOtros021().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b21t00.getDerechoOcOtros021().toUpperCase() + "%");
				}
				where.append(" AND t1.DERECHO_OC_OTROS_021 IS NOT NULL");
			}
			if (aa83b21t00.getCalle021() != null) {
				where.append(" AND UPPER(t1.CALLE_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getCalle021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getCalle021().toUpperCase() + "%");
				}
				where.append(" AND t1.CALLE_021 IS NOT NULL");
			}
			if (aa83b21t00.getNumCalle021() != null) {
				where.append(" AND UPPER(t1.NUM_CALLE_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getNumCalle021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getNumCalle021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUM_CALLE_021 IS NOT NULL");
			}
			if (aa83b21t00.getPiso021() != null) {
				where.append(" AND UPPER(t1.PISO_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getPiso021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getPiso021().toUpperCase() + "%");
				}
				where.append(" AND t1.PISO_021 IS NOT NULL");
			}
			if (aa83b21t00.getLetra021() != null) {
				where.append(" AND UPPER(t1.LETRA_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getLetra021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getLetra021().toUpperCase() + "%");
				}
				where.append(" AND t1.LETRA_021 IS NOT NULL");
			}
			if (aa83b21t00.getCp021() != null) {
				where.append(" AND t1.CP_021 = ?");
				params.add(aa83b21t00.getCp021());
			}
			if (aa83b21t00.getMunicipio021() != null) {
				where.append(" AND t1.MUNICIPIO_021 = ?");
				params.add(aa83b21t00.getMunicipio021());
			}
			if (aa83b21t00.getProvincia021() != null) {
				where.append(" AND t1.PROVINCIA_021 = ?");
				params.add(aa83b21t00.getProvincia021());
			}
			if (aa83b21t00.getNumPersReagrupar021() != null) {
				where.append(" AND t1.NUM_PERS_REAGRUPAR_021 = ?");
				params.add(aa83b21t00.getNumPersReagrupar021());
			}
			if (aa83b21t00.getNumPersHabitan021() != null) {
				where.append(" AND t1.NUM_PERS_HABITAN_021 = ?");
				params.add(aa83b21t00.getNumPersHabitan021());
			}
			if (aa83b21t00.getUdsFamHabitan021() != null) {
				where.append(" AND t1.UDS_FAM_HABITAN_021 = ?");
				params.add(aa83b21t00.getUdsFamHabitan021());
			}
			if (aa83b21t00.getNumMenoresHabitan021() != null) {
				where.append(" AND t1.NUM_MENORES_HABITAN_021 = ?");
				params.add(aa83b21t00.getNumMenoresHabitan021());
			}
			if (aa83b21t00.getNumAdultHabitan021() != null) {
				where.append(" AND t1.NUM_ADULT_HABITAN_021 = ?");
				params.add(aa83b21t00.getNumAdultHabitan021());
			}
			if (aa83b21t00.getNombreRep021() != null) {
				where.append(" AND UPPER(t1.NOMBRE_REP_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getNombreRep021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getNombreRep021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NOMBRE_REP_021 IS NOT NULL");
			}
			if (aa83b21t00.getApel1Rep021() != null) {
				where.append(" AND UPPER(t1.APEL1_REP_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getApel1Rep021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getApel1Rep021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.APEL1_REP_021 IS NOT NULL");
			}
			if (aa83b21t00.getApel2Rep021() != null) {
				where.append(" AND UPPER(t1.APEL2_REP_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getApel2Rep021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getApel2Rep021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.APEL2_REP_021 IS NOT NULL");
			}
			if (aa83b21t00.getId012Rep() != null) {
				where.append(" AND t1.ID_012_REP = ?");
				params.add(aa83b21t00.getId012Rep());
			}
			if (aa83b21t00.getNumDocRep021() != null) {
				where.append(" AND UPPER(t1.NUM_DOC_REP_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getNumDocRep021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getNumDocRep021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NUM_DOC_REP_021 IS NOT NULL");
			}
			if (aa83b21t00.getTelf1Rep021() != null) {
				where.append(" AND UPPER(t1.TELF1_REP_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getTelf1Rep021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getTelf1Rep021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF1_REP_021 IS NOT NULL");
			}
			if (aa83b21t00.getTelf2Rep021() != null) {
				where.append(" AND UPPER(t1.TELF2_REP_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getTelf2Rep021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getTelf2Rep021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TELF2_REP_021 IS NOT NULL");
			}
	
			// Meto el PASEVIVIENDA
			if (aa83b21t00.getPasarvivienda021() != null) {
				where.append(" AND UPPER(t1.PASE_VIVIENDA_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getPasarvivienda021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getPasarvivienda021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.PASE_VIVIENDA_021 IS NOT NULL");
			}
	
			// Si el campo soli_cerrada_021 = 'N' o Nulo significa que esta
			// abierta la solicitud
			if ("N".equalsIgnoreCase(aa83b21t00.getSolicerrada021())) {
				// where.append(" AND UPPER(t1.SOLI_CERRADA_023) like ? ESCAPE  '\\'");
				where.append(" AND UPPER(nvl(t1.SOLI_CERRADA_021,'N')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getSolicerrada021().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b21t00.getSolicerrada021().toUpperCase()
							+ "%");
				}
				// where.append(" AND t1.SOLI_CERRADA_025 IS NOT NULL");
			}		
	
			if (aa83b21t00.getNotifLeida021() != null) {
				where.append(" AND UPPER(t1.NOTIF_LEIDA_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getSolicerrada021().toUpperCase() + "%");
				} else {
					params.add("%" + aa83b21t00.getSolicerrada021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.NOTIF_LEIDA_021 IS NOT NULL");
			}
	
			if (aa83b21t00.getTipoNotificacion021() != null) {
				where.append(" AND UPPER(t1.TIPO_NOTIFICACION_021) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(aa83b21t00.getTipoNotificacion021().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ aa83b21t00.getTipoNotificacion021().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TIPO_NOTIFICACION_021 IS NOT NULL");
			}
	
			if (aa83b21t00.getTelf_notificacion_021() != null) {
				where.append(" AND t1.TELF_NOTIFICACION_021 = ?");
				params.add(aa83b21t00.getTelf_notificacion_021());
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	public Aa83b21t00 validarSolicitud(Aa83b21t00 aa83b21t00) {
		StringBuffer sql = new StringBuffer();
		// SELECT * FROM AA83B21T00 SOL INNER JOIN AA83B09T00 TRAM
		// ON SOL.ID_021=TRAM.ID_021_NUM_SOL AND SOL.ID_ANO_021=TRAM.ID_ANO_021
		// WHERE TRAM.ID_001_FASE='1' AND TRAM.ID_002_TRAM='3'
		// AND SOL.ID_021=45 AND SOL.ID_ANO_021=2016
		sql.append("SELECT SOL.ID_021 ID021, SOL.ID_ANO_021 IDANO021,SOL.NOMBRE_021 NOMBRE021, FEC_REG_021 FECREG021, NUM_REG_021 NUMREG021 "
				+ "FROM AA83B21T00 SOL INNER JOIN AA83B09T00 TRAM");
		sql.append(" ON SOL.ID_021=TRAM.ID_021_NUM_SOL AND SOL.ID_ANO_021=TRAM.ID_ANO_021");
		sql.append(" WHERE TRAM.ID_001_FASE='1' AND TRAM.ID_002_TRAM='3'");
		sql.append(" AND SOL.ID_021=? AND SOL.ID_ANO_021=?");
		ArrayList<String> params = new ArrayList<String>();
		params.add(String.valueOf(aa83b21t00.getId021()));
		params.add(String.valueOf(aa83b21t00.getIdAno021()));
		List<Aa83b21t00> lista = (List<Aa83b21t00>) this.jdbcTemplate.query(
				sql.toString(), this.rwMap5, params.toArray());
		if (!lista.isEmpty()) {
			aa83b21t00 = lista.get(0);
		}
		return aa83b21t00;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Aa83b21t00 enviarVivienda(Aa83b21t00 aa83b21t00) {
		aa83b21t00.setPasarvivienda021("S");

		String query = "UPDATE AA83B21T00 SET PASE_VIVIENDA_021 = ? "
				+ "WHERE ID_ANO_021=? AND ID_021=? ";
		this.jdbcTemplate.update(query, aa83b21t00.getPasarvivienda021(),
				aa83b21t00.getIdAno021(), aa83b21t00.getId021());
		return aa83b21t00;
	}

	@Override
	public Aa83b21t00 marcarNotifLeida(Aa83b21t00 aa83b21t00) {
		String query = "UPDATE AA83B21T00 SET NOTIF_LEIDA_021 = ? "
				+ "WHERE ID_ANO_021=? AND ID_021=? ";
		this.jdbcTemplate.update(query, "S", aa83b21t00.getIdAno021(),
				aa83b21t00.getId021());
		return aa83b21t00;
	}
	
	@Override
	public Aa83b21t00 marcarReqSubsanaLeido021(Aa83b21t00 aa83b21t00) {

		String query = "UPDATE AA83B21T00 SET REQ_LEIDO_021 = ? "
				+ "WHERE ID_ANO_021=? AND ID_021=? ";
		this.jdbcTemplate.update(query, "S", aa83b21t00.getIdAno021(),
				aa83b21t00.getId021());
		return aa83b21t00;
	}
	

	@Override
	public Aa83b21t00 cerrarExp(Aa83b21t00 aa83b21t00) {
		String query = "UPDATE AA83B21T00 SET NOTIF_LEIDA_021 =? , SOLI_CERRADA_021 = ? "
				+ "WHERE ID_ANO_021=? AND ID_021=? ";
		this.jdbcTemplate.update(query, "S", "S", aa83b21t00.getIdAno021(),
				aa83b21t00.getId021());
		return aa83b21t00;
	}

	@Override
	public Aa83b21t00 cerrarExpReq(Aa83b21t00 aa83b21t00) {
		String query = "UPDATE AA83B21T00 SET NOTIF_LEIDA_021 =? , SOLI_CERRADA_021 = ?, RESOL_FAVORABLE_021=0 "
				+ " WHERE ID_ANO_021=? AND ID_021=? ";
		this.jdbcTemplate.update(query, "S", "S", aa83b21t00.getIdAno021(),
				aa83b21t00.getId021());
		return aa83b21t00;
	}
}
