package com.ejie.aa83b.dao;

import java.io.ByteArrayInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b19t00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa83b19t00DaoImpl generated by UDA, 23-dic-2015 12:32:26.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b19t00DaoImpl implements Aa83b19t00Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b19t00> rwMap = new RowMapper<Aa83b19t00>() {
		public Aa83b19t00 mapRow(ResultSet resultSet, int rowNum)throws SQLException {
			return new Aa83b19t00(resultSet.getInt("ID019"),
					resultSet.getString("NOMBRE019"),
					resultSet.getString("APEL1019"),
					resultSet.getString("APEL2019"),
					resultSet.getString("NUMEMP"),
					resultSet.getInt("IDCARGO005"),
					resultSet.getBlob("FIRMADIGITAL019"),
					resultSet.getString("ACTIVOSN019"), 
					resultSet.getString("CARGOES"),
					resultSet.getString("CARGOEU"), "uno",
					resultSet.getString("FECINIVIGENCIA019"),
					resultSet.getString("FECFINVIGENCIA019")

			);
		}
	};

	private RowMapper<Aa83b19t00> rwMapPK = new RowMapper<Aa83b19t00>() {
		public Aa83b19t00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa83b19t00(resultSet.getInt("ID019"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b19t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b19t00>>() {
		public JerarquiaDto<Aa83b19t00> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Aa83b19t00 aa83b19t00 = new Aa83b19t00(resultSet.getInt("ID019"),
					resultSet.getString("NOMBRE019"),
					resultSet.getString("APEL1019"),
					resultSet.getString("APEL2019"),
					resultSet.getString("NUMEMP"),
					resultSet.getInt("IDCARGO005"),
					resultSet.getBlob("FIRMADIGITAL019"),
					resultSet.getString("ACTIVOSN019"), resultSet.getString("CARGOES"),
					resultSet.getString("CARGOEU"), "dos",
					resultSet.getString("FECINIVIGENCIA019"),
					resultSet.getString("FECFINVIGENCIA019"));

			JerarquiaDto<Aa83b19t00> jerarquia = new JerarquiaDto<Aa83b19t00>();
			jerarquia.setModel(aa83b19t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b19t00 table.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @return Aa83b19t00
	 */
	public Aa83b19t00 add(final Aa83b19t00 aa83b19t00) {

		aa83b19t00.setId019(jdbcTemplate.queryForInt("SELECT SEQ_AA83B19T00_ID_019.NEXTVAL FROM DUAL"));

		final String formatoEs = Aa83BConstants.ES_PATTERN;
		final String formatoEu = Aa83BConstants.EU_PATTERN;

		String query = "INSERT INTO AA83B19T00 (ID_019, NOMBRE_019, APEL1_019, APEL2_019, NUM_EMP, ID_CARGO_005, ACTIVO_SN_019, FEC_INI_VIGENCIA_019, FEC_FIN_VIGENCIA_019, FIRMA_DIGITAL_019) VALUES (?,?,?,?,?,?,?,to_date(?,?),to_date(?,?),?)";//
		this.jdbcTemplate.update(query, new PreparedStatementSetter() {
			public void setValues(PreparedStatement ps) throws SQLException {
				int index = 1;
				ps.setInt(index++, aa83b19t00.getId019());// aa83b19t00.getId019()
				ps.setString(index++, aa83b19t00.getNombre019());
				ps.setString(index++, aa83b19t00.getApel1019());
				ps.setString(index++, aa83b19t00.getApel2019());
				ps.setString(index++, aa83b19t00.getNumEmp());
				ps.setInt(index++, aa83b19t00.getIdCargo005());
				ps.setString(index++, "S");
				ps.setString(index++, aa83b19t00.getFecinivigencia019());
				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
					ps.setString(index++, formatoEu);
				} else {
					ps.setString(index++, formatoEs);
				}
				ps.setString(index++, aa83b19t00.getFecfinvigencia019());
				if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
					ps.setString(index++, formatoEu);
				} else {
					ps.setString(index++, formatoEs);
				}
				ps.setBinaryStream(
						index++,
						new ByteArrayInputStream(aa83b19t00.getFirmaDigital019()), aa83b19t00.getFirmaDigital019().length);
			}
		});

		return aa83b19t00;
	}

	/**
	 * Updates a single row in the Aa83b19t00 table.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @return Aa83b19t00
	 */
	public Aa83b19t00 update(final Aa83b19t00 aa83b19t00) {
		String query = "UPDATE AA83B19T00 SET NOMBRE_019=?, APEL1_019=?, APEL2_019=?, NUM_EMP=?, ID_CARGO_005=?, ACTIVO_SN_019=?, FEC_INI_VIGENCIA_019=trunc(to_date(?,'dd/mm/yyyy')), FEC_FIN_VIGENCIA_019=trunc(to_date(?,'dd/mm/yyyy'))";
		if (aa83b19t00.getFirmaDigital019() != null) {
			query += " ,FIRMA_DIGITAL_019=? ";
		}
		query += "  WHERE ID_019=?";
		if (null == aa83b19t00.getActivoSn019()) {
			aa83b19t00.setActivoSn019("N");
		}

		this.jdbcTemplate.update(query, new PreparedStatementSetter() {
			public void setValues(PreparedStatement ps) throws SQLException {
				int index = 1;
				ps.setString(index++, aa83b19t00.getNombre019());
				ps.setString(index++, aa83b19t00.getApel1019());
				ps.setString(index++, aa83b19t00.getApel2019());
				ps.setString(index++, aa83b19t00.getNumEmp());
				ps.setInt(index++, aa83b19t00.getIdCargo005());
				ps.setString(index++, aa83b19t00.getActivoSn019());
				ps.setString(index++, aa83b19t00.getFecinivigencia019());
				ps.setString(index++, aa83b19t00.getFecfinvigencia019());				
				if (aa83b19t00.getFirmaDigital019() != null) {
					ps.setBinaryStream(index++, new ByteArrayInputStream(
							aa83b19t00.getFirmaDigital019()), aa83b19t00
							.getFirmaDigital019().length);

				}
				ps.setInt(index++, aa83b19t00.getId019());
			}
		});
		
		/*
		 * this.jdbcTemplate.update(query, aa83b19t00.getNombre019(),
		 * aa83b19t00.getApel1019(), aa83b19t00.getApel2019(),
		 * aa83b19t00.getNumEmp(), aa83b19t00.getIdCargo005(),
		 * aa83b19t00.getFirmaDigital019(), aa83b19t00.getActivoSn019(),
		 * aa83b19t00.getId019());
		 */
		return aa83b19t00;
	}

	/**
	 * Finds a single row in the Aa83b19t00 table.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @return Aa83b19t00
	 */
	@Transactional(readOnly = true)
	public Aa83b19t00 find(Aa83b19t00 aa83b19t00) {

		String formato = Aa83bUtilidades.getDateFormat();

		StringBuilder query = new StringBuilder("SELECT ID019, NOMBRE019, APEL1019, APEL2019, NUMEMP, IDCARGO005, CARGOES, CARGOEU, ")
			.append("FIRMADIGITAL019, ACTIVOSN019, ").append("to_char(FECINIVIGENCIA019,'").append(formato).append("') FECINIVIGENCIA019,")
			.append("to_char(FECFINVIGENCIA019,'").append(formato).append("') FECFINVIGENCIA019 FROM AA83B19V00 t1 WHERE t1.ID019 = ? ");

		
		List<Aa83b19t00> aa83b19t00List = this.jdbcTemplate.query(query.toString(),this.rwMap, aa83b19t00.getId019());
		return (Aa83b19t00) DataAccessUtils.uniqueResult(aa83b19t00List);
	}

	/**
	 * Removes a single row in the Aa83b19t00 table.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @return
	 */
	public void remove(Aa83b19t00 aa83b19t00) {
		// String query = "DELETE FROM AA83B19T00 WHERE ID_019=?";
		String query = "UPDATE AA83B19T00 SET ACTIVO_SN_019='N' WHERE ID_019=?";
		this.jdbcTemplate.update(query, aa83b19t00.getId019());
	}

	/**
	 * Finds a list of rows in the Aa83b19t00 table.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b19t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b19t00> findAll(Aa83b19t00 aa83b19t00,JQGridRequestDto jqGridRequestDto) {
		
		String formato = Aa83bUtilidades.getDateFormat();
		
		StringBuilder query = new StringBuilder("SELECT ID019, NOMBRE019, APEL1019, APEL2019, NUMEMP, IDCARGO005, CARGOES, CARGOEU, ")
			.append("FIRMADIGITAL019, ACTIVOSN019, ").append("to_char(FECINIVIGENCIA019,'").append(formato).append("') FECINIVIGENCIA019,")
			.append("to_char(FECFINVIGENCIA019,'").append(formato).append("') FECFINVIGENCIA019 FROM AA83B19V00 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b19t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b19t00>) this.jdbcTemplate.query(query.toString(),this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b19t00 table using like.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b19t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b19t00> findAllLike(Aa83b19t00 aa83b19t00,JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83bUtilidades.getDateFormat();
		StringBuilder query = new StringBuilder("SELECT ID019, NOMBRE019, APEL1019, APEL2019, NUMEMP, IDCARGO005, CARGOES, CARGOEU, ")
			.append("FIRMADIGITAL019, ACTIVOSN019, ").append("to_char(FECINIVIGENCIA019,'").append(formato).append("') FECINIVIGENCIA019,")
			.append("to_char(FECFINVIGENCIA019,'").append(formato).append("') FECFINVIGENCIA019 FROM AA83B19V00 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b19t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b19t00>) this.jdbcTemplate.query(query.toString(),this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b19t00 table.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b19t00 aa83b19t00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B19V00 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b19t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),params.toArray());
	}

	/**
	 * Counts rows in the Aa83b19t00 table using like.
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b19t00 aa83b19t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B19V00 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b19t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b19t00 selected for rup_table
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b19t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b19t00>> reorderSelection(Aa83b19t00 aa83b19t00, JQGridRequestDto jqGridRequestDto,Boolean startsWith) {
		String formato = Aa83bUtilidades.getDateFormat();
		StringBuilder query = new StringBuilder("SELECT ID019, NOMBRE019, APEL1019, APEL2019, NUMEMP, IDCARGO005, CARGOES, CARGOEU, ")
			.append("FIRMADIGITAL019, ACTIVOSN019, ").append("to_char(FECINIVIGENCIA019,'").append(formato).append("') FECINIVIGENCIA019,")
			.append("to_char(FECFINVIGENCIA019,'").append(formato).append("') FECFINVIGENCIA019 FROM AA83B19V00 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b19t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto, Aa83b19t00.class, filterParamList,"ID019");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b19t00>(this.rwMapPK,jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b19t00
	 * @param searchParams
	 *            Aa83b19t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b19t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b19t00>> search(Aa83b19t00 filterParams,Aa83b19t00 searchParams, JQGridRequestDto jqGridRequestDto,Boolean startsWith) {
		String formato = Aa83bUtilidades.getDateFormat();
		StringBuilder query = new StringBuilder("SELECT ID019, NOMBRE019, APEL1019, APEL2019, NUMEMP, IDCARGO005, CARGOES, CARGOEU, ")
			.append("FIRMADIGITAL019, ACTIVOSN019, ").append("to_char(FECINIVIGENCIA019,'").append(formato).append("') FECINIVIGENCIA019,")
			.append("to_char(FECFINVIGENCIA019,'").append(formato).append("') FECFINVIGENCIA019 FROM AA83B19V00");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b19t00.class, filterParamList,searchSQL, searchParamList, "", "ID_019");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b19t00>(this.rwMapPK,jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b19t00
	 *            Aa83b19t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b19t00 filteraa83b19t00,JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT ID019, NOMBRE019, APEL1019, APEL2019, NUMEMP, IDCARGO005, CARGOES, CARGOEU, ")
				.append("FIRMADIGITAL019, ACTIVOSN019, FECINIVIGENCIA019, FECFINVIGENCIA019 FROM AA83B19V00 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b19t00,startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Aa83b19t00.class,query, params, "ID019");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b19t00 table.
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b19t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b19t00>> findAllLikeJerarquia(
			Aa83b19t00 filterAa83b19t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT ID019, NOMBRE019, APEL1019, APEL2019, NUMEMP, IDCARGO005, CARGOES, CARGOEU, ")
				.append("FIRMADIGITAL019, ACTIVOSN019, FECINIVIGENCIA019, FECFINVIGENCIA019 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B19T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B19V00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b19t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,mapaWhere, "ID019", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b19t00 filterAa83b19t00,JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B19T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B19V00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b19t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID019", "ID_PADRE", from,from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b19t00
	 *            Aa83b19t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b19t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b19t00>> findAllChild(Aa83b19t00 filterAa83b19t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B19T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B19V00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b19t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID019", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),new RowNumResultSetExtractor<Aa83b19t00>(this.rwMapPK,"ID019"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b19t00 entity
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b19t00 aa83b19t00) {

		StringBuilder where = new StringBuilder(Aa83b19t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b19t00 != null && aa83b19t00.getId019() != null) {
			where.append(" AND ID019 = ?");
			params.add(aa83b19t00.getId019());
		}
		if (aa83b19t00 != null && aa83b19t00.getNombre019() != null) {
			where.append(" AND NOMBRE019 = ?");
			params.add(aa83b19t00.getNombre019());
		}
		if (aa83b19t00 != null && aa83b19t00.getApel1019() != null) {
			where.append(" AND APEL1019 = ?");
			params.add(aa83b19t00.getApel1019());
		}
		if (aa83b19t00 != null && aa83b19t00.getApel2019() != null) {
			where.append(" AND APEL2019 = ?");
			params.add(aa83b19t00.getApel2019());
		}
		if (aa83b19t00 != null && aa83b19t00.getNumEmp() != null) {
			where.append(" AND NUMEMP = ?");
			params.add(aa83b19t00.getNumEmp());
		}
		if (aa83b19t00 != null && aa83b19t00.getIdCargo005() != null) {
			where.append(" AND IDCARGO005 = ?");
			params.add(aa83b19t00.getIdCargo005());
		}
		if (aa83b19t00 != null && aa83b19t00.getActivoSn019() != null) {
			where.append(" AND ACTIVOSN019 = ?");
			params.add(aa83b19t00.getActivoSn019());
		}
		if (aa83b19t00 != null && aa83b19t00.getFecinivigencia019() != null) {
			where.append(" AND FECINIVIGENCIA019 = ?");
			params.add(aa83b19t00.getFecinivigencia019());
		}
		if (aa83b19t00 != null && aa83b19t00.getFecfinvigencia019() != null) {
			where.append(" AND FECFINVIGENCIA019 = ?");
			params.add(aa83b19t00.getFecfinvigencia019());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b19t00 entity
	 * 
	 * @param aa83b19t00
	 *            Aa83b19t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b19t00 aa83b19t00,Boolean startsWith) {

		StringBuilder where = new StringBuilder(Aa83b19t00DaoImpl.STRING_BUILDER_INIT);
		StringBuilder whereAuxI = new StringBuilder(Aa83b19t00DaoImpl.STRING_BUILDER_INIT);
		StringBuilder whereAuxF = new StringBuilder(Aa83b19t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b19t00 != null && aa83b19t00.getId019() != null) {
			where.append(" AND ID019 = ?");
			params.add(aa83b19t00.getId019());
		}
		if (aa83b19t00 != null && aa83b19t00.getNombre019() != null) {
			where.append(" AND UPPER(TRANSLATE(NOMBRE019,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(Aa83bUtilidades.SinTildes(aa83b19t00.getNombre019().toUpperCase()) + "%");
			} else {
				params.add("%" + Aa83bUtilidades.SinTildes(aa83b19t00.getNombre019().toUpperCase()) + "%");
			}
			where.append(" AND NOMBRE019 IS NOT NULL");
		}
		if (aa83b19t00 != null && aa83b19t00.getApel1019() != null) {
			where.append(" AND UPPER(TRANSLATE(APEL1019,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(Aa83bUtilidades.SinTildes(aa83b19t00.getApel1019().toUpperCase()) + "%");
			} else {
				params.add("%" + Aa83bUtilidades.SinTildes(aa83b19t00.getApel1019().toUpperCase()) + "%");
			}
			where.append(" AND APEL1019 IS NOT NULL");
		}
		if (aa83b19t00 != null && aa83b19t00.getApel2019() != null) {
			where.append(" AND UPPER(TRANSLATE(APEL2019,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(Aa83bUtilidades.SinTildes(aa83b19t00.getApel2019().toUpperCase()) + "%");
			} else {
				params.add("%" + Aa83bUtilidades.SinTildes(aa83b19t00.getApel2019().toUpperCase()) + "%");
			}
			where.append(" AND APEL2019 IS NOT NULL");
		}
		if (aa83b19t00 != null && aa83b19t00.getNumEmp() != null) {
			where.append(" AND UPPER(NUMEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b19t00.getNumEmp().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b19t00.getNumEmp().toUpperCase() + "%");
			}
			where.append(" AND NUMEMP IS NOT NULL");
		}
		if (aa83b19t00 != null && aa83b19t00.getIdCargo005() != null) {
			where.append(" AND IDCARGO005 = ?");
			params.add(aa83b19t00.getIdCargo005());
		}
		if (aa83b19t00 != null && aa83b19t00.getActivoSn019() != null
				&& !"0".equalsIgnoreCase(aa83b19t00.getActivoSn019())) {
			where.append(" AND UPPER(ACTIVOSN019) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b19t00.getActivoSn019().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b19t00.getActivoSn019().toUpperCase()
						+ "%");
			}
			where.append(" AND ACTIVOSN019 IS NOT NULL");
		}


		if (aa83b19t00  != null  && aa83b19t00.getFecIniVigD() != null ) {
			if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
				whereAuxI.append(" to_date(FECINIVIGENCIA019),'").append(Aa83BConstants.EU_PATTERN).append("') >= to_date(?,'").append(Aa83BConstants.EU_PATTERN).append("') ");
				params.add(aa83b19t00.getFecIniVigD());
			} else {
				whereAuxI.append(" to_date(FECINIVIGENCIA019,'").append(Aa83BConstants.ES_PATTERN).append("') >= to_date(?,'").append(Aa83BConstants.ES_PATTERN).append("') ");
				params.add(aa83b19t00.getFecIniVigD());
			}			
			
	     }
		
		if (aa83b19t00  != null  && aa83b19t00.getFecIniVigH() != null ) {
			if (whereAuxI.length() > 1){
				whereAuxI.append(" AND ");
			}
			if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
				whereAuxI.append("  to_date(FECINIVIGENCIA019,'").append(Aa83BConstants.EU_PATTERN).append("') <= to_date(?,'").append(Aa83BConstants.EU_PATTERN).append("') ");
				params.add(aa83b19t00.getFecIniVigH());
			} else {
				whereAuxI.append("  to_date(FECINIVIGENCIA019,'").append(Aa83BConstants.ES_PATTERN).append("') <= to_date(?,'").append(Aa83BConstants.ES_PATTERN).append("') ");
				params.add(aa83b19t00.getFecIniVigH());
			}					
	     }
		
		if (aa83b19t00  != null  && aa83b19t00.getFecFinVigD() != null ) {
			if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
				whereAuxF.append(" to_date(FECFINVIGENCIA019,'").append(Aa83BConstants.EU_PATTERN).append("') >= to_date(?,'").append(Aa83BConstants.EU_PATTERN).append("') ");
				params.add(aa83b19t00.getFecFinVigD());
			} else {
				whereAuxF.append(" to_date(FECFINVIGENCIA019,'").append(Aa83BConstants.ES_PATTERN).append("') >= to_date(?,'").append(Aa83BConstants.ES_PATTERN).append("') ");
				params.add(aa83b19t00.getFecFinVigD());
			}
	     }
		if (aa83b19t00  != null  && aa83b19t00.getFecFinVigH() != null ) {
			if (whereAuxF.length() > 1){
				whereAuxF.append(" AND ");
			}
			if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
				whereAuxF.append(" to_date(FECFINVIGENCIA019,'").append(Aa83BConstants.EU_PATTERN).append("') <= to_date(?,'").append(Aa83BConstants.EU_PATTERN).append("') ");
				params.add(aa83b19t00.getFecFinVigH());
			} else {
				whereAuxF.append(" to_date(FECFINVIGENCIA019,'").append(Aa83BConstants.ES_PATTERN).append("') <= to_date(?,'").append(Aa83BConstants.ES_PATTERN).append("') ");
				params.add(aa83b19t00.getFecFinVigH());
			}					
	     }				
		
		if (whereAuxI.length() > 1 ) {
			if (whereAuxF.length() > 1){
				where.append(" AND (").append(whereAuxI).append(" ) OR (").append(whereAuxF).append(")");
			} else {
				where.append(" AND ").append(whereAuxI);
			}
		} else {
			if (whereAuxF.length() > 1){
				where.append(" AND ").append(whereAuxF);
			}
		}
		
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
