package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b11t00;
import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Aa83b11t00DaoImpl generated by UDA, 08-feb-2016 13:26:33.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b11t00DaoImpl implements Aa83b11t00Dao {
	private JdbcTemplate jdbcTemplate;

	
	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Aa83b11t00DaoImpl.class);
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b11t00> rwMap = new RowMapper<Aa83b11t00>() {
		public Aa83b11t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b11t00(resultSet.getInt("ID011"),
					resultSet.getInt("ID001FASE"),
					resultSet.getInt("ID002TRAM"),
					resultSet.getInt("ID003TIPOSOL"),
					resultSet.getInt("ID025NUMSOL"),
					resultSet.getLong("IDANOSOL025"),
					resultSet.getDate("FACTU011"),
					resultSet.getString("USUA011"),
					resultSet.getDate("FREGSAL011"),
					resultSet.getString("NREGSAL011"),
					resultSet.getDate("FNOTIF011"),
					resultSet.getDate("FEXPIR011"),
					resultSet.getDate("FMODIF011"),
					resultSet.getString("USUMOD011"),
					resultSet.getDate("FTRAM011"));
		}
	};

	private RowMapper<Aa83b11t00> rwMapPK = new RowMapper<Aa83b11t00>() {
		public Aa83b11t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b11t00(resultSet.getInt("ID011"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b11t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b11t00>>() {
		public JerarquiaDto<Aa83b11t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa83b11t00 aa83b11t00 = new Aa83b11t00(resultSet.getInt("ID011"),
					resultSet.getInt("ID001FASE"),
					resultSet.getInt("ID002TRAM"),
					resultSet.getInt("ID003TIPOSOL"),
					resultSet.getInt("ID025NUMSOL"),
					resultSet.getLong("IDANOSOL025"),
					resultSet.getDate("FACTU011"),
					resultSet.getString("USUA011"),
					resultSet.getDate("FREGSAL011"),
					resultSet.getString("NREGSAL011"),
					resultSet.getDate("FNOTIF011"),
					resultSet.getDate("FEXPIR011"),
					resultSet.getDate("FMODIF011"),
					resultSet.getString("USUMOD011"),
					resultSet.getDate("FTRAM011"));

			JerarquiaDto<Aa83b11t00> jerarquia = new JerarquiaDto<Aa83b11t00>();
			jerarquia.setModel(aa83b11t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @return Aa83b11t00
	 */
	public Aa83b11t00 add(Aa83b11t00 aa83b11t00) {
		final int nextId = jdbcTemplate
				.queryForInt("SELECT SEQ_AA83B11T00_ID_011.NEXTVAL FROM DUAL");
		aa83b11t00.setId011(nextId);

		String query = "INSERT INTO AA83B11T00 (ID_011, ID_001_FASE, ID_002_TRAM, ID_003_TIPO_SOL, ID_025_NUM_SOL, ID_ANO_SOL_025, F_ACTU_011, USUA_011, F_REG_SAL_011, N_REG_SAL_011, F_NOTIF_011, F_EXPIR_011, F_MODIF_011, USU_MOD_011, F_TRAM_011) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b11t00.getId011(),
				aa83b11t00.getId001Fase(), aa83b11t00.getId002Tram(),
				aa83b11t00.getId003TipoSol(), aa83b11t00.getId025NumSol(),
				aa83b11t00.getIdAnoSol025(), aa83b11t00.getfActu011(),
				aa83b11t00.getUsua011(), aa83b11t00.getFRegSal011(),
				aa83b11t00.getNRegSal011(), aa83b11t00.getFNotif011(),
				aa83b11t00.getFExpir011(), aa83b11t00.getFModif011(),
				aa83b11t00.getUsuMod011(), aa83b11t00.getFTram011());
		return aa83b11t00;
	}

	/**
	 * Updates a single row in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @return Aa83b11t00
	 */
	public Aa83b11t00 update(Aa83b11t00 aa83b11t00) {
		String query = "UPDATE AA83B11T00 SET ID_001_FASE=?, ID_002_TRAM=?, ID_003_TIPO_SOL=?, ID_025_NUM_SOL=?, ID_ANO_SOL_025=?, F_ACTU_011=?, USUA_011=?, F_REG_SAL_011=?, N_REG_SAL_011=?, F_NOTIF_011=?, F_EXPIR_011=?, F_MODIF_011=?, USU_MOD_011=?, F_TRAM_011=? WHERE ID_011=?";
		this.jdbcTemplate.update(query, aa83b11t00.getId001Fase(),
				aa83b11t00.getId002Tram(), aa83b11t00.getId003TipoSol(),
				aa83b11t00.getId025NumSol(), aa83b11t00.getIdAnoSol025(),
				aa83b11t00.getfActu011(), aa83b11t00.getUsua011(),
				aa83b11t00.getFRegSal011(), aa83b11t00.getNRegSal011(),
				aa83b11t00.getFNotif011(), aa83b11t00.getFExpir011(),
				aa83b11t00.getFModif011(), aa83b11t00.getUsuMod011(),
				aa83b11t00.getFTram011(), aa83b11t00.getId011());
		return aa83b11t00;
	}

	/**
	 * Finds a single row in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @return Aa83b11t00
	 */
	@Transactional(readOnly = true)
	public Aa83b11t00 find(Aa83b11t00 aa83b11t00) {
		String query = "SELECT t1.ID_011 ID011, t1.ID_001_FASE ID001FASE, t1.ID_002_TRAM ID002TRAM, t1.ID_003_TIPO_SOL ID003TIPOSOL, t1.ID_025_NUM_SOL ID025NUMSOL, t1.ID_ANO_SOL_025 IDANOSOL025, t1.F_ACTU_011 FACTU011, t1.USUA_011 USUA011, t1.F_REG_SAL_011 FREGSAL011, t1.N_REG_SAL_011 NREGSAL011, t1.F_NOTIF_011 FNOTIF011, t1.F_EXPIR_011 FEXPIR011, t1.F_MODIF_011 FMODIF011, t1.USU_MOD_011 USUMOD011, t1.F_TRAM_011 FTRAM011 FROM AA83B11T00 t1  WHERE t1.ID_011 = ?  ";

		List<Aa83b11t00> aa83b11t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b11t00.getId011());
		return (Aa83b11t00) DataAccessUtils.uniqueResult(aa83b11t00List);
	}

	/**
	 * Removes a single row in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @return
	 */
	public void remove(Aa83b11t00 aa83b11t00) {
		String query = "DELETE FROM AA83B11T00 WHERE ID_011=?";
		this.jdbcTemplate.update(query, aa83b11t00.getId011());
	}

	/**
	 * Finds a list of rows in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b11t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b11t00> findAll(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		query.append("FROM AA83B11T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b11t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b11t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b11t00> findEnviadas(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// query.append("FROM AA83B11T00 t1 ");
		query.append("from aa83b25t00 s, aa83b11t00 t1 ");
		query.append("where s.id_025 = t1.id_025_num_sol ");
		query.append("AND s.id_ano_025 = t1.ID_ANO_SOL_025 ");
		query.append("AND (SOLI_CERRADA_025 IS NULL OR SOLI_CERRADA_025 <> 'S') ");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND s.notif_leida_025 = 'S' ");
		query.append("AND s.id_025||s.id_ano_025 NOT IN ");
		query.append("( ");
		query.append("select r.id_025||r.id_ano_025 from aa83b25t00 r, aa83b11t00 x ");
		query.append("where ");
		query.append("r.id_025 = x.id_025_num_sol ");
		query.append("AND r.id_ano_025 = x.id_ano_sol_025 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
		query.append("AND s.id_025 IN ( " + 
				"SELECT t43.ID_SOL FROM aa83b43t00 t43 WHERE " +
				"t43.ID_TIPOSOL = 3 " +  
				"AND t43.CODIGO_SITUACION = '00')");
		// query.append("group by s.id_021, s.id_ano_021, t1.id_001_fase, t1.id_002_tram ");
//		query.append("order by  s.id_025 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b11t00);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_025 ");
		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b11t00 table using like.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b11t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b11t00> findAllLike(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		query.append("FROM AA83B11T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b11t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY t1.F_ACTU_011 DESC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b11t00 table.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b11t00 aa83b11t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B11T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b11t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b11t00 table using like.
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b11t00 aa83b11t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B11T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b11t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b11t00 selected for rup_table
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b11t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b11t00>> reorderSelection(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// FROM
		query.append("FROM AA83B11T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b11t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b11t00.class, filterParamList,
				"ID_011");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b11t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b11t00
	 * @param searchParams
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b11t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b11t00>> search(Aa83b11t00 filterParams,
			Aa83b11t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// FROM
		query.append("FROM AA83B11T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b11t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_011");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b11t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b11t00 filteraa83b11t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// FROM
		query.append("FROM AA83B11T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b11t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b11t00.class,
						query, params, "ID_011");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b11t00 table.
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b11t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b11t00>> findAllLikeJerarquia(
			Aa83b11t00 filterAa83b11t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B11T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B11T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b11t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_011", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b11t00 filterAa83b11t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B11T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B11T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b11t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_011", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b11t00
	 *            Aa83b11t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b11t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b11t00>> findAllChild(
			Aa83b11t00 filterAa83b11t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B11T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B11T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b11t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_011", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa83b11t00>(this.rwMapPK,
								"ID_011"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b11t00 entity
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b11t00 aa83b11t00) {

		StringBuilder where = new StringBuilder(
				Aa83b11t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b11t00 != null && aa83b11t00.getId011() != null) {
			where.append(" AND t1.ID_011 = ?");
			params.add(aa83b11t00.getId011());
		}
		if (aa83b11t00 != null && aa83b11t00.getId001Fase() != null) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b11t00.getId001Fase());
		}
		if (aa83b11t00 != null && aa83b11t00.getId002Tram() != null) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b11t00.getId002Tram());
		}
		if (aa83b11t00 != null && aa83b11t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b11t00.getId003TipoSol());
		}
		if (aa83b11t00 != null && aa83b11t00.getId025NumSol() != null) {
			where.append(" AND t1.ID_025_NUM_SOL = ?");
			params.add(aa83b11t00.getId025NumSol());
		}
		if (aa83b11t00 != null && aa83b11t00.getIdAnoSol025() != null) {
			where.append(" AND t1.ID_ANO_SOL_025 = ?");
			params.add(aa83b11t00.getIdAnoSol025());
		}
		if (aa83b11t00 != null && aa83b11t00.getfActu011() != null) {
			where.append(" AND t1.F_ACTU_011 = ?");
			params.add(aa83b11t00.getfActu011());
		}
		if (aa83b11t00 != null && aa83b11t00.getUsua011() != null) {
			where.append(" AND t1.USUA_011 = ?");
			params.add(aa83b11t00.getUsua011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFRegSal011() != null) {
			where.append(" AND t1.F_REG_SAL_011 = ?");
			params.add(aa83b11t00.getFRegSal011());
		}
		if (aa83b11t00 != null && aa83b11t00.getNRegSal011() != null) {
			where.append(" AND t1.N_REG_SAL_011 = ?");
			params.add(aa83b11t00.getNRegSal011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFNotif011() != null) {
			where.append(" AND t1.F_NOTIF_011 = ?");
			params.add(aa83b11t00.getFNotif011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFExpir011() != null) {
			where.append(" AND t1.F_EXPIR_011 = ?");
			params.add(aa83b11t00.getFExpir011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFModif011() != null) {
			where.append(" AND t1.F_MODIF_011 = ?");
			params.add(aa83b11t00.getFModif011());
		}
		if (aa83b11t00 != null && aa83b11t00.getUsuMod011() != null) {
			where.append(" AND t1.USU_MOD_011 = ?");
			params.add(aa83b11t00.getUsuMod011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFTram011() != null) {
			where.append(" AND t1.F_TRAM_011 = ?");
			params.add(aa83b11t00.getFTram011());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	private Map<String, ?> getWhereMapIdColeccion (Aa83b11t00 aa83b11t00, String idColeccion) {

		StringBuilder where = new StringBuilder(
				Aa83b11t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b11t00 != null && aa83b11t00.getId011() != null) {
			where.append(" AND t1.ID_011 = ?");
			params.add(aa83b11t00.getId011());
		}
		if (aa83b11t00 != null && aa83b11t00.getId001Fase() != null) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b11t00.getId001Fase());
		}
		if (aa83b11t00 != null && aa83b11t00.getId002Tram() != null) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b11t00.getId002Tram());
		}
		if (aa83b11t00 != null && aa83b11t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b11t00.getId003TipoSol());
		}
		if (aa83b11t00 != null && aa83b11t00.getId025NumSol() != null) {
			where.append(" AND t1.ID_025_NUM_SOL = ?");
			params.add(aa83b11t00.getId025NumSol());
		}
		if (aa83b11t00 != null && aa83b11t00.getIdAnoSol025() != null) {
			where.append(" AND t1.ID_ANO_SOL_025 = ?");
			params.add(aa83b11t00.getIdAnoSol025());
		}
		if (aa83b11t00 != null && aa83b11t00.getfActu011() != null) {
			where.append(" AND t1.F_ACTU_011 = ?");
			params.add(aa83b11t00.getfActu011());
		}
		if (aa83b11t00 != null && aa83b11t00.getUsua011() != null) {
			where.append(" AND t1.USUA_011 = ?");
			params.add(aa83b11t00.getUsua011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFRegSal011() != null) {
			where.append(" AND t1.F_REG_SAL_011 = ?");
			params.add(aa83b11t00.getFRegSal011());
		}
		if (aa83b11t00 != null && aa83b11t00.getNRegSal011() != null) {
			where.append(" AND t1.N_REG_SAL_011 = ?");
			params.add(aa83b11t00.getNRegSal011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFNotif011() != null) {
			where.append(" AND t1.F_NOTIF_011 = ?");
			params.add(aa83b11t00.getFNotif011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFExpir011() != null) {
			where.append(" AND t1.F_EXPIR_011 = ?");
			params.add(aa83b11t00.getFExpir011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFModif011() != null) {
			where.append(" AND t1.F_MODIF_011 = ?");
			params.add(aa83b11t00.getFModif011());
		}
		if (aa83b11t00 != null && aa83b11t00.getUsuMod011() != null) {
			where.append(" AND t1.USU_MOD_011 = ?");
			params.add(aa83b11t00.getUsuMod011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFTram011() != null) {
			where.append(" AND t1.F_TRAM_011 = ?");
			params.add(aa83b11t00.getFTram011());
		}
		if(idColeccion!= null){
			where.append(" AND t43.ID_COLECCION=? ");
			params.add(idColeccion);
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b11t00 entity
	 * 
	 * @param aa83b11t00
	 *            Aa83b11t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b11t00 aa83b11t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b11t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b11t00 != null && aa83b11t00.getId011() != null) {
			where.append(" AND t1.ID_011 = ?");
			params.add(aa83b11t00.getId011());
		}
		if (aa83b11t00 != null && aa83b11t00.getId001Fase() != null) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b11t00.getId001Fase());
		}
		if (aa83b11t00 != null && aa83b11t00.getId002Tram() != null) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b11t00.getId002Tram());
		}
		if (aa83b11t00 != null && aa83b11t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b11t00.getId003TipoSol());
		}
		if (aa83b11t00 != null && aa83b11t00.getId025NumSol() != null) {
			where.append(" AND t1.ID_025_NUM_SOL = ?");
			params.add(aa83b11t00.getId025NumSol());
		}
		if (aa83b11t00 != null && aa83b11t00.getIdAnoSol025() != null) {
			where.append(" AND t1.ID_ANO_SOL_025 = ?");
			params.add(aa83b11t00.getIdAnoSol025());
		}
		if (aa83b11t00 != null && aa83b11t00.getfActu011() != null) {
			where.append(" AND t1.F_ACTU_011 = ?");
			params.add(aa83b11t00.getfActu011());
		}
		if (aa83b11t00 != null && aa83b11t00.getUsua011() != null) {
			where.append(" AND UPPER(t1.USUA_011) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b11t00.getUsua011().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b11t00.getUsua011().toUpperCase() + "%");
			}
			where.append(" AND t1.USUA_011 IS NOT NULL");
		}
		if (aa83b11t00 != null && aa83b11t00.getFRegSal011() != null) {
			where.append(" AND t1.F_REG_SAL_011 = ?");
			params.add(aa83b11t00.getFRegSal011());
		}
		if (aa83b11t00 != null && aa83b11t00.getNRegSal011() != null) {
			where.append(" AND UPPER(t1.N_REG_SAL_011) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b11t00.getNRegSal011().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b11t00.getNRegSal011().toUpperCase() + "%");
			}
			where.append(" AND t1.N_REG_SAL_011 IS NOT NULL");
		}
		if (aa83b11t00 != null && aa83b11t00.getFNotif011() != null) {
			where.append(" AND t1.F_NOTIF_011 = ?");
			params.add(aa83b11t00.getFNotif011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFExpir011() != null) {
			where.append(" AND t1.F_EXPIR_011 = ?");
			params.add(aa83b11t00.getFExpir011());
		}
		if (aa83b11t00 != null && aa83b11t00.getFModif011() != null) {
			where.append(" AND t1.F_MODIF_011 = ?");
			params.add(aa83b11t00.getFModif011());
		}
		if (aa83b11t00 != null && aa83b11t00.getUsuMod011() != null) {
			where.append(" AND UPPER(t1.USU_MOD_011) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b11t00.getUsuMod011().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b11t00.getUsuMod011().toUpperCase() + "%");
			}
			where.append(" AND t1.USU_MOD_011 IS NOT NULL");
		}
		if (aa83b11t00 != null && aa83b11t00.getFTram011() != null) {
			where.append(" AND t1.F_TRAM_011 = ?");
			params.add(aa83b11t00.getFTram011());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Aa83b11t00 getLastRow(Aa83b11t00 aa83b11t00) {
		// TODO Auto-generated method stub
		String query = "SELECT t1.ID_011 ID011, t1.ID_001_FASE ID001FASE, t1.ID_002_TRAM ID002TRAM, t1.ID_003_TIPO_SOL ID003TIPOSOL, "
				+ "t1.ID_025_NUM_SOL ID025NUMSOL, t1.ID_ANO_SOL_025 IDANOSOL025, t1.F_ACTU_011 FACTU011, t1.USUA_011 USUA011, "
				+ "t1.F_REG_SAL_011 FREGSAL011, t1.N_REG_SAL_011 NREGSAL011, t1.F_NOTIF_011 FNOTIF011, t1.F_EXPIR_011 FEXPIR011, "
				+ "t1.F_MODIF_011 FMODIF011, t1.USU_MOD_011 USUMOD011, t1.F_TRAM_011 FTRAM011 "
				+ "FROM AA83B11T00 t1  "
				+ "where t1.id_011 = ( select max (id_011) from AA83B11T00 t "
				+ "where id_025_num_sol=? "
				+ "AND ID_ANO_SOL_025=? "
				+ "group by id_025_num_sol) ";

		List<Aa83b11t00> aa83b11t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b11t00.getId025NumSol(),
				aa83b11t00.getIdAnoSol025());
		return (Aa83b11t00) DataAccessUtils.uniqueResult(aa83b11t00List);
	}

	@Transactional(readOnly = true)
	public List<Aa83b11t00> findAllLikeNotificacion(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// query.append("FROM AA83B11T00 t1 ");
		query.append("from aa83b25t00 s, aa83b11t00 t1 ");
		query.append("where s.id_025 = t1.id_025_num_sol ");
		query.append("AND s.id_ano_025 = t1.ID_ANO_SOL_025 ");
		query.append("AND (SOLI_CERRADA_025 IS NULL OR SOLI_CERRADA_025 <> 'S') ");
		query.append("AND (NOTIF_LEIDA_025 IS NULL OR NOTIF_LEIDA_025 <> 'S')");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND s.id_025||s.id_ano_025 NOT IN ");
		query.append("( ");
		query.append("select r.id_025||r.id_ano_025 from aa83b25t00 r, aa83b11t00 x ");
		query.append("where ");
		query.append("r.id_025 = x.id_025_num_sol ");
		query.append("AND r.id_ano_025 = x.ID_ANO_SOL_025 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
		// query.append("group by s.id_021, s.id_ano_021, t1.id_001_fase, t1.id_002_tram ");
//		query.append("order by  s.id_025 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b11t00);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_025 ");
		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
	@Transactional(readOnly = true)
	public List<Aa83b11t00> findAllLikeNotificacionIdColeccion(Aa83b11t00 aa83b11t00,
			JQGridRequestDto jqGridRequestDto, String idColeccion) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// query.append("FROM AA83B11T00 t1 ");
		query.append("from aa83b25t00 s, aa83b11t00 t1, AA83B43T00 t43  ");
		query.append("where s.id_025 = t1.id_025_num_sol ");
		query.append("AND s.id_ano_025 = t1.ID_ANO_SOL_025 ");
		query.append("AND t43.ID_SOL= s.id_025 ");
		query.append("AND t43.ID_ANYO= s.id_ano_025 ");
		query.append("AND (SOLI_CERRADA_025 IS NULL OR SOLI_CERRADA_025 <> 'S') ");
		query.append("AND (NOTIF_LEIDA_025 IS NULL OR NOTIF_LEIDA_025 <> 'S')");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND s.id_025||s.id_ano_025 NOT IN ");
		query.append("( ");
		query.append("select r.id_025||r.id_ano_025 from aa83b25t00 r, aa83b11t00 x ");
		query.append("where ");
		query.append("r.id_025 = x.id_025_num_sol ");
		query.append("AND r.id_ano_025 = x.ID_ANO_SOL_025 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
		// query.append("group by s.id_021, s.id_ano_021, t1.id_001_fase, t1.id_002_tram ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapIdColeccion(aa83b11t00, idColeccion);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_025 ");
		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	@Override
	public List<Aa83b11t00> findAllLikeNotificacionFechas(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta) {
		// TODO Auto-generated method stub

		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String fechaD = (String) new SimpleDateFormat(formato)
				.format(fechaDesde);
		String fechaH = (String) new SimpleDateFormat(formato)
				.format(fechaHasta);
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// query.append("FROM AA83B11T00 t1 ");
		query.append("from aa83b25t00 s, aa83b11t00 t1 ");
		query.append("where s.id_025 = t1.id_025_num_sol ");
		query.append("AND s.id_ano_025 = t1.ID_ANO_SOL_025 ");
		query.append("AND (SOLI_CERRADA_025 IS NULL OR SOLI_CERRADA_025 <> 'S') ");
		query.append("AND (NOTIF_LEIDA_025 IS NULL OR NOTIF_LEIDA_025 <> 'S')");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND t1.F_ACTU_011 BETWEEN TO_DATE('" + fechaH + "','"
				+ formato + "') AND TO_DATE('" + fechaD + "','" + formato
				+ "') ");
		// nuevo
		query.append("AND t1.ID_011 = (Select MAX (ID_011) from aa83b11t00 z where z.id_025_num_sol = t1.id_025_num_sol and ID_ANO_SOL_025 = t1.ID_ANO_SOL_025) ");
		query.append("AND s.id_025||s.id_ano_025 NOT IN ");
		query.append("( ");
		query.append("select r.id_025||r.id_ano_025 from aa83b25t00 r, aa83b11t00 x ");
		query.append("where ");
		query.append("r.id_025 = x.id_025_num_sol ");
		query.append("AND r.id_ano_025 = x.ID_ANO_SOL_025 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
//		query.append("order by  s.id_025 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b11t00);
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_025 ");
		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
	
	
	public List<Aa83b11t00> findAllLikeNotificacionFechasIdColeccion(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta, String idColeccion) {
		// TODO Auto-generated method stub

		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String fechaD = (String) new SimpleDateFormat(formato)
				.format(fechaDesde);
		String fechaH = (String) new SimpleDateFormat(formato)
				.format(fechaHasta);
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// query.append("FROM AA83B11T00 t1 ");
		query.append("from aa83b25t00 s, aa83b11t00 t1, AA83B43T00 t43  ");
		query.append("where s.id_025 = t1.id_025_num_sol ");
		query.append("AND s.id_ano_025 = t1.ID_ANO_SOL_025 ");
		query.append("AND t43.ID_SOL= s.id_025 ");
		query.append("AND t43.ID_ANYO= s.id_ano_025 ");
		query.append("AND (SOLI_CERRADA_025 IS NULL OR SOLI_CERRADA_025 <> 'S') ");
		query.append("AND (NOTIF_LEIDA_025 IS NULL OR NOTIF_LEIDA_025 <> 'S')");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND t1.F_ACTU_011 BETWEEN TO_DATE('" + fechaH + "','"
				+ formato + "') AND TO_DATE('" + fechaD + "','" + formato
				+ "') ");
		// nuevo
		query.append("AND t1.ID_011 = (Select MAX (ID_011) from aa83b11t00 z where z.id_025_num_sol = t1.id_025_num_sol and ID_ANO_SOL_025 = t1.ID_ANO_SOL_025) ");
		query.append("AND s.id_025||s.id_ano_025 NOT IN ");
		query.append("( ");
		query.append("select r.id_025||r.id_ano_025 from aa83b25t00 r, aa83b11t00 x ");
		query.append("where ");
		query.append("r.id_025 = x.id_025_num_sol ");
		query.append("AND r.id_ano_025 = x.ID_ANO_SOL_025 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapIdColeccion(aa83b11t00, idColeccion);
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_025 ");
		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	@Override
	public List<Aa83b11t00> findEnviadosRequerimientosFechas(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta) {
		// TODO Auto-generated method stub
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String FaseReq = "1";
		String TramReq = "3";
		String fechaD = (String) new SimpleDateFormat(formato)
				.format(fechaDesde);
		String fechaH = (String) new SimpleDateFormat(formato)
				.format(fechaHasta);
		
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// query.append("FROM AA83B11T00 t1 ");
		query.append("from aa83b25t00 s, aa83b11t00 t1 ");
		query.append("where s.id_025 = t1.id_025_num_sol ");
		query.append("AND s.id_ano_025 = t1.ID_ANO_SOL_025 ");
		query.append("AND (SOLI_CERRADA_025 IS NULL OR SOLI_CERRADA_025 <> 'S') ");
		query.append("AND NOTIF_LEIDA_025 <> 'S' ");
		query.append("AND (id_001_fase='" + FaseReq + "'  AND id_002_tram='"
				+ TramReq + "') ");
		query.append("AND t1.F_ACTU_011 BETWEEN TO_DATE('" + fechaH + "','"
				+ formato + "') AND TO_DATE('" + fechaD + "','" + formato
				+ "') ");
		// nuevo
		query.append("AND t1.ID_011 = (Select MAX (ID_011) from aa83b11t00 z where z.id_025_num_sol = t1.id_025_num_sol and ID_ANO_SOL_025 = t1.ID_ANO_SOL_025) ");
		query.append("AND s.id_025||s.id_ano_025 NOT IN ");
		query.append("( ");
		query.append("select r.id_025||r.id_ano_025 from aa83b25t00 r, aa83b11t00 x ");
		query.append("where ");
		query.append("r.id_025 = x.id_025_num_sol ");
		query.append("AND r.id_ano_025 = x.ID_ANO_SOL_025 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
		

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b11t00);
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_025 ");
		logger.info("query findEnviadosRequerimientosFechas -->"+ query.toString());
		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
	@Override
	public List<Aa83b11t00> findEnviadosRequerimientosFechasIdColeccion(
			Aa83b11t00 aa83b11t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta, String idColeccion) {
		// TODO Auto-generated method stub
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String FaseReq = "1";
		String TramReq = "3";
		String fechaD = (String) new SimpleDateFormat(formato)
				.format(fechaDesde);
		String fechaH = (String) new SimpleDateFormat(formato)
				.format(fechaHasta);
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_011 ID011,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_025_NUM_SOL ID025NUMSOL,t1.ID_ANO_SOL_025 IDANOSOL025,t1.F_ACTU_011 FACTU011,t1.USUA_011 USUA011,t1.F_REG_SAL_011 FREGSAL011,t1.N_REG_SAL_011 NREGSAL011,t1.F_NOTIF_011 FNOTIF011,t1.F_EXPIR_011 FEXPIR011,t1.F_MODIF_011 FMODIF011,t1.USU_MOD_011 USUMOD011,t1.F_TRAM_011 FTRAM011 ");
		// query.append("FROM AA83B11T00 t1 ");
		query.append("from aa83b25t00 s, aa83b11t00 t1, AA83B43T00 t43  ");
		query.append("where s.id_025 = t1.id_025_num_sol ");
		query.append("AND s.id_ano_025 = t1.ID_ANO_SOL_025 ");
		query.append("AND t43.ID_SOL= s.id_025 ");
		query.append("AND t43.ID_ANYO= s.id_ano_025 ");
		query.append("AND (SOLI_CERRADA_025 IS NULL OR SOLI_CERRADA_025 <> 'S') ");
		query.append("AND NOTIF_LEIDA_025 <> 'S' ");
		query.append("AND (id_001_fase='" + FaseReq + "'  AND id_002_tram='"
				+ TramReq + "') ");
		query.append("AND t1.F_ACTU_011 BETWEEN TO_DATE('" + fechaH + "','"
				+ formato + "') AND TO_DATE('" + fechaD + "','" + formato
				+ "') ");
		// nuevo
		query.append("AND t1.ID_011 = (Select MAX (ID_011) from aa83b11t00 z where z.id_025_num_sol = t1.id_025_num_sol and ID_ANO_SOL_025 = t1.ID_ANO_SOL_025) ");
		query.append("AND s.id_025||s.id_ano_025 NOT IN ");
		query.append("( ");
		query.append("select r.id_025||r.id_ano_025 from aa83b25t00 r, aa83b11t00 x ");
		query.append("where ");
		query.append("r.id_025 = x.id_025_num_sol ");
		query.append("AND r.id_ano_025 = x.ID_ANO_SOL_025 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
		

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapIdColeccion(aa83b11t00, idColeccion);
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_025 ");
		return (List<Aa83b11t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
}
