package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b09t00;
import com.ejie.aa83b.model.Aa83b10t00;
import com.ejie.aa83b.util.Aa83BConstants;

/**
 * Aa83b10t00DaoImpl generated by UDA, 23-dic-2015 10:54:59.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b10t00DaoImpl implements Aa83b10t00Dao {
	private JdbcTemplate jdbcTemplate;
	
	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Aa83b10t00DaoImpl.class);


	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b10t00> rwMap = new RowMapper<Aa83b10t00>() {
		public Aa83b10t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b10t00(resultSet.getInt("ID010"),
					resultSet.getInt("ID001FASE"),
					resultSet.getInt("ID002TRAM"),
					resultSet.getInt("ID003TIPOSOL"),
					resultSet.getLong("ID023NUMSOL"),
					resultSet.getLong("IDANO023"),
					resultSet.getDate("FACTU010"),
					resultSet.getString("USUA010"),
					resultSet.getDate("FREGSAL010"),
					resultSet.getString("NREGSAL010"),
					resultSet.getDate("FNOTIF010"),
					resultSet.getDate("FEXPIR010"),
					resultSet.getDate("FMODIF010"),
					resultSet.getString("USUMOD010"),
					resultSet.getDate("FTRAM010"));
		}
	};

	private RowMapper<Aa83b10t00> rwMapPK = new RowMapper<Aa83b10t00>() {
		public Aa83b10t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b10t00(resultSet.getInt("ID010"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b10t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b10t00>>() {
		public JerarquiaDto<Aa83b10t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa83b10t00 aa83b10t00 = new Aa83b10t00(resultSet.getInt("ID010"),
					resultSet.getInt("ID001FASE"),
					resultSet.getInt("ID002TRAM"),
					resultSet.getInt("ID003TIPOSOL"),
					resultSet.getLong("ID023NUMSOL"),
					resultSet.getLong("IDANO023"),
					resultSet.getDate("FACTU010"),
					resultSet.getString("USUA010"),
					resultSet.getDate("FREGSAL010"),
					resultSet.getString("NREGSAL010"),
					resultSet.getDate("FNOTIF010"),
					resultSet.getDate("FEXPIR010"),
					resultSet.getDate("FMODIF010"),
					resultSet.getString("USUMOD010"),
					resultSet.getDate("FTRAM010"));

			JerarquiaDto<Aa83b10t00> jerarquia = new JerarquiaDto<Aa83b10t00>();
			jerarquia.setModel(aa83b10t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b10t00 table.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @return Aa83b10t00
	 */
	public Aa83b10t00 add(Aa83b10t00 aa83b10t00) {
		final int nextId = jdbcTemplate
				.queryForInt("SELECT SEQ_AA83B10T00_ID_010.NEXTVAL FROM DUAL");
		aa83b10t00.setId010(nextId);

		String query = "INSERT INTO AA83B10T00 (ID_010, ID_001_FASE, ID_002_TRAM, ID_003_TIPO_SOL, ID_023_NUM_SOL, ID_ANO_023, F_ACTU_010, USUA_010, F_REG_SAL_010, N_REG_SAL_010, F_NOTIF_010, F_EXPIR_010, F_MODIF_010, USU_MOD_010, F_TRAM_010) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b10t00.getId010(),
				aa83b10t00.getId001Fase(), aa83b10t00.getId002Tram(),
				aa83b10t00.getId003TipoSol(), aa83b10t00.getId023NumSol(),
				aa83b10t00.getIdAno023(), aa83b10t00.getfActu010(),
				aa83b10t00.getUsua010(), aa83b10t00.getFRegSal010(),
				aa83b10t00.getNRegSal010(), aa83b10t00.getFNotif010(),
				aa83b10t00.getFExpir010(), aa83b10t00.getFModif010(),
				aa83b10t00.getUsuMod010(), aa83b10t00.getFTram010());
		return aa83b10t00;
	}

	/**
	 * Updates a single row in the Aa83b10t00 table.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @return Aa83b10t00
	 */
	public Aa83b10t00 update(Aa83b10t00 aa83b10t00) {
		String query = "UPDATE AA83B10T00 SET ID_001_FASE=?, ID_002_TRAM=?, ID_003_TIPO_SOL=?, ID_023_NUM_SOL=?, ID_ANO_023=?, F_ACTU_010=?, USUA_010=?, F_REG_SAL_010=?, N_REG_SAL_010=?, F_NOTIF_010=?, F_EXPIR_010=?, F_MODIF_010=?, USU_MOD_010=?, F_TRAM_010=? WHERE ID_010=?";
		this.jdbcTemplate.update(query, aa83b10t00.getId001Fase(),
				aa83b10t00.getId002Tram(), aa83b10t00.getId003TipoSol(),
				aa83b10t00.getId023NumSol(), aa83b10t00.getIdAno023(),
				aa83b10t00.getfActu010(), aa83b10t00.getUsua010(),
				aa83b10t00.getFRegSal010(), aa83b10t00.getNRegSal010(),
				aa83b10t00.getFNotif010(), aa83b10t00.getFExpir010(),
				aa83b10t00.getFModif010(), aa83b10t00.getUsuMod010(),
				aa83b10t00.getFTram010(), aa83b10t00.getId010());
		return aa83b10t00;
	}

	/**
	 * Finds a single row in the Aa83b10t00 table.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @return Aa83b10t00
	 */
	@Transactional(readOnly = true)
	public Aa83b10t00 find(Aa83b10t00 aa83b10t00) {
		String query = "SELECT t1.ID_010 ID010, t1.ID_001_FASE ID001FASE, t1.ID_002_TRAM ID002TRAM, t1.ID_003_TIPO_SOL ID003TIPOSOL, t1.ID_023_NUM_SOL ID023NUMSOL, t1.ID_ANO_023 IDANO023, t1.F_ACTU_010 FACTU010, t1.USUA_010 USUA010, t1.F_REG_SAL_010 FREGSAL010, t1.N_REG_SAL_010 NREGSAL010, t1.F_NOTIF_010 FNOTIF010, t1.F_EXPIR_010 FEXPIR010, t1.F_MODIF_010 FMODIF010, t1.USU_MOD_010 USUMOD010, t1.F_TRAM_010 FTRAM010 FROM AA83B10T00 t1  WHERE t1.ID_010 = ?  ";

		List<Aa83b10t00> aa83b10t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b10t00.getId010());
		return (Aa83b10t00) DataAccessUtils.uniqueResult(aa83b10t00List);
	}

	/**
	 * Removes a single row in the Aa83b10t00 table.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @return
	 */
	public void remove(Aa83b10t00 aa83b10t00) {
		String query = "DELETE FROM AA83B10T00 WHERE ID_010=?";
		this.jdbcTemplate.update(query, aa83b10t00.getId010());
	}

	/**
	 * Finds a list of rows in the Aa83b10t00 table.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b10t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b10t00> findAll(Aa83b10t00 aa83b10t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("FROM AA83B10T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b10t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b10t00 table using like.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b10t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b10t00> findAllLike(Aa83b10t00 aa83b10t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("FROM AA83B10T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b10t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY t1.F_ACTU_010 DESC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b10t00 table using like.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b10t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b10t00> findEnviadas(Aa83b10t00 aa83b10t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("from aa83b23t00 s, aa83b10t00 t1 ");
		query.append("where s.id_023 = t1.id_023_num_sol ");
		query.append("AND s.id_ano_023 = t1.id_ano_023 ");
		query.append("AND (SOLI_CERRADA_023 IS NULL OR SOLI_CERRADA_023 <> 'S') ");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND s.notif_leida_023 = 'S' ");
		query.append("AND s.id_023||s.id_ano_023 NOT IN ");
		query.append("( ");
		query.append("select r.id_023||r.id_ano_023 from aa83b23t00 r, aa83b10t00 x ");
		query.append("where ");
		query.append("r.id_023 = x.id_023_num_sol ");
		query.append("AND r.id_ano_023 = x.id_ano_023 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
		query.append("AND s.id_023 IN ( " + 
				"SELECT t43.ID_SOL FROM aa83b43t00 t43 WHERE " +
				"t43.ID_TIPOSOL = 2 " +  
				"AND t43.CODIGO_SITUACION = '00')");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b10t00);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// query.append(" ORDER BY t1.ID_010 ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_023 ");
		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b10t00 table.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b10t00 aa83b10t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B10T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b10t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b10t00 table using like.
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b10t00 aa83b10t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B10T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b10t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b10t00 selected for rup_table
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b10t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b10t00>> reorderSelection(
			Aa83b10t00 aa83b10t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		// FROM
		query.append("FROM AA83B10T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b10t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b10t00.class, filterParamList,
				"ID_010");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b10t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b10t00
	 * @param searchParams
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b10t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b10t00>> search(Aa83b10t00 filterParams,
			Aa83b10t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		// FROM
		query.append("FROM AA83B10T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b10t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_010");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b10t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b10t00
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b10t00 filteraa83b10t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		// FROM
		query.append("FROM AA83B10T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b10t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b10t00.class,
						query, params, "ID_010");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b10t00 table.
	 * 
	 * @param filterAa83b10t00
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b10t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b10t00>> findAllLikeJerarquia(
			Aa83b10t00 filterAa83b10t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B10T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B10T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b10t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_010", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b10t00
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b10t00 filterAa83b10t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B10T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B10T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b10t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_010", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b10t00
	 *            Aa83b10t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b10t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b10t00>> findAllChild(
			Aa83b10t00 filterAa83b10t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B10T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B10T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b10t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_010", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa83b10t00>(this.rwMapPK,
								"ID_010"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b10t00 entity
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b10t00 aa83b10t00) {

		StringBuilder where = new StringBuilder(
				Aa83b10t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b10t00 != null && aa83b10t00.getId010() != null) {
			where.append(" AND t1.ID_010 = ?");
			params.add(aa83b10t00.getId010());
		}
		if (aa83b10t00 != null && aa83b10t00.getId001Fase() != null) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b10t00.getId001Fase());
		}
		if (aa83b10t00 != null && aa83b10t00.getId002Tram() != null) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b10t00.getId002Tram());
		}
		if (aa83b10t00 != null && aa83b10t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b10t00.getId003TipoSol());
		}
		if (aa83b10t00 != null && aa83b10t00.getId023NumSol() != null) {
			where.append(" AND t1.ID_023_NUM_SOL = ?");
			params.add(aa83b10t00.getId023NumSol());
		}
		if (aa83b10t00 != null && aa83b10t00.getIdAno023() != null) {
			where.append(" AND t1.ID_ANO_023 = ?");
			params.add(aa83b10t00.getIdAno023());
		}
		if (aa83b10t00 != null && aa83b10t00.getfActu010() != null) {
			where.append(" AND t1.F_ACTU_010 = ?");
			params.add(aa83b10t00.getfActu010());
		}
		if (aa83b10t00 != null && aa83b10t00.getUsua010() != null) {
			where.append(" AND t1.USUA_010 = ?");
			params.add(aa83b10t00.getUsua010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFRegSal010() != null) {
			where.append(" AND t1.F_REG_SAL_010 = ?");
			params.add(aa83b10t00.getFRegSal010());
		}
		if (aa83b10t00 != null && aa83b10t00.getNRegSal010() != null) {
			where.append(" AND t1.N_REG_SAL_010 = ?");
			params.add(aa83b10t00.getNRegSal010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFNotif010() != null) {
			where.append(" AND t1.F_NOTIF_010 = ?");
			params.add(aa83b10t00.getFNotif010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFExpir010() != null) {
			where.append(" AND t1.F_EXPIR_010 = ?");
			params.add(aa83b10t00.getFExpir010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFModif010() != null) {
			where.append(" AND t1.F_MODIF_010 = ?");
			params.add(aa83b10t00.getFModif010());
		}
		if (aa83b10t00 != null && aa83b10t00.getUsuMod010() != null) {
			where.append(" AND t1.USU_MOD_010 = ?");
			params.add(aa83b10t00.getUsuMod010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFTram010() != null) {
			where.append(" AND t1.F_TRAM_010 = ?");
			params.add(aa83b10t00.getFTram010());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	private Map<String, ?> getWhereMapIdColeccion(Aa83b10t00 aa83b10t00, String idColeccion) {

		StringBuilder where = new StringBuilder(
				Aa83b10t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b10t00 != null && aa83b10t00.getId010() != null) {
			where.append(" AND t1.ID_010 = ?");
			params.add(aa83b10t00.getId010());
		}
		if (aa83b10t00 != null && aa83b10t00.getId001Fase() != null) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b10t00.getId001Fase());
		}
		if (aa83b10t00 != null && aa83b10t00.getId002Tram() != null) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b10t00.getId002Tram());
		}
		if (aa83b10t00 != null && aa83b10t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b10t00.getId003TipoSol());
		}
		if (aa83b10t00 != null && aa83b10t00.getId023NumSol() != null) {
			where.append(" AND t1.ID_023_NUM_SOL = ?");
			params.add(aa83b10t00.getId023NumSol());
		}
		if (aa83b10t00 != null && aa83b10t00.getIdAno023() != null) {
			where.append(" AND t1.ID_ANO_023 = ?");
			params.add(aa83b10t00.getIdAno023());
		}
		if (aa83b10t00 != null && aa83b10t00.getfActu010() != null) {
			where.append(" AND t1.F_ACTU_010 = ?");
			params.add(aa83b10t00.getfActu010());
		}
		if (aa83b10t00 != null && aa83b10t00.getUsua010() != null) {
			where.append(" AND t1.USUA_010 = ?");
			params.add(aa83b10t00.getUsua010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFRegSal010() != null) {
			where.append(" AND t1.F_REG_SAL_010 = ?");
			params.add(aa83b10t00.getFRegSal010());
		}
		if (aa83b10t00 != null && aa83b10t00.getNRegSal010() != null) {
			where.append(" AND t1.N_REG_SAL_010 = ?");
			params.add(aa83b10t00.getNRegSal010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFNotif010() != null) {
			where.append(" AND t1.F_NOTIF_010 = ?");
			params.add(aa83b10t00.getFNotif010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFExpir010() != null) {
			where.append(" AND t1.F_EXPIR_010 = ?");
			params.add(aa83b10t00.getFExpir010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFModif010() != null) {
			where.append(" AND t1.F_MODIF_010 = ?");
			params.add(aa83b10t00.getFModif010());
		}
		if (aa83b10t00 != null && aa83b10t00.getUsuMod010() != null) {
			where.append(" AND t1.USU_MOD_010 = ?");
			params.add(aa83b10t00.getUsuMod010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFTram010() != null) {
			where.append(" AND t1.F_TRAM_010 = ?");
			params.add(aa83b10t00.getFTram010());
		}
		if(idColeccion!= null){
			where.append(" AND t43.ID_COLECCION=? ");
			params.add(idColeccion);
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b10t00 entity
	 * 
	 * @param aa83b10t00
	 *            Aa83b10t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b10t00 aa83b10t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b10t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b10t00 != null && aa83b10t00.getId010() != null) {
			where.append(" AND t1.ID_010 = ?");
			params.add(aa83b10t00.getId010());
		}
		if (aa83b10t00 != null && aa83b10t00.getId001Fase() != null) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b10t00.getId001Fase());
		}
		if (aa83b10t00 != null && aa83b10t00.getId002Tram() != null) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b10t00.getId002Tram());
		}
		if (aa83b10t00 != null && aa83b10t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b10t00.getId003TipoSol());
		}
		if (aa83b10t00 != null && aa83b10t00.getId023NumSol() != null) {
			where.append(" AND t1.ID_023_NUM_SOL = ?");
			params.add(aa83b10t00.getId023NumSol());
		}
		if (aa83b10t00 != null && aa83b10t00.getIdAno023() != null) {
			where.append(" AND t1.ID_ANO_023 = ?");
			params.add(aa83b10t00.getIdAno023());
		}
		if (aa83b10t00 != null && aa83b10t00.getfActu010() != null) {
			where.append(" AND t1.F_ACTU_010 = ?");
			params.add(aa83b10t00.getfActu010());
		}
		if (aa83b10t00 != null && aa83b10t00.getUsua010() != null) {
			where.append(" AND UPPER(t1.USUA_010) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b10t00.getUsua010().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b10t00.getUsua010().toUpperCase() + "%");
			}
			where.append(" AND t1.USUA_010 IS NOT NULL");
		}
		if (aa83b10t00 != null && aa83b10t00.getFRegSal010() != null) {
			where.append(" AND t1.F_REG_SAL_010 = ?");
			params.add(aa83b10t00.getFRegSal010());
		}
		if (aa83b10t00 != null && aa83b10t00.getNRegSal010() != null) {
			where.append(" AND UPPER(t1.N_REG_SAL_010) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b10t00.getNRegSal010().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b10t00.getNRegSal010().toUpperCase() + "%");
			}
			where.append(" AND t1.N_REG_SAL_010 IS NOT NULL");
		}
		if (aa83b10t00 != null && aa83b10t00.getFNotif010() != null) {
			where.append(" AND t1.F_NOTIF_010 = ?");
			params.add(aa83b10t00.getFNotif010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFExpir010() != null) {
			where.append(" AND t1.F_EXPIR_010 = ?");
			params.add(aa83b10t00.getFExpir010());
		}
		if (aa83b10t00 != null && aa83b10t00.getFModif010() != null) {
			where.append(" AND t1.F_MODIF_010 = ?");
			params.add(aa83b10t00.getFModif010());
		}
		if (aa83b10t00 != null && aa83b10t00.getUsuMod010() != null) {
			where.append(" AND UPPER(t1.USU_MOD_010) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b10t00.getUsuMod010().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b10t00.getUsuMod010().toUpperCase() + "%");
			}
			where.append(" AND t1.USU_MOD_010 IS NOT NULL");
		}
		if (aa83b10t00 != null && aa83b10t00.getFTram010() != null) {
			where.append(" AND t1.F_TRAM_010 = ?");
			params.add(aa83b10t00.getFTram010());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Aa83b10t00 getLastRow(Aa83b10t00 aa83b10t00) {
		// TODO Auto-generated method stub
		String query = "SELECT t1.ID_010 ID010, t1.ID_001_FASE ID001FASE, t1.ID_002_TRAM ID002TRAM, t1.ID_003_TIPO_SOL ID003TIPOSOL, "
				+ "t1.ID_023_NUM_SOL ID023NUMSOL, t1.ID_ANO_023 IDANO023, t1.F_ACTU_010 FACTU010, t1.USUA_010 USUA010, "
				+ "t1.F_REG_SAL_010 FREGSAL010, t1.N_REG_SAL_010 NREGSAL010, t1.F_NOTIF_010 FNOTIF010, t1.F_EXPIR_010 FEXPIR010, "
				+ "t1.F_MODIF_010 FMODIF010, t1.USU_MOD_010 USUMOD010, t1.F_TRAM_010 FTRAM010 "
				+ "FROM AA83B10T00 t1  "
				+ "where t1.id_010 = ( select max (id_010) from AA83B10T00 t "
				+ "where id_023_num_sol=? "
				+ "AND id_ano_023=? "
				+ "group by id_023_num_sol) ";

		List<Aa83b10t00> aa83b10t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b10t00.getId023NumSol(),
				aa83b10t00.getIdAno023());
		return (Aa83b10t00) DataAccessUtils.uniqueResult(aa83b10t00List);
	}

	@Transactional(readOnly = true)
	public List<Aa83b10t00> findAllLikeNotificacion(Aa83b10t00 aa83b10t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("from aa83b23t00 s, aa83b10t00 t1 ");
		query.append("where s.id_023 = t1.id_023_num_sol ");
		query.append("AND s.id_ano_023 = t1.id_ano_023 ");
		query.append("AND (SOLI_CERRADA_023 IS NULL OR SOLI_CERRADA_023 <> 'S') ");
		query.append("AND (NOTIF_LEIDA_023 IS NULL OR NOTIF_LEIDA_023 <> 'S')");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND s.id_023||s.id_ano_023 NOT IN ");
		query.append("( ");
		query.append("select r.id_023||r.id_ano_023 from aa83b23t00 r, aa83b10t00 x ");
		query.append("where ");
		query.append("r.id_023 = x.id_023_num_sol ");
		query.append("AND r.id_ano_023 = x.id_ano_023 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
//		query.append("order by  s.id_023 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b10t00);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// query.append(" ORDER BY t1.ID_010 ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_023 ");
		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
	
	@Override
	public List<Aa83b10t00> findAllLikeNotificacionIdColeccion(
			Aa83b10t00 aa83b10t00, JQGridRequestDto jqGridRequestDto, String idColeccion) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("from aa83b23t00 s, aa83b10t00 t1, AA83B43T00 t43  ");
		query.append("where s.id_023 = t1.id_023_num_sol ");
		query.append("AND s.id_ano_023 = t1.id_ano_023 ");
		query.append("AND t43.ID_SOL= s.id_023 ");
		query.append("AND t43.ID_ANYO= s.id_ano_023 ");
		query.append("AND (SOLI_CERRADA_023 IS NULL OR SOLI_CERRADA_023 <> 'S') ");
		query.append("AND (NOTIF_LEIDA_023 IS NULL OR NOTIF_LEIDA_023 <> 'S')");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND s.id_023||s.id_ano_023 NOT IN ");
		query.append("( ");
		query.append("select r.id_023||r.id_ano_023 from aa83b23t00 r, aa83b10t00 x ");
		query.append("where ");
		query.append("r.id_023 = x.id_023_num_sol ");
		query.append("AND r.id_ano_023 = x.id_ano_023 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapIdColeccion(aa83b10t00, idColeccion);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// query.append(" ORDER BY t1.ID_010 ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_023 ");
		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
	
	@Override
	public List<Aa83b10t00> findEnviadasNotificacionFechas(
			Aa83b10t00 aa83b10t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta) {
		// TODO Auto-generated method stub

		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String fechaD = (String) new SimpleDateFormat(formato)
				.format(fechaDesde);
		String fechaH = (String) new SimpleDateFormat(formato)
				.format(fechaHasta);

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("from aa83b23t00 s, aa83b10t00 t1 ");
		query.append("where s.id_023 = t1.id_023_num_sol ");
		query.append("AND s.id_ano_023 = t1.id_ano_023 ");
		query.append("AND (SOLI_CERRADA_023 IS NULL OR SOLI_CERRADA_023 <> 'S') ");
		query.append("AND (NOTIF_LEIDA_023 IS NULL OR NOTIF_LEIDA_023 <> 'S')");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND t1.F_ACTU_010 BETWEEN TO_DATE('" + fechaH + "','"
				+ formato + "') AND TO_DATE('" + fechaD + "','" + formato
				+ "') ");
		// nuevo
		query.append("AND t1.ID_010 = (Select MAX (ID_010) from aa83b10t00 z where z.id_023_num_sol = t1.id_023_num_sol and z.id_ano_023 = t1.id_ano_023) ");
		query.append("AND s.id_023||s.id_ano_023 NOT IN ");
		query.append("( ");
		query.append("select r.id_023||r.id_ano_023 from aa83b23t00 r, aa83b10t00 x ");
		query.append("where ");
		query.append("r.id_023 = x.id_023_num_sol ");
		query.append("AND r.id_ano_023 = x.id_ano_023 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
//		query.append("order by  s.id_023 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b10t00);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_023 ");
		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
	
	@Override
	public List<Aa83b10t00> findAllLikeNotificacionFechasIdColeccion(
			Aa83b10t00 aa83b10t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta, String idColeccion) {
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String fechaD = (String) new SimpleDateFormat(formato)
				.format(fechaDesde);
		String fechaH = (String) new SimpleDateFormat(formato)
				.format(fechaHasta);

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("from aa83b23t00 s, aa83b10t00 t1, AA83B43T00 t43 ");
		query.append("where s.id_023 = t1.id_023_num_sol ");
		query.append("AND s.id_ano_023 = t1.id_ano_023 ");
		query.append("AND t43.ID_SOL= s.id_023 ");
		query.append("AND t43.ID_ANYO= s.id_ano_023 ");
		query.append("AND (SOLI_CERRADA_023 IS NULL OR SOLI_CERRADA_023 <> 'S') ");
		query.append("AND (NOTIF_LEIDA_023 IS NULL OR NOTIF_LEIDA_023 <> 'S')");
		query.append("AND (id_001_fase='2'  AND id_002_tram='2') ");
		query.append("AND t1.F_ACTU_010 BETWEEN TO_DATE('" + fechaH + "','"
				+ formato + "') AND TO_DATE('" + fechaD + "','" + formato
				+ "') ");
		// nuevo
		query.append("AND t1.ID_010 = (Select MAX (ID_010) from aa83b10t00 z where z.id_023_num_sol = t1.id_023_num_sol and z.id_ano_023 = t1.id_ano_023) ");
		query.append("AND s.id_023||s.id_ano_023 NOT IN ");
		query.append("( ");
		query.append("select r.id_023||r.id_ano_023 from aa83b23t00 r, aa83b10t00 x ");
		query.append("where ");
		query.append("r.id_023 = x.id_023_num_sol ");
		query.append("AND r.id_ano_023 = x.id_ano_023 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
//		query.append("order by  s.id_023 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapIdColeccion(aa83b10t00, idColeccion);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_023 ");
		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
		
	}

	@Override
	public List<Aa83b10t00> findEnviadosRequerimientosFechas(
			Aa83b10t00 aa83b10t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub

		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String fechaD = (String) new SimpleDateFormat(formato)
				.format(fechaDesde);
		String fechaH = (String) new SimpleDateFormat(formato)
				.format(fechaHasta);
		logger.info("fechaD -->" + fechaD);
		logger.info("fechaH -->" + fechaH);
		
		logger.info("formato -->" + formato);
		
		String FaseReq = "1";
		String TramReq = "3";

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("from aa83b23t00 s, aa83b10t00 t1 ");
		query.append("where s.id_023 = t1.id_023_num_sol ");
		query.append("AND s.id_ano_023 = t1.id_ano_023 ");
		query.append("AND (SOLI_CERRADA_023 IS NULL OR SOLI_CERRADA_023 <> 'S') ");
		query.append("AND (id_001_fase='" + FaseReq + "'  AND id_002_tram='"
				+ TramReq + "') ");
		query.append("AND t1.F_ACTU_010 BETWEEN TO_DATE('" + fechaH + "','"
				+ formato + "') AND TO_DATE('" + fechaD + "','" + formato
				+ "') ");
		// nuevo
		query.append("AND t1.ID_010 = (Select MAX (ID_010) from aa83b10t00 z where z.id_023_num_sol = t1.id_023_num_sol and z.id_ano_023 = t1.id_ano_023) ");
		query.append("AND s.id_023||s.id_ano_023 NOT IN ");
		query.append("( ");
		query.append("select r.id_023||r.id_ano_023 from aa83b23t00 r, aa83b10t00 x ");
		query.append("where ");
		query.append("r.id_023 = x.id_023_num_sol ");
		query.append("AND r.id_ano_023 = x.id_ano_023 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
		

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b10t00);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_023 ");
		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
	
	@Override
	public List<Aa83b10t00> findEnviadosRequerimientosFechasIdColeccion(
			Aa83b10t00 aa83b10t00, JQGridRequestDto jqGridRequestDto,
			Date fechaDesde, Date fechaHasta, String idColeccion) {

		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String fechaD = (String) new SimpleDateFormat(formato)
				.format(fechaDesde);
		String fechaH = (String) new SimpleDateFormat(formato)
				.format(fechaHasta);

		String FaseReq = "1";
		String TramReq = "3";

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_010 ID010,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_023_NUM_SOL ID023NUMSOL,t1.ID_ANO_023 IDANO023,t1.F_ACTU_010 FACTU010,t1.USUA_010 USUA010,t1.F_REG_SAL_010 FREGSAL010,t1.N_REG_SAL_010 NREGSAL010,t1.F_NOTIF_010 FNOTIF010,t1.F_EXPIR_010 FEXPIR010,t1.F_MODIF_010 FMODIF010,t1.USU_MOD_010 USUMOD010,t1.F_TRAM_010 FTRAM010 ");
		query.append("from aa83b23t00 s, aa83b10t00 t1, AA83B43T00 t43 ");
		query.append("where s.id_023 = t1.id_023_num_sol ");
		query.append("AND s.id_ano_023 = t1.id_ano_023 ");
		query.append("AND t43.ID_SOL= s.id_023 ");
		query.append("AND t43.ID_ANYO= s.id_ano_023 ");
		query.append("AND (SOLI_CERRADA_023 IS NULL OR SOLI_CERRADA_023 <> 'S') ");
		query.append("AND (id_001_fase='" + FaseReq + "'  AND id_002_tram='"
				+ TramReq + "') ");
		query.append("AND t1.F_ACTU_010 BETWEEN TO_DATE('" + fechaH + "','"
				+ formato + "') AND TO_DATE('" + fechaD + "','" + formato
				+ "') ");
		// nuevo
		query.append("AND t1.ID_010 = (Select MAX (ID_010) from aa83b10t00 z where z.id_023_num_sol = t1.id_023_num_sol and z.id_ano_023 = t1.id_ano_023) ");
		query.append("AND s.id_023||s.id_ano_023 NOT IN ");
		query.append("( ");
		query.append("select r.id_023||r.id_ano_023 from aa83b23t00 r, aa83b10t00 x ");
		query.append("where ");
		query.append("r.id_023 = x.id_023_num_sol ");
		query.append("AND r.id_ano_023 = x.id_ano_023 ");
		query.append("AND (x.id_001_fase='3'  AND x.id_002_tram='1') ");
		query.append(") ");
		

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapIdColeccion(aa83b10t00, idColeccion);
		// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		query.append("order by  s.id_023 ");
		return (List<Aa83b10t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	

}
