package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b08t00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa83b08t00DaoImpl generated by UDA, 08-feb-2016 13:26:33.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b08t00DaoImpl implements Aa83b08t00Dao {
	private JdbcTemplate jdbcTemplate;
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b08t00> rwMap = new RowMapper<Aa83b08t00>() {
		public Aa83b08t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b08t00(resultSet.getInt("ID008"),
					resultSet.getInt("ID003TIPOSOL"),
					resultSet.getLong("IDANO025"),
					resultSet.getInt("ID025NUMSOL"),
					resultSet.getString("TIPOMODIF038"),
					resultSet.getString("FACTU008"),
					resultSet.getString("USUMODIF008"));
		}
	};

	private RowMapper<Aa83b08t00> rwMapPK = new RowMapper<Aa83b08t00>() {
		public Aa83b08t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b08t00(resultSet.getInt("ID008"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b08t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b08t00>>() {
		public JerarquiaDto<Aa83b08t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa83b08t00 aa83b08t00 = new Aa83b08t00(resultSet.getInt("ID008"),
					resultSet.getInt("ID003TIPOSOL"),
					resultSet.getLong("IDANO025"),
					resultSet.getInt("ID025NUMSOL"),
					resultSet.getString("TIPOMODIF038"),
					resultSet.getString("FACTU008"),
					resultSet.getString("USUMODIF008"));

			JerarquiaDto<Aa83b08t00> jerarquia = new JerarquiaDto<Aa83b08t00>();
			jerarquia.setModel(aa83b08t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b08t00 table.
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @return Aa83b08t00
	 */
	public Aa83b08t00 add(Aa83b08t00 aa83b08t00) {
		String formato = Aa83BConstants.ES_PATTERN_HORA_SELECT;// leire
		SimpleDateFormat dateFormat = new SimpleDateFormat(
				Aa83BConstants.ES_PATTERN_HORA);// "yyyy/MM/dd HH:mm:ss");
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_HORA_SELECT;
			dateFormat = new SimpleDateFormat(Aa83BConstants.EU_PATTERN_HORA);
		}

		java.util.Date date = new java.util.Date();
		String fechaD = dateFormat.format(date);

		String query = "INSERT INTO AA83B08T00 (ID_008, ID_003_TIPO_SOL, ID_ANO_025, ID_025_NUM_SOL, TIPO_MODIF_038, F_ACTU_008, USU_MODIF_008) VALUES (?,?,?,?,?,to_date(?,?),?)";
		this.jdbcTemplate.update(query, aa83b08t00.getId008(),
				aa83b08t00.getId003TipoSol(), aa83b08t00.getIdAno025(),
				aa83b08t00.getId025NumSol(), aa83b08t00.getTipoModif038(),
				fechaD, formato, aa83b08t00.getUsuModif008());
		return aa83b08t00;
	}

	/**
	 * Updates a single row in the Aa83b08t00 table.
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @return Aa83b08t00
	 */
	public Aa83b08t00 update(Aa83b08t00 aa83b08t00) {
		String formato = Aa83BConstants.ES_PATTERN;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN;
		}
		String query = "UPDATE AA83B08T00 SET ID_003_TIPO_SOL=?, ID_ANO_025=?, ID_025_NUM_SOL=?, TIPO_MODIF_038=?, F_ACTU_008=to_date(?,?), USU_MODIF_008=? WHERE ID_008=?";
		this.jdbcTemplate.update(query, aa83b08t00.getId003TipoSol(),
				aa83b08t00.getIdAno025(), aa83b08t00.getId025NumSol(),
				aa83b08t00.getTipoModif038(), aa83b08t00.getfActu008(),
				formato, aa83b08t00.getUsuModif008(), aa83b08t00.getId008());
		return aa83b08t00;
	}

	/**
	 * Finds a single row in the Aa83b08t00 table.
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @return Aa83b08t00
	 */
	@Transactional(readOnly = true)
	public Aa83b08t00 find(Aa83b08t00 aa83b08t00) {
		String formato = Aa83BConstants.ES_PATTERN_HORA_SELECT;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_HORA_SELECT;
		}
		String query = "SELECT t1.ID_008 ID008, t1.ID_003_TIPO_SOL ID003TIPOSOL, t1.ID_ANO_025 IDANO025, t1.ID_025_NUM_SOL ID025NUMSOL, t1.TIPO_MODIF_038 TIPOMODIF038, to_char(t1.F_ACTU_008,"
				+ formato
				+ ") FACTU008, t1.USU_MODIF_008 USUMODIF008 FROM AA83B08T00 t1  WHERE t1.ID_008 = ?  ";

		List<Aa83b08t00> aa83b08t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b08t00.getId008());
		return (Aa83b08t00) DataAccessUtils.uniqueResult(aa83b08t00List);
	}

	/**
	 * Removes a single row in the Aa83b08t00 table.
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @return
	 */
	public void remove(Aa83b08t00 aa83b08t00) {
		String query = "DELETE FROM AA83B08T00 WHERE ID_008=?";
		this.jdbcTemplate.update(query, aa83b08t00.getId008());
	}

	/**
	 * Finds a list of rows in the Aa83b08t00 table.
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b08t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b08t00> findAll(Aa83b08t00 aa83b08t00,
			JQGridRequestDto jqGridRequestDto) {
		String formato = Aa83BConstants.ES_PATTERN_HORA_SELECT;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_HORA_SELECT;
		}
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_008 ID008,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_ANO_025 IDANO025,t1.ID_025_NUM_SOL ID025NUMSOL,t1.TIPO_MODIF_038 TIPOMODIF038,to_char(t1.F_ACTU_008,"
						+ formato + ") FACTU008,t1.USU_MODIF_008 USUMODIF008 ");
		query.append("FROM AA83B08T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b08t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		return (List<Aa83b08t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b08t00 table using like.
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b08t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b08t00> findAllLike(Aa83b08t00 aa83b08t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_HORA_SELECT;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_HORA_SELECT;
		}
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_008 ID008,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_ANO_025 IDANO025,t1.ID_025_NUM_SOL ID025NUMSOL,t1.TIPO_MODIF_038 TIPOMODIF038,to_char(t1.F_ACTU_008,"
						+ formato + ") FACTU008,t1.USU_MODIF_008 USUMODIF008 ");
		query.append("FROM AA83B08T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b08t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY  t1.F_ACTU_008 DESC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		return (List<Aa83b08t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b08t00 table.
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b08t00 aa83b08t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B08T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b08t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b08t00 table using like.
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b08t00 aa83b08t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B08T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b08t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b08t00 selected for rup_table
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b08t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b08t00>> reorderSelection(
			Aa83b08t00 aa83b08t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_HORA_SELECT;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_HORA_SELECT;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_008 ID008,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_ANO_025 IDANO025,t1.ID_025_NUM_SOL ID025NUMSOL,t1.TIPO_MODIF_038 TIPOMODIF038,t1.to_char(t1.F_ACTU_008,"
						+ formato + ") FACTU008,t1.USU_MODIF_008 USUMODIF008 ");
		// FROM
		query.append("FROM AA83B08T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b08t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b08t00.class, filterParamList,
				"ID_008");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b08t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b08t00
	 * @param searchParams
	 *            Aa83b08t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b08t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b08t00>> search(Aa83b08t00 filterParams,
			Aa83b08t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_HORA_SELECT;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_HORA_SELECT;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_008 ID008,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_ANO_025 IDANO025,t1.ID_025_NUM_SOL ID025NUMSOL,t1.TIPO_MODIF_038 TIPOMODIF038,to_char(t1.F_ACTU_008,"
						+ formato + ") FACTU008,t1.USU_MODIF_008 USUMODIF008 ");
		// FROM
		query.append("FROM AA83B08T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b08t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_008");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b08t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b08t00
	 *            Aa83b08t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b08t00 filteraa83b08t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		String formato = Aa83BConstants.ES_PATTERN_HORA_SELECT;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_HORA_SELECT;
		}
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_008 ID008,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_ANO_025 IDANO025,t1.ID_025_NUM_SOL ID025NUMSOL,t1.TIPO_MODIF_038 TIPOMODIF038,to_char(t1.F_ACTU_008,"
						+ formato + ") FACTU008,t1.USU_MODIF_008 USUMODIF008 ");
		// FROM
		query.append("FROM AA83B08T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b08t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b08t00.class,
						query, params, "ID_008");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b08t00 table.
	 * 
	 * @param filterAa83b08t00
	 *            Aa83b08t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b08t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b08t00>> findAllLikeJerarquia(
			Aa83b08t00 filterAa83b08t00, JQGridRequestDto jqGridRequestDto) {
		String formato = Aa83BConstants.ES_PATTERN_HORA_SELECT;
		if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale()
				.getLanguage())) {
			formato = Aa83BConstants.EU_PATTERN_HORA_SELECT;
		}
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_008 ID008,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.ID_ANO_025 IDANO025,t1.ID_025_NUM_SOL ID025NUMSOL,t1.TIPO_MODIF_038 TIPOMODIF038,to_char(t1.F_ACTU_008,"
						+ formato + ") FACTU008,t1.USU_MODIF_008 USUMODIF008 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B08T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B08T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b08t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_008", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b08t00
	 *            Aa83b08t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b08t00 filterAa83b08t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B08T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B08T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b08t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_008", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b08t00
	 *            Aa83b08t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b08t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b08t00>> findAllChild(
			Aa83b08t00 filterAa83b08t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B08T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B08T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b08t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_008", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa83b08t00>(this.rwMapPK,
								"ID_008"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b08t00 entity
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b08t00 aa83b08t00) {

		StringBuilder where = new StringBuilder(
				Aa83b08t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b08t00 != null && aa83b08t00.getId008() != null) {
			where.append(" AND t1.ID_008 = ?");
			params.add(aa83b08t00.getId008());
		}
		if (aa83b08t00 != null && aa83b08t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b08t00.getId003TipoSol());
		}
		if (aa83b08t00 != null && aa83b08t00.getIdAno025() != null) {
			where.append(" AND t1.ID_ANO_025 = ?");
			params.add(aa83b08t00.getIdAno025());
		}
		if (aa83b08t00 != null && aa83b08t00.getId025NumSol() != null) {
			where.append(" AND t1.ID_025_NUM_SOL = ?");
			params.add(aa83b08t00.getId025NumSol());
		}
		if (aa83b08t00 != null && aa83b08t00.getTipoModif038() != null) {
			where.append(" AND t1.TIPO_MODIF_038 = ?");
			params.add(aa83b08t00.getTipoModif038());
		}
		if (aa83b08t00 != null && aa83b08t00.getfActu008() != null) {
			where.append(" AND t1.F_ACTU_008 = ?");
			params.add(aa83b08t00.getfActu008());
		}
		if (aa83b08t00 != null && aa83b08t00.getUsuModif008() != null) {
			where.append(" AND t1.USU_MODIF_008 = ?");
			params.add(aa83b08t00.getUsuModif008());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b08t00 entity
	 * 
	 * @param aa83b08t00
	 *            Aa83b08t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b08t00 aa83b08t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b08t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b08t00 != null && aa83b08t00.getId008() != null) {
			where.append(" AND t1.ID_008 = ?");
			params.add(aa83b08t00.getId008());
		}
		if (aa83b08t00 != null && aa83b08t00.getId003TipoSol() != null) {
			where.append(" AND t1.ID_003_TIPO_SOL = ?");
			params.add(aa83b08t00.getId003TipoSol());
		}
		if (aa83b08t00 != null && aa83b08t00.getIdAno025() != null) {
			where.append(" AND t1.ID_ANO_025 = ?");
			params.add(aa83b08t00.getIdAno025());
		}
		if (aa83b08t00 != null && aa83b08t00.getId025NumSol() != null) {
			where.append(" AND t1.ID_025_NUM_SOL = ?");
			params.add(aa83b08t00.getId025NumSol());
		}
		if (aa83b08t00 != null && aa83b08t00.getTipoModif038() != null) {
			where.append(" AND UPPER(t1.TIPO_MODIF_038) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b08t00.getTipoModif038().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b08t00.getTipoModif038().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPO_MODIF_038 IS NOT NULL");
		}
		if (aa83b08t00 != null && aa83b08t00.getfActu008() != null) {
			where.append(" AND t1.F_ACTU_008 = ?");
			params.add(aa83b08t00.getfActu008());
		}
		if (aa83b08t00 != null && aa83b08t00.getUsuModif008() != null) {
			where.append(" AND UPPER(t1.USU_MODIF_008) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b08t00.getUsuModif008().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b08t00.getUsuModif008().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.USU_MODIF_008 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
