package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b07v00;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilidades;

/**
 * Aa83b07v00DaoImpl generated by UDA, 26-oct-2016 16:26:48.
 * @author UDA
 */
 
@Repository
@Transactional
public class Aa83b07v00DaoImpl implements Aa83b07v00Dao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b07v00> rwMap = new RowMapper<Aa83b07v00>() {
		public Aa83b07v00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			
			Aa83b07v00 obj = new Aa83b07v00();
			obj.setSolconcat(resultSet.getString("SOLCONCAT")); 
            obj.setIdAno(resultSet.getString("IDANO"));
            obj.setId(resultSet.getString("ID"));
            obj.setNumReg(resultSet.getString("NUMREG"));
            if (resultSet.getString("NOMBRE") != null){
            	obj.setNombre(Aa83bUtilidades.tildesSinHtml(resultSet.getString("NOMBRE")));
            }
            if (resultSet.getString("APEL1") != null) {
            	obj.setApel1(Aa83bUtilidades.tildesSinHtml(resultSet.getString("APEL1")));
            }
            if (resultSet.getString("APEL2") != null) {
            	obj.setApel2(Aa83bUtilidades.tildesSinHtml(resultSet.getString("APEL2")));
            }
            if (resultSet.getString("APELLIDOS") != null) {
            	obj.setApellidos(Aa83bUtilidades.tildesSinHtml(resultSet.getString("APELLIDOS")));
            }
            obj.setTipoDoc(resultSet.getString("TIPODOC"));
            obj.setNumDoc(resultSet.getString("NUMDOC"));
            obj.setSoliCerrada(resultSet.getString("SOLICERRADA"));
            obj.setIdSol(resultSet.getString("IDSOL"));
            obj.setTipoSol(resultSet.getString("TIPOSOL"));
            obj.setIdFase(resultSet.getString("IDFASE"));
            obj.setIdTram(resultSet.getString("IDTRAM"));
            obj.setFecAltaOrd(resultSet.getTimestamp("FECALTAORD"));
            obj.setFecAltaEs(resultSet.getString("FECALTAES"));
            obj.setFecAltaEu(resultSet.getString("FECALTAEU"));            
            if (resultSet.getString("DESCESTRAM") !=null ) {
            	obj.setDescEsTram(Aa83bUtilidades.tildesSinHtml(resultSet.getString("DESCESTRAM")));
            }
            if (resultSet.getString("DESCEUTRAM") != null){
            	obj.setDescEuTram(Aa83bUtilidades.tildesSinHtml(resultSet.getString("DESCEUTRAM")));
            }
			
           return obj; } } ;
           
	private RowMapper<Aa83b07v00> rwMapPK = new RowMapper<Aa83b07v00>() {
		public Aa83b07v00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Aa83b07v00 obj = new Aa83b07v00();
			obj.setSolconcat(resultSet.getString("SOLCONCAT")); 
            obj.setIdAno(resultSet.getString("IDANO"));
            obj.setId(resultSet.getString("ID"));
            obj.setNumReg(resultSet.getString("NUMREG"));
            if (resultSet.getString("NOMBRE") != null){
            	obj.setNombre(Aa83bUtilidades.tildesSinHtml(resultSet.getString("NOMBRE")));
            }
            if (resultSet.getString("APEL1") != null) {
            	obj.setApel1(Aa83bUtilidades.tildesSinHtml(resultSet.getString("APEL1")));
            }
            if (resultSet.getString("APEL2") != null) {
            	obj.setApel2(Aa83bUtilidades.tildesSinHtml(resultSet.getString("APEL2")));
            }
            if (resultSet.getString("APELLIDOS") != null) {
            	obj.setApellidos(Aa83bUtilidades.tildesSinHtml(resultSet.getString("APELLIDOS")));
            }
            obj.setTipoDoc(resultSet.getString("TIPODOC"));
            obj.setNumDoc(resultSet.getString("NUMDOC"));
            obj.setSoliCerrada(resultSet.getString("SOLICERRADA"));
            obj.setIdSol(resultSet.getString("IDSOL"));
            obj.setTipoSol(resultSet.getString("TIPOSOL"));
            obj.setIdFase(resultSet.getString("IDFASE"));
            obj.setIdTram(resultSet.getString("IDTRAM"));
            obj.setFecAltaOrd(resultSet.getTimestamp("FECALTAORD"));
            obj.setFecAltaEs(resultSet.getString("FECALTAES"));
            obj.setFecAltaEu(resultSet.getString("FECALTAEU"));
            if (resultSet.getString("DESCESTRAM") !=null ) {
            	obj.setDescEsTram(Aa83bUtilidades.tildesSinHtml(resultSet.getString("DESCESTRAM")));
            }
            if (resultSet.getString("DESCEUTRAM") != null){
            	obj.setDescEuTram(Aa83bUtilidades.tildesSinHtml(resultSet.getString("DESCEUTRAM")));
            }
			
           return obj; } } ;

	/**
     * Rowmapper para Jerarquía
     *
     * @param dataSource DataSource
     * @return
     */
	private RowMapper<JerarquiaDto< Aa83b07v00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b07v00>>() {
		public JerarquiaDto<Aa83b07v00> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Aa83b07v00 aa83b07v00 = new Aa83b07v00(resultSet.getString("SOLCONCAT"), 
					resultSet.getString("IDANO"), 
					resultSet.getString("ID"), 
					resultSet.getString("NUMREG"), 
					resultSet.getString("NOMBRE"), 
					resultSet.getString("APEL1"), 
					resultSet.getString("APEL2"), 
					resultSet.getString("APELLIDOS"), 
					resultSet.getString("TIPODOC"), 
					resultSet.getString("NUMDOC"), 
					resultSet.getString("SOLICERRADA"), 
					resultSet.getString("IDSOL"), 
					resultSet.getString("TIPOSOL"), 
					resultSet.getString("IDFASE"), 
					resultSet.getString("IDTRAM"), 
					resultSet.getString("FECALTAES"), 
					resultSet.getString("FECALTAEU"),					
					resultSet.getTimestamp("FECALTAORD"), 
					resultSet.getString("DESCESTRAM"), 
					resultSet.getString("DESCEUTRAM"));

			JerarquiaDto<Aa83b07v00> jerarquia = new JerarquiaDto<Aa83b07v00>();
			jerarquia.setModel(aa83b07v00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
     * Inserts a single row in the Aa83b07v00 table.
     *
     * @param aa83b07v00 Aa83b07v00
     * @return Aa83b07v00
     */
	public Aa83b07v00 add(Aa83b07v00 aa83b07v00) {
    	String query = "INSERT INTO AA83B07V00 (SOLCONCAT, ID_ANO, ID, NUM_REG, NOMBRE, APEL1, APEL2, APELLIDOS, TIPO_DOC, NUM_DOC, SOLI_CERRADA, ID_SOL, TIPO_SOL, ID_FASE, ID_TRAM, FEC_ALTA_ES, FEC_ALTA_EU, FEC_ALTA_ORD, DESC_ES_TRAM, DESC_EU_TRAM) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b07v00.getSolconcat(), aa83b07v00.getIdAno(), aa83b07v00.getId(), aa83b07v00.getNumReg(), aa83b07v00.getNombre(), aa83b07v00.getApel1(), aa83b07v00.getApel2(), aa83b07v00.getApellidos(), aa83b07v00.getTipoDoc(), aa83b07v00.getNumDoc(), aa83b07v00.getSoliCerrada(), aa83b07v00.getIdSol(), aa83b07v00.getTipoSol(), aa83b07v00.getIdFase(), aa83b07v00.getIdTram(), aa83b07v00.getFecAltaEs(), aa83b07v00.getFecAltaEu(), aa83b07v00.getFecAltaOrd(), aa83b07v00.getDescEsTram(), aa83b07v00.getDescEuTram());
		return aa83b07v00;
	}

    /**
     * Updates a single row in the Aa83b07v00 table.
     *
     * @param aa83b07v00 Aa83b07v00
     * @return Aa83b07v00
     */
    public Aa83b07v00 update(Aa83b07v00 aa83b07v00) {
		String query = "UPDATE AA83B07V00 SET  WHERE SOLCONCAT=? AND ID_ANO=? AND ID=? AND NUM_REG=? AND NOMBRE=? AND APEL1=? AND APEL2=? AND APELLIDOS=? AND TIPO_DOC=? AND NUM_DOC=? AND SOLI_CERRADA=? AND ID_SOL=? AND TIPO_SOL=? AND ID_FASE=? AND ID_TRAM=? AND FEC_ALTA_ES=? AND FEC_ALTA_EU=? AND FEC_ALTA_ORD=? AND DESC_ES_TRAM=? AND DESC_EU_TRAM=?";
		this.jdbcTemplate.update(query, aa83b07v00.getSolconcat(), aa83b07v00.getIdAno(), aa83b07v00.getId(), aa83b07v00.getNumReg(), aa83b07v00.getNombre(), aa83b07v00.getApel1(), aa83b07v00.getApel2(), aa83b07v00.getApellidos(), aa83b07v00.getTipoDoc(), aa83b07v00.getNumDoc(), aa83b07v00.getSoliCerrada(), aa83b07v00.getIdSol(), aa83b07v00.getTipoSol(), aa83b07v00.getIdFase(), aa83b07v00.getIdTram(), aa83b07v00.getFecAltaEs(), aa83b07v00.getFecAltaEu(), aa83b07v00.getFecAltaOrd(), aa83b07v00.getDescEsTram(), aa83b07v00.getDescEuTram());
		return aa83b07v00;
	}

    /**
     * Finds a single row in the Aa83b07v00 table.
     *
     * @param aa83b07v00 Aa83b07v00
     * @return Aa83b07v00
     */
    @Transactional (readOnly = true)
    public Aa83b07v00 find(Aa83b07v00 aa83b07v00) {
		String query = "SELECT t1.SOLCONCAT SOLCONCAT, t1.ID_ANO IDANO, t1.ID ID, t1.NUM_REG NUMREG, t1.NOMBRE NOMBRE, t1.APEL1 APEL1, t1.APEL2 APEL2, t1.APELLIDOS APELLIDOS, t1.TIPO_DOC TIPODOC, t1.NUM_DOC NUMDOC, t1.SOLI_CERRADA SOLICERRADA, t1.ID_SOL IDSOL, t1.TIPO_SOL TIPOSOL, t1.ID_FASE IDFASE, t1.ID_TRAM IDTRAM, t1.FEC_ALTA_ES FECALTAES, t1.FEC_ALTA_EU FECALTAEU, t1.FEC_ALTA_ORD FECALTAORD, t1.DESC_ES_TRAM DESCESTRAM, t1.DESC_EU_TRAM DESCEUTRAM FROM AA83B07V00 t1  WHERE t1.SOLCONCAT = ?   AND t1.ID_ANO = ?   AND t1.ID = ?   AND t1.NUM_REG = ?   AND t1.NOMBRE = ?   AND t1.APEL1 = ?   AND t1.APEL2 = ?   AND t1.APELLIDOS = ?   AND t1.TIPO_DOC = ?   AND t1.NUM_DOC = ?   AND t1.SOLI_CERRADA = ?   AND t1.ID_SOL = ?   AND t1.TIPO_SOL = ?   AND t1.ID_FASE = ?   AND t1.ID_TRAM = ?   AND t1.FEC_ALTA_ES = ?   AND t1.FEC_ALTA_EU = ?   AND t1.DESC_ES_TRAM = ?   AND t1.DESC_EU_TRAM = ?  ";
		
		List<Aa83b07v00> aa83b07v00List = this.jdbcTemplate.query(query, this.rwMap, aa83b07v00.getSolconcat() , aa83b07v00.getIdAno() , aa83b07v00.getId() , aa83b07v00.getNumReg() , aa83b07v00.getNombre() , aa83b07v00.getApel1() , aa83b07v00.getApel2() , aa83b07v00.getApellidos() , aa83b07v00.getTipoDoc() , aa83b07v00.getNumDoc() , aa83b07v00.getSoliCerrada() , aa83b07v00.getIdSol() , aa83b07v00.getTipoSol() , aa83b07v00.getIdFase() , aa83b07v00.getIdTram() , aa83b07v00.getFecAltaEs() , aa83b07v00.getFecAltaEu() , aa83b07v00.getFecAltaOrd() , aa83b07v00.getDescEsTram() , aa83b07v00.getDescEuTram());
		return (Aa83b07v00) DataAccessUtils.uniqueResult(aa83b07v00List);
    }

    /**
     * Removes a single row in the Aa83b07v00 table.
     *
     * @param aa83b07v00 Aa83b07v00
     * @return
     */
    public void remove(Aa83b07v00 aa83b07v00) {
		String query = "DELETE FROM AA83B07V00 WHERE SOLCONCAT=? AND ID_ANO=? AND ID=? AND NUM_REG=? AND NOMBRE=? AND APEL1=? AND APEL2=? AND APELLIDOS=? AND TIPO_DOC=? AND NUM_DOC=? AND SOLI_CERRADA=? AND ID_SOL=? AND TIPO_SOL=? AND ID_FASE=? AND ID_TRAM=? AND FEC_ALTA_ES=? AND FEC_ALTA_EU=? AND FEC_ALTA_ORD=? AND DESC_ES_TRAM=? AND DESC_EU_TRAM=?";
		this.jdbcTemplate.update(query, aa83b07v00.getSolconcat() , aa83b07v00.getIdAno() , aa83b07v00.getId() , aa83b07v00.getNumReg() , aa83b07v00.getNombre() , aa83b07v00.getApel1() , aa83b07v00.getApel2() , aa83b07v00.getApellidos() , aa83b07v00.getTipoDoc() , aa83b07v00.getNumDoc() , aa83b07v00.getSoliCerrada() , aa83b07v00.getIdSol() , aa83b07v00.getTipoSol() , aa83b07v00.getIdFase() , aa83b07v00.getIdTram() , aa83b07v00.getFecAltaEs() ,aa83b07v00.getFecAltaEu() , aa83b07v00.getFecAltaOrd() , aa83b07v00.getDescEsTram() , aa83b07v00.getDescEuTram());
    }
    
   /**
    * Finds a list of rows in the Aa83b07v00 table.
    * 
    * @param aa83b07v00 Aa83b07v00
    * @param jqGridRequestDto JQGridRequestDto
    * @return List<Aa83b07v00> 
    */
	@Transactional (readOnly = true)
    public List<Aa83b07v00> findAll(Aa83b07v00 aa83b07v00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.SOLCONCAT SOLCONCAT,t1.ID_ANO IDANO,t1.ID ID,t1.NUM_REG NUMREG,t1.NOMBRE NOMBRE,t1.APEL1 APEL1,t1.APEL2 APEL2,t1.APELLIDOS APELLIDOS,t1.TIPO_DOC TIPODOC,t1.NUM_DOC NUMDOC,t1.SOLI_CERRADA SOLICERRADA,t1.ID_SOL IDSOL,t1.TIPO_SOL TIPOSOL,t1.ID_FASE IDFASE,t1.ID_TRAM IDTRAM,t1.FEC_ALTA_ES FECALTAES,t1.FEC_ALTA_EU FECALTAEU,t1.FEC_ALTA_ORD FECALTAORD,t1.DESC_ES_TRAM DESCESTRAM,t1.DESC_EU_TRAM DESCEUTRAM "); 
		query.append("FROM AA83B07V00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b07v00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b07v00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the Aa83b07v00 table using like.
     * 
     * @param aa83b07v00 Aa83b07v00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<Aa83b07v00>
     */
	@Transactional (readOnly = true)
    public List<Aa83b07v00> findAllLike(Aa83b07v00 aa83b07v00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.SOLCONCAT SOLCONCAT,t1.ID_ANO IDANO,t1.ID ID,t1.NUM_REG NUMREG,t1.NOMBRE NOMBRE,t1.APEL1 APEL1,t1.APEL2 APEL2,t1.APELLIDOS APELLIDOS,t1.TIPO_DOC TIPODOC,t1.NUM_DOC NUMDOC,t1.SOLI_CERRADA SOLICERRADA,t1.ID_SOL IDSOL,t1.TIPO_SOL TIPOSOL,t1.ID_FASE IDFASE,t1.ID_TRAM IDTRAM,t1.FEC_ALTA_ES FECALTAES,t1.FEC_ALTA_EU FECALTAEU,t1.FEC_ALTA_ORD FECALTAORD,t1.DESC_ES_TRAM DESCESTRAM,t1.DESC_EU_TRAM DESCEUTRAM "); 
        query.append("FROM AA83B07V00 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b07v00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b07v00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
     * Counts rows in the Aa83b07v00 table.
     * 
     * @param aa83b07v00 Aa83b07v00
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Aa83b07v00 aa83b07v00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B07V00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b07v00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Aa83b07v00 table using like.
     * 
     * @param aa83b07v00 Aa83b07v00
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Aa83b07v00 aa83b07v00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B07V00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b07v00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b07v00 selected for rup_table
     * 
     * @param aa83b07v00 Aa83b07v00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b07v00>> 
     */
	@Override 
	public List<TableRowDto<Aa83b07v00>> reorderSelection(Aa83b07v00 aa83b07v00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.SOLCONCAT SOLCONCAT,t1.ID_ANO IDANO,t1.ID ID,t1.NUM_REG NUMREG,t1.NOMBRE NOMBRE,t1.APEL1 APEL1,t1.APEL2 APEL2,t1.APELLIDOS APELLIDOS,t1.TIPO_DOC TIPODOC,t1.NUM_DOC NUMDOC,t1.SOLI_CERRADA SOLICERRADA,t1.ID_SOL IDSOL,t1.TIPO_SOL TIPOSOL,t1.ID_FASE IDFASE,t1.ID_TRAM IDTRAM,t1.FEC_ALTA FECALTA,t1.FEC_ALTA_ORD FECALTAORD,t1.DESC_ES_TRAM DESCESTRAM,t1.DESC_EU_TRAM DESCEUTRAM "); 
		// FROM
        query.append("FROM AA83B07V00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b07v00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Aa83b07v00.class, filterParamList, "SOLCONCAT,ID_ANO,ID,NUM_REG,NOMBRE,APEL1,APEL2,APELLIDOS,TIPO_DOC,NUM_DOC,SOLI_CERRADA,ID_SOL,TIPO_SOL,ID_FASE,ID_TRAM,FEC_ALTA_ES,FEC_ALTA_EU,DESC_ES_TRAM,DESC_EU_TRAM" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b07v00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
     * 
     * @param filterParams Aa83b07v00
     * @param searchParams Aa83b07v00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b07v00>> 
     */
	@Override
	public List<TableRowDto<Aa83b07v00>> search(Aa83b07v00 filterParams, Aa83b07v00 searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.SOLCONCAT SOLCONCAT,t1.ID_ANO IDANO,t1.ID ID,t1.NUM_REG NUMREG,t1.NOMBRE NOMBRE,t1.APEL1 APEL1,t1.APEL2 APEL2,t1.APELLIDOS APELLIDOS,t1.TIPO_DOC TIPODOC,t1.NUM_DOC NUMDOC,t1.SOLI_CERRADA SOLICERRADA,t1.ID_SOL IDSOL,t1.TIPO_SOL TIPOSOL,t1.ID_FASE IDFASE,t1.ID_TRAM IDTRAM,t1.FEC_ALTA FECALTA,t1.FEC_ALTA_ORD FECALTAORD,t1.DESC_ES_TRAM DESCESTRAM,t1.DESC_EU_TRAM DESCEUTRAM "); 
		// FROM
        query.append("FROM AA83B07V00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Aa83b07v00.class, filterParamList, searchSQL, searchParamList, from_alias, "SOLCONCAT,ID_ANO,ID,NUM_REG,NOMBRE,APEL1,APEL2,APELLIDOS,TIPO_DOC,NUM_DOC,SOLI_CERRADA,ID_SOL,TIPO_SOL,ID_FASE,ID_TRAM,FEC_ALTA_ES,FEC_ALTA_EU,DESC_ES_TRAM,DESC_EU_TRAM");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b07v00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table
     * 
     * @param filteraa83b07v00 Aa83b07v00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean 
     */
	@Override
	public void removeMultiple(Aa83b07v00 filteraa83b07v00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.SOLCONCAT SOLCONCAT,t1.ID_ANO IDANO,t1.ID ID,t1.NUM_REG NUMREG,t1.NOMBRE NOMBRE,t1.APEL1 APEL1,t1.APEL2 APEL2,t1.APELLIDOS APELLIDOS,t1.TIPO_DOC TIPODOC,t1.NUM_DOC NUMDOC,t1.SOLI_CERRADA SOLICERRADA,t1.ID_SOL IDSOL,t1.TIPO_SOL TIPOSOL,t1.ID_FASE IDFASE,t1.ID_TRAM IDTRAM,t1.FEC_ALTA FECALTA,t1.FEC_ALTA_ORD FECALTAORD,t1.DESC_ES_TRAM DESCESTRAM,t1.DESC_EU_TRAM DESCEUTRAM "); 
		// FROM
        query.append("FROM AA83B07V00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b07v00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Aa83b07v00.class, query, params, "SOLCONCAT,ID_ANO,ID,NUM_REG,NOMBRE,APEL1,APEL2,APELLIDOS,TIPO_DOC,NUM_DOC,SOLI_CERRADA,ID_SOL,TIPO_SOL,ID_FASE,ID_TRAM,FEC_ALTA_ES,FEC_ALTA_EU,DESC_ES_TRAM,DESC_EU_TRAM");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b07v00 table.
     * 
     * @param filterAa83b07v00 Aa83b07v00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<JerarquiaDto<Aa83b07v00>> 
     */
	@Override
	public List<JerarquiaDto<Aa83b07v00>> findAllLikeJerarquia(Aa83b07v00 filterAa83b07v00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.SOLCONCAT SOLCONCAT,t1.ID_ANO IDANO,t1.ID ID,t1.NUM_REG NUMREG,t1.NOMBRE NOMBRE,t1.APEL1 APEL1,t1.APEL2 APEL2,t1.APELLIDOS APELLIDOS,t1.TIPO_DOC TIPODOC,t1.NUM_DOC NUMDOC,t1.SOLI_CERRADA SOLICERRADA,t1.ID_SOL IDSOL,t1.TIPO_SOL TIPOSOL,t1.ID_FASE IDFASE,t1.ID_TRAM IDTRAM,t1.FEC_ALTA FECALTA,t1.FEC_ALTA_ORD FECALTAORD,,t1.DESC_ES_TRAM DESCESTRAM,t1.DESC_EU_TRAM DESCEUTRAM "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B07V00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B07V00");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b07v00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "SOLCONCAT,ID_ANO,ID,NUM_REG,NOMBRE,APEL1,APEL2,APELLIDOS,TIPO_DOC,NUM_DOC,SOLI_CERRADA,ID_SOL,TIPO_SOL,ID_FASE,ID_TRAM,FEC_ALTA,FEC_ALTA_ORD,DESC_ES_TRAM,DESC_EU_TRAM", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
     * 
     * @param filterAa83b07v00 Aa83b07v00
     * @param jqGridRequestDto JQGridRequestDto
     * @return Long 
     */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b07v00 filterAa83b07v00, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B07V00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B07V00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b07v00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "SOLCONCAT,ID_ANO,ID,NUM_REG,NOMBRE,APEL1,APEL2,APELLIDOS,TIPO_DOC,NUM_DOC,SOLI_CERRADA,ID_SOL,TIPO_SOL,ID_FASE,ID_TRAM,FEC_ALTA,FEC_ALTA_ORD,DESC_ES_TRAM,DESC_EU_TRAM", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
     * 
     * @param filterAa83b07v00 Aa83b07v00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<TableRowDto<Aa83b07v00>> 
     */
	@Override
	public List<TableRowDto<Aa83b07v00>> findAllChild(Aa83b07v00 filterAa83b07v00, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B07V00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B07V00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b07v00, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "SOLCONCAT,ID_ANO,ID,NUM_REG,NOMBRE,APEL1,APEL2,APELLIDOS,TIPO_DOC,NUM_DOC,SOLI_CERRADA,ID_SOL,TIPO_SOL,ID_FASE,ID_TRAM,FEC_ALTA,FEC_ALTA_ORD,DESC_ES_TRAM,DESC_EU_TRAM", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Aa83b07v00>(this.rwMapPK, "SOLCONCAT,ID_ANO,ID,NUM_REG,NOMBRE,APEL1,APEL2,APELLIDOS,TIPO_DOC,NUM_DOC,SOLI_CERRADA,ID_SOL,TIPO_SOL,ID_FASE,ID_TRAM,FEC_ALTA_ES,FEC_ALTA_EU,DESC_ES_TRAM,DESC_EU_TRAM"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Aa83b07v00 entity 
	 * 
	 * @param aa83b07v00 Aa83b07v00
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Aa83b07v00 aa83b07v00){
		
		StringBuilder where = new StringBuilder(Aa83b07v00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b07v00  != null  && aa83b07v00.getSolconcat() != null ) {
			where.append(" AND t1.SOLCONCAT = ?");
			params.add(aa83b07v00.getSolconcat());
		}
		if (aa83b07v00  != null  && aa83b07v00.getIdAno() != null ) {
			where.append(" AND t1.ID_ANO = ?");
			params.add(aa83b07v00.getIdAno());
		}
		if (aa83b07v00  != null  && aa83b07v00.getId() != null ) {
			where.append(" AND t1.ID = ?");
			params.add(aa83b07v00.getId());
		}
		if (aa83b07v00  != null  && aa83b07v00.getNumReg() != null ) {
			where.append(" AND t1.NUM_REG = ?");
			params.add(aa83b07v00.getNumReg());
		}
		if (aa83b07v00  != null  && aa83b07v00.getNombre() != null ) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(aa83b07v00.getNombre());
		}
		if (aa83b07v00  != null  && aa83b07v00.getApel1() != null ) {
			where.append(" AND t1.APEL1 = ?");
			params.add(aa83b07v00.getApel1());
		}
		if (aa83b07v00  != null  && aa83b07v00.getApel2() != null ) {
			where.append(" AND t1.APEL2 = ?");
			params.add(aa83b07v00.getApel2());
		}
		if (aa83b07v00  != null  && aa83b07v00.getApellidos() != null ) {
			where.append(" AND t1.APELLIDOS = ?");
			params.add(aa83b07v00.getApellidos());
		}
		if (aa83b07v00  != null  && aa83b07v00.getTipoDoc() != null ) {
			where.append(" AND t1.TIPO_DOC = ?");
			params.add(aa83b07v00.getTipoDoc());
		}
		if (aa83b07v00  != null  && aa83b07v00.getNumDoc() != null ) {
			where.append(" AND t1.NUM_DOC = ?");
			params.add(aa83b07v00.getNumDoc());
		}
		if (aa83b07v00  != null  && aa83b07v00.getSoliCerrada() != null ) {
			where.append(" AND t1.SOLI_CERRADA = ?");
			params.add(aa83b07v00.getSoliCerrada());
		}
		if (aa83b07v00  != null  && aa83b07v00.getIdSol() != null ) {
			where.append(" AND t1.ID_SOL = ?");
			params.add(aa83b07v00.getIdSol());
		}
		if (aa83b07v00  != null  && aa83b07v00.getTipoSol() != null ) {
			where.append(" AND t1.TIPO_SOL = ?");
			params.add(aa83b07v00.getTipoSol());
		}
		if (aa83b07v00  != null  && aa83b07v00.getIdFase() != null ) {
			where.append(" AND t1.ID_FASE = ?");
			params.add(aa83b07v00.getIdFase());
		}
		if (aa83b07v00  != null  && aa83b07v00.getIdTram() != null ) {
			where.append(" AND t1.ID_TRAM = ?");
			params.add(aa83b07v00.getIdTram());
		}
		if (aa83b07v00  != null  && aa83b07v00.getFecAltaEs() != null ) {
			where.append(" AND t1.FEC_ALTA_ES = ?");
			params.add(aa83b07v00.getFecAltaEs());
		}
		if (aa83b07v00  != null  && aa83b07v00.getFecAltaEu() != null ) {
			where.append(" AND t1.FEC_ALTA_EU = ?");
			params.add(aa83b07v00.getFecAltaEu());
		}		
		if (aa83b07v00  != null  && aa83b07v00.getFecAltaOrd() != null ) {
			where.append(" AND t1.FEC_ALTA_ORD = ?");
			params.add(aa83b07v00.getFecAltaOrd());
		}
		if (aa83b07v00  != null  && aa83b07v00.getDescEsTram() != null ) {
			where.append(" AND t1.DESC_ES_TRAM = ?");
			params.add(aa83b07v00.getDescEsTram());
		}
		if (aa83b07v00  != null  && aa83b07v00.getDescEuTram() != null ) {
			where.append(" AND t1.DESC_EU_TRAM = ?");
			params.add(aa83b07v00.getDescEuTram());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Aa83b07v00 entity 
	 * 
	 * @param aa83b07v00 Aa83b07v00
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (Aa83b07v00 aa83b07v00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(Aa83b07v00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b07v00  != null  && aa83b07v00.getSolconcat() != null ) {
			where.append(" AND UPPER(t1.SOLCONCAT) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b07v00.getSolconcat().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b07v00.getSolconcat().toUpperCase() +"%");
			}
			where.append(" AND t1.SOLCONCAT IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getIdAno() != null ) {
			where.append(" AND t1.ID_ANO = ?");
			params.add(aa83b07v00.getIdAno());
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getId() != null ) {
			where.append(" AND t1.ID = ?");
			params.add(aa83b07v00.getId());
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getNumReg() != null ) {
			where.append(" AND UPPER(t1.NUM_REG) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b07v00.getNumReg().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b07v00.getNumReg().toUpperCase() +"%");
			}
			where.append(" AND t1.NUM_REG IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getNombre() != null ) {
			where.append(" AND UPPER(TRANSLATE(t1.NOMBRE,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(Aa83bUtilidades.SinTildes(aa83b07v00.getNombre().toUpperCase() +"%"));
			}else{
				params.add(Aa83bUtilidades.SinTildes("%"+aa83b07v00.getNombre().toUpperCase() +"%"));
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");	     }			
		if (aa83b07v00  != null  && aa83b07v00.getApel1() != null ) {
			where.append(" AND UPPER(TRANSLATE(t1.APEL1,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(Aa83bUtilidades.SinTildes(aa83b07v00.getApel1().toUpperCase() +"%"));
			}else{
				params.add(Aa83bUtilidades.SinTildes("%"+aa83b07v00.getApel1().toUpperCase() +"%"));
			}
			where.append(" AND t1.APEL1 IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getApel2() != null ) {
			where.append(" AND UPPER(TRANSLATE(t1.APEL2,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(Aa83bUtilidades.SinTildes(aa83b07v00.getApel2().toUpperCase() +"%"));
			}else{
				params.add(Aa83bUtilidades.SinTildes("%"+aa83b07v00.getApel2().toUpperCase() +"%"));
			}
			where.append(" AND t1.APEL2 IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getApellidos() != null ) {
			where.append(" AND UPPER(TRANSLATE(t1.APELLIDOS,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(Aa83bUtilidades.SinTildes(aa83b07v00.getApellidos().toUpperCase() +"%"));
			}else{
				params.add(Aa83bUtilidades.SinTildes("%"+aa83b07v00.getApellidos().toUpperCase() +"%"));
			}
			where.append(" AND t1.APELLIDOS IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getTipoDoc() != null && !"0".equals(aa83b07v00.getTipoDoc())) {
			where.append(" AND t1.TIPO_DOC = ?");
			params.add(aa83b07v00.getTipoDoc());
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getNumDoc() != null ) {
			where.append(" AND UPPER(t1.NUM_DOC) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b07v00.getNumDoc().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b07v00.getNumDoc().toUpperCase() +"%");
			}
			where.append(" AND t1.NUM_DOC IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getSoliCerrada() != null && "N".equals(aa83b07v00.getSoliCerrada())) {
			where.append(" AND UPPER(t1.SOLI_CERRADA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b07v00.getSoliCerrada().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b07v00.getSoliCerrada().toUpperCase() +"%");
			}
			where.append(" AND t1.SOLI_CERRADA IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getIdSol() != null && !"0".equals(aa83b07v00.getIdSol()) ) {
			where.append(" AND t1.ID_SOL = ?");
			params.add(aa83b07v00.getIdSol());
	     }			
		
		if (aa83b07v00  != null  && aa83b07v00.getTipoSol() != null) {
			where.append(" AND UPPER(t1.TIPO_SOL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b07v00.getTipoSol().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b07v00.getTipoSol().toUpperCase() +"%");
			}
			where.append(" AND t1.TIPO_SOL IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getIdFase() != null && !"0".equals(aa83b07v00.getIdFase())) {
			where.append(" AND t1.ID_FASE = ?");
			params.add(aa83b07v00.getIdFase());
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getIdTram() != null  && !"0".equals(aa83b07v00.getIdTram())) {
			where.append(" AND t1.ID_TRAM = ?");
			params.add(aa83b07v00.getIdTram());
	     }			

		if (aa83b07v00  != null  && aa83b07v00.getFecDesde() != null ) {
			if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
				where.append(" AND to_date(FEC_ALTA_EU,'").append(Aa83BConstants.EU_PATTERN).append("') >= to_date(?,'").append(Aa83BConstants.EU_PATTERN).append("') ");
				params.add(aa83b07v00.getFecDesde());
			} else {
				where.append(" AND to_date(FEC_ALTA_ES,'").append(Aa83BConstants.ES_PATTERN).append("') >= to_date(?,'").append(Aa83BConstants.ES_PATTERN).append("') ");
				params.add(aa83b07v00.getFecDesde());
			}			
			
	     }
		if (aa83b07v00  != null  && aa83b07v00.getFecHasta() != null ) {
			if (Aa83BConstants.EU.equals(LocaleContextHolder.getLocale().getLanguage())) {
				where.append(" AND to_date(FEC_ALTA_EU,'").append(Aa83BConstants.EU_PATTERN).append("') <= to_date(?,'").append(Aa83BConstants.EU_PATTERN).append("') ");
				params.add(aa83b07v00.getFecHasta());
			} else {
				where.append(" AND to_date(FEC_ALTA_ES,'").append(Aa83BConstants.ES_PATTERN).append("') <= to_date(?,'").append(Aa83BConstants.ES_PATTERN).append("') ");
				params.add(aa83b07v00.getFecHasta());
			}					
	     }

		if (aa83b07v00  != null  && aa83b07v00.getDescEsTram() != null ) {
			where.append(" AND UPPER(t1.DESC_ES_TRAM) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b07v00.getDescEsTram().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b07v00.getDescEsTram().toUpperCase() +"%");
			}
			where.append(" AND t1.DESC_ES_TRAM IS NOT NULL");
	     }			
		if (aa83b07v00  != null  && aa83b07v00.getDescEuTram() != null ) {
			where.append(" AND UPPER(t1.DESC_EU_TRAM) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b07v00.getDescEuTram().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b07v00.getDescEuTram().toUpperCase() +"%");
			}
			where.append(" AND t1.DESC_EU_TRAM IS NOT NULL");
	     }



		

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

