package com.ejie.aa83b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b05v00;

/**
 * Aa83b05v00DaoImpl generated by UDA, 06-sep-2016 11:43:01.
 * @author UDA
 */
 
@Repository
@Transactional
public class Aa83b05v00DaoImpl implements Aa83b05v00Dao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b05v00> rwMap = new RowMapper<Aa83b05v00>() {
		public Aa83b05v00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Aa83b05v00(
               resultSet.getInt("ID002"), resultSet.getString("DESCES002"), resultSet.getString("DESCEU002"), resultSet.getInt("ID001FASE")
           ); } } ;
           
	private RowMapper<Aa83b05v00> rwMapPK = new RowMapper<Aa83b05v00>() {
		public Aa83b05v00 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa83b05v00(
				resultSet.getInt("ID002"), resultSet.getString("DESCES002"), resultSet.getString("DESCEU002"), resultSet.getInt("ID001FASE")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
     * @param dataSource DataSource
     * @return
     */
	private RowMapper<JerarquiaDto< Aa83b05v00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b05v00>>() {
		public JerarquiaDto<Aa83b05v00> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Aa83b05v00 aa83b05v00 = new Aa83b05v00(resultSet.getInt("ID002"), resultSet.getString("DESCES002"), resultSet.getString("DESCEU002"), resultSet.getInt("ID001FASE"));

			JerarquiaDto<Aa83b05v00> jerarquia = new JerarquiaDto<Aa83b05v00>();
			jerarquia.setModel(aa83b05v00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
     * Inserts a single row in the Aa83b05v00 table.
     *
     * @param aa83b05v00 Aa83b05v00
     * @return Aa83b05v00
     */
	public Aa83b05v00 add(Aa83b05v00 aa83b05v00) {
    	String query = "INSERT INTO AA83B05V00 (ID_002, DESC_ES_002, DESC_EU_002, ID_001_FASE) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b05v00.getId002(), aa83b05v00.getDescEs002(), aa83b05v00.getDescEu002(), aa83b05v00.getId001Fase());
		return aa83b05v00;
	}

    /**
     * Updates a single row in the Aa83b05v00 table.
     *
     * @param aa83b05v00 Aa83b05v00
     * @return Aa83b05v00
     */
    public Aa83b05v00 update(Aa83b05v00 aa83b05v00) {
		String query = "UPDATE AA83B05V00 SET  WHERE ID_002=? AND DESC_ES_002=? AND DESC_EU_002=? AND ID_001_FASE=?";
		this.jdbcTemplate.update(query, aa83b05v00.getId002(), aa83b05v00.getDescEs002(), aa83b05v00.getDescEu002(), aa83b05v00.getId001Fase());
		return aa83b05v00;
	}

    /**
     * Finds a single row in the Aa83b05v00 table.
     *
     * @param aa83b05v00 Aa83b05v00
     * @return Aa83b05v00
     */
    @Transactional (readOnly = true)
    public Aa83b05v00 find(Aa83b05v00 aa83b05v00) {
		String query = "SELECT t1.ID_002 ID002, t1.DESC_ES_002 DESCES002, t1.DESC_EU_002 DESCEU002, t1.ID_001_FASE ID001FASE FROM AA83B05V00 t1  WHERE t1.ID_002 = ?   AND t1.DESC_ES_002 = ?   AND t1.DESC_EU_002 = ?   AND t1.ID_001_FASE = ?  ";
		
		List<Aa83b05v00> aa83b05v00List = this.jdbcTemplate.query(query, this.rwMap, aa83b05v00.getId002() , aa83b05v00.getDescEs002() , aa83b05v00.getDescEu002() , aa83b05v00.getId001Fase());
		return (Aa83b05v00) DataAccessUtils.uniqueResult(aa83b05v00List);
    }

    /**
     * Removes a single row in the Aa83b05v00 table.
     *
     * @param aa83b05v00 Aa83b05v00
     * @return
     */
    public void remove(Aa83b05v00 aa83b05v00) {
		String query = "DELETE FROM AA83B05V00 WHERE ID_002=? AND DESC_ES_002=? AND DESC_EU_002=? AND ID_001_FASE=?";
		this.jdbcTemplate.update(query, aa83b05v00.getId002() , aa83b05v00.getDescEs002() , aa83b05v00.getDescEu002() , aa83b05v00.getId001Fase());
    }
    
   /**
    * Finds a list of rows in the Aa83b05v00 table.
    * 
    * @param aa83b05v00 Aa83b05v00
    * @param jqGridRequestDto JQGridRequestDto
    * @return List<Aa83b05v00> 
    */
	@Transactional (readOnly = true)
    public List<Aa83b05v00> findAll(Aa83b05v00 aa83b05v00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_002 ID002,t1.DESC_ES_002 DESCES002,t1.DESC_EU_002 DESCEU002,t1.ID_001_FASE ID001FASE "); 
		query.append("FROM AA83B05V00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b05v00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b05v00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the Aa83b05v00 table using like.
     * 
     * @param aa83b05v00 Aa83b05v00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<Aa83b05v00>
     */
	@Transactional (readOnly = true)
    public List<Aa83b05v00> findAllLike(Aa83b05v00 aa83b05v00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_002 ID002,t1.DESC_ES_002 DESCES002,t1.DESC_EU_002 DESCEU002,t1.ID_001_FASE ID001FASE "); 
        query.append("FROM AA83B05V00 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b05v00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Aa83b05v00>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
     * Counts rows in the Aa83b05v00 table.
     * 
     * @param aa83b05v00 Aa83b05v00
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Aa83b05v00 aa83b05v00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B05V00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b05v00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Aa83b05v00 table using like.
     * 
     * @param aa83b05v00 Aa83b05v00
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Aa83b05v00 aa83b05v00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA83B05V00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b05v00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b05v00 selected for rup_table
     * 
     * @param aa83b05v00 Aa83b05v00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b05v00>> 
     */
	@Override 
	public List<TableRowDto<Aa83b05v00>> reorderSelection(Aa83b05v00 aa83b05v00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_002 ID002,t1.DESC_ES_002 DESCES002,t1.DESC_EU_002 DESCEU002,t1.ID_001_FASE ID001FASE "); 
		// FROM
        query.append("FROM AA83B05V00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b05v00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Aa83b05v00.class, filterParamList, "ID_002,DESC_ES_002,DESC_EU_002,ID_001_FASE" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b05v00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
     * 
     * @param filterParams Aa83b05v00
     * @param searchParams Aa83b05v00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Aa83b05v00>> 
     */
	@Override
	public List<TableRowDto<Aa83b05v00>> search(Aa83b05v00 filterParams, Aa83b05v00 searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_002 ID002,t1.DESC_ES_002 DESCES002,t1.DESC_EU_002 DESCEU002,t1.ID_001_FASE ID001FASE "); 
		// FROM
        query.append("FROM AA83B05V00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Aa83b05v00.class, filterParamList, searchSQL, searchParamList, from_alias, "ID_002,DESC_ES_002,DESC_EU_002,ID_001_FASE");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Aa83b05v00>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table
     * 
     * @param filteraa83b05v00 Aa83b05v00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean 
     */
	@Override
	public void removeMultiple(Aa83b05v00 filteraa83b05v00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.ID_002 ID002,t1.DESC_ES_002 DESCES002,t1.DESC_EU_002 DESCEU002,t1.ID_001_FASE ID001FASE "); 
		// FROM
        query.append("FROM AA83B05V00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b05v00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Aa83b05v00.class, query, params, "ID_002,DESC_ES_002,DESC_EU_002,ID_001_FASE");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b05v00 table.
     * 
     * @param filterAa83b05v00 Aa83b05v00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<JerarquiaDto<Aa83b05v00>> 
     */
	@Override
	public List<JerarquiaDto<Aa83b05v00>> findAllLikeJerarquia(Aa83b05v00 filterAa83b05v00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.ID_002 ID002,t1.DESC_ES_002 DESCES002,t1.DESC_EU_002 DESCEU002,t1.ID_001_FASE ID001FASE "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B05V00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B05V00");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b05v00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID_002,DESC_ES_002,DESC_EU_002,ID_001_FASE", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
     * 
     * @param filterAa83b05v00 Aa83b05v00
     * @param jqGridRequestDto JQGridRequestDto
     * @return Long 
     */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b05v00 filterAa83b05v00, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B05V00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B05V00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b05v00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID_002,DESC_ES_002,DESC_EU_002,ID_001_FASE", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
     * 
     * @param filterAa83b05v00 Aa83b05v00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<TableRowDto<Aa83b05v00>> 
     */
	@Override
	public List<TableRowDto<Aa83b05v00>> findAllChild(Aa83b05v00 filterAa83b05v00, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM AA83B05V00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AA83B05V00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa83b05v00, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID_002,DESC_ES_002,DESC_EU_002,ID_001_FASE", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Aa83b05v00>(this.rwMapPK, "ID_002,DESC_ES_002,DESC_EU_002,ID_001_FASE"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Aa83b05v00 entity 
	 * 
	 * @param aa83b05v00 Aa83b05v00
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Aa83b05v00 aa83b05v00){
		
		StringBuilder where = new StringBuilder(Aa83b05v00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b05v00  != null  && aa83b05v00.getId002() != null ) {
			where.append(" AND t1.ID_002 = ?");
			params.add(aa83b05v00.getId002());
		}
		if (aa83b05v00  != null  && aa83b05v00.getDescEs002() != null ) {
			where.append(" AND t1.DESC_ES_002 = ?");
			params.add(aa83b05v00.getDescEs002());
		}
		if (aa83b05v00  != null  && aa83b05v00.getDescEu002() != null ) {
			where.append(" AND t1.DESC_EU_002 = ?");
			params.add(aa83b05v00.getDescEu002());
		}
		if (aa83b05v00  != null  && aa83b05v00.getId001Fase() != null ) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b05v00.getId001Fase());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Aa83b05v00 entity 
	 * 
	 * @param aa83b05v00 Aa83b05v00
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (Aa83b05v00 aa83b05v00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(Aa83b05v00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		System.out.println("aa83b05v00 --->" + aa83b05v00);
		if (aa83b05v00  != null  && aa83b05v00.getId002() != null ) {
			where.append(" AND t1.ID_002 = ?");
			params.add(aa83b05v00.getId002());
	     }			
		if (aa83b05v00  != null  && aa83b05v00.getDescEs002() != null ) {
			where.append(" AND UPPER(t1.DESC_ES_002) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b05v00.getDescEs002().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b05v00.getDescEs002().toUpperCase() +"%");
			}
			where.append(" AND t1.DESC_ES_002 IS NOT NULL");
	     }			
		if (aa83b05v00  != null  && aa83b05v00.getDescEu002() != null ) {
			where.append(" AND UPPER(t1.DESC_EU_002) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(aa83b05v00.getDescEu002().toUpperCase() +"%");
			}else{
				params.add("%"+aa83b05v00.getDescEu002().toUpperCase() +"%");
			}
			where.append(" AND t1.DESC_EU_002 IS NOT NULL");
	     }			
		if (aa83b05v00  != null  && aa83b05v00.getId001Fase() != null ) {
			where.append(" AND t1.ID_001_FASE = ?");
			params.add(aa83b05v00.getId001Fase());
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		System.out.println("where Aa83b05v00 --->" + where);
		mapWhere.put("params", params);
		System.out.println("params Aa83b05v00 --->" + params);
		
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

