package com.ejie.aa83b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa83b.model.Aa83b01t00;
import com.ejie.aa83b.model.Aa83b02t00;
import com.ejie.aa83b.model.Aa83b03t00;
import com.ejie.aa83b.model.Aa83b04t00;
import com.ejie.aa83b.model.Aa83b36t00;
import com.ejie.aa83b.service.Aa83b01t00Service;
import com.ejie.aa83b.service.Aa83b02t00Service;
import com.ejie.aa83b.service.Aa83b03t00Service;
import com.ejie.aa83b.service.Aa83b36t00Service;
import com.ejie.aa83b.util.Aa83BConstants;
import com.ejie.aa83b.util.Aa83bUtilidades;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa83b04t00DaoImpl generated by UDA, 14-ene-2016 10:01:25.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class Aa83b04t00DaoImpl implements Aa83b04t00Dao {
	private JdbcTemplate jdbcTemplate;
	@Autowired
	private Aa83b02t00Service aa83b02t00Service;
	@Autowired
	private Aa83b01t00Service aa83b01t00Service;
	@Autowired
	private Aa83b03t00Service aa83b03t00Service;
	@Autowired
	private Aa83b36t00Service aa83b36t00Service;
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa83b04t00> rwMap = new RowMapper<Aa83b04t00>() {
		public Aa83b04t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			// buscamos el tramite y la fase
			Aa83b01t00 fase = new Aa83b01t00();
			if (Aa83BConstants.VALOR_VACIO.equals(resultSet
					.getString("ID001FASE"))) {
				fase.setId001(Integer.parseInt(resultSet.getString("ID001FASE")));
				fase.setIdTipoSol(Aa83BConstants.VALOR_VACIO_INT);
			} else if (Aa83BConstants.VALOR_VACIO_INT == resultSet
					.getInt("ID003TIPOSOL")) {
				fase.setId001(Aa83BConstants.VALOR_VACIO_INT);
				fase.setIdTipoSol(resultSet.getInt("ID003TIPOSOL"));
			} else {
				fase.setId001(Integer.parseInt(resultSet.getString("ID001FASE")));
				fase.setIdTipoSol(resultSet.getInt("ID003TIPOSOL"));
			}
			fase = aa83b01t00Service.find(fase);
			Aa83b02t00 tramite = new Aa83b02t00();
			if (Aa83BConstants.VALOR_VACIO_INT == fase.getIdTipoSol()
					|| Aa83BConstants.VALOR_VACIO_INT == fase.getId001()) {
				tramite.setId002(Aa83BConstants.VALOR_VACIO_INT);
			} else {
				tramite.setId002(Integer.parseInt(resultSet
						.getString("ID002TRAM")));
			}
			tramite.setId001Fase(fase.getId001());
			tramite.setId003TipoSol(fase.getIdTipoSol());
			tramite = aa83b02t00Service.find(tramite);
			// buscamos el tipo y el subtipo de dokusi
			Aa83b36t00 tipoDokusi = new Aa83b36t00();
			if (null != resultSet.getString("TDDOKUSI030")) {
				tipoDokusi.setIdCodigo036(resultSet.getString("TDDOKUSI030"));
				tipoDokusi = aa83b36t00Service.find(tipoDokusi);
			}
			Aa83b36t00 subtipoDokusi = new Aa83b36t00();
			if (null != resultSet.getString("SDDOKUSI030")) {
				subtipoDokusi
						.setIdCodigo036(resultSet.getString("SDDOKUSI030"));
				subtipoDokusi = aa83b36t00Service.find(subtipoDokusi);
			}
			// buscamos el tipo de solicitus
			Aa83b03t00 solicitud = new Aa83b03t00();
			solicitud.setId003(resultSet.getInt("ID003TIPOSOL"));
			solicitud = aa83b03t00Service.find(solicitud);
			return new Aa83b04t00(resultSet.getInt("ID004"),
					resultSet.getInt("ID001FASE"), fase.getDescEs001(),
					fase.getDescEu001(), resultSet.getInt("ID002TRAM"),
					tramite.getDescEs002(), tramite.getDescEu002(),
					resultSet.getInt("ID003TIPOSOL"), solicitud.getDescEs003(),
					solicitud.getDescEu003(),
					null == resultSet.getString("DESCES004") ? ""
							: Aa83bUtilidades.TildesHtml(resultSet
									.getString("DESCES004")),
					resultSet.getString("DESCEU004"),
					resultSet.getString("NOMTEMPLATE004"),
					resultSet.getBlob("TEMPLATE004"),
					resultSet.getString("TDDOKUSI030"),
					tipoDokusi.getDescEs036(), tipoDokusi.getDescEu036(),
					resultSet.getString("SDDOKUSI030"),
					subtipoDokusi.getDescEs036(), subtipoDokusi.getDescEu036());
		}
	};

	private RowMapper<Aa83b04t00> rwMapPK = new RowMapper<Aa83b04t00>() {
		public Aa83b04t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa83b04t00(resultSet.getInt("ID004"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa83b04t00>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa83b04t00>>() {
		public JerarquiaDto<Aa83b04t00> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			// buscamos el tramite y la fase
			Aa83b01t00 fase = new Aa83b01t00();
			if (Aa83BConstants.VALOR_VACIO.equals(resultSet
					.getString("ID001FASE"))) {
				fase.setId001(Integer.parseInt(resultSet.getString("ID001FASE")));
				fase.setIdTipoSol(Aa83BConstants.VALOR_VACIO_INT);
			} else if (Aa83BConstants.VALOR_VACIO_INT == resultSet
					.getInt("ID003TIPOSOL")) {
				fase.setId001(Aa83BConstants.VALOR_VACIO_INT);
				fase.setIdTipoSol(resultSet.getInt("ID003TIPOSOL"));
			} else {
				fase.setId001(Integer.parseInt(resultSet.getString("ID001FASE")));
				fase.setIdTipoSol(resultSet.getInt("ID003TIPOSOL"));
			}
			fase = aa83b01t00Service.find(fase);
			Aa83b02t00 tramite = new Aa83b02t00();
			if (Aa83BConstants.VALOR_VACIO_INT == fase.getIdTipoSol()
					|| Aa83BConstants.VALOR_VACIO_INT == fase.getId001()) {
				tramite.setId002(Aa83BConstants.VALOR_VACIO_INT);
			} else {
				tramite.setId002(Integer.parseInt(resultSet
						.getString("ID002TRAM")));
			}
			tramite.setId001Fase(fase.getId001());
			tramite.setId003TipoSol(fase.getIdTipoSol());
			tramite = aa83b02t00Service.find(tramite);
			// buscamos el tipo y el subtipo de dokusi
			Aa83b36t00 tipoDokusi = new Aa83b36t00();
			if (null != resultSet.getString("TDDOKUSI030")) {
				tipoDokusi.setIdCodigo036(resultSet.getString("TDDOKUSI030"));
				tipoDokusi = aa83b36t00Service.find(tipoDokusi);
			}
			Aa83b36t00 subtipoDokusi = new Aa83b36t00();
			if (null != resultSet.getString("SDDOKUSI030")) {
				subtipoDokusi
						.setIdCodigo036(resultSet.getString("SDDOKUSI030"));
				subtipoDokusi = aa83b36t00Service.find(subtipoDokusi);
			}
			// buscamos el tipo de solicitus
			Aa83b03t00 solicitud = new Aa83b03t00();
			solicitud.setId003(resultSet.getInt("ID003TIPOSOL"));
			solicitud = aa83b03t00Service.find(solicitud);
			Aa83b04t00 aa83b04t00 = new Aa83b04t00(resultSet.getInt("ID004"),
					resultSet.getInt("ID001FASE"), fase.getDescEs001(),
					fase.getDescEu001(), resultSet.getInt("ID002TRAM"),
					tramite.getDescEs002(), tramite.getDescEu002(),
					resultSet.getInt("ID003TIPOSOL"), solicitud.getDescEs003(),
					solicitud.getDescEu003(), resultSet.getString("DESCES004"),
					resultSet.getString("DESCEU004"),
					resultSet.getString("NOMTEMPLATE004"),
					resultSet.getBlob("TEMPLATE004"),
					resultSet.getString("TDDOKUSI030"),
					tipoDokusi.getDescEs036(), tipoDokusi.getDescEu036(),
					resultSet.getString("SDDOKUSI030"),
					subtipoDokusi.getDescEs036(), subtipoDokusi.getDescEu036());

			JerarquiaDto<Aa83b04t00> jerarquia = new JerarquiaDto<Aa83b04t00>();
			jerarquia.setModel(aa83b04t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa83b04t00 table.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @return Aa83b04t00
	 */
	public Aa83b04t00 add(Aa83b04t00 aa83b04t00) {

		final int nextId = jdbcTemplate
				.queryForInt("SELECT SEQ_AA83B04T00_ID_004.NEXTVAL FROM DUAL");
		aa83b04t00.setId004(nextId);

		String query = "INSERT INTO AA83B04T00 (ID_004, ID_001_FASE, ID_002_TRAM, ID_003_TIPO_SOL, DESC_ES_004, DESC_EU_004, NOM_TEMPLATE_004, TEMPLATE_004, TD_DOKUSI_030, SD_DOKUSI_030) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa83b04t00.getId004(),
				aa83b04t00.getIdfase(), aa83b04t00.getId002Tram(),
				aa83b04t00.getId003TipoSol(), aa83b04t00.getDescEs004(),
				aa83b04t00.getDescEu004(), aa83b04t00.getNomTemplate004(),
				aa83b04t00.getPlantilla004(), aa83b04t00.getTdDokusi030(),
				aa83b04t00.getSdDokusi030());
		return aa83b04t00;
	}

	/**
	 * Updates a single row in the Aa83b04t00 table.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @return Aa83b04t00
	 */
	public Aa83b04t00 update(Aa83b04t00 aa83b04t00) {
		String blob_template = "";
		System.out.println("EN DAO Aa83b04t00.update");
		System.out.println("EN DAO Aa83b04t00.update::"
				+ aa83b04t00.getPlantilla004());
		if (aa83b04t00.getPlantilla004() != null)
			blob_template = " TEMPLATE_004=?, ";
		String query = "UPDATE AA83B04T00 SET ID_001_FASE=?, ID_002_TRAM=?, "
				+ "ID_003_TIPO_SOL=?, DESC_ES_004=?, DESC_EU_004=?, "
				// + "NOM_TEMPLATE_004=?, "
				+ blob_template + "TD_DOKUSI_030=?, "
				+ "SD_DOKUSI_030=? WHERE ID_004=?";
		if (aa83b04t00.getPlantilla004() == null)
			this.jdbcTemplate.update(query, aa83b04t00.getIdfase(),
					aa83b04t00.getId002Tram(), aa83b04t00.getId003TipoSol(),
					aa83b04t00.getDescEs004(), aa83b04t00.getDescEu004(),
					aa83b04t00.getTdDokusi030(), aa83b04t00.getSdDokusi030(),
					aa83b04t00.getId004());
		else
			this.jdbcTemplate.update(query, aa83b04t00.getIdfase(),
					aa83b04t00.getId002Tram(), aa83b04t00.getId003TipoSol(),
					aa83b04t00.getDescEs004(), aa83b04t00.getDescEu004(),
					aa83b04t00.getPlantilla004(), aa83b04t00.getTdDokusi030(),
					aa83b04t00.getSdDokusi030(), aa83b04t00.getId004());
		return aa83b04t00;
	}

	/**
	 * Finds a single row in the Aa83b04t00 table.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @return Aa83b04t00
	 */
	@Transactional(readOnly = true)
	public Aa83b04t00 find(Aa83b04t00 aa83b04t00) {
		String query = "SELECT t1.ID_004 ID004, t1.ID_001_FASE ID001FASE, t1.ID_002_TRAM ID002TRAM, t1.ID_003_TIPO_SOL ID003TIPOSOL, t1.DESC_ES_004 DESCES004, t1.DESC_EU_004 DESCEU004, t1.NOM_TEMPLATE_004 NOMTEMPLATE004, t1.TEMPLATE_004 TEMPLATE004, t1.TD_DOKUSI_030 TDDOKUSI030, t1.SD_DOKUSI_030 SDDOKUSI030 FROM AA83B04T00 t1  WHERE t1.ID_004 = ?  ";

		List<Aa83b04t00> aa83b04t00List = this.jdbcTemplate.query(query,
				this.rwMap, aa83b04t00.getId004());
		return (Aa83b04t00) DataAccessUtils.uniqueResult(aa83b04t00List);
	}

	/**
	 * Removes a single row in the Aa83b04t00 table.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @return
	 */
	public void remove(Aa83b04t00 aa83b04t00) {
		String query = "DELETE FROM AA83B04T00 WHERE ID_004=?";
		this.jdbcTemplate.update(query, aa83b04t00.getId004());
	}

	/**
	 * Finds a list of rows in the Aa83b04t00 table.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa83b04t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b04t00> findAll(Aa83b04t00 aa83b04t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_004 ID004,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_004 DESCES004,t1.DESC_EU_004 DESCEU004,t1.NOM_TEMPLATE_004 NOMTEMPLATE004,t1.TEMPLATE_004 TEMPLATE004,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		query.append("FROM AA83B04T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b04t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		return (List<Aa83b04t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa83b04t00 table using like.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa83b04t00>
	 */
	@Transactional(readOnly = true)
	public List<Aa83b04t00> findAllLike(Aa83b04t00 aa83b04t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_004 ID004,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_004 DESCES004,t1.DESC_EU_004 DESCEU004,t1.NOM_TEMPLATE_004 NOMTEMPLATE004,t1.TEMPLATE_004 TEMPLATE004,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		query.append("FROM AA83B04T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b04t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		return (List<Aa83b04t00>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa83b04t00 table.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa83b04t00 aa83b04t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B04T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa83b04t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa83b04t00 table using like.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa83b04t00 aa83b04t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA83B04T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b04t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa83b04t00 selected for rup_table
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b04t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b04t00>> reorderSelection(
			Aa83b04t00 aa83b04t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_004 ID004,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_004 DESCES004,t1.DESC_EU_004 DESCEU004,t1.NOM_TEMPLATE_004 NOMTEMPLATE004,t1.TEMPLATE_004 TEMPLATE004,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		// FROM
		query.append("FROM AA83B04T00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa83b04t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa83b04t00.class, filterParamList,
				"ID_004");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b04t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa83b04t00
	 * @param searchParams
	 *            Aa83b04t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa83b04t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b04t00>> search(Aa83b04t00 filterParams,
			Aa83b04t00 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_004 ID004,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_004 DESCES004,t1.DESC_EU_004 DESCEU004,t1.NOM_TEMPLATE_004 NOMTEMPLATE004,t1.TEMPLATE_004 TEMPLATE004,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		// FROM
		query.append("FROM AA83B04T00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa83b04t00.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_004");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa83b04t00>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa83b04t00
	 *            Aa83b04t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa83b04t00 filteraa83b04t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_004 ID004,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_004 DESCES004,t1.DESC_EU_004 DESCEU004,t1.NOM_TEMPLATE_004 NOMTEMPLATE004,t1.TEMPLATE_004 TEMPLATE004,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		// FROM
		query.append("FROM AA83B04T00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa83b04t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa83b04t00.class,
						query, params, "ID_004");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa83b04t00 table.
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa83b04t00>>
	 */
	@Override
	public List<JerarquiaDto<Aa83b04t00>> findAllLikeJerarquia(
			Aa83b04t00 filterAa83b04t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_004 ID004,t1.ID_001_FASE ID001FASE,t1.ID_002_TRAM ID002TRAM,t1.ID_003_TIPO_SOL ID003TIPOSOL,t1.DESC_ES_004 DESCES004,t1.DESC_EU_004 DESCEU004,t1.NOM_TEMPLATE_004 NOMTEMPLATE004,t1.TEMPLATE_004 TEMPLATE004,t1.TD_DOKUSI_030 TDDOKUSI030,t1.SD_DOKUSI_030 SDDOKUSI030 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B04T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B04T00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b04t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_004", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa83b04t00 filterAa83b04t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B04T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B04T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b04t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_004", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);
		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa83b04t00
	 *            Aa83b04t00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa83b04t00>>
	 */
	@Override
	public List<TableRowDto<Aa83b04t00>> findAllChild(
			Aa83b04t00 filterAa83b04t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA83B04T00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA83B04T00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa83b04t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_004", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa83b04t00>(this.rwMapPK,
								"ID_004"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b04t00 entity
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa83b04t00 aa83b04t00) {

		StringBuilder where = new StringBuilder(
				Aa83b04t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b04t00 != null && aa83b04t00.getId004() != null) {
			where.append(" AND t1.ID_004 = ?");
			params.add(aa83b04t00.getId004());
		}
		if (aa83b04t00 != null && aa83b04t00.getIdfase() != null
				&& Aa83BConstants.VALOR_VACIO_INT != aa83b04t00.getIdfase()) {
			where.append(" AND (t1.ID_001_FASE = ? OR t1.ID_001_FASE = ?)");
			params.add(aa83b04t00.getIdfase());
			params.add(Aa83BConstants.VALOR_VACIO);
		}
		if (aa83b04t00 != null && aa83b04t00.getId002Tram() != null
				&& Aa83BConstants.VALOR_VACIO_INT != aa83b04t00.getId002Tram()) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b04t00.getId002Tram());
		}
		if (aa83b04t00 != null
				&& aa83b04t00.getId003TipoSol() != null
				&& Aa83BConstants.VALOR_VACIO_INT != aa83b04t00
						.getId003TipoSol()) {
			where.append(" AND (t1.ID_003_TIPO_SOL = ? OR t1.ID_003_TIPO_SOL = ?)");
			params.add(aa83b04t00.getId003TipoSol());
			params.add(Aa83BConstants.VALOR_VACIO);
		}
		if (aa83b04t00 != null && aa83b04t00.getDescEs004() != null) {
			where.append(" AND t1.DESC_ES_004 = ?");
			params.add(aa83b04t00.getDescEs004());
		}
		if (aa83b04t00 != null && aa83b04t00.getDescEu004() != null) {
			where.append(" AND t1.DESC_EU_004 = ?");
			params.add(aa83b04t00.getDescEu004());
		}
		if (aa83b04t00 != null && aa83b04t00.getNomTemplate004() != null) {
			where.append(" AND t1.NOM_TEMPLATE_004 = ?");
			params.add(aa83b04t00.getNomTemplate004());
		}
		if (aa83b04t00 != null
				&& aa83b04t00.getTdDokusi030() != null
				&& !Aa83BConstants.VALOR_VACIO.equals(aa83b04t00
						.getTdDokusi030())) {
			where.append(" AND t1.TD_DOKUSI_030 = ?");
			params.add(aa83b04t00.getTdDokusi030());
		}
		if (aa83b04t00 != null
				&& aa83b04t00.getSdDokusi030() != null
				&& !Aa83BConstants.VALOR_VACIO.equals(aa83b04t00
						.getSdDokusi030())) {
			where.append(" AND t1.SD_DOKUSI_030 = ?");
			params.add(aa83b04t00.getSdDokusi030());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa83b04t00 entity
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa83b04t00 aa83b04t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa83b04t00DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa83b04t00 != null && aa83b04t00.getId004() != null) {
			where.append(" AND t1.ID_004 = ?");
			params.add(aa83b04t00.getId004());
		}
		if (aa83b04t00 != null && aa83b04t00.getIdfase() != null
				&& Aa83BConstants.VALOR_VACIO_INT != aa83b04t00.getIdfase()) {
			where.append(" AND (t1.ID_001_FASE = ? OR t1.ID_001_FASE = ?)");
			params.add(aa83b04t00.getIdfase());
			params.add(Aa83BConstants.VALOR_VACIO);
		}
		if (aa83b04t00 != null && aa83b04t00.getId002Tram() != null
				&& Aa83BConstants.VALOR_VACIO_INT != aa83b04t00.getId002Tram()) {
			where.append(" AND t1.ID_002_TRAM = ?");
			params.add(aa83b04t00.getId002Tram());
		}
		if (aa83b04t00 != null
				&& aa83b04t00.getId003TipoSol() != null
				&& Aa83BConstants.VALOR_VACIO_INT != aa83b04t00
						.getId003TipoSol()) {
			where.append(" AND (t1.ID_003_TIPO_SOL = ? OR t1.ID_003_TIPO_SOL = ?)");
			params.add(aa83b04t00.getId003TipoSol());
			params.add(Aa83BConstants.VALOR_VACIO);
		}
		if (aa83b04t00 != null && aa83b04t00.getDescEs004() != null) {
			where.append(" AND UPPER(TRANSLATE(t1.DESC_ES_004,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(Aa83bUtilidades.SinTildes(aa83b04t00.getDescEs004()
						.toUpperCase()) + "%");
			} else {
				params.add("%"
						+ Aa83bUtilidades.SinTildes(aa83b04t00.getDescEs004()
								.toUpperCase()) + "%");
			}
			where.append(" AND t1.DESC_ES_004 IS NOT NULL");
		}
		if (aa83b04t00 != null && aa83b04t00.getDescEu004() != null) {
			where.append(" AND UPPER(TRANSLATE(t1.DESC_EU_004,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(Aa83bUtilidades.SinTildes(aa83b04t00.getDescEu004()
						.toUpperCase()) + "%");
			} else {
				params.add("%"
						+ Aa83bUtilidades.SinTildes(aa83b04t00.getDescEu004()
								.toUpperCase()) + "%");
			}
			where.append(" AND t1.DESC_EU_004 IS NOT NULL");
		}
		if (aa83b04t00 != null && aa83b04t00.getNomTemplate004() != null) {
			where.append(" AND UPPER(TRANSLATE(t1.NOM_TEMPLATE_004,'','aeiouaeiouaoaeiooaeioucAEIOUAEIOUAOAEIOOAEIOUC')) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(Aa83bUtilidades.SinTildes(aa83b04t00
						.getNomTemplate004().toUpperCase()) + "%");
			} else {
				params.add("%"
						+ Aa83bUtilidades.SinTildes(aa83b04t00
								.getNomTemplate004().toUpperCase()) + "%");
			}
			where.append(" AND t1.NOM_TEMPLATE_004 IS NOT NULL");
		}
		if (aa83b04t00 != null && aa83b04t00.getTdDokusi030() != null) {
			where.append(" AND UPPER(t1.TD_DOKUSI_030) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b04t00.getTdDokusi030().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b04t00.getTdDokusi030().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TD_DOKUSI_030 IS NOT NULL");
		}
		if (aa83b04t00 != null && aa83b04t00.getSdDokusi030() != null) {
			where.append(" AND UPPER(t1.SD_DOKUSI_030) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa83b04t00.getSdDokusi030().toUpperCase() + "%");
			} else {
				params.add("%" + aa83b04t00.getSdDokusi030().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SD_DOKUSI_030 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Finds a single row in the Aa83b04t00 table.
	 * 
	 * @param aa83b04t00
	 *            Aa83b04t00
	 * @return Aa83b04t00
	 */

	@Transactional(readOnly = true)
	public Aa83b04t00 findTemplateByName(String nombre) {
		String query = "SELECT ID_004, NOM_TEMPLATE_004, TEMPLATE_004 FROM AA83B04T00   WHERE NOM_TEMPLATE_004 = '"
				+ nombre + "'";

		List<Aa83b04t00> aa83b04t00List = this.jdbcTemplate.query(query,
				this.plantillarowMap);

		Aa83b04t00 aa83b04t00 = (Aa83b04t00) aa83b04t00List.get(0);

		return (Aa83b04t00) aa83b04t00;
	}

	/** The comunicacionrowMap map. */
	private RowMapper<Aa83b04t00> plantillarowMap = new RowMapper<Aa83b04t00>() {
		public Aa83b04t00 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa83b04t00 plantilla = new Aa83b04t00();

			plantilla.setId004(resultSet.getInt("ID_004"));
			plantilla
					.setNomTemplate004(resultSet.getString("NOM_TEMPLATE_004"));
			plantilla.setTemplate004(resultSet.getBlob("TEMPLATE_004"));
			plantilla.setFichero(plantilla.getPlantilla004());
			if (null != plantilla) {
				// MultipartFile mfile = (MultipartFile) firmaDigital019;
				plantilla.setPlantilla004(plantilla.getTemplate004().getBytes(
						1, (int) plantilla.getTemplate004().length()));
			}
			return plantilla;
		}
	};

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
