COMMENT ON column AA83B21T00.RESOL_FAVORABLE_021 IS 'Resolucion favorable del informe: 0 Desfavorable, 1 Favorable, 2 Anulado';
COMMENT ON column AA83B23T00.RESOL_FAVORABLE_023 IS 'Resolucion favorable del informe: 0 Desfavorable, 1 Favorable, 2 Anulado';
COMMENT ON column AA83B25T00.RESOL_FAVORABLE_025 IS 'Resolucion favorable del informe: 0 Desfavorable, 1 Favorable, 2 Anulado';

ALTER TABLE AA83B21T00 ADD OBSERVACIONES_021 VARCHAR2 (300);
ALTER TABLE AA83B23T00 ADD OBSERVACIONES_023 VARCHAR2 (300);
ALTER TABLE AA83B25T00 ADD OBSERVACIONES_025 VARCHAR2 (300);

-- Vista para obtener los datos de la ficha de las solicitudes de adecuacion
CREATE OR REPLACE FORCE VIEW "AA83B"."AA83B21V00" ("ID021", "IDANO021", "FECREG021", "ID015MOTIVOS_SOL", "MOTIVOES015", "MOTIVOEU015", "CONSENTIMIENTOS2021", "NOMBRE021", "APEL1021", "APEL2021", "TELF1021", "TELF2021", "EMAIL021", "CALLECOMUNIC021", "NUMEROCOMUNIC021", "PISOCOMUNIC021", "LETRACOMUNIC021", "CPOSTALCOMUNIC021", "PROVINCIACOMUNIC021", "PROVCOMUNIC", "MUNICIPCOMUNIC021", "MUNICOMUNIC", "NUMDOC021", "NACIONALIDAD021", "PAISDS", "CALLE021", "NUMCALLE021", "PISO021", "LETRA021", "CP021", "PROVINCIA021", "PROVINS", "MUNICIPIO021", "MUNIDSINS", "ID014TITULARIDADVIV", "DESCES014", "DESCEU014", "ID016DERECHOSOCUP", "DESCES016", "DESCEU016", "NUMPERSHABITAN021", "NUMPERSREAGRUPAR021", "OBSERVACIONES021") AS 
  SELECT ID_021, ID_ANO_021, FEC_REG_021, ID_015_MOTIVOS_SOL, T15.DESC_ES_015, T15.DESC_EU_015, nvl(T21.CONSENTIMIENTOS2_021,' '),
T21.NOMBRE_021, T21.APEL1_021, T21.APEL2_021, nvl(T21.TELF1_021,' '), nvl(T21.TELF2_021,' '), nvl(T21.EMAIL_021,' '), 
CALLEC.TIPO_VIA || ' ' || (case when LENGTH(TRIM(TRANSLATE(T21.CALLE_COMUNIC_021, ' +-.0123456789',' '))) > 0 then T21.CALLE_COMUNIC_021 else CALLEC.DS_O end), nvl(T21.NUMERO_COMUNIC_021,' '), nvl(T21.PISO_COMUNIC_021,' '), nvl(T21.LETRA_COMUNIC_021,' '), 
nvl(T21.CPOSTAL_COMUNIC_021,' '), 
T21.PROVINCIA_COMUNIC_021, nvl(PROVC.DS_O, ' '), T21.MUNICIP_COMUNIC_021, nvl(MUNIC.DS_O, ' '), T21.NUM_DOC_021, T21.NACIONALIDAD_021, 
PAIS.DS_O, CALLE.TIPO_VIA || ' ' || (case when LENGTH(TRIM(TRANSLATE(T21.CALLE_021, ' +-.0123456789',' '))) > 0 then T21.CALLE_021 else CALLE.DS_O end), nvl(T21.NUM_CALLE_021,' '), nvl(T21.PISO_021,' '), nvl(T21.LETRA_021, ' '), nvl(T21.CP_021, ' '), T21.PROVINCIA_021, nvl(PROV.DS_O, ' '), 
T21.MUNICIPIO_021, nvl(MUNI.DS_O, ' ' ), T21.ID_014_TITULARIDAD_VIV, T14.DESC_ES_014, T14.DESC_EU_014, T21.ID_016_DERECHOS_OCUP, 
T16.DESC_ES_016, T16.DESC_EU_016, nvl(T21.NUM_PERS_HABITAN_021, '0'), nvl(T21.NUM_PERS_REAGRUPAR_021,'0'), nvl(T21.OBSERVACIONES_021,' ')
FROM AA83B21T00 T21
INNER JOIN AA83B15T00 T15 ON T15.ID_015 = T21.ID_015_MOTIVOS_SOL
LEFT OUTER JOIN T17I.T17_PROVINCIA PROVC ON PROVC.ID = T21.PROVINCIA_COMUNIC_021
LEFT OUTER JOIN T17I.T17_MUNICIPIO MUNIC ON MUNIC.PROVINCIA_ID=T21.PROVINCIA_COMUNIC_021 AND MUNIC.ID = T21.MUNICIP_COMUNIC_021
LEFT OUTER JOIN T17I.T17_CALLE CALLEC ON CALLEC.ID = (case when LENGTH(TRIM(TRANSLATE(T21.CALLE_COMUNIC_021, ' +-.0123456789',' '))) > 0 then '0' else T21.CALLE_COMUNIC_021 end)
LEFT OUTER JOIN T17I.T17_PROVINCIA PROV ON PROV.ID = T21.PROVINCIA_021
LEFT OUTER JOIN T17I.T17_MUNICIPIO MUNI ON MUNI.PROVINCIA_ID=T21.PROVINCIA_021 AND MUNI.ID = T21.MUNICIPIO_021
LEFT OUTER JOIN T17I.T17_CALLE CALLE ON  CALLE.ID = (case when LENGTH(TRIM(TRANSLATE(T21.CALLE_021, ' +-.0123456789',' '))) > 0 then '0' else T21.CALLE_021 end)
LEFT OUTER JOIN T17I.T17_PAIS PAIS ON PAIS.ID = T21.NACIONALIDAD_021
INNER JOIN AA83B14T00 T14 ON T14.ID_014 = T21.ID_014_TITULARIDAD_VIV
INNER JOIN AA83B16T00 T16 ON T16.ID_016 = T21.ID_016_DERECHOS_OCUP; 



-- Vista para obtener todos los documentos asociados a la solicitud sin repetidos 
CREATE OR REPLACE VIEW AA83B31V01 
(IDANO021, ID021NUMSOL, ID030TIPDOCSOL, DESCES030, DESCEU030) AS
SELECT DISTINCT T31.ID_ANO_021, T31.ID_021_NUM_SOL, T31.ID_030_TIP_DOC_SOL, T30.DESC_ES_030, T30.DESC_EU_030
FROM AA83B31T00 T31
INNER JOIN AA83B30T00 T30 ON T30.ID_030 = T31.ID_030_TIP_DOC_SOL
ORDER BY DESC_ES_030
;

-- Vista para recuperar los vinculos familiares y sus descripciones
CREATE OR REPLACE VIEW AA83B18V00 (ID_018, ID_021_NUM_SOL, ID_ANO_021, ID_013_VINCULOS_FAM, DESC_ES_013, DESC_EU_013,
NOMBRE_018, APEL_018, EDAD_018) AS
select  T18.ID_018, T18.ID_021_NUM_SOL, T18.ID_ANO_021, T18.ID_013_VINCULOS_FAM, T13.DESC_ES_013, T13.DESC_EU_013,
T18.NOMBRE_018, T18.APEL_018, T18.EDAD_018
from aa83b18t00 T18
INNER JOIN AA83B13T00 T13 ON T13.ID_013 = T18.ID_013_VINCULOS_FAM
ORDER BY DESC_ES_013;


  CREATE OR REPLACE FORCE EDITIONABLE VIEW "AA83B"."AA83B31V00" ("ID_031", "ID_ANO_021", "ID_030_TIP_DOC_SOL", "ID_021_NUM_SOL", "OID_031_PAPEL0", "ID_009_HISTO_TRAM", "DESC_OTROS_031", "ORG_DOC_ENTREGADO_031", "NOM_DOC_ENTREGADO_031", "FEC_DOC_ENTREGADO_031", "TIPO_APORTACION_031", "FASE_DESC_ES_001", "FASE_DESC_EU_001", "TRAMITE_DESC_ES_002", "TRAMITE_DESC_EU_002", "ID_TRAMITE_002") AS 
  select t1.ID_031 ID031,t1.ID_ANO_021 IDANO021,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_021_NUM_SOL ID021NUMSOL,
t1.OID_031_PAPEL0 OID031PAPEL0,t1.ID_009_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_031 DESCOTROS031,
t1.ORG_DOC_ENTREGADO_031 ORGDOCENTREGADO031,t1.NOM_DOC_ENTREGADO_031 NOMDOCENTREGADO031,
t1.FEC_DOC_ENTREGADO_031 FECDOCENTREGADO031,t1.TIPO_APORTACION_031 TIPOAPORTACION031,
t01.DESC_ES_001, t01.DESC_EU_001, t02.DESC_ES_002, t02.DESC_EU_002, t09.ID_002_TRAM
from aa83b31t00 t1
inner join aa83b09t00 t09 on t09.ID_009 = t1.ID_009_HISTO_TRAM
inner join aa83b01t00 t01 on t01.ID_001 = t09.ID_001_FASE and t01.ID_TIPO_SOL = t09.ID_003_TIPO_SOL
inner join aa83b02t00 t02 on t02.ID_001_FASE = t09.ID_001_FASE and t02.ID_002 = t09.ID_002_TRAM and t02.ID_003_TIPO_SOL = t09.ID_003_TIPO_SOL;


  CREATE OR REPLACE FORCE EDITIONABLE VIEW "AA83B"."AA83B32V00" ("ID_032", "ID_ANO_023", "ID_030_TIP_DOC_SOL", "ID_023_NUM_SOL", "OID_032_PAPEL0", "ID_010_HISTO_TRAM", "DESC_OTROS_032", "ORG_DOC_ENTREGADO_032", "NOM_DOC_ENTREGADO_032", "FEC_DOC_ENTREGADO_032", "TIPO_APORTACION_032", "FASE_DESC_ES_001", "FASE_DESC_EU_001", "TRAMITE_DESC_ES_002", "TRAMITE_DESC_EU_002", "ID_TRAMITE_002") AS 
  select t1.ID_032 ID032,t1.ID_ANO_023 IDANO023,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_023_NUM_SOL ID023NUMSOL,
t1.OID_032_PAPEL0 OID032PAPEL0,t1.ID_010_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_032 DESCOTROS032,
t1.ORG_DOC_ENTREGADO_032 ORGDOCENTREGADO032,t1.NOM_DOC_ENTREGADO_032 NOMDOCENTREGADO032,
t1.FEC_DOC_ENTREGADO_032 FECDOCENTREGADO032,t1.TIPO_APORTACION_032 TIPOAPORTACION032,
t01.DESC_ES_001, t01.DESC_EU_001, t02.DESC_ES_002, t02.DESC_EU_002, t10.ID_002_TRAM
from aa83b32t00 t1
inner join aa83b10t00 t10 on t10.ID_010 = t1.ID_010_HISTO_TRAM
inner join aa83b01t00 t01 on t01.ID_001 = t10.ID_001_FASE and t01.ID_TIPO_SOL = t10.ID_003_TIPO_SOL
inner join aa83b02t00 t02 on t02.ID_001_FASE = t10.ID_001_FASE and t02.ID_002 = t10.ID_002_TRAM and t02.ID_003_TIPO_SOL = t10.ID_003_TIPO_SOL;


  CREATE OR REPLACE FORCE EDITIONABLE VIEW "AA83B"."AA83B33V00" ("ID_033", "ID_ANO_025", "ID_030_TIP_DOC_SOL", "ID_025_NUM_SOL", "OID_033_PAPEL0", "ID_011_HISTO_TRAM", "DESC_OTROS_033", "ORG_DOC_ENTREGADO_033", "NOM_DOC_ENTREGADO_033", "FEC_DOC_ENTREGADO_033", "TIPO_APORTACION_033", "FASE_DESC_ES_001", "FASE_DESC_EU_001", "TRAMITE_DESC_ES_002", "TRAMITE_DESC_EU_002", "ID_TRAMITE_002") AS 
  select t1.ID_033 ID033,t1.ID_ANO_025 IDANO025,t1.ID_030_TIP_DOC_SOL ID030TIPDOCSOL,t1.ID_025_NUM_SOL ID025NUMSOL,
t1.OID_033_PAPEL0 OID033PAPEL0,t1.ID_011_HISTO_TRAM ID009HISTOTRAM,t1.DESC_OTROS_033 DESCOTROS033,
t1.ORG_DOC_ENTREGADO_033 ORGDOCENTREGADO033,t1.NOM_DOC_ENTREGADO_033 NOMDOCENTREGADO033,
t1.FEC_DOC_ENTREGADO_033 FECDOCENTREGADO033,t1.TIPO_APORTACION_033 TIPOAPORTACION033,
t01.DESC_ES_001, t01.DESC_EU_001, t02.DESC_ES_002, t02.DESC_EU_002, t11.ID_002_TRAM
from aa83b33t00 t1
inner join aa83b11t00 t11 on t11.ID_011 = t1.ID_011_HISTO_TRAM
inner join aa83b01t00 t01 on t01.ID_001 = t11.ID_001_FASE and t01.ID_TIPO_SOL = t11.ID_003_TIPO_SOL
inner join aa83b02t00 t02 on t02.ID_001_FASE = t11.ID_001_FASE and t02.ID_002 = t11.ID_002_TRAM and t02.ID_003_TIPO_SOL = t11.ID_003_TIPO_SOL;


UPDATE AA83B30T00  SET TD_DOKUSI_030='25' WHERE ID_030='1'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='8'  WHERE ID_030='2'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='3'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='14' WHERE ID_030='4'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='5'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='10' WHERE ID_030='6'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='7'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='24' WHERE ID_030='8'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='9'  ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='10' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='25' WHERE ID_030='11' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='2'  WHERE ID_030='12' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='13' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='14' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='15' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='16' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='17' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='1'  WHERE ID_030='18' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='19' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='20' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='21' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='22' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='23' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='24' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='25' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='26' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='27' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='28' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='5'  WHERE ID_030='29' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='30' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='31' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='1'  WHERE ID_030='32' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='20' WHERE ID_030='33' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='20' WHERE ID_030='34' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='20' WHERE ID_030='35' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='36' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='37' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='25' WHERE ID_030='38' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='18' WHERE ID_030='39' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='40' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='41' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='18' WHERE ID_030='42' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='43' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='24' WHERE ID_030='44' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='27' WHERE ID_030='45' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='5'  WHERE ID_030='46' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='47' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='1'  WHERE ID_030='48' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='49' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='50' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='51' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='52' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='53' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='54' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='55' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='56' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='57' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='58' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='59' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='60' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='11' WHERE ID_030='61' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='3'  WHERE ID_030='62' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='25' WHERE ID_030='63' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='8'  WHERE ID_030='64' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='65' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='14' WHERE ID_030='66' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='67' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='10' WHERE ID_030='68' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='69' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='24' WHERE ID_030='70' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='71' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='72' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='25' WHERE ID_030='73' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='2'  WHERE ID_030='74' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='75' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='76' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='77' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='26' WHERE ID_030='78' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='79' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='1'  WHERE ID_030='80' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='81' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='82' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='83' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='84' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='85' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='86' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='87' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='88' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='89' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='90' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='5'  WHERE ID_030='91' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='92' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='93' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='1'  WHERE ID_030='94' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='20' WHERE ID_030='95' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='20' WHERE ID_030='96' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='20' WHERE ID_030='97' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='21' WHERE ID_030='98' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='1'  WHERE ID_030='99' ;
UPDATE AA83B30T00  SET TD_DOKUSI_030='25' WHERE ID_030='100';
UPDATE AA83B30T00  SET TD_DOKUSI_030='18' WHERE ID_030='101';
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='102';
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='103';
UPDATE AA83B30T00  SET TD_DOKUSI_030='18' WHERE ID_030='104';
UPDATE AA83B30T00  SET TD_DOKUSI_030='19' WHERE ID_030='105';
UPDATE AA83B30T00  SET TD_DOKUSI_030='24' WHERE ID_030='106';
UPDATE AA83B30T00  SET TD_DOKUSI_030='27' WHERE ID_030='107';
UPDATE AA83B30T00  SET TD_DOKUSI_030='5'  WHERE ID_030='108';
UPDATE AA83B30T00  SET TD_DOKUSI_030='18' WHERE ID_030='109';
UPDATE AA83B30T00  SET TD_DOKUSI_030='1'  WHERE ID_030='110';
UPDATE AA83B30T00  SET TD_DOKUSI_030='29' WHERE ID_030='111';
UPDATE AA83B30T00  SET TD_DOKUSI_030='11' WHERE ID_030='112';
UPDATE AA83B30T00  SET TD_DOKUSI_030='3'  WHERE ID_030='113';

Insert into AA83B30T00 (ID_030,TD_DOKUSI_030,DESC_ES_030,ID_001_FASE,ID_002_TRAM,ID_003_TIPO_SOL,DESC_EU_030,SD_DOKUSI_030,ID_040_BLOQUE) values ('114','3','Contrato de Subarriendo','1','1','3','Contrato de Subarriendo_EUS','00','0');
Insert into AA83B30T00 (ID_030,TD_DOKUSI_030,DESC_ES_030,ID_001_FASE,ID_002_TRAM,ID_003_TIPO_SOL,DESC_EU_030,SD_DOKUSI_030,ID_040_BLOQUE) values ('115','3','Contrato de Subarriendo','1','4','3','Contrato de Subarriendo_EUS','0','0');

Insert into AA83B04T00 (ID_004,ID_001_FASE,ID_002_TRAM,ID_003_TIPO_SOL,DESC_ES_004,DESC_EU_004,NOM_TEMPLATE_004,TD_DOKUSI_030,SD_DOKUSI_030) values ('25','0','0','3','Ficha','Fitxa','FICHAADE',null,null);




DROP SEQUENCE SEQ_AA83B05T00_ID_005;

--  Create Triggers 
CREATE SEQUENCE SEQ_AA83B05T00_ID_005 
    INCREMENT BY 1 
    START WITH 3 
    NOMAXVALUE 
    MINVALUE 1 
	NOCYCLE 
	NOCACHE 
	NOORDER;

commit;





