CREATE TABLE AA83B43T00 
(ID_SOL NUMBER (8,0) NOT NULL,
ID_ANYO  NUMBER (4,0) NOT NULL,
ID_TIPOSOL NUMBER(8,0) NOT NULL,
ID_REMESA NUMBER(15,0) NOT NULL,
ID_COLECCION  NUMBER(15,0) NOT NULL,
ID_ENVIO  NUMBER(15,0) NOT NULL,
CODIGO_REMESA VARCHAR2(20 BYTE) NOT NULL,
CODIGO_COLECCION VARCHAR2(20 BYTE) NOT NULL,
CODIGO_ENVIO VARCHAR2(20 BYTE) NOT NULL,
PRIMARY KEY(ID_SOL, ID_ANYO, ID_TIPOSOL, ID_ENVIO)
);
COMMENT ON COLUMN AA83B43T00.ID_SOL IS 'Identificador';
COMMENT ON COLUMN AA83B43T00.ID_ANYO IS 'Ao de la solicitud';
COMMENT ON COLUMN AA83B43T00.ID_TIPOSOL IS 'Tipo de solicitud';
COMMENT ON COLUMN AA83B43T00.ID_REMESA IS 'Identificador de la remesa';
COMMENT ON COLUMN AA83B43T00.ID_COLECCION IS 'Identificador de la coleccin';
COMMENT ON COLUMN AA83B43T00.ID_ENVIO IS 'Identificador del envio';
COMMENT ON COLUMN AA83B43T00.CODIGO_REMESA IS 'Cdigo de la remesa';
COMMENT ON COLUMN AA83B43T00.CODIGO_COLECCION IS 'Cdigo de la coleccin';
COMMENT ON COLUMN AA83B43T00.CODIGO_ENVIO IS 'Cdigo del envio';


ALTER TABLE AA83B21T00
ADD REQ_LEIDO_021 CHAR(1 BYTE) DEFAULT 'N';

ALTER TABLE AA83B23T00
ADD REQ_LEIDO_023 CHAR(1 BYTE) DEFAULT 'N';


ALTER TABLE AA83B25T00
ADD REQ_LEIDO_025 CHAR(1 BYTE) DEFAULT 'N';


ALTER TABLE AA83B43T00 ADD CODIGO_SITUACION VARCHAR2(2 BYTE) DEFAULT '00';
ALTER TABLE AA83B43T00 ADD DESCRIPCION_ES VARCHAR2(70 BYTE) DEFAULT 'Sin estado';
ALTER TABLE AA83B43T00 ADD DESCRIPCION_EU VARCHAR(70 BYTE) DEFAULT 'Sin estado_eu';
ALTER TABLE AA83B43T00 ADD FECHA_SITUACION VARCHAR2(10 BYTE);
ALTER TABLE AA83B43T00 ADD FECHA_ENVIO TIMESTAMP;

 
COMMENT ON COLUMN "AA83B"."AA83B43T00"."CODIGO_SITUACION" IS 'Cdigo de la situacin, 00 no se ha recibido aviso por parte de correos';
 
COMMENT ON COLUMN "AA83B"."AA83B43T00"."DESCRIPCION_ES" IS 'Descripcin en castellano de la situacin';
 
COMMENT ON COLUMN "AA83B"."AA83B43T00"."DESCRIPCION_EU" IS 'Descripcin en euskera de la situacin';
 
COMMENT ON COLUMN "AA83B"."AA83B43T00"."FECHA_SITUACION" IS 'Fecha de la situacin, formato:dd/MM/yyyy';

COMMENT ON COLUMN "AA83B"."AA83B43T00"."FECHA_ENVIO" IS 'Fecha en la que se ha realizado el envio';
 
 
ALTER TABLE AA83B43T00 ADD UIDPUESTOTRAMITADOR VARCHAR2(20 BYTE);

COMMENT ON COLUMN "AA83B"."AA83B43T00"."UIDPUESTOTRAMITADOR" IS 'Uid del puesto tramitador';


CREATE OR REPLACE FORCE VIEW "AA83B"."AA83B19V00" ("ID019", "NOMBRE019", "APEL1019", "APEL2019", "NUMEMP", "IDCARGO005", "CARGOES", "CARGOEU", "FIRMADIGITAL019", "ACTIVOSN019", "FECINIVIGENCIA019", "FECFINVIGENCIA019") AS 
 SELECT t1.ID_019 ID019,t1.NOMBRE_019 NOMBRE019,t1.APEL1_019 APEL1019,t1.APEL2_019 APEL2019,t1.NUM_EMP NUMEMP,
t1.ID_CARGO_005 IDCARGO005, t5.DESC_ES_005 CARGOES, t5.DESC_EU_005 CARGOEU, t1.FIRMA_DIGITAL_019 FIRMADIGITAL019,t1.ACTIVO_SN_019 ACTIVOSN019,
t1.FEC_INI_VIGENCIA_019 FECINIVIGENCIA019, 
t1.FEC_FIN_VIGENCIA_019 FECFINVIGENCIA019 
FROM AA83B19T00 t1
inner join aa83b05t00 t5 on t5.ID_005 = t1.ID_CARGO_005;
 

alter table aa83b19t00 add FEC_INI_VIGENCIA_019 DATE;
alter table aa83b19t00 add FEC_FIN_VIGENCIA_019 DATE;

COMMENT ON COLUMN AA83B.AA83B19T00.FEC_INI_VIGENCIA_019 IS 'Fecha inicio vigencia';
COMMENT ON COLUMN AA83B.AA83B19T00.FEC_FIN_VIGENCIA_019 IS 'Fecha fin vigencia';
 
-- Cambios para guardar documentos aportados previamente
ALTER TABLE AA83B31T00
	ADD (ORG_DOC_ENTREGADO_031  VARCHAR2(640),
	NOM_DOC_ENTREGADO_031  VARCHAR2(640),
	FEC_DOC_ENTREGADO_031  DATE,
	TIPO_APORTACION_031    VARCHAR2(6)
  )
;
ALTER TABLE AA83B32T00
	ADD (ORG_DOC_ENTREGADO_032  VARCHAR2(640),
	NOM_DOC_ENTREGADO_032  VARCHAR2(640),
	FEC_DOC_ENTREGADO_032  DATE,
	TIPO_APORTACION_032    VARCHAR2(6)
  )
 ; 
  ALTER TABLE AA83B33T00
	ADD (ORG_DOC_ENTREGADO_033  VARCHAR2(640),
	NOM_DOC_ENTREGADO_033  VARCHAR2(640),
	FEC_DOC_ENTREGADO_033  DATE,
	TIPO_APORTACION_033    VARCHAR2(6)
  )
  ;
  
COMMENT ON COLUMN AA83B.AA83B31T00.ORG_DOC_ENTREGADO_031  IS 'Organismo de entrega del documento'
;
COMMENT ON COLUMN AA83B.AA83B31T00.NOM_DOC_ENTREGADO_031  IS 'Nombre del Documento entregado'
;
COMMENT ON COLUMN AA83B.AA83B31T00.FEC_DOC_ENTREGADO_031  IS 'Fecha de entrega del documento'
;
COMMENT ON COLUMN AA83B.AA83B31T00.TIPO_APORTACION_031    IS 'Tipo de aportacion del documento'
;


COMMENT ON COLUMN AA83B.AA83B32T00.ORG_DOC_ENTREGADO_032  IS 'Organismo de entrega del documento'
;
COMMENT ON COLUMN AA83B.AA83B32T00.NOM_DOC_ENTREGADO_032  IS 'Nombre del Documento entregado'
;
COMMENT ON COLUMN AA83B.AA83B32T00.FEC_DOC_ENTREGADO_032  IS 'Fecha de entrega del documento'
;
COMMENT ON COLUMN AA83B.AA83B32T00.TIPO_APORTACION_032   IS 'Tipo de aportacion del documento'
;

COMMENT ON COLUMN AA83B.AA83B33T00.ORG_DOC_ENTREGADO_033  IS 'Organismo de entrega del documento'
;
COMMENT ON COLUMN AA83B.AA83B33T00.NOM_DOC_ENTREGADO_033  IS 'Nombre del Documento entregado'
;
COMMENT ON COLUMN AA83B.AA83B33T00.FEC_DOC_ENTREGADO_033  IS 'Fecha de entrega del documento'
;
COMMENT ON COLUMN AA83B.AA83B33T00.TIPO_APORTACION_033    IS 'Tipo de aportacion del documento'
;

UPDATE AA83B31T00
SET TIPO_APORTACION_031='A'
;
UPDATE AA83B32T00
SET TIPO_APORTACION_032='A'
;
UPDATE AA83B33T00
SET TIPO_APORTACION_033='A'
;


-- Tabla de emails

DROP TRIGGER AA83B.TRG_AA83B42T00_ID_042;

DROP SEQUENCE AA83B.SEQ_AA83B42T00_ID_042;

DROP TABLE AA83B.AA83B42T00 CASCADE CONSTRAINTS;

CREATE TABLE AA83B.AA83B42T00
(
	ID_042        NUMBER(8) NOT NULL,
	NOM_COMPLETO_042  VARCHAR2(250),
	EMAIL_042         VARCHAR2(120),
	ACTIVO_SN_042         CHAR(1)
)
TABLESPACE  AA8301E00
PCTFREE     10
INITRANS    1
MAXTRANS    255
STORAGE (
        INITIAL         65536
        MINEXTENTS      1
        MAXEXTENTS      2147483645
        BUFFER_POOL     DEFAULT
        ) 
LOGGING
NOCOMPRESS
NOCACHE
NOPARALLEL
MONITORING;


ALTER TABLE AA83B.AA83B42T00
ADD CONSTRAINT SYS_C0067113 CHECK ("ID_042" IS NOT NULL);

ALTER TABLE AA83B.AA83B42T00 ADD CONSTRAINT PK_AA83BT042 
	PRIMARY KEY (ID_042) 
 USING INDEX;

CREATE SEQUENCE AA83B.SEQ_AA83B42T00_ID_042 
    INCREMENT BY 1 
    START WITH 1 
    NOMAXVALUE 
    MINVALUE 1 
	NOCYCLE 
	NOCACHE 
	NOORDER;

CREATE OR REPLACE TRIGGER TRG_AA83B42T00_ID_042 
	BEFORE INSERT 
	ON AA83B42T00 
	FOR EACH ROW 
	BEGIN 
		SELECT SEQ_AA83B42T00_ID_042.NEXTVAL 
		INTO :NEW.ID_042 
		FROM DUAL; 
	END;
	
/
	
CREATE OR REPLACE FORCE VIEW "AA83B"."AA83B06V00" ("ID_002", "DESC_ES_002", "DESC_EU_002", "ID_001_FASE") AS 
  SELECT DISTINCT ID_002,DESC_ES_002,DESC_EU_002, ID_001_FASE
  from AA83B02T00    
   where (ID_002 =1 AND ID_001_FASE=2) OR (ID_002 =2 AND ID_001_FASE=1);
 

   COMMENT ON TABLE "AA83B"."AA83B06V00"  IS 'Trmites para comunicaciones';	
	
  CREATE OR REPLACE FORCE VIEW "AA83B"."AA83B07V00" ("SOLCONCAT", "ID_ANO", "ID", "NUM_REG", "NOMBRE", "APEL1", "APEL2", "APELLIDOS", "TIPO_DOC", "NUM_DOC", "SOLI_CERRADA", "ID_SOL", "TIPO_SOL", "ID_FASE", "ID_TRAM", "FEC_ALTA_ES", "FEC_ALTA_EU", "FEC_ALTA_ORD", "DESC_ES_TRAM", "DESC_EU_TRAM") AS 
  SELECT  
  T03.TIPO_SOL_003 || ' ' || T21.ID_ANO_021 || ' ' ||  T21.ID_021 as solConcat, T21.ID_ANO_021, T21.ID_021, 
  T21.NUM_REG_021, T21.NOMBRE_021, T21.APEL1_021, T21.APEL2_021,  T21.APEL1_021 || ' ' || T21.APEL2_021 APELLIDOS,
  t21.ID_012_TIPO_DOC,NUM_DOC_021, NVL(SOLI_CERRADA_021,'N')
, T03.ID_003, T03.TIPO_SOL_003
, T09.ID_001_FASE, T09.ID_002_TRAM
  ,to_char(F_ACTU_006,'dd/MM/yyyy')
  ,to_char(F_ACTU_006,'yyyy/MM/dd')  
,to_timestamp(to_char(F_ACTU_006,'yyyy/MM/DD HH24:mi:ss'),'yyyy/MM/DD HH24:mi:ss')
, T02.DESC_ES_002, T02.DESC_EU_002
FROM AA83B21T00 T21
INNER JOIN AA83B03T00 T03 ON T03.ID_003 = 3
INNER JOIN AA83B09T00 T09 ON T09.ID_009 IN (SELECT MAX(T09MAX.ID_009) ID_009
            FROM AA83B09T00 T09MAX 
            WHERE T09MAX.ID_003_TIPO_SOL = T03.ID_003 AND T09MAX.ID_ANO_021 = T21.ID_ANO_021 AND 
                  T09MAX.ID_021_NUM_SOL = T21.ID_021
            )
INNER JOIN AA83B06T00 T06 ON T06.ID_006 in (SELECT MAX(T06MAX.ID_006 ) ID_006
                                           FROM AA83B06T00 T06MAX 
                                           WHERE T06MAX.TIPO_MODIF_038 = 'A' AND T06MAX.ID_003_TIPO_SOL = T03.ID_003 AND 
                                                T06MAX.ID_ANO_021 = T21.ID_ANO_021 AND T06MAX.ID_021_NUM_SOL = T21.ID_021
                                                )
INNER JOIN AA83B02T00 T02 ON T02.ID_001_FASE = T09.ID_001_FASE AND T02.ID_003_TIPO_SOL = T03.ID_003 AND T02.ID_002 = T09.ID_002_TRAM
UNION
SELECT  T03.TIPO_SOL_003 || ' ' || T23.ID_ANO_023 || ' ' ||  T23.ID_023 as solConcat, T23.ID_ANO_023, T23.ID_023, 
T23.NUM_REG_023, T23.NOMBRE_023, T23.APEL1_023, T23.APEL2_023,  T23.APEL1_023 || ' ' || T23.APEL2_023 APELLIDOS,
t23.ID_012_TIPO_DOC,T23.NUM_DOC_023, NVL(SOLI_CERRADA_023,'N')
, T03.ID_003, T03.TIPO_SOL_003
, T10.ID_001_FASE, T10.ID_002_TRAM
  ,to_char(F_ACTU_007,'dd/MM/yyyy')
    ,to_char(F_ACTU_007,'yyyy/MM/dd')  
,to_timestamp(to_char(F_ACTU_007,'yyyy/MM/DD HH24:mi:ss'),'yyyy/MM/DD HH24:mi:ss')
, T02.DESC_ES_002, T02.DESC_EU_002
FROM AA83B23T00 T23
INNER JOIN AA83B03T00 T03 ON T03.ID_003 = 2
INNER JOIN AA83B10T00 T10 ON T10.ID_010 IN (SELECT MAX(T10MAX.ID_010) ID_010
            FROM AA83B10T00 T10MAX 
            WHERE T10MAX.ID_003_TIPO_SOL = T03.ID_003 AND T10MAX.ID_ANO_023 = T23.ID_ANO_023 AND 
                  T10MAX.ID_023_NUM_SOL = T23.ID_023
            )
INNER JOIN AA83B07T00 T07 ON T07.ID_007 in (SELECT MAX(T07MAX.ID_007 ) ID_007
                                           FROM AA83B07T00 T07MAX 
                                           WHERE T07MAX.TIPO_MODIF_038 = 'A' AND T07MAX.ID_003_TIPO_SOL = T03.ID_003 AND 
                                                T07MAX.ID_ANO_023 = T23.ID_ANO_023 AND T07MAX.ID_023_NUM_SOL = T23.ID_023
                                                )
INNER JOIN AA83B02T00 T02 ON T02.ID_001_FASE = T10.ID_001_FASE AND T02.ID_003_TIPO_SOL = T03.ID_003 AND T02.ID_002 = T10.ID_002_TRAM
UNION
SELECT  T03.TIPO_SOL_003 || ' ' || T25.ID_ANO_025 || ' ' ||  T25.ID_025 as solConcat, T25.ID_ANO_025, T25.ID_025, 
T25.NUM_REG_025, T25.NOMBRE_025, T25.APEL1_025, T25.APEL2_025,  T25.APEL2_025 || ' ' || T25.APEL2_025 APELLIDOS,
t25.ID_012_TIPO_DOC, NUM_DOC_025, NVL(SOLI_CERRADA_025,'N')
, T03.ID_003, T03.TIPO_SOL_003
, T11.ID_001_FASE, T11.ID_002_TRAM
  ,to_char(F_ACTU_008,'dd/MM/yyyy')
    ,to_char(F_ACTU_008,'yyyy/MM/dd')  
,to_timestamp(to_char(F_ACTU_008,'yyyy/MM/DD HH24:mi:ss'),'yyyy/MM/DD HH24:mi:ss')
, T02.DESC_ES_002, T02.DESC_EU_002
FROM AA83B25T00 T25
INNER JOIN AA83B03T00 T03 ON T03.ID_003 = 1
INNER JOIN AA83B11T00 T11 ON T11.ID_011 IN (SELECT MAX(T11MAX.ID_011) ID_011
            FROM AA83B11T00 T11MAX 
            WHERE T11MAX.ID_003_TIPO_SOL = T03.ID_003 AND T11MAX.ID_ANO_SOL_025 = T25.ID_ANO_025 AND 
                  T11MAX.ID_025_NUM_SOL = T25.ID_025
            )
INNER JOIN AA83B08T00 T08 ON T08.ID_008 in (SELECT MAX(T08MAX.ID_008 ) ID_008
                                           FROM AA83B08T00 T08MAX 
                                           WHERE T08MAX.TIPO_MODIF_038 = 'A' AND T08MAX.ID_003_TIPO_SOL = T03.ID_003 AND 
                                                T08MAX.ID_ANO_025 = T25.ID_ANO_025 AND T08MAX.ID_025_NUM_SOL = T25.ID_025
                                                )
INNER JOIN AA83B02T00 T02 ON T02.ID_001_FASE = T11.ID_001_FASE AND T02.ID_003_TIPO_SOL = T03.ID_003 AND T02.ID_002 = T11.ID_002_TRAM
;
 

