CREATE TABLE AA83B.AA83B42T00 
(	
	ID_042 					NUMBER(8,0) NOT NULL ENABLE, 
	NOM_COMPLETO_042	 	VARCHAR2(250 BYTE), 
	EMAIL_042				VARCHAR2(120 BYTE), 
	ACTIVO_SN_042			CHAR(1 BYTE)
)
TABLESPACE  AA8301E00
PCTFREE     10
INITRANS    1
MAXTRANS    255
STORAGE (
        BUFFER_POOL     DEFAULT
        ) 
LOGGING
NOCOMPRESS
NOCACHE
NOPARALLEL
MONITORING
;

CREATE TABLE AA83B.AA83B43T00 
(	
    ID_SOL 				NUMBER(8,0) NOT NULL ENABLE, 
	ID_ANYO 			NUMBER(4,0) NOT NULL ENABLE, 
	ID_TIPOSOL 			NUMBER(8,0) NOT NULL ENABLE, 
	ID_REMESA 			NUMBER(15,0) NOT NULL ENABLE, 
	ID_COLECCION 		NUMBER(15,0) NOT NULL ENABLE, 
	ID_ENVIO 			NUMBER(15,0) NOT NULL ENABLE, 
	CODIGO_REMESA 		VARCHAR2(20 BYTE) NOT NULL ENABLE, 
	CODIGO_COLECCION 	VARCHAR2(20 BYTE) NOT NULL ENABLE, 
	CODIGO_ENVIO 		VARCHAR2(20 BYTE) NOT NULL ENABLE, 
	CODIGO_SITUACION 	VARCHAR2(2 BYTE) DEFAULT '00', 
	DESCRIPCION_ES 		VARCHAR2(70 BYTE) DEFAULT 'Sin estado', 
	DESCRIPCION_EU 		VARCHAR2(70 BYTE) DEFAULT 'Sin estado_eu', 
	FECHA_SITUACION 	VARCHAR2(10 BYTE), 
	FECHA_ENVIO 		TIMESTAMP (6), 
	UIDPUESTOTRAMITADOR VARCHAR2(20 BYTE)
)
TABLESPACE  AA8301E00
PCTFREE     10
INITRANS    1
MAXTRANS    255
STORAGE (
        BUFFER_POOL     DEFAULT
        ) 
LOGGING
NOCOMPRESS
NOCACHE
NOPARALLEL
MONITORING
;


   COMMENT ON COLUMN "AA83B"."AA83B43T00"."ID_SOL" IS 'Identificador';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."ID_ANYO" IS 'Ao de la solicitud';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."ID_TIPOSOL" IS 'Tipo de solicitud';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."ID_REMESA" IS 'Identificador de la remesa';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."ID_COLECCION" IS 'Identificador de la coleccin';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."ID_ENVIO" IS 'Identificador del envio';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."CODIGO_REMESA" IS 'Cdigo de la remesa';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."CODIGO_COLECCION" IS 'Cdigo de la coleccin';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."CODIGO_ENVIO" IS 'Cdigo del envio';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."CODIGO_SITUACION" IS 'Cdigo de la situacin, 00 no se ha recibido aviso por parte de correos';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."DESCRIPCION_ES" IS 'Descripcin en castellano de la situacin';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."DESCRIPCION_EU" IS 'Descripcin en euskera de la situacin';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."FECHA_SITUACION" IS 'Fecha de la situacin, formato:dd/MM/yyyy';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."FECHA_ENVIO" IS 'Fecha en la que se ha realizado el envio';
   COMMENT ON COLUMN "AA83B"."AA83B43T00"."UIDPUESTOTRAMITADOR" IS 'Uid del puesto tramitador';

ALTER TABLE AA83B.AA83B42T00
ADD CONSTRAINT SYS_C0067113 CHECK ("ID_042" IS NOT NULL);

ALTER TABLE AA83B42T00 ADD CONSTRAINT PK_AA83B42T00 
	PRIMARY KEY (ID_042) 
 USING INDEX 
;

ALTER TABLE AA83B.AA83B43T00 ADD CONSTRAINT PK_AA83B43T00 
	PRIMARY KEY (ID_SOL, ID_ANYO, ID_TIPOSOL, ID_ENVIO) 
 USING INDEX 
;

ALTER TABLE AA83B21T00 ADD (BIS_021  VARCHAR2(10), BIS_COMUNIC_021  VARCHAR2(10));
ALTER TABLE AA83B23T00 ADD (BIS_COMUNIC_023  VARCHAR2(10) );
ALTER TABLE AA83B25T00 ADD (BIS_COMUNIC_025  VARCHAR2(10) );


CREATE OR REPLACE FORCE VIEW "AA83B"."AA83B21V00" ("ID021", "IDANO021", "FECREG021", "ID015MOTIVOS_SOL", "MOTIVOES015", "MOTIVOEU015", "CONSENTIMIENTOS2021", "NOMBRE021", "APEL1021", "APEL2021", "TELF1021", "TELF2021", "EMAIL021", "CALLECOMUNIC021", "NUMEROCOMUNIC021", "BISCOMUNIC021", "PISOCOMUNIC021", "LETRACOMUNIC021", "CPOSTALCOMUNIC021", "PROVINCIACOMUNIC021", "PROVCOMUNIC", "MUNICIPCOMUNIC021", "MUNICOMUNIC", "NUMDOC021", "NACIONALIDAD021", "PAISDS", "CALLE021", "NUMCALLE021", "BIS021", "PISO021", "LETRA021", "CP021", "PROVINCIA021", "PROVINS", "MUNICIPIO021", "MUNIDSINS", "ID014TITULARIDADVIV", "DESCES014", "DESCEU014", "ID016DERECHOSOCUP", "DESCES016", "DESCEU016", "NUMPERSHABITAN021", "NUMPERSREAGRUPAR021", "OBSERVACIONES021") AS 
  SELECT ID_021, ID_ANO_021, FEC_REG_021, ID_015_MOTIVOS_SOL, T15.DESC_ES_015, T15.DESC_EU_015, nvl(T21.CONSENTIMIENTOS2_021,' '),
T21.NOMBRE_021, T21.APEL1_021, T21.APEL2_021, nvl(T21.TELF1_021,' '), nvl(T21.TELF2_021,' '), nvl(T21.EMAIL_021,' '), 
CALLEC.TIPO_VIA || ' ' || (case when LENGTH(TRIM(TRANSLATE(T21.CALLE_COMUNIC_021, ' +-.0123456789',' '))) > 0 then T21.CALLE_COMUNIC_021 else CALLEC.DS_O end), nvl(T21.NUMERO_COMUNIC_021,' '), nvl(T21.BIS_COMUNIC_021,' '), nvl(T21.PISO_COMUNIC_021,' '), nvl(T21.LETRA_COMUNIC_021,' '), 
nvl(T21.CPOSTAL_COMUNIC_021,' '), 
T21.PROVINCIA_COMUNIC_021, nvl(PROVC.DS_O, ' '), T21.MUNICIP_COMUNIC_021, nvl(MUNIC.DS_O, ' '), T21.NUM_DOC_021, T21.NACIONALIDAD_021, 
PAIS.DS_O, CALLE.TIPO_VIA || ' ' || (case when LENGTH(TRIM(TRANSLATE(T21.CALLE_021, ' +-.0123456789',' '))) > 0 then T21.CALLE_021 else CALLE.DS_O end), nvl(T21.NUM_CALLE_021,' '), nvl(T21.BIS_021,' '), nvl(T21.PISO_021,' '), nvl(T21.LETRA_021, ' '), nvl(T21.CP_021, ' '), T21.PROVINCIA_021, nvl(PROV.DS_O, ' '), 
T21.MUNICIPIO_021, nvl(MUNI.DS_O, ' ' ), T21.ID_014_TITULARIDAD_VIV, T14.DESC_ES_014, T14.DESC_EU_014, T21.ID_016_DERECHOS_OCUP, 
T16.DESC_ES_016, T16.DESC_EU_016, nvl(T21.NUM_PERS_HABITAN_021, '0'), nvl(T21.NUM_PERS_REAGRUPAR_021,'0'), nvl(T21.OBSERVACIONES_021,' ')
FROM AA83B21T00 T21
INNER JOIN AA83B15T00 T15 ON T15.ID_015 = T21.ID_015_MOTIVOS_SOL
LEFT OUTER JOIN T17I.T17_PROVINCIA PROVC ON PROVC.ID = T21.PROVINCIA_COMUNIC_021
LEFT OUTER JOIN T17I.T17_MUNICIPIO MUNIC ON MUNIC.PROVINCIA_ID=T21.PROVINCIA_COMUNIC_021 AND MUNIC.ID = T21.MUNICIP_COMUNIC_021
LEFT OUTER JOIN T17I.T17_CALLE CALLEC ON CALLEC.ID = (case when LENGTH(TRIM(TRANSLATE(T21.CALLE_COMUNIC_021, ' +-.0123456789',' '))) > 0 then '0' else T21.CALLE_COMUNIC_021 end)
LEFT OUTER JOIN T17I.T17_PROVINCIA PROV ON PROV.ID = T21.PROVINCIA_021
LEFT OUTER JOIN T17I.T17_MUNICIPIO MUNI ON MUNI.PROVINCIA_ID=T21.PROVINCIA_021 AND MUNI.ID = T21.MUNICIPIO_021
LEFT OUTER JOIN T17I.T17_CALLE CALLE ON  CALLE.ID = (case when LENGTH(TRIM(TRANSLATE(T21.CALLE_021, ' +-.0123456789',' '))) > 0 then '0' else T21.CALLE_021 end)
LEFT OUTER JOIN T17I.T17_PAIS PAIS ON PAIS.ID = T21.NACIONALIDAD_021
INNER JOIN AA83B14T00 T14 ON T14.ID_014 = T21.ID_014_TITULARIDAD_VIV
INNER JOIN AA83B16T00 T16 ON T16.ID_016 = T21.ID_016_DERECHOS_OCUP;
 


UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Sin Fase',DESC_EU_001='Faserik gabe' WHERE ID_001='0' AND ID_TIPO_SOL='0';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Solicitud de Informe',DESC_EU_001='Txostenaren eskaera' WHERE ID_001='1' AND ID_TIPO_SOL='1';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Resolucin',DESC_EU_001='Ebazpenarena' WHERE ID_001='2' AND ID_TIPO_SOL='1';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Cierre',DESC_EU_001='Ixtea' WHERE ID_001='3' AND ID_TIPO_SOL='1';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Solicitud de Informe',DESC_EU_001='Txostenaren eskaera' WHERE ID_001='1' AND ID_TIPO_SOL='2';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Resolucin',DESC_EU_001='Ebazpenarena' WHERE ID_001='2' AND ID_TIPO_SOL='2';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Cierre',DESC_EU_001='Ixtea' WHERE ID_001='3' AND ID_TIPO_SOL='2';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Solicitud de Informe',DESC_EU_001='Txostenaren eskaera' WHERE ID_001='1' AND ID_TIPO_SOL='3';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Resolucin',DESC_EU_001='Ebazpenarena' WHERE ID_001='2' AND ID_TIPO_SOL='3';
UPDATE AA83B.AA83B01T00 SET DESC_ES_001='Cierre',DESC_EU_001='Ixtea' WHERE ID_001='3' AND ID_TIPO_SOL='3';

UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Sin trmite',DESC_EU_002='Izapiderik gabe' WHERE ID_002='0' AND ID_001_FASE='0' AND ID_003_TIPO_SOL='0';		
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de solicitud telemtica',DESC_EU_002='Eskaera telematikoko hartzea' WHERE ID_002='0' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de solicitud e inicio del expediente',DESC_EU_002='Eskaera-harrera eta espedientearen hasiera'  WHERE ID_002='1' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Requerimiento de subsanacin',DESC_EU_002='Konpontzearen eskakizuneko' WHERE ID_002='2' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Notificacin de Requerimiento de subsanacin',DESC_EU_002='Konpontzearen eskakizuneko jakinarazpena' WHERE ID_002='3' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de Documentacin de Subsanacin',DESC_EU_002='Konpontze-Dokumentazio Harrera' WHERE ID_002='4' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Informe de resolucin',DESC_EU_002='Erabaki-txostena' WHERE ID_002='1' AND ID_001_FASE='2' AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Notificacin de informe de resolucin',DESC_EU_002='Erabaki-Txosten jakinarazpena' WHERE ID_002='2' AND ID_001_FASE='2' AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Cierre del expediente',DESC_EU_002='Espedienteko ixtea' WHERE ID_002='1' AND ID_001_FASE='3' AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de solicitud telemtica',DESC_EU_002='Eskaera telematikoko hartzea' WHERE ID_002='0' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de solicitud e inicio del expediente',DESC_EU_002='Eskaera-harrera eta espedientearen hasiera'  WHERE ID_002='1' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Requerimiento de subsanacin',DESC_EU_002='Konpontzearen eskakizuna' WHERE ID_002='2' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Notificacin de Requerimiento de subsanacin',DESC_EU_002='Konpontzearen eskakizuneko jakinarazpena' WHERE ID_002='3' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de Documentacin de Subsanacin',DESC_EU_002='Konpontze-Dokumentazio Harrera' WHERE ID_002='4' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Informe de resolucin',DESC_EU_002='Erabaki-txostena' WHERE ID_002='1' AND ID_001_FASE='2' AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Notificacin de informe de resolucin',DESC_EU_002='Erabaki-Txosten jakinarazpena' WHERE ID_002='2' AND ID_001_FASE='2' AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Cierre del expediente',DESC_EU_002='Espedienteko ixtea' WHERE ID_002='1' AND ID_001_FASE='3' AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de solicitud telemtica',DESC_EU_002='Eskaera telematikoko hartzea' WHERE ID_002='0' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de solicitud e inicio del expediente',DESC_EU_002='Eskaera-harrera eta espedientearen hasiera'  WHERE ID_002='1' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Requerimiento de subsanacin',DESC_EU_002='Konpontzearen eskakizuna' WHERE ID_002='2' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Notificacin de Requerimiento de subsanacin',DESC_EU_002='Konpontzearen eskakizuneko jakinarazpena' WHERE ID_002='3' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Recepcin de Documentacin de Subsanacin',DESC_EU_002='Konpontze-Dokumentazio Harrera' WHERE ID_002='4' AND ID_001_FASE='1' AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Informe de resolucin',DESC_EU_002='Erabaki-txostena' WHERE ID_002='1' AND ID_001_FASE='2' AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Notificacin de informe de resolucin',DESC_EU_002='Erabaki-Txosten jakinarazpena' WHERE ID_002='2' AND ID_001_FASE='2' AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B02T00 SET DESC_ES_002='Cierre del expediente',DESC_EU_002='Espedienteko ixtea' WHERE ID_002='1' AND ID_001_FASE='3' AND ID_003_TIPO_SOL='3';

UPDATE AA83B.AA83B03T00 SET DESC_ES_003='Solicitud de Arraigo',DESC_EU_003='Errotze Eskaera' WHERE ID_003='1';
UPDATE AA83B.AA83B03T00 SET DESC_ES_003='Solicitud de Esfuerzo de Integracin',DESC_EU_003='Gizarteratzeko Ahaleginaren Eskaera' WHERE ID_003='2';
UPDATE AA83B.AA83B03T00 SET DESC_ES_003='Solicitud de Adecuacin de Vivienda',DESC_EU_003='Etxebizitzaren Egokitasun Eskaera' WHERE ID_003='3';
UPDATE AA83B.AA83B03T00 SET DESC_ES_003='Todas',DESC_EU_003='Guztiak' WHERE ID_003='0';

UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Requerimiento Subsanacion ADE',DESC_EU_004='ADE Zuzentzeko espedientea' WHERE ID_004='22';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Informe de resolucion de ESF',DESC_EU_004='ESF Ebazpenaren txostena' WHERE ID_004='9';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Informe de resolucion de ARR',DESC_EU_004='ARR Ebazpenaren txostena' WHERE ID_004='8';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Acuses de recibo',DESC_EU_004='Jaso izanaren agiriak' WHERE ID_004='4';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Relacin de acuses',DESC_EU_004='Hartu-agiriak' WHERE ID_004='5';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Etiquetas',DESC_EU_004='Etiketak' WHERE ID_004='6';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Etiquetas carpetas',DESC_EU_004='Karpetetarako Etiketak' WHERE ID_004='7';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Adjunto remito',DESC_EU_004='Honekin batera doa dokumentua' WHERE ID_004='11';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Informe de resolucion de ADE',DESC_EU_004='ADE Ebazpenaren txostena' WHERE ID_004='10';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Requerimiento Subsanacion ARR',DESC_EU_004='ARR Zuzentzeko espedientea' WHERE ID_004='26';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Requerimiento Subsanacion ESF',DESC_EU_004='ESF Zuzentzeko espedientea' WHERE ID_004='24';
UPDATE AA83B.AA83B04T00  SET  DESC_ES_004='Ficha',DESC_EU_004='Fitxa' WHERE ID_004='25';


UPDATE AA83B.AA83B05T00  SET DESC_ES_005='Tcnico de Inmigracin' , DESC_EU_005='Immigrazio teknikaria' WHERE ID_005='1';
UPDATE AA83B.AA83B05T00  SET DESC_ES_005='Director' ,DESC_EU_005='Zuzendaria' WHERE ID_005='2';



UPDATE AA83B.AA83B12T00   SET DESC_ES_012='DNI',DESC_EU_012='NAN' WHERE ID_012='1';
UPDATE AA83B.AA83B12T00   SET DESC_ES_012='NIE',DESC_EU_012='AIZ' WHERE ID_012='2';
UPDATE AA83B.AA83B12T00   SET DESC_ES_012='PASAPORTE',DESC_EU_012='PASAPORTEA' WHERE ID_012='3';
UPDATE AA83B.AA83B12T00   SET DESC_ES_012='OTROS',DESC_EU_012='BESTERIK' WHERE ID_012='4';


UPDATE AA83B.AA83B13T00  SET DESC_ES_013='Madre',DESC_EU_013='Ama' WHERE ID_013='1'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='Padre',DESC_EU_013='Aita' WHERE ID_013='2'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='Hija',DESC_EU_013='Alaba' WHERE ID_013='3'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='Hijo',DESC_EU_013='Semea' WHERE ID_013='4'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='Cnyuge',DESC_EU_013='Ezkontidea' WHERE ID_013='5'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='Menor Tutelado/a', DESC_EU_013='Tutoretzapeko adin txikikoa'WHERE ID_013='6'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='Hermano',DESC_EU_013='Anaia' WHERE ID_013='7'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='SOBRINO/A',DESC_EU_013='Iloba' WHERE ID_013='8'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='NIETO/A',DESC_EU_013='Biloba' WHERE ID_013='9'; 
UPDATE AA83B.AA83B13T00  SET DESC_ES_013='Otro',DESC_EU_013='Besterik' WHERE ID_013='10';


UPDATE AA83B.AA83B14T00 SET  DESC_ES_014='Propietario/a',DESC_EU_014='Jabea' WHERE ID_014='1';
UPDATE AA83B.AA83B14T00 SET  DESC_ES_014='En alquiler',DESC_EU_014	='Alokairuan' WHERE ID_014='2';
UPDATE AA83B.AA83B14T00 SET  DESC_ES_014='Cesin',DESC_EU_014	='Jabetzaren lagapena'  WHERE ID_014='3';
UPDATE AA83B.AA83B14T00 SET  DESC_ES_014='Subarriendo',DESC_EU_014	='Azpierrettamendua' WHERE ID_014='4';
UPDATE AA83B.AA83B14T00 SET  DESC_ES_014='Trabajador/a Interno/a',DESC_EU_014='Etxeko langilea' WHERE ID_014='5';


UPDATE AA83B.AA83B15T00 SET DESC_ES_015='Autorizacin de residencia temporal por reagrupacin familiar',DESC_EU_015='Aldi baterako Egoitza-baimena, familia berrelkartzeko' WHERE ID_015='1';
UPDATE AA83B.AA83B15T00 SET DESC_ES_015='Renovacin de Autorizacin de residencia por reagrupacin familiar, en caso de cambio de vivienda',DESC_EU_015='Aldi baterako Egoitza-baimena, familia berrelkartzeko (beti ere etxebizitza aldaketa egon delako)' WHERE ID_015='2';
UPDATE AA83B.AA83B15T00 SET DESC_ES_015='Regularizacion de menor en situacin Administrativa Irregular',DESC_EU_015='Estatu Espainolean jaio eta administrazio egoera ez erregularrean dagoen adin txikikoa erregularizatzeko' WHERE ID_015='3';
UPDATE AA83B.AA83B15T00 SET DESC_ES_015='Otros',DESC_EU_015='Besterik' WHERE ID_015='4';

UPDATE AA83B.AA83B16T00 SET DESC_ES_016='Solicitante',DESC_EU_016='Eskatzailea' WHERE ID_016='1';
UPDATE AA83B.AA83B16T00 SET DESC_ES_016='Familiar de primer grado',DESC_EU_016='Lehendabiziko graduko familiartekoa' WHERE ID_016='2';
UPDATE AA83B.AA83B16T00 SET DESC_ES_016='Otro',DESC_EU_016='Besterik' WHERE ID_016='3';
                                                                                
UPDATE AA83B.AA83B17T00 SET DESC_ES_017='Mujer',DESC_EU_017='Emakumea' WHERE ID_017='1';
UPDATE AA83B.AA83B17T00 SET DESC_ES_017='Varon',DESC_EU_017='Gizona'   WHERE ID_017='2';
                                                       
UPDATE AA83B.AA83B26T00 SET DESC_ES_026='Renovacin de Autorizacin de Residencia Temporal No Lucrativa',DESC_EU_026='Aldi baterako Egoitza-baimena berritzea, irabazi-asmorik gabekoa' WHERE ID_026='1'; 
UPDATE AA83B.AA83B26T00 SET DESC_ES_026='Renovacin de Autorizacin de Residencia Temporal por reagrupacin familiar',DESC_EU_026='Aldi baterako Egoitza-baimena berritzea, berrelkartutako familiartekoen egoitza-baimena' WHERE ID_026='2'; 
UPDATE AA83B.AA83B26T00 SET DESC_ES_026='Renovacin de Autorizacin de Residencia Temporal y trabajo por cuenta ajena',DESC_EU_026='Aldi baterako Egoitza eta besteren kontura lan egiteko baimena berritzea' WHERE ID_026='3'; 
UPDATE AA83B.AA83B26T00 SET DESC_ES_026='Renovacin de Autorizacin de Residencia Temporal y trabajo por cuenta propia',DESC_EU_026='Aldi baterako Egoitza eta norberaren kontura lan egiteko baimena berritzea' WHERE ID_026='4'; 
UPDATE AA83B.AA83B26T00 SET DESC_ES_026='Otros',DESC_EU_026='Besterik' WHERE ID_026='5'; 
                        
UPDATE AA83B.AA83B27T00 SET DESC_ES_027='No se ha presentado la solicitud de renovacin',DESC_EU_027='Oraindik ez da eskabidea aurkeztu' WHERE ID_027='1'; 
UPDATE AA83B.AA83B27T00 SET DESC_ES_027='Solicitud presentada, pero no resuelta',DESC_EU_027='Egina dago, baina oraindik ebatzi gabe dagoen eskabidea' WHERE ID_027='2'; 
UPDATE AA83B.AA83B27T00 SET DESC_ES_027='Escrito notificando trmite de alegaciones por incumplimiento de algun requisito vinculado con la renovacin',DESC_EU_027='Eskabidea aurkeztuta, baina jakinarazpena jaso du agiri gehiago eskatuz' WHERE ID_027='3'; 
UPDATE AA83B.AA83B27T00 SET DESC_ES_027='Copia de la Resolucin Denegatoria de la renovacin de la autorizacin temporal de residencia',DESC_EU_027='Aldi baterako egoitzarako baimen-eskaerari emandako ezezko Ebazpena' WHERE ID_027='4'; 


UPDATE AA83B.AA83B38T00 SET DESC_ES_038='Consulta',DESC_EU_038='Kontsulta' WHERE ID_038='C';
UPDATE AA83B.AA83B38T00 SET DESC_ES_038='Alta',DESC_EU_038='Alta' WHERE ID_038='A';
UPDATE AA83B.AA83B38T00 SET DESC_ES_038='Modificacin',DESC_EU_038='Aldaketa' WHERE ID_038='M';
                        
UPDATE AA83B.AA83B39T00 SET DESC_ES_039='Presencial - Envo postal' ,DESC_EU_039='Aurrez aurrekoa - Ohiko posta'   WHERE ID_TIPO_NOTIF_039='P';
UPDATE AA83B.AA83B39T00 SET DESC_ES_039='Telemtica - Mis Gestiones',DESC_EU_039='Elektronikoa - Nire kudeaketak'  WHERE ID_TIPO_NOTIF_039='T';


UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Solicitud de Adecuacion de Vivienda',
  DESC_EU_030      ='Etxebizitzaren Egokitasun Eskaera',
  ID_040_BLOQUE    ='0'
WHERE ID_030       ='1'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Tarjeta de Residencia',
  DESC_EU_030      ='Egoitza-txartela',
  ID_040_BLOQUE    ='12'
WHERE ID_030       ='2'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Certificado Empadronamiento Colectivo',
  DESC_EU_030      ='Errolda-egiaztagiri kolektiboa:',
  ID_040_BLOQUE    ='8'
WHERE ID_030       ='3'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Escritura Propiedad',
  DESC_EU_030      ='Etxebizitzaren eskriturak',
  ID_040_BLOQUE    ='10'
WHERE ID_030       ='4'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Acreditacion Parentesco',
  DESC_EU_030      ='Familiarteko egiaztapena',
  ID_040_BLOQUE    ='2'
WHERE ID_030       ='5'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato arrendamiento',
  DESC_EU_030      ='Alokairuko kontratua',
  ID_040_BLOQUE    ='10'
WHERE ID_030       ='6'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Acta notarial',
  DESC_EU_030      ='Notario-akta',
  ID_040_BLOQUE    ='0'
WHERE ID_030       ='7'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Acreditacion relacion profesional',
  DESC_EU_030      ='Erlazio profesionaleko egiaztapena',
  ID_040_BLOQUE    ='11'
WHERE ID_030       ='8'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Acreditacion relacion con menor irregular',
  DESC_EU_030      ='Adingabe irregularrekiko erlazio egiaztapena',
  ID_040_BLOQUE    ='2'
WHERE ID_030       ='9'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Otros',
  DESC_EU_030      ='Besteak',
  ID_040_BLOQUE    ='0'
WHERE ID_030       ='10'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Solicitud de Esfuerzo de Integracion',
  DESC_EU_030      ='Gizarteratzeko Ahaleginaren Eskaera',
  ID_040_BLOQUE    ='0'
WHERE ID_030       ='11'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Tarjeta de identidad de extranjero (TIE)',
  DESC_EU_030      ='Atzerritarren Identitate Txartela (AIZ)',
  ID_040_BLOQUE    ='12'
WHERE ID_030       ='12'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Formacion Sociolaboral. Certificacion de haber cursado o estar cursando formacion para el empleo',
  DESC_EU_030      ='Soziolaborala prestakuntza. Egiaztagiriak, lanerako prestakuntza hartu izan duela edo hartzen ari delakoak.',
  ID_040_BLOQUE    ='4'
WHERE ID_030       ='13'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Lenguas Oficiales, euskera o Castellano. Acreditacion de haber participado en cursos de la EPA, Escuela Oficial de Idiomas, programas euskaldunizacion...',
  DESC_EU_030      ='Euskal Autonomia erkidegoko Hizkuntza ofizialak. Euskara edo Gaztelania',
  ID_040_BLOQUE    ='3'
WHERE ID_030       ='14'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Formacion. Certificacion acreditativa de haber finalizado o estar cursando alguna titulacion de caracter oficial del sistema educativo.',
  DESC_EU_030      ='Prestakuntza. Egiaztagiria, Hezkuntza-sistema ofizialekoa den titulazioa edo ikasketak burutzen ari delako egiaztagiria',
  ID_040_BLOQUE    ='3'
WHERE ID_030       ='15'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Otro tipo de acciones formativas.',
  DESC_EU_030      ='Bestelako prestakuntza ekintzak burutu izanaren egiaztagiriak',
  ID_040_BLOQUE    ='3'
WHERE ID_030       ='16'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Participacion',
  DESC_EU_030      ='Parte-hartzea',
  ID_040_BLOQUE    ='5'
WHERE ID_030       ='17'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Vida laboral o contrado del coyuge o pareja de hecho.',
  DESC_EU_030      ='Baliabide ekonomikoak. Ezkontidearen edo izatezko bikotearen lan-jarduera',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='18'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de Renta Basica (RGI)',
  DESC_EU_030      ='Baliabide ekonomikoak. Oinarrizko Errenta jasotzen duelako egiaztagiria',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='19'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de la Prestacion Complementaria de Vivienda.',
  DESC_EU_030      ='Baliabide ekonomikoak. Certificado de ser perceptor de la Prestacion Complementaria de Vivienda._EUS',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='20'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de Ayudas Especiales para la Insercion.',
  DESC_EU_030      ='Baliabide ekonomikoak. Gizarteratzeko laguntza bereziak jasotzen dituelako egiaztagiria',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='21'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Otro tipo de documentos que acrediten la percepcion de algun ingreso.',
  DESC_EU_030      ='Baliabide ekonomikoak. Diru-sarrerak dituela egiaztatu ahal duten bestelako dokumentuak',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='22'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Inclusion Social. Documentacion que acredite que es firmante de un convenio de insercion, plan de trabajo compartido',
  DESC_EU_030      ='Gizarteratzea. Gizarteratze hitzarmen baten sinatzailea dela edo elkarlanean aritzeko plan baten ari dela egiaztatzen duen dokumentazioa',
  ID_040_BLOQUE    ='9'
WHERE ID_030       ='23'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Inclusion Social. Informe de Servicios Sociales de base sobre los esfuerzos de inclusin de la persona solicitante',
  DESC_EU_030      ='Gizarteratzea. Oinarrizko Gizarte-zerbitzuen txostena, eskatzaileak integratzeko egindako ahaleginari buruzkoak',
  ID_040_BLOQUE    ='9'
WHERE ID_030       ='24'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Inclusion Social. Informe de entidades que trabajan en el ambito de la inclusin.',
  DESC_EU_030      ='Gizarteratzea. Inklusio arloan lan egiten duen entitate baten txostena',
  ID_040_BLOQUE    ='9'
WHERE ID_030       ='25'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Inclusion Social. Otro tipo de documentacion que acredite que el solicitante es beneficiario ha participado en acciones de inclusin social',
  DESC_EU_030      ='Gizarteratzea.Eskatzaileak gizarteratze jardueretan parte hartu duela egiaztatzen duen bestelako dokumentazioa',
  ID_040_BLOQUE    ='9'
WHERE ID_030       ='26'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Vinculos Familiares. Documentacion acreditativa de vinculos con familiares residentes en Euskadi o el resto del estado.',
  DESC_EU_030      ='Familiarrak. Espainiako Estatuan bizi diren familiartekoak dituela egiaztatzen duen dokumentazioa: NANa edo AITa;Familia liburua; Erregistro Zibileko egiaztagiriak',
  ID_040_BLOQUE    ='2'
WHERE ID_030       ='27'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Vinculos Familiares. Certificado empadornaminto colectivo.',
  DESC_EU_030      ='Familiarrak. Errolda-egiaztagiri kolektiboa',
  ID_040_BLOQUE    ='2'
WHERE ID_030       ='28'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Vinculos Familiares. Documentacion acreditativa de la regulacin de las medidas paternofiliales (sentencia judicial o convenio) y su cumplimiento.',
  DESC_EU_030      ='Familiarrak. Seme-alabekin bizi ez bada, neurri paternofilialen arautzea egiaztatzen duen dokumentazioa (epai judiziala edo beste izaera bateko hitzarmen arau-emailea), eta betetzen dela egiaztatzen duen dokumentazioa',
  ID_040_BLOQUE    ='2'
WHERE ID_030       ='29'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Residencia. Volantes o certificados historicos de empadronamiento.',
  DESC_EU_030      ='Espainiako estatuan bizi izandako denbora. Errolda-agiri historikoen egiaztagiriak',
  ID_040_BLOQUE    ='10'
WHERE ID_030       ='30'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Residencia. Otros.',
  DESC_EU_030      ='Espainiako estatuan bizi izandako denbora. Bestelako dokumentazioa',
  ID_040_BLOQUE    ='10'
WHERE ID_030       ='31'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Actividad Laboral. Informe de Seguridad Social sobre periodos de cotizacion.',
  DESC_EU_030      ='Lan jarduera. Gizarte Segurantzako txostena, kotizazio-aldiarena',
  ID_040_BLOQUE    ='6'
WHERE ID_030       ='32'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Actividad Laboral. Informe de Lanbide o INEM sobre periodos de inscripcion como demandante de empleo.',
  DESC_EU_030      ='Lan jarduera. INEMen edo LANBIDEren txostena, enplegu-eskatzaile bezala emandako denborari buruzkoa',
  ID_040_BLOQUE    ='6'
WHERE ID_030       ='33'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Actividad Laboral. Documentacion acreditativa de ser perceptor de prestacin por desempleo.',
  DESC_EU_030      ='Lan jarduera. Lan-kontratua edo Lan-eskaintza',
  ID_040_BLOQUE    ='6'
WHERE ID_030       ='34'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Actividad Laboral. Otros.',
  DESC_EU_030      ='Lan jarduera. Bestelako dokumentazioa',
  ID_040_BLOQUE    ='6'
WHERE ID_030       ='35'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Nacionalidad. Documentacion acreditativa de haber solicitado la nacionalidad espaola',
  DESC_EU_030      ='Nazionalitatea. Espainiako nazionalitatea eskatu izana egiaztatzen duen dokumentazioa',
  ID_040_BLOQUE    ='7'
WHERE ID_030       ='36'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Otros',
  DESC_EU_030      ='Besterik',
  ID_040_BLOQUE    ='0'
WHERE ID_030       ='37'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='2';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Solicitud de Informe de Arraigo',
  DESC_EU_030      ='Eskabidea errotze txostena',
  ID_040_BLOQUE    ='0'
WHERE ID_030       ='38'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Pgina del pasaporte donde aparecen los datos personales',
  DESC_EU_030      ='Pasaportea. Nahikoa da datu pertsonalak agertzen diren orrialdearen kopia aurkeztea',
  ID_040_BLOQUE    ='12'
WHERE ID_030       ='39'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Permanencia. Volante o certificado historico de empadronamiento de los ultimos 3 aos de permanencia',
  DESC_EU_030      ='Bizi izandako denbora. Azken hiru urteetako errolda-egiaztagiriak',
  ID_040_BLOQUE    ='8'
WHERE ID_030       ='40'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Permanencia. Volante o certificado correspondiente al empadronamiento actual',
  DESC_EU_030      ='Bizi izandako denbora. Oraingo etxebizitzari dagokion erroldatze-ziurtagiria, eskabidea aurkeztu baino hiru hilabete emana, gehienez',
  ID_040_BLOQUE    ='8'
WHERE ID_030       ='41'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Permanencia. Sello de entrada consignado en el pasaporte',
  DESC_EU_030      ='Bizi izandako denbora. Pasaporteko sarrera-zigilua',
  ID_040_BLOQUE    ='8'
WHERE ID_030       ='42'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Permanencia. Otros documentos que acrediten los 3 ultimos aos de permanencia continuada.',
  DESC_EU_030      ='Bizi izandako denbora. Azken hiru urteetan Estatuan eta jarraian bizi izan zarela egiaztatzen duten bestelako agirien kopiak, baldin eta erroldatu gabeko tarteak izan badituzu.',
  ID_040_BLOQUE    ='8'
WHERE ID_030       ='43'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato. Contrato de Trabajo.',
  DESC_EU_030      ='Kontratua. Lan-kontratua',
  ID_040_BLOQUE    ='11'
WHERE ID_030       ='44'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato. Certificado mdico.',
  DESC_EU_030      ='Kontratua. Ziurtagiri medikua',
  ID_040_BLOQUE    ='11'
WHERE ID_030       ='45'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato. Sentencia judicial.',
  DESC_EU_030      ='Kontratua. Epai judiziala',
  ID_040_BLOQUE    ='11'
WHERE ID_030       ='46'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Otros',
  DESC_EU_030      ='Besterik',
  ID_040_BLOQUE    ='0'
WHERE ID_030       ='47'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Contrato de trabajo del/la cnyuge o pareja de hecho, acompaado de su vida laboral actualizada',
  DESC_EU_030      ='Dituzun baliabide ekonomikoak. Ezkontidearen edo izatezko bikotekidearen lan-kontratua eta Lan Bizitzaren Txosten eguneratua',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='48'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de renta basica (RGI)',
  DESC_EU_030      ='Dituzun baliabide ekonomikoak. Oinarrizko Errenta jasotzearen egiaztagiria',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='49'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de ayudas especiales para la insercion',
  DESC_EU_030      ='Dituzun baliabide ekonomikoak. Gizarteratzeko laguntza bereziak jasotzearen egiaztagiria',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='50'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado o documentacio bancaria',
  DESC_EU_030      ='Dituzun baliabide ekonomikoak. Bankuko egiaztagiria edo agiriak',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='51'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Otro tipo de documentos que puedan acreditar la percepcin de algun tipo de ingreso',
  DESC_EU_030      ='Dituzun baliabide ekonomikoak. Diru-sarrerak badituzula egiaztatu ahal duten bestelako agiriak',
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='52'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Vinculos Familiares. Documentacion acreditativa de vinculos con familiares residentes en Euskadi o el resto del estado.',
  DESC_EU_030      ='Familiarrak. Espainiako Estatuan bizi diren familiartekoak dituela egiaztatzen duen dokumentazioa',
  ID_040_BLOQUE    ='2'
WHERE ID_030       ='53'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Vinculos Familiares. Certificado empadronaminto colectivo, en caso de convivir con dicho familiar',
  DESC_EU_030      ='Familiarrak. Erroldatze-ziurtagiri kolektiboa, familiarrarekin biziz gero',
  ID_040_BLOQUE    ='2'
WHERE ID_030       ='54'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Formacion Sociolaboral. Certificacion de haber cursado o estar cursando formacion para el empleo',
  DESC_EU_030      ='Soziolaborala. Egiaztagiria, lanerako prestakuntza hartu izan duzula edo hartzen ari zarela',
  ID_040_BLOQUE    ='4'
WHERE ID_030       ='55'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Formacion. Lenguas Oficiales, euskera o Castellano. Acreditacion de haber participado en cursos de la EPA, Escuela Oficial de Idiomas, programas euskaldunizacion...',
  DESC_EU_030      ='Prestakuntza. Euskal Autonomia erkidegoko hizkuntza ofizialak.',
  ID_040_BLOQUE    ='3'
WHERE ID_030       ='56'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Formacion. Certificacion acreditativa de haber finalizado o estar cursando alguna titulacion de caracter oficial del sistema educativo.',
  DESC_EU_030      ='Prestakuntza. Hezkuntza-sistema ofizialekoa den titulazioa edo ikasketak egiten ari zarelako
egiaztagiria',
  ID_040_BLOQUE    ='3'
WHERE ID_030       ='57'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Formacion. Otro tipo de acciones formativas',
  DESC_EU_030      ='Prestakuntza. Bestelako prestakuntza ekintzak',
  ID_040_BLOQUE    ='3'
WHERE ID_030       ='58'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Participacion. Documentacion que acredite la participacion del solicitante en programas socioculturales, asociaciones provadas sin animo de lucro u otro tipo de organizaciones de caracter social debidamente registradas. Afiliacion a sindicatos o partidos politicos.',
  DESC_EU_030      ='Parte-hartzea. Ekintza soziokulturaletan parte hartu duzulako, irabazi asmorik gabeko elkarte pribatuetakoa edo behar bezala erregistratuta dauden bestelako elkarteetako kide zarelakoa, sindikatu edo alderdi politiko bateko kide zarelakoa, atzerritarrak gizarteratzen laguntzeko gertakari sozialetan, kulturaletan edo bestelakoetan parte hartu duzulakoa.',
  ID_040_BLOQUE    ='5'
WHERE ID_030       ='59'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='1';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Sin catalogar' ,
  DESC_EU_030      ='Katalogatu gabe' ,
  ID_040_BLOQUE    = '21'
WHERE ID_030       = '60'
AND ID_001_FASE    ='0'
AND ID_002_TRAM    ='0'
AND ID_003_TIPO_SOL='0' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Libro de familia' ,
  DESC_EU_030      ='Familia liburua' ,
  ID_040_BLOQUE    ='11'
WHERE ID_030       = '61'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato de Cesion/ Arriendo' ,
  DESC_EU_030      ='Lagapen/Alokairu-kontratua' ,
  ID_040_BLOQUE    = '3'
WHERE ID_030       = '62'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Solicitud de Adecuacion de Vivienda' ,
  DESC_EU_030      ='Etxebizitzaren Egokitasun Eskaera' ,
  ID_040_BLOQUE    ='25'
WHERE ID_030       = '63'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3';
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Tarjeta de Residencia' ,
  DESC_EU_030      ='Egoitza-txartela' ,
  ID_040_BLOQUE    = '8'
WHERE ID_030       ='64'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Certificado Empadronamiento Colectivo' ,
  DESC_EU_030      ='Errolda-egiaztagiri kolektiboa:' ,
  ID_040_BLOQUE    = '19'
WHERE ID_030       ='65'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Escritura Propiedad' ,
  DESC_EU_030      ='Etxebizitzaren eskriturak' ,
  ID_040_BLOQUE    ='14'
WHERE ID_030       ='66'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Acreditacion Parentesco' ,
  DESC_EU_030      ='Familiarteko egiaztapena' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='67'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato arrendamiento' ,
  DESC_EU_030      ='Alokairuko kontratua' ,
  ID_040_BLOQUE    = '10'
WHERE ID_030       ='68'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Acta notarial' ,
  DESC_EU_030      ='Notario-akta' ,
  ID_040_BLOQUE    = '21'
WHERE ID_030       ='69'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Acreditacion relacion profesional' ,
  DESC_EU_030      ='Erlazio profesionaleko egiaztapena' ,
  ID_040_BLOQUE    = '24'
WHERE ID_030       ='70'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Acreditacion relacion con menor irregular' ,
  DESC_EU_030      ='Adingabe irregularrekiko erlazio egiaztapena' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='71'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Otros' ,
  DESC_EU_030      ='Besterik' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='72'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Solicitud de Esfuerzo de Integracion' ,
  DESC_EU_030      ='Gizarteratzeko Ahaleginaren Eskaera' ,
  ID_040_BLOQUE    ='25'
WHERE ID_030       ='73'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Tarjeta de identidad de extranjero (TIE)' ,
  DESC_EU_030      ='Atzerritarren Identitate Txartela (AIZ)' ,
  ID_040_BLOQUE    ='2'
WHERE ID_030       ='74'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Formacion Sociolaboral. Certificacion de haber cursado o estar cursando formacion para el empleo' ,
  DESC_EU_030      ='Soziolaborala prestakuntza. Egiaztagiriak, lanerako prestakuntza hartu izan duela edo hartzen ari delakoak.' ,
  ID_040_BLOQUE    ='26'
WHERE ID_030       ='75'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Lenguas Oficiales, euskera o Castellano. Acreditacion de haber participado en cursos de la EPA, Escuela Oficial de Idiomas, programas euskaldunizacion...' ,
  DESC_EU_030      ='Euskal Autonomia erkidegoko Hizkuntza ofizialak. Euskara edo Gaztelania' ,
  ID_040_BLOQUE    ='26'
WHERE ID_030       ='76'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Formacion. Certificacion acreditativa de haber finalizado o estar cursando alguna titulacion de caracter oficial del sistema educativo.' ,
  DESC_EU_030      ='Prestakuntza. Egiaztagiria, Hezkuntza-sistema ofizialekoa den titulazioa edo ikasketak burutzen ari delako egiaztagiria' ,
  ID_040_BLOQUE    = '26'
WHERE ID_030       ='77'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Otro tipo de acciones formativas.' ,
  DESC_EU_030      ='Bestelako prestakuntza ekintzak burutu izanaren egiaztagiriak' ,
  ID_040_BLOQUE    = '26'
WHERE ID_030       ='78'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Participacion' ,
  DESC_EU_030      ='Parte-hartzea' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='79'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Vida laboral o contrado del coyuge o pareja de hecho.' ,
  DESC_EU_030      ='Baliabide ekonomikoak. Ezkontidearen edo izatezko bikotearen lan-jarduera' ,
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='80'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de Renta Basica (RGI)' ,
  DESC_EU_030      ='Baliabide ekonomikoak. Oinarrizko Errenta jasotzen duelako egiaztagiria' ,
  ID_040_BLOQUE    = '29'
WHERE ID_030       ='81'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de la Prestacion Complementaria de Vivienda.' ,
  DESC_EU_030      ='Baliabide ekonomikoak. Certificado de ser perceptor de la Prestacion Complementaria de Vivienda._EUS' ,
  ID_040_BLOQUE    ='29'
WHERE ID_030       ='82'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de Ayudas Espciales para la Insercion.' ,
  DESC_EU_030      ='Baliabide ekonomikoak. Gizarteratzeko laguntza bereziak jasotzen dituelako egiaztagiria' ,
  ID_040_BLOQUE    ='29'
WHERE ID_030       ='83'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Otro tipo de documentos que acrediten la percepcion de algun ingreso.' ,
  DESC_EU_030      ='Baliabide ekonomikoak. Diru-sarrerak dituela egiaztatu ahal duten bestelako dokumentuak' ,
  ID_040_BLOQUE    = '21'
WHERE ID_030       ='84'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Inclusion Social. Documentacion que acredite que es firmante de un convenio de insercion, plan de trabajo compartido' ,
  DESC_EU_030      ='Gizarteratzea. Gizarteratze hitzarmen baten sinatzailea dela edo elkarlanean aritzeko plan baten ari dela egiaztatzen duen dokumentazioa' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='85'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Inclusion Social. Informe de Servicios Sociales de base sobre los esfuerzos de inclusin de la persona solicitante' ,
  DESC_EU_030      ='Gizarteratzea. Oinarrizko Gizarte-zerbitzuen txostena, eskatzaileak integratzeko egindako ahaleginari buruzkoak' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='86'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Inclusion Social. Informe de entidades que trabajan en el ambito de la inclusin.' ,
  DESC_EU_030      ='Gizarteratzea. Inklusio arloan lan egiten duen entitate baten txostena' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='87'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Inclusion Social. Otro tipo de documentacion que acredite que el solicitante es beneficiario ha participado en acciones de inclusin social' ,
  DESC_EU_030      ='Gizarteratzea.Eskatzaileak gizarteratze jardueretan parte hartu duela egiaztatzen duen bestelako dokumentazioa' ,
  ID_040_BLOQUE    = '21'
WHERE ID_030       ='88'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Vinculos Familiares. Documentacion acreditativa de vinculos con familiares residentes en Euskadi o el resto del estado.' ,
  DESC_EU_030      ='Familiarrak. Espainiako Estatuan bizi diren familiartekoak dituela egiaztatzen duen dokumentazioa: NANa edo AITa;Familia liburua; Erregistro Zibileko egiaztagiriak' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='89'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Vinculos Familiares. Certificado empadronamiento colectivo.' ,
  DESC_EU_030      ='Familiarrak. Errolda-egiaztagiri kolektiboa:' ,
  ID_040_BLOQUE    ='19'
WHERE ID_030       ='90'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Vinculos Familiares. Documentacion acreditativa de la regulacin de las medidas paternofiliales (sentencia judicial o convenio) y su cumplimiento.' ,
  DESC_EU_030      ='Familiarrak. Seme-alabekin bizi ez bada, neurri paternofilialen arautzea egiaztatzen duen dokumentazioa (epai judiziala edo beste izaera bateko hitzarmen arau-emailea), eta betetzen dela egiaztatzen duen dokumentazioa' ,
  ID_040_BLOQUE    ='5'
WHERE ID_030       ='91'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Residencia. Volantes o certificados historicos de empadronamiento.' ,
  DESC_EU_030      ='Espainiako estatuan bizi izandako denbora. Errolda-agiri historikoen egiaztagiriak' ,
  ID_040_BLOQUE    = '19'
WHERE ID_030       ='92'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Residencia. Otros.' ,
  DESC_EU_030      ='Espainiako estatuan bizi izandako denbora. Bestelako dokumentazioa' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='93'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Actividad Laboral. Informe de Seguridad Social sobre periodos de cotizacion.' ,
  DESC_EU_030      ='Lan jarduera. Gizarte Segurantzako txostena, kotizazio-aldiarena' ,
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='94'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Actividad Laboral. Informe de Lanbide o INEM sobre periodos de inscripcion como demandante de empleo.' ,
  DESC_EU_030      ='Lan jarduera. INEMen edo LANBIDEren txostena, enplegu-eskatzaile bezala emandako denborari buruzkoa' ,
  ID_040_BLOQUE    ='20'
WHERE ID_030       ='95'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Actividad Laboral. Documentacion acreditativa de ser perceptor de prestacin por desempleo.' ,
  DESC_EU_030      ='Lan jarduera. Lan-kontratua edo Lan-eskaintza' ,
  ID_040_BLOQUE    ='20'
WHERE ID_030       ='96'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Actividad Laboral. Otros.' ,
  DESC_EU_030      ='Lan jarduera. Bestelako dokumentazioa' ,
  ID_040_BLOQUE    = '20'
WHERE ID_030       ='97'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Nacionalidad. Documentacion acreditativa de haber solicitado la nacionalidad espaola' ,
  DESC_EU_030      ='Nazionalitatea. Espainiako nazionalitatea eskatu izana egiaztatzen duen dokumentazioa' ,
  ID_040_BLOQUE    ='21'
WHERE ID_030       ='98'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Otros' ,
  DESC_EU_030      ='Besterik' ,
  ID_040_BLOQUE    ='1'
WHERE ID_030       ='99'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='2' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Solicitud de Informe de Arraigo' ,
  DESC_EU_030      ='Eskabidea errotze txostena' ,
  ID_040_BLOQUE    ='25'
WHERE ID_030       ='100'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Pgina del pasaporte donde aparecen los datos personales',
  DESC_EU_030      ='Pasaportea. Nahikoa da datu pertsonalak agertzen diren orrialdearen kopia aurkeztea',
  ID_040_BLOQUE    ='18'
WHERE ID_030       ='101'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Permanencia. Volante o certificado historico de empadronamiento de los ultimos 3 aos de permanencia' ,
  DESC_EU_030      ='Bizi izandako denbora. Azken hiru urteetako errolda-egiaztagiriak' ,
  ID_040_BLOQUE    ='19'
WHERE ID_030       ='102'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Permanencia. Volante o certificado correspondiente al empadronamiento actual' ,
  DESC_EU_030      ='Bizi izandako denbora. Oraingo etxebizitzari dagokion erroldatze-ziurtagiria, eskabidea aurkeztu baino hiru hilabete emana, gehienez' ,
  ID_040_BLOQUE    ='19'
WHERE ID_030       ='103'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Permanencia. Sello de entrada consignado en el pasaporte' ,
  DESC_EU_030      ='Bizi izandako denbora. Pasaporteko sarrera-zigilua' ,
  ID_040_BLOQUE    ='18'
WHERE ID_030       ='104'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Permanencia. Otros documentos que acrediten los 3 ultimos aos de permanencia continuada.' ,
  DESC_EU_030      ='Bizi izandako denbora. Azken hiru urteetan Estatuan eta jarraian bizi izan zarela egiaztatzen duten bestelako agirien kopiak, baldin eta erroldatu gabeko tarteak izan badituzu.' ,
  ID_040_BLOQUE    = '19'
WHERE ID_030       ='105'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato. Contrato de Trabajo.' ,
  DESC_EU_030      ='Kontratua. Lan-kontratua' ,
  ID_040_BLOQUE    = '24'
WHERE ID_030       ='106'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato. Certificado mdico.' ,
  DESC_EU_030      ='Kontratua. Ziurtagiri medikua' ,
  ID_040_BLOQUE    = '27'
WHERE ID_030       ='107'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato. Sentencia judicial.' ,
  DESC_EU_030      ='Kontratua. Epai judiziala' ,
  ID_040_BLOQUE    = '5'
WHERE ID_030       ='108'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Otros' ,
  DESC_EU_030      ='Besterik' ,
  ID_040_BLOQUE    = '18'
WHERE ID_030       ='109'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Contrato de trabajo del/la cnyuge o pareja de hecho, acompaado de su vida laboral actualizada',
  DESC_EU_030      ='Dituzun baliabide ekonomikoak. Ezkontidearen edo izatezko bikotekidearen lan-kontratua eta Lan Bizitzaren Txosten eguneratua',
  ID_040_BLOQUE    = '1'
WHERE ID_030       ='110'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Medios Economicos. Certificado de ser perceptor de renta basica (RGI)' ,
  DESC_EU_030      ='Dituzun baliabide ekonomikoak. Oinarrizko Errenta jasotzearen egiaztagiria' ,
  ID_040_BLOQUE    = '29'
WHERE ID_030       ='111'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='1' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Libro de familia' ,
  DESC_EU_030      ='Familia liburua' ,
  ID_040_BLOQUE    = '11'
WHERE ID_030       ='112'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato de Cesion/ Arriendo' ,
  DESC_EU_030      ='Lagapen/Alokairu-kontratua' ,
  ID_040_BLOQUE    = '3'
WHERE ID_030       ='113'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato de Subarriendo' ,
  DESC_EU_030      ='Berralokairuko kontratua' ,
  ID_040_BLOQUE    ='3'
WHERE ID_030       ='118'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='1'
AND ID_003_TIPO_SOL='3' ;
UPDATE AA83B.AA83B30T00
SET DESC_ES_030    ='Contrato de Subarriendo' ,
  DESC_EU_030      ='Berralokairuko kontratua' ,
  ID_040_BLOQUE    = '3'
WHERE ID_030       ='119'
AND ID_001_FASE    ='1'
AND ID_002_TRAM    ='4'
AND ID_003_TIPO_SOL='3' ;



CREATE TABLE AA83B43T00 
(ID_SOL NUMBER (8,0) NOT NULL,
ID_ANYO  NUMBER (4,0) NOT NULL,
ID_TIPOSOL NUMBER(8,0) NOT NULL,
ID_REMESA NUMBER(15,0) NOT NULL,
ID_COLECCION  NUMBER(15,0) NOT NULL,
ID_ENVIO  NUMBER(15,0) NOT NULL,
CODIGO_REMESA VARCHAR2(20 BYTE) NOT NULL,
CODIGO_COLECCION VARCHAR2(20 BYTE) NOT NULL,
CODIGO_ENVIO VARCHAR2(20 BYTE) NOT NULL,
PRIMARY KEY(ID_SOL, ID_ANYO, ID_TIPOSOL, ID_ENVIO)
);
COMMENT ON COLUMN AA83B43T00.ID_SOL IS 'Identificador';
COMMENT ON COLUMN AA83B43T00.ID_ANYO IS 'Ao de la solicitud';
COMMENT ON COLUMN AA83B43T00.ID_TIPOSOL IS 'Tipo de solicitud';
COMMENT ON COLUMN AA83B43T00.ID_REMESA IS 'Identificador de la remesa';
COMMENT ON COLUMN AA83B43T00.ID_COLECCION IS 'Identificador de la coleccin';
COMMENT ON COLUMN AA83B43T00.ID_ENVIO IS 'Identificador del envio';
COMMENT ON COLUMN AA83B43T00.CODIGO_REMESA IS 'Cdigo de la remesa';
COMMENT ON COLUMN AA83B43T00.CODIGO_COLECCION IS 'Cdigo de la coleccin';
COMMENT ON COLUMN AA83B43T00.CODIGO_ENVIO IS 'Cdigo del envio';

ALTER TABLE AA83B43T00 ADD CODIGO_SITUACION VARCHAR2(2 BYTE) DEFAULT '00';
ALTER TABLE AA83B43T00 ADD DESCRIPCION_ES VARCHAR2(70 BYTE) DEFAULT 'Sin estado';
ALTER TABLE AA83B43T00 ADD DESCRIPCION_EU VARCHAR(70 BYTE) DEFAULT 'Sin estado_eu';
ALTER TABLE AA83B43T00 ADD FECHA_SITUACION VARCHAR2(10 BYTE);
ALTER TABLE AA83B43T00 ADD FECHA_ENVIO TIMESTAMP;

 
COMMENT ON COLUMN "AA83B"."AA83B43T00"."CODIGO_SITUACION" IS 'Cdigo de la situacin, 00 no se ha recibido aviso por parte de correos';
 
COMMENT ON COLUMN "AA83B"."AA83B43T00"."DESCRIPCION_ES" IS 'Descripcin en castellano de la situacin';
 
COMMENT ON COLUMN "AA83B"."AA83B43T00"."DESCRIPCION_EU" IS 'Descripcin en euskera de la situacin';
 
COMMENT ON COLUMN "AA83B"."AA83B43T00"."FECHA_SITUACION" IS 'Fecha de la situacin, formato:dd/MM/yyyy';

COMMENT ON COLUMN "AA83B"."AA83B43T00"."FECHA_ENVIO " IS 'Fecha en la que se ha realizado el envio';
 
 
ALTER TABLE AA83B43T00 ADD UIDPUESTOTRAMITADOR VARCHAR2(20 BYTE);

COMMENT ON COLUMN "AA83B"."AA83B43T00"."UIDPUESTOTRAMITADOR " IS 'Uid del puesto tramitador';


