package aa83b.exe.handler;

import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;

import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import aa83b.exe.Aa83BConstants;
import aa83b.exe.Aa83bUtilXML;



/**
 * Handler para tracear los mensajes soap que se envian y reciben en la
 * aplicacion
 * 
 * @author DS
 * 
 */
public class LogClientHandler implements SOAPHandler<SOAPMessageContext> {

	private static final Logger logger = LoggerFactory
			.getLogger(LogClientHandler.class);

	/**
	 * Constructor por defecto
	 */
	public LogClientHandler() {
	}

	/**
	 * @return Set
	 */
	public Set<QName> getHeaders() {
		return new HashSet<QName>();
	}

	/**
	 * @param context
	 *            MessageContext
	 */
	public void close(MessageContext context) {
	}

	/**
	 * @param context
	 *            SOAPMessageContext
	 * @return boolean
	 */
	public boolean handleFault(SOAPMessageContext context) {
		return true;
	}

	/**
	 * @param context
	 *            SOAPMessageContext
	 * @return boolean
	 */
	public boolean handleMessage(SOAPMessageContext context) {
		Boolean saliente = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
		saliente = (saliente != null && saliente.booleanValue());
		try {
			StringBuilder traza = new StringBuilder(
					Aa83BConstants.STRING_BUILDER_INIT);
			traza.append("Mensaje Soap ").append(
					saliente ? "saliente" : "entrante");
			traza.append(":\r\n");
			traza.append(Aa83bUtilXML.document2String(context.getMessage()
					.getSOAPBody().getOwnerDocument()));
			LogClientHandler.logger.debug(traza.toString());
		} catch (SOAPException e) {
			LogClientHandler.logger.error(
					"Error al obtener la traza de mensaje ", e);
		}
		return true;
	}
}
