package aa83b.exe.handler;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

/**
 * 
 * @author DS
 * 
 */
@SuppressWarnings(value = "rawtypes")
public class JaxWsPortProxyHandlerResolver implements HandlerResolver {

	private List<Handler> handlerChain;

	/**
	 * handlerChain setter.
	 * 
	 * @param handlerChain
	 *            Parametro a asignar.
	 */
	public void setHandlerChain(List<Handler> handlerChain) {
		this.handlerChain = handlerChain;
	}

	/**
	 * Constructor
	 */
	public JaxWsPortProxyHandlerResolver() {
		this.handlerChain = new ArrayList<Handler>();
	}

	/**
	 * Constructor inicializado con un handlerChain pasado como parametro.
	 * 
	 * @param handlerChain
	 *            Parámetro a asignar.
	 */
	public JaxWsPortProxyHandlerResolver(List<Handler> handlerChain) {
		this.handlerChain = handlerChain;
	}

	/**
	 * Devuelve la lista de handlers asociados.
	 * 
	 * @param portInfo
	 *            Permite al handler obtener la informacion necesaria del port.
	 * @return Lista de handlers asociados.
	 */
	public List<Handler> getHandlerChain(PortInfo portInfo) {
		return this.handlerChain;
	}

}
