package aa83b.exe.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import aa83b.exe.Aa83bClsTrazas;
import aa83b.exe.model.Aa83bSituacionEntregaRemesa;


import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class Aa83bNotificacionCorreosDaoImpl extends NamedParameterJdbcDaoSupport implements Aa83bNotificacionCorreosDao{
	
	@Resource
	private RowMapper<Aa83bSituacionEntregaRemesa> rwMap = new RowMapper<Aa83bSituacionEntregaRemesa>() {
		public Aa83bSituacionEntregaRemesa mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {
			return new Aa83bSituacionEntregaRemesa(
					resultSet.getInt("ID_REMESA"),
					resultSet.getString("UIDPUESTOTRAMITADOR"));
		}
	};
	@Resource
	private RowMapper<Aa83bSituacionEntregaRemesa> rwMap2 = new RowMapper<Aa83bSituacionEntregaRemesa>() {
		public Aa83bSituacionEntregaRemesa mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {
			return new Aa83bSituacionEntregaRemesa(
					resultSet.getInt("ID_ENVIO"));
		}
	};
	public List<Aa83bSituacionEntregaRemesa> buscarRemesas(){
		Aa83bClsTrazas.debug("buscarRemesas");
		String query="SELECT ID_REMESA, UIDPUESTOTRAMITADOR FROM AA83B43T00 group by ID_REMESA, UIDPUESTOTRAMITADOR ";
		return  this.getJdbcTemplate().query(query.toString(), rwMap);
	}
	public Boolean buscarEnvio(int idEnvio){
		Aa83bClsTrazas.debug("buscarEnvio");
		String query="SELECT ID_ENVIO FROM AA83B43T00 WHERE ID_ENVIO=? ";
		List<Object> params = new ArrayList<Object>();
		params.add(idEnvio);
		List<Aa83bSituacionEntregaRemesa> ex = this.getJdbcTemplate().query(query.toString(),rwMap2, params.toArray());
		if(ex.size()!=0){
			Aa83bClsTrazas.debug("Envio encontrado:::" + idEnvio);
			Aa83bClsTrazas.debug("Ex:::" + ex);
			return true;
		}else{
			Aa83bClsTrazas.debug("Envio NO encontrado:::" + idEnvio);
			return false;
		}
	}
	
	public Aa83bSituacionEntregaRemesa update(Aa83bSituacionEntregaRemesa remesa){
	
	String query="UPDATE AA83B43T00 SET CODIGO_SITUACION=?, DESCRIPCION_ES=?, DESCRIPCION_EU=?, FECHA_SITUACION=? WHERE ID_ENVIO=?";
	
	this.getJdbcTemplate().update(query, remesa.getCodigoSituacion(), remesa.getDescripcionES(), remesa.getDescripcionEU(), remesa.getFechaSituacion(), remesa.getIdEnvio());
	return remesa;
	}
	
	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
	
}
