package aa83b.exe.batch;

import java.util.*;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;


import aa83b.exe.Aa83BConstants;
import aa83b.exe.Aa83bClsTrazas;
import aa83b.exe.Aa83bUtilSeguridad;
import aa83b.exe.model.Aa83bSituacionEntregaRemesa;
import aa83b.exe.service.Aa83bNotificacionCorreosService;
import aa83b.exe.aa66WS.AA66Notificaciones;
import aa83b.exe.aa66WS.IdentTramitadorCondicionalAplicacionWs;


public class Aa83bSituacionRemesa {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		Aa83bClsTrazas.debug(" *********************************** Inicio  MAIN de Aa83bSituacionRemesa ***********************************");
		Aa83bClsTrazas.debug("Prueba main");
		String sesionToken = Aa83bUtilSeguridad.getTokenStringXLNets(Aa83BConstants.COD_APLICACION);

		ApplicationContext context = null;
		try{
			Aa83bClsTrazas.debug(" Antes del context");
			context = new ClassPathXmlApplicationContext("aa83b-spring-context.xml");
		}
		catch(Exception e){
			Aa83bClsTrazas.debug("error al recuperar aa83b-spring-context.xml  "+e);
		}
		Aa83bClsTrazas.debug(" coger bean  Aa83bNotificacionCorreosService");
		Aa83bNotificacionCorreosService notificacionCorreos=(Aa83bNotificacionCorreosService)context.getBean("Aa83bNotificacionCorreosService");
		AA66Notificaciones service =(AA66Notificaciones)context.getBean("AA66NotificacionesWebServiceImplService");
		try {
			Aa83bClsTrazas.debug("Vamos a entrar en metodo obtenerSituacion");
			obtenerSituacion(notificacionCorreos, service);
			
		} catch (Exception t) {
			Aa83bClsTrazas.debug(" FIN main Aa83bSituacionRemesa  ERROR grave." + t.getMessage());
		}
		 
	}

	public static void obtenerSituacion(Aa83bNotificacionCorreosService notificacionCorreos, AA66Notificaciones service){
		
       //Buscar todas las remesas
		Aa83bClsTrazas.debug("antes de entrar en buscarRemesas");
		 List<Aa83bSituacionEntregaRemesa> idRemesas=notificacionCorreos.buscarRemesas();
		 Aa83bClsTrazas.debug("idRemesas " +idRemesas);
       for(int i=0; i< idRemesas.size(); i++){
    	   IdentTramitadorCondicionalAplicacionWs remesaSituaciones =new IdentTramitadorCondicionalAplicacionWs();
    	   remesaSituaciones.setId(idRemesas.get(i).getIdRemesa());
    	   remesaSituaciones.setUidPuestoTramitador(idRemesas.get(i).getUidPuestoTramitador());
    	   remesaSituaciones.setAplicacion(Aa83BConstants.COD_APLICACION);
    	   remesaSituaciones.setTodas(true);
    	   
    	   Aa83bClsTrazas.debug("Solicitar la situacion de los envios de la remesa: " + idRemesas.get(i).getIdRemesa());
    	   //Solicitar la situacion de los envios de las remesas
    	   service.situacionEntregaRemesa(remesaSituaciones);
    	   Aa83bClsTrazas.debug("Situacion solicitada ");
       }
       
    
       
       
	}

}
