package aa83b.exe.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import aa83b.exe.Aa83bClsTrazas;
import aa83b.exe.aa66WS.AA66Notificaciones;
import aa83b.exe.model.Aa83bSituacionEntregaRemesa;
import aa83b.exe.service.Aa83bNotificacionCorreosService;

public class Aa83bCambiarSituacionRemesa {
  
	/**
	 * @param args
	 * @throws IOException 
	 * @throws ParserConfigurationException 
	 * @throws SAXException 
	 */
	public static void main(String[] args) throws IOException,
			ParserConfigurationException, SAXException {
		Aa83bClsTrazas
				.debug(" *********************************** Inicio  MAIN de Aa83bCambiarSituacionRemesa ***********************************");

		ApplicationContext context = null;
		try {
			Aa83bClsTrazas.debug(" Antes del context");
			context = new ClassPathXmlApplicationContext(
					"aa83b-spring-context.xml");
		} catch (Exception e) {
			Aa83bClsTrazas
					.debug("error al recuperar aa83b-spring-context.xml  " + e);
		}
		Aa83bClsTrazas.debug(" coger bean  Aa83bNotificacionCorreosService");
		Aa83bNotificacionCorreosService notificacionCorreos = (Aa83bNotificacionCorreosService) context
				.getBean("Aa83bNotificacionCorreosService");

		Aa83bClsTrazas.debug(" Leer ficheros que se han descargado desde PIF");
		// Leer ficheros que se han descargado desde PIF
		 String path = "/datos/aa83b/file/aa66";
		 File folder = new File(path);
	     File[] listOfFiles = folder.listFiles();


		for (int i = 0; i < listOfFiles.length; i++) {

			if (listOfFiles[i].isFile()) {
				Aa83bClsTrazas.debug(" leyendo fichero::::::" + listOfFiles[i].getName());
				BufferedReader br = new BufferedReader(new FileReader(
						listOfFiles[i]));
				// Lectura del fichero xml
				String entrada;
				String cadena = "";
				while ((entrada = br.readLine()) != null) {
					cadena = cadena + entrada;

				}
				DocumentBuilderFactory dbf = DocumentBuilderFactory
						.newInstance();
				DocumentBuilder db = dbf.newDocumentBuilder();

				InputSource archivo = new InputSource();
				archivo.setCharacterStream(new StringReader(cadena));

				Document documento = db.parse(archivo);
				documento.getDocumentElement().normalize();

				NodeList nodeLista = documento
						.getElementsByTagName("situacionEnvio");
				Aa83bClsTrazas.debug("nodeList situacionEnvio::" + nodeLista);

				for (int s = 0; s < nodeLista.getLength(); s++) {
					Aa83bSituacionEntregaRemesa aa83bSituacionEntregaRemesa = new Aa83bSituacionEntregaRemesa();
					Node primerNodo = nodeLista.item(s);
					int idEnvio = 0;
					if (primerNodo.getNodeType() == Node.ELEMENT_NODE) {

						// Recogemos el idEnvio
						Element primerElemento = (Element) primerNodo;
						NodeList primerNombreElementoLista = primerElemento
								.getElementsByTagName("idEnvio");
						Element primerNombreElemento = (Element) primerNombreElementoLista
								.item(0);
						NodeList primerNombre = primerNombreElemento
								.getChildNodes();
						aa83bSituacionEntregaRemesa.setIdEnvio(Integer
								.parseInt(((Node) primerNombre.item(0))
										.getNodeValue().toString()));
						idEnvio = Integer
								.parseInt(((Node) primerNombre.item(0))
										.getNodeValue().toString());
						Aa83bClsTrazas.debug("idEnvio::::" + idEnvio);
						// Buscamos el idEnvio en la BBDD, si est continuamos,
						// sino
						// pasamos a la siguiente situacion de envio
						if (notificacionCorreos.buscarEnvio(idEnvio) == true) {
							// Cogemos el codigo de Situacion del envio
							NodeList segundoNombreElementoLista = primerElemento
									.getElementsByTagName("codigoSituacion");

							Element segundoNombreElemento = (Element) segundoNombreElementoLista
									.item(0);
							NodeList segundoNombre = segundoNombreElemento
									.getChildNodes();
							aa83bSituacionEntregaRemesa
									.setCodigoSituacion(((Node) segundoNombre
											.item(0)).getNodeValue().toString());
							// Cogemos la descripcion en castellano
							NodeList tercerNombreElementoLista = primerElemento
									.getElementsByTagName("descripcionCastellano");

							Element tercerNombreElemento = (Element) tercerNombreElementoLista
									.item(0);
							NodeList tercerNombre = tercerNombreElemento
									.getChildNodes();
							aa83bSituacionEntregaRemesa
									.setDescripcionES(((Node) tercerNombre
											.item(0)).getNodeValue().toString());
							// Cogemos la descripcion en euskera
							NodeList cuartoNombreElementoLista = primerElemento
									.getElementsByTagName("descripcionEuskera");

							Element cuartoNombreElemento = (Element) cuartoNombreElementoLista
									.item(0);
							NodeList cuartoNombre = cuartoNombreElemento
									.getChildNodes();
							aa83bSituacionEntregaRemesa
									.setDescripcionEU(((Node) cuartoNombre
											.item(0)).getNodeValue().toString());
							// Cogemos la fechaSituacion
							NodeList quintoElementoLista = primerElemento
									.getElementsByTagName("fechaSituacion");

							Element quintoNombreElemento = (Element) quintoElementoLista
									.item(0);
							NodeList quintoNombre = quintoNombreElemento
									.getChildNodes();
							aa83bSituacionEntregaRemesa
									.setFechaSituacion(((Node) quintoNombre
											.item(0)).getNodeValue().toString());
							// Modificamos la tabla 43 de la BBDD
							notificacionCorreos
									.update(aa83bSituacionEntregaRemesa);
						}

					}
				}
			}
		}

	}

}
