package aa83b.exe;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * Utilidades para el manejo de XMLs
 * 
 * @author DS
 * 
 */
public class Aa83bUtilXML {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bUtilXML.class);

	/**
	 * 'UtilXML'
	 */
	private Aa83bUtilXML() {
	}

	/**
	 * Obtiene el XML en formato String
	 * 
	 * @param node
	 *            Document
	 * @return String
	 */
	public static String document2String(Document node) {
		Aa83bUtilXML.logger.trace("document2String INI");
		try {
			Source source = new DOMSource(node);
			StringWriter stringWriter = new StringWriter();
			Result result = new StreamResult(stringWriter);
			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer transformer = factory.newTransformer();
			transformer.transform(source, result);
			String resultado = stringWriter.getBuffer().toString();
			Aa83bUtilXML.logger.trace("document2String FIN");
			return resultado;
		} catch (TransformerConfigurationException e) {
			Aa83bUtilXML.logger.error("document2String", e);
		} catch (TransformerException e) {
			Aa83bUtilXML.logger.error("document2String", e);
		}
		return null;
	}

	/**
	 * Obtiene un objeto Document(XMl) a partir de un InputStream
	 * 
	 * @param input
	 *            InputStream
	 * @return Document el document
	 */
	public static Document inputStream2Document(InputStream input) {
		Aa83bUtilXML.logger.trace("inputStream2Document INI");
		Document tmpX = null;
		DocumentBuilder builder = null;
		try {
			builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			tmpX = builder.parse(input);
			tmpX.getDocumentElement().normalize();
		} catch (ParserConfigurationException e) {
			Aa83bUtilXML.logger.error("inputStream2Document", e);
		} catch (SAXException e) {
			Aa83bUtilXML.logger.error("inputStream2Document", e);
		} catch (IOException e) {
			Aa83bUtilXML.logger.error("inputStream2Document", e);
		}

		Aa83bUtilXML.logger.trace("inputStream2Document FIN");
		return tmpX;

	}

	/**
	 * Obtiene un objeto Document(XMl) a partir de una cadena.
	 * 
	 * @param s
	 *            la cadena
	 * @return Document el document
	 */
	public static Document string2Document(String s) {
		Aa83bUtilXML.logger.trace("string2Document INI");
		Document tmpX = null;
		DocumentBuilder builder = null;
		try {

			builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

			// LOCAL
			tmpX = builder.parse(new ByteArrayInputStream(s.getBytes()));

			// tmpX = builder.parse(s);
			tmpX.getDocumentElement().normalize();

		} catch (ParserConfigurationException e) {

			Aa83bUtilXML.logger.error("string2Document", e);
		} catch (SAXException e) {

			Aa83bUtilXML.logger.error("string2Document", e);
		} catch (IOException e) {

			Aa83bUtilXML.logger.error("string2Document", e);
		}
		Aa83bUtilXML.logger.trace("string2Document FIN");
		return tmpX;
	}

	/**
	 * Valida un XML contra un esquema
	 * 
	 * @param inXSD
	 *            InputStream
	 * @param dXML
	 *            Document
	 * @return boolean
	 */
	public static boolean validateXMLSchema(InputStream inXSD, Document dXML) {
		Aa83bUtilXML.logger.trace("validateXMLSchema INI");
		boolean resultado = false;
		try {
			SchemaFactory factory = SchemaFactory
					.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			Schema schema = factory.newSchema(new StreamSource(inXSD));
			Validator validator = schema.newValidator();
			validator.validate(new DOMSource(dXML));
			resultado = true;
		} catch (IOException e) {
			Aa83bUtilXML.logger.warn("validateXMLSchema", e);
		} catch (SAXException e) {
			Aa83bUtilXML.logger.warn("validateXMLSchema", e);
		}
		Aa83bUtilXML.logger.trace("validateXMLSchema resultado: {}", resultado);
		return resultado;
	}

}
