package aa83b.exe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Properties;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import sun.misc.BASE64Encoder;

import com.ejie.x38.security.UserCredentials;
import com.sun.org.apache.xpath.internal.XPathAPI;

import n38a.exe.N38APISesion;
import n38c.exe.N38API;

public class Aa83bSesionUtils {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa83bSesionUtils.class);

	/** The app configuration. */
	@Autowired()
	private static Properties appConfiguration;

	private Aa83bSesionUtils() {
	}

	public static Vector<String> getSecurityProfiles() { // NOPMD
		UserCredentials userCredentials = null;
		userCredentials = (UserCredentials) SecurityContextHolder.getContext()
				.getAuthentication().getCredentials();

		return userCredentials.getUserProfiles();
	}

	public static String[] getProfiles(HttpServletRequest request) {

		N38API n38API = new N38API(request);
		// Numero de usuarios
		String[] strUsuario = new String[100];
		int contaTotal = 0;
		try {
			NodeList nodeLi;

			String filtro = "//parent::elemento/parametro[@id=\"n38perfiles\"]/valor/text()";
			nodeLi = XPathAPI.selectNodeList(n38API.n38ItemSesion(), filtro);
			for (int i = 0; i < nodeLi.getLength(); ++i) {
				if (!nodeLi.item(i).getNodeValue().equals("")) {
					strUsuario[i] = nodeLi.item(i).getNodeValue();
					contaTotal++;
					// System.out
					// .println("****************************************fncItemSesion strUsuario[i]="
					// + strUsuario[i]);
					// Aa83bSesionUtils.logger
					// .info("****************************************fncItemSesion strUsuario[i]="
					// + strUsuario[i]);
				}
			}
		} catch (Exception e) {
			Aa83bSesionUtils.logger.error("Aa83BPlateaUtils->getProfiles: "
					+ e.getMessage());
		}
		String[] retorno = new String[contaTotal];
		for (int i = 0; i < contaTotal; i++)
			retorno[i] = strUsuario[i];
		return retorno;

	}

	public static String getUserName() {
		if (Aa83bUtilSeguridad.enOficina())
			return "OFICINA_USER";
		else
			return ((UserCredentials) SecurityContextHolder.getContext()
					.getAuthentication().getCredentials()).getUserName();
	}

	public static String getUidSession() {
		return ((UserCredentials) SecurityContextHolder.getContext()
				.getAuthentication().getCredentials()).getUidSession();
	}

	public static String getUserFullName() {
		return ((UserCredentials) SecurityContextHolder.getContext()
				.getAuthentication().getCredentials()).getFullName();
	}

	public static String getUserNif() {
		return ((UserCredentials) SecurityContextHolder.getContext()
				.getAuthentication().getCredentials()).getNif();
	}

	/**
	 * Gets the session document.
	 * 
	 * @param request
	 *            the request
	 * @return the session document
	 */
	public static Document getSessionDocument(HttpServletRequest request) {
		N38API n38api = new N38API(request);
		return n38api.n38ItemSesion();
	}

	public static String getTokenXLNets(String idAplic) {
		String token = null;

		try {
			System.out.println("Cojo el TOKEN");
			N38APISesion miAPISesion = new N38APISesion();
			Document miSesion;
			miSesion = miAPISesion.n38APISesionCrearApp(idAplic);
			token = DOM2String(miSesion);

		} catch (Exception e) {
			token = leerFichero("c:/config/p16b/Tokenwaa83b.xml", false);
			Aa83bSesionUtils.logger
					.error("Aa83BPlateaUtils->getTokenXLNets: Excepcion creando el token de aplicacion:"
							+ e.getMessage());
		}
		return token;
	}

	/**
	 * Lee un fichero y devuelve el contenido
	 * 
	 * @param elFichero
	 *            el nombre del fichero
	 * @param codificar
	 *            indica si ha de codificarse el contenido
	 * @return el contenido
	 */
	public static String leerFichero(String elFichero, boolean codificar) {
		String cadenaSesion = "";
		try {
			File laSesion = new File(elFichero);

			InputStream is = new FileInputStream(laSesion);

			long length = laSesion.length();

			// Create the byte array to hold the data
			byte[] bytes = new byte[(int) length];

			// Read in the bytes
			int offset = 0;
			int numRead = 0;
			while (offset < bytes.length
					&& (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
				offset += numRead;
			}

			// Ensure all the bytes have been read in
			if (offset < bytes.length) {
				throw new IOException("No se ha podido leer " + elFichero);
			}

			// Close the input stream and return bytes
			is.close();

			BASE64Encoder encoder = new BASE64Encoder();

			if (codificar) {
				cadenaSesion = encoder.encode(bytes);
			} else {
				cadenaSesion = new String(bytes);
			}

		} catch (Exception e) {

			Aa83bSesionUtils.logger
					.error("P16BPlateaUtils.leerFichero->EXCEPTION"
							+ e.getMessage());
		}

		return cadenaSesion;
	}

	public static String DOM2String(Document doc) {
		TransformerFactory transformerFactory = TransformerFactory
				.newInstance();
		Transformer transformer = null;
		try {
			transformer = transformerFactory.newTransformer();
		} catch (javax.xml.transform.TransformerConfigurationException error) {
			// int coderror=123;
			// String msgerror=error.getMessage();
			return null;
		}

		Source source = new DOMSource(doc);

		StringWriter writer = new StringWriter();
		Result result = new StreamResult(writer);
		try {
			transformer.transform(source, result);
		} catch (javax.xml.transform.TransformerException error) {
			// int coderror=123;
			// String msgerror=error.getMessage();
			Aa83bSesionUtils.logger
					.error("P16BPlateaUtils.DOM2String->EXCEPTION"
							+ error.getMessage());
		}

		String s = writer.toString();
		return s;// NOPMD
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
