/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.validation;

import com.ejie.x38.json.JSONObject;
import com.ejie.x38.util.DateTimeManager;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.StaticsContainer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ValidationManager {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ValidationManager.class);
    @Resource
    private ReloadableResourceBundleMessageSource messageSource;
    @Autowired(required=false)
    private Validator validator;

    @PostConstruct
    public void init() {
        if (this.validator == null) {
            ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).buildValidatorFactory();
            this.validator = validatorFactory.getValidator();
        }
    }

    public void validate(Errors errors, Object obj, Class<?> ... groups) {
        if (groups == null || groups.length == 0 || groups[0] == null) {
            groups = new Class[]{Default.class};
        }
        Set violations = this.validator.validate(obj, (Class[])groups);
        for (ConstraintViolation v : violations) {
            Path path = v.getPropertyPath();
            String propertyName = "";
            if (path != null) {
                for (Path.Node n : path) {
                    propertyName = String.valueOf(propertyName) + n.getName() + ".";
                }
                propertyName = propertyName.substring(0, propertyName.length() - 1);
            }
            String constraintName = v.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
            if (propertyName == null || "".equals(propertyName)) {
                errors.reject(constraintName, v.getMessage());
                continue;
            }
            errors.rejectValue(propertyName, constraintName, v.getMessage());
        }
    }

    public String validateProperty(String bean, String property, String value, Locale locale) {
        try {
            String capitalicedBean = StringUtils.capitalize((String)bean);
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(Class.forName(String.valueOf(StaticsContainer.modelPackageName) + capitalicedBean));
            beanWrapper.setAutoGrowNestedPaths(true);
            beanWrapper.setPropertyValue(property, (Object)value);
            Set constraintViolations = this.validator.validateProperty(beanWrapper.getWrappedInstance(), property, new Class[]{Default.class});
            return this.summary(constraintViolations, bean, locale);
        }
        catch (Exception e) {
            logger.error(StackTraceManager.getStackTrace(e));
            return "error!";
        }
    }

    public Map<String, List<String>> getErrorsAsMap(Errors errors) {
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, List<String>> errorsMap = new HashMap<String, List<String>>();
        List fieldErrors = errors.getAllErrors();
        for (ObjectError objectError : fieldErrors) {
            String errorMessage;
            String key;
            if (objectError instanceof FieldError) {
                FieldError fieldError = (FieldError)objectError;
                key = fieldError.getField();
                try {
                    errorMessage = this.messageSource.getMessage(fieldError.getDefaultMessage(), null, locale);
                }
                catch (NoSuchMessageException e) {
                    errorMessage = fieldError.getCode();
                }
            } else {
                key = objectError.getCode();
                try {
                    errorMessage = this.messageSource.getMessage(objectError.getDefaultMessage(), null, locale);
                }
                catch (NoSuchMessageException e) {
                    errorMessage = objectError.getDefaultMessage();
                }
            }
            if (errorsMap.containsKey(key)) {
                ((List)errorsMap.get(key)).add(errorMessage);
                continue;
            }
            ArrayList<String> listaErrores = new ArrayList<String>();
            listaErrores.add(errorMessage);
            errorsMap.put(key, listaErrores);
        }
        return errorsMap;
    }

    public List<String> getErrorsAsList(Errors errors) {
        Locale locale = LocaleContextHolder.getLocale();
        ArrayList<String> list = new ArrayList<String>();
        List fieldErrors = errors.getFieldErrors();
        for (FieldError fieldError : fieldErrors) {
            String errorMessage;
            try {
                errorMessage = this.messageSource.getMessage(fieldError.getCode(), null, locale);
            }
            catch (NoSuchMessageException e) {
                errorMessage = fieldError.getCode();
            }
            list.add(errorMessage);
        }
        return list;
    }

    public Map<String, Object> getRupFeedbackMsg(String msg, String style) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("label", msg);
        if (style != null && !"".equals(style)) {
            map.put("style", style);
        }
        return map;
    }

    public JSONObject getMessageJSON(Object fieldErrors) {
        return this.getMessageJSON(fieldErrors, null, null);
    }

    public JSONObject getMessageJSON(Object fieldErrors, Object feedbackMessage) {
        return this.getMessageJSON(fieldErrors, feedbackMessage, null);
    }

    public JSONObject getMessageJSON(Object fieldErrors, Object feedbackMessage, String style) {
        JSONObject message = new JSONObject();
        if (feedbackMessage != null) {
            JSONObject feedbackObj = new JSONObject();
            feedbackObj.put("message", feedbackMessage);
            if (style != null && !"".equals(style)) {
                feedbackObj.put("style", style);
            }
            message.put("rupFeedback", feedbackObj);
        }
        if (fieldErrors != null) {
            message.put("rupErrorFields", fieldErrors);
        }
        return message;
    }

    @Deprecated
    public String validateObject(String bean, String data, Locale locale) {
        try {
            Class<?> clazz = Class.forName(String.valueOf(StaticsContainer.modelPackageName) + bean);
            ObjectMapper mapper = new ObjectMapper();
            Object instance = mapper.readValue(data, clazz);
            Set constraintViolations = this.validator.validate(instance, new Class[0]);
            return this.summary(constraintViolations, bean, locale);
        }
        catch (Exception e) {
            logger.error(StackTraceManager.getStackTrace(e));
            return "error!";
        }
    }

    @Deprecated
    public <T> Boolean writeValidationErrors(T object, HttpServletResponse response) {
        Set constraintViolations = this.validator.validate(object, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            String summary = this.summary(constraintViolations, object.getClass().getSimpleName(), LocaleContextHolder.getLocale());
            response.setStatus(406);
            response.setContentType("text/javascript;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Expires", DateTimeManager.getHttpExpiredDate());
            try {
                response.getWriter().write(summary);
                return true;
            }
            catch (IOException e) {
                logger.error(StackTraceManager.getStackTrace(e));
                return true;
            }
        }
        return false;
    }

    private <T> String summary(Set<ConstraintViolation<T>> constraintViolations, String bean, Locale locale) {
        Iterator<ConstraintViolation<T>> ite = constraintViolations.iterator();
        HashMap errors = new HashMap();
        String propertyKey = "";
        while (ite.hasNext()) {
            String interpolatedMessage;
            ConstraintViolation<T> constraintViolation = ite.next();
            propertyKey = "" + constraintViolation.getPropertyPath();
            List propertyErrors = errors.containsKey(propertyKey) ? (List)errors.get(propertyKey) : new ArrayList();
            HashMap<String, String> node = new HashMap<String, String>();
            try {
                interpolatedMessage = this.messageSource.getMessage(constraintViolation.getMessage(), null, locale);
            }
            catch (NoSuchMessageException e) {
                interpolatedMessage = constraintViolation.getMessage();
            }
            if (interpolatedMessage != null && !interpolatedMessage.equals("")) {
                node.put(constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), interpolatedMessage);
            } else {
                node.put(constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), "message not found");
                logger.error("Validation message for key " + constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName() + " not found");
            }
            propertyErrors.add(node);
            errors.put(propertyKey, propertyErrors);
        }
        if (!errors.isEmpty()) {
            HashMap<String, String> title = new HashMap<String, String>();
            title.put("key", bean);
            String header = this.serialize(title);
            String body = this.serialize(errors);
            String[] result = new String[]{header, body};
            String summary = this.serialize(result);
            return summary;
        }
        return null;
    }

    private String serialize(Object obj) {
        StringWriter sw = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator((Writer)sw);
            mapper.writeValue(jsonGenerator, obj);
            sw.close();
            return sw.getBuffer().toString();
        }
        catch (IOException e) {
            logger.error(StackTraceManager.getStackTrace(e));
            return "error!";
        }
    }
}

