/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.util;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlManager {
    private static final Logger logger = LoggerFactory.getLogger(XmlManager.class);
    private static final XPath xPath = XPathFactory.newInstance().newXPath();

    public static Node searchDomNode(Node docDom, String strPath) throws TransformerException {
        if (docDom != null && docDom.getTextContent() != null) {
            logger.debug("Searching node [" + strPath + "] in document " + docDom.getTextContent());
        } else {
            logger.debug("Can't find node [" + strPath + "] in empty document");
        }
        try {
            return (Node)xPath.evaluate(strPath, docDom, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new TransformerException(e);
        }
        catch (DOMException e) {
            throw new TransformerException(e);
        }
    }

    public static Vector<String> searchDomVector(Node docDom, String strPath) throws TransformerException {
        NodeList nodeLiResultado;
        Vector<String> vecValores = null;
        try {
            nodeLiResultado = (NodeList)xPath.evaluate(strPath, docDom, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new TransformerException(e);
        }
        if (nodeLiResultado.getLength() != 0) {
            int x = 0;
            vecValores = new Vector();
            x = 0;
            while (x < nodeLiResultado.getLength()) {
                if (nodeLiResultado.item(x).hasChildNodes()) {
                    vecValores.add(nodeLiResultado.item(x).getFirstChild().getNodeValue());
                } else {
                    vecValores.add("");
                }
                ++x;
            }
        } else {
            vecValores = new Vector<String>();
        }
        return vecValores;
    }
}

