/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.util;

import com.ejie.x38.util.Constants;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeManager {
    public static SimpleDateFormat getDateTimeFormat(Locale locale) {
        if (locale.getLanguage().equals("eu")) {
            return Constants.YYYYMMDD_DATE_FORMAT;
        }
        if (locale.getLanguage().equals("fr") || locale.getLanguage().equals("es") || locale.getLanguage().equals("en")) {
            return Constants.DDMMYYYY_DATE_FORMAT;
        }
        return Constants.DDMMYYYY_DATE_FORMAT;
    }

    public static SimpleDateFormat getTimestampFormat(Locale locale) {
        if (locale.getLanguage().equals("eu")) {
            return Constants.YYYYMMDD_HHMMSS_DATE_FORMAT;
        }
        if (locale.getLanguage().equals("fr") || locale.getLanguage().equals("es") || locale.getLanguage().equals("en")) {
            return Constants.DDMMYYYY_HHMMSS_DATE_FORMAT;
        }
        return Constants.DDMMYYYY_HHMMSS_DATE_FORMAT;
    }

    public static SimpleDateFormat getTimeFormat(Locale locale) {
        return Constants.HHMMSS_TIME_FORMAT;
    }

    public static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static String getHttpExpiredDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 3);
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return httpDateFormat.format(calendar.getTime());
    }

    public static String getHttpExpiredDate(Date date) {
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return httpDateFormat.format(date);
    }
}

