/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.serialization;

import com.ejie.x38.serialization.ThreadSafeCache;
import com.ejie.x38.serialization.UdaModule;
import com.ejie.x38.util.StackTraceManager;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;

public class UdaMappingJacksonHttpMessageConverter
extends MappingJacksonHttpMessageConverter {
    protected final Logger logger = LoggerFactory.getLogger(UdaMappingJacksonHttpMessageConverter.class);
    private ObjectMapper udaObjectMapper = new ObjectMapper();
    private UdaModule udaModule;

    @PostConstruct
    public void initialize() {
        if (this.udaModule != null) {
            this.udaObjectMapper.registerModule((Module)this.udaModule);
            if (this.udaModule.getSerializationConfigFeatures() != null) {
                for (SerializationConfig.Feature feature : this.udaModule.getSerializationConfigFeatures().keySet()) {
                    if (this.udaModule.getSerializationConfigFeatures().get(feature).booleanValue()) {
                        this.udaObjectMapper.enable(new SerializationConfig.Feature[]{feature});
                        this.getObjectMapper().enable(new SerializationConfig.Feature[]{feature});
                        continue;
                    }
                    this.udaObjectMapper.disable(new SerializationConfig.Feature[]{feature});
                    this.getObjectMapper().disable(new SerializationConfig.Feature[]{feature});
                }
            }
            if (this.udaModule.getDeserializationConfigFeatures() != null) {
                for (DeserializationConfig.Feature feature : this.udaModule.getDeserializationConfigFeatures().keySet()) {
                    if (this.udaModule.getDeserializationConfigFeatures().get(feature).booleanValue()) {
                        this.udaObjectMapper.enable(new DeserializationConfig.Feature[]{feature});
                        this.getObjectMapper().enable(new DeserializationConfig.Feature[]{feature});
                        continue;
                    }
                    this.udaObjectMapper.disable(new DeserializationConfig.Feature[]{feature});
                    this.getObjectMapper().disable(new DeserializationConfig.Feature[]{feature});
                }
            }
            if (this.udaModule.getSerializationInclusions() != null) {
                for (JsonSerialize.Inclusion inclusion : this.udaModule.getSerializationInclusions()) {
                    this.udaObjectMapper.setSerializationInclusion(inclusion);
                    this.getObjectMapper().setSerializationInclusion(inclusion);
                }
            }
        }
    }

    protected void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonEncoding encoding = this.getEncoding(outputMessage.getHeaders().getContentType());
        JsonGenerator jsonGenerator = this.udaObjectMapper.getJsonFactory().createJsonGenerator(outputMessage.getBody(), encoding);
        try {
            if (!ThreadSafeCache.getMap().isEmpty() && ThreadSafeCache.getMap().keySet().contains("RUP")) {
                this.logger.info("UDA's Serialization Mechanism is being triggered.");
                this.udaObjectMapper.writeValue(jsonGenerator, o);
            } else {
                this.logger.info("Spring's Default Object Mapper searialization is being triggered.");
                super.writeInternal(o, outputMessage);
            }
        }
        catch (Exception ex) {
            this.logger.error(StackTraceManager.getStackTrace(ex));
            throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try {
            if (!ThreadSafeCache.getMap().isEmpty() && ThreadSafeCache.getMap().keySet().contains("RUP_MULTI_ENTITY")) {
                this.logger.info("UDA's MultiBean deserialization Mechanism is being triggered.");
                return this.udaObjectMapper.readValue(inputMessage.getBody(), clazz);
            }
            this.logger.info("Spring's Default Object Mapper deserialization is being triggered.");
            return super.readInternal(clazz, inputMessage);
        }
        catch (Exception ex) {
            this.logger.error(StackTraceManager.getStackTrace(ex));
            throw new HttpMessageNotReadableException("Could not deserialize JSON: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private JsonEncoding getEncoding(MediaType contentType) {
        if (contentType != null && contentType.getCharSet() != null) {
            Charset charset = contentType.getCharSet();
            JsonEncoding[] jsonEncodingArray = JsonEncoding.values();
            int n = jsonEncodingArray.length;
            int n2 = 0;
            while (n2 < n) {
                JsonEncoding encoding = jsonEncodingArray[n2];
                if (charset.name().equals(encoding.getJavaName())) {
                    return encoding;
                }
                ++n2;
            }
        }
        return JsonEncoding.UTF8;
    }

    public void setUdaObjectMapper(ObjectMapper udaObjectMapper) {
        this.udaObjectMapper = udaObjectMapper;
    }

    public ObjectMapper getUdaObjectMapper() {
        return this.udaObjectMapper;
    }

    @Deprecated
    public void setJacksonJsonObjectMapper(ObjectMapper jacksonJsonObjectMapper) {
        this.udaObjectMapper = jacksonJsonObjectMapper;
    }

    public void setUdaModule(UdaModule udaModule) {
        this.udaModule = udaModule;
    }
}

