/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.serialization;

import com.ejie.x38.util.StackTraceManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiModelDeserializer
extends JsonDeserializer<Map<String, Object>> {
    protected final Logger logger = LoggerFactory.getLogger(MultiModelDeserializer.class);

    public Map<String, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        HashMap<String, Object> mapaRetorno = new HashMap<String, Object>();
        JsonNode jsonNodeTree = jsonParser.readValueAsTree();
        JsonNode rupMultiModelMappingsNode = jsonNodeTree.get("rupEntityMapping");
        Iterator fields = jsonNodeTree.getFields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String propertyName = (String)next.getKey();
            if (rupMultiModelMappingsNode == null || !rupMultiModelMappingsNode.has(propertyName)) continue;
            String beanType = rupMultiModelMappingsNode.get(propertyName).asText();
            JsonParser entityJsonParser = jsonFactory.createJsonParser(((JsonNode)next.getValue()).toString());
            try {
                Object obj = entityJsonParser.readValueAs(Class.forName(beanType));
                mapaRetorno.put(propertyName, obj);
            }
            catch (ClassNotFoundException cnfe) {
                String stackTrace = StackTraceManager.getStackTrace(cnfe);
                this.logger.error(StackTraceManager.getStackTrace(cnfe));
                throw new JsonParseException(stackTrace, entityJsonParser.getCurrentLocation());
            }
        }
        return mapaRetorno;
    }
}

