/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import com.ejie.x38.security.Credentials;
import com.ejie.x38.security.PerimetralSecurityWrapper;
import com.ejie.x38.util.ThreadStorageManager;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class PreAuthenticateProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    @Resource
    private ReloadableResourceBundleMessageSource messageSource;
    private static final Logger logger = LoggerFactory.getLogger(PreAuthenticateProcessingFilter.class);
    private PerimetralSecurityWrapper perimetralSecurityWrapper;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isAjax = ((HttpServletRequest)request).getHeaders("X-Requested-With").hasMoreElements();
        logger.info("the request is entering in the security system");
        String valid = this.getPerimetralSecurityWrapper().validateSession((HttpServletRequest)request, (HttpServletResponse)response);
        if (valid.equals("true")) {
            if (!isAjax || ((HttpServletRequest)request).getSession(false).getAttribute("userChange") == null) {
                super.doFilter(request, response, chain);
                logger.info("the request is exiting of the security system");
            } else {
                HttpSession httpSession = ((HttpServletRequest)request).getSession(false);
                httpSession.removeAttribute("name");
                httpSession.removeAttribute("surname");
                httpSession.removeAttribute("fullName");
                httpSession.removeAttribute("userName");
                httpSession.removeAttribute("reloadData");
                httpSession.removeAttribute("uidSession");
                httpSession.removeAttribute("userChange");
                httpSession.removeAttribute("destroySessionSecuritySystem");
                String content = this.messageSource.getMessage("security.ajaxLoadError", null, LocaleContextHolder.getLocale());
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                httpServletResponse.setStatus(403);
                httpServletResponse.setContentLength(content.getBytes(Charset.forName(httpServletResponse.getCharacterEncoding())).length);
                httpServletResponse.getWriter().print(content);
                httpServletResponse.flushBuffer();
            }
        } else if (valid.equals("false")) {
            chain.doFilter(request, response);
            logger.info("the request is exiting of the security system");
        } else {
            if (!isAjax) {
                ((HttpServletResponse)response).sendRedirect(valid);
                return;
            }
            String content = this.messageSource.getMessage("security.ajaxError", null, LocaleContextHolder.getLocale());
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.setStatus(403);
            httpServletResponse.setContentLength(content.getBytes(Charset.forName(httpServletResponse.getCharacterEncoding())).length);
            httpServletResponse.getWriter().print(content);
            httpServletResponse.flushBuffer();
        }
    }

    protected synchronized Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        Credentials result = this.perimetralSecurityWrapper.getCredentials();
        try {
            result.loadCredentialsData(this.perimetralSecurityWrapper, request);
            MDC.put((String)"session", (String)result.getUidSession());
            MDC.put((String)"user", (String)result.getUserName());
            MDC.put((String)"position", (String)result.getPosition());
        }
        finally {
            request.getSession(false).removeAttribute("credentialsLoading");
        }
        return result;
    }

    protected synchronized Object getPreAuthenticatedPrincipal(HttpServletRequest httpRequest) {
        String principalUser = null;
        HttpSession session = httpRequest.getSession(false);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.isReloadData(httpRequest, ThreadStorageManager.getCurrentThreadId())) {
            if (authentication != null) {
                authentication.setAuthenticated(false);
            }
            if (session.getAttribute("userChange") == null) {
                logger.info("The cache of user's credentials is expired. Proceeds to recharge the user's credentials");
                this.setInvalidateSessionOnPrincipalChange(false);
            } else {
                logger.info("The incoming user and the authenticated user are not equal. Proceed to load the new user's credentials");
                session.removeAttribute("userChange");
            }
            SecurityContextHolder.clearContext();
            return "##udaReloadUser##";
        }
        this.setInvalidateSessionOnPrincipalChange(true);
        principalUser = this.perimetralSecurityWrapper.getUserConnectedUserName(httpRequest);
        logger.info("The incoming user is: " + principalUser);
        return principalUser;
    }

    private synchronized boolean isReloadData(HttpServletRequest httpRequest, Long currentThreadId) {
        HttpSession session = httpRequest.getSession(false);
        Long reloadDataId = (Long)session.getAttribute("reloadData");
        if (session != null && session.getAttribute("reloadData") != null && currentThreadId.equals(reloadDataId)) {
            session.setAttribute("credentialsLoading", (Object)"true");
            session.removeAttribute("reloadData");
            return true;
        }
        return false;
    }

    public PerimetralSecurityWrapper getPerimetralSecurityWrapper() {
        return this.perimetralSecurityWrapper;
    }

    public void setPerimetralSecurityWrapper(PerimetralSecurityWrapper perimetralSecurityWrapper) {
        this.perimetralSecurityWrapper = perimetralSecurityWrapper;
    }
}

