/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class MyUserDetails
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private String password;
    private String username;
    private Collection<GrantedAuthority> authorities;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;
    private GrantedAuthority[] profiles;

    public MyUserDetails(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, GrantedAuthority[] profiles) throws IllegalArgumentException {
        if (username == null || "".equals(username) || password == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.username = username;
        this.password = password;
        this.enabled = enabled;
        this.accountNonExpired = accountNonExpired;
        this.credentialsNonExpired = credentialsNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.setProfiles(profiles);
        this.setAuthorities(profiles);
    }

    public GrantedAuthority[] getProfiles() {
        return this.profiles;
    }

    protected void setProfiles(GrantedAuthority[] perfiles) {
        Assert.notNull((Object)perfiles, (String)"Cannot pass a null GrantedAuthority array");
        ArrayList<GrantedAuthority> notNullAuthorities = new ArrayList<GrantedAuthority>();
        int i = 0;
        while (i < perfiles.length) {
            Assert.notNull((Object)perfiles[i], (String)("Granted perfiles element " + i + " is null - GrantedAuthority[] cannot contain any null elements"));
            notNullAuthorities.add(perfiles[i]);
            ++i;
        }
        this.profiles = notNullAuthorities.toArray(new GrantedAuthority[notNullAuthorities.size()]);
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    protected void setAuthorities(GrantedAuthority[] authorities) {
        Assert.notNull((Object)authorities, (String)"Cannot pass a null GrantedAuthority array");
        ArrayList<GrantedAuthority> sorter = new ArrayList<GrantedAuthority>();
        int i = 0;
        while (i < authorities.length) {
            Assert.notNull((Object)authorities[i], (String)("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements"));
            sorter.add(authorities[i]);
            ++i;
        }
        this.authorities = sorter;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof MyUserDetails) || rhs == null) {
            return false;
        }
        MyUserDetails user = (MyUserDetails)rhs;
        if (user.getProfiles().length != this.getProfiles().length) {
            return false;
        }
        int i = 0;
        while (i < this.getProfiles().length) {
            if (!this.getProfiles()[i].equals(user.getProfiles()[i])) {
                return false;
            }
            ++i;
        }
        return this.getPassword().equals(user.getPassword()) && this.getUsername().equals(user.getUsername()) && this.isAccountNonExpired() == user.isAccountNonExpired() && this.isAccountNonLocked() == user.isAccountNonLocked() && this.isCredentialsNonExpired() == user.isCredentialsNonExpired() && this.isEnabled() == user.isEnabled();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.username).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.enabled).append("; ");
        sb.append("AccountNonExpired: ").append(this.accountNonExpired).append("; ");
        sb.append("credentialsNonExpired: ").append(this.credentialsNonExpired).append("; ");
        sb.append("AccountNonLocked: ").append(this.accountNonLocked).append("; ");
        if (this.getProfiles() != null) {
            sb.append("Granted Profiles: ");
            int i = 0;
            while (i < this.getProfiles().length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getProfiles()[i].toString());
                ++i;
            }
        } else {
            sb.append("Not granted any profiles");
        }
        sb.append("; ");
        return sb.toString();
    }
}

