/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import com.ejie.x38.security.PerimetralSecurityWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.util.Assert;

public class MyLogoutHandler
implements LogoutHandler {
    private boolean invalidateHttpSession;
    private boolean invalidateUserSession;
    private PerimetralSecurityWrapper perimetralSecurityWrapper;
    static Logger logger = LoggerFactory.getLogger(MyLogoutHandler.class);

    public PerimetralSecurityWrapper getPerimetralSecurityWrapper() {
        return this.perimetralSecurityWrapper;
    }

    public void setPerimetralSecurityWrapper(PerimetralSecurityWrapper perimetralSecurityWrapper) {
        this.perimetralSecurityWrapper = perimetralSecurityWrapper;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        HttpSession httpSession = request.getSession(false);
        logger.info("XLNET session is invalid. Proceeding to clean the Security Context Holder.");
        if (authentication != null) {
            authentication.setAuthenticated(false);
        }
        SecurityContextHolder.clearContext();
        if (httpSession != null && httpSession.getAttribute("SPRING_SECURITY_CONTEXT") != null) {
            httpSession.removeAttribute("SPRING_SECURITY_CONTEXT");
        }
        logger.info("SecurityContextHolder cleared!");
        if (this.invalidateUserSession) {
            Assert.notNull((Object)request, (String)"HttpServletRequest required");
            this.getPerimetralSecurityWrapper().logout(request, response);
            logger.info("XLNET " + this.getPerimetralSecurityWrapper().getUserConnectedUidSession(request) + " Session destroyed!");
        }
        if (httpSession != null && this.invalidateHttpSession) {
            try {
                logger.info("Session " + httpSession.getId() + " invalidated!");
                httpSession.invalidate();
            }
            catch (IllegalStateException e) {
                logger.info("The user session isn't valid, it is not necessary delete it");
            }
        }
    }

    public boolean isInvalidateHttpSession() {
        return this.invalidateHttpSession;
    }

    public void setInvalidateHttpSession(boolean invalidateHttpSession) {
        this.invalidateHttpSession = invalidateHttpSession;
    }

    public boolean isInvalidateUserSession() {
        return this.invalidateUserSession;
    }

    public void setInvalidateUserSession(boolean invalidateUserSession) {
        this.perimetralSecurityWrapper.setDestroySessionSecuritySystem(invalidateUserSession);
        this.invalidateUserSession = invalidateUserSession;
    }
}

