/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import com.ejie.x38.security.Credentials;
import com.ejie.x38.security.MyUserDetails;
import com.ejie.x38.security.PerimetralSecurityWrapper;
import com.ejie.x38.security.XlnetGrantedAuthority;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class MyAuthenticatedUserDetailsService
implements AuthenticationUserDetailsService<Authentication> {
    private static final Logger logger = LoggerFactory.getLogger(MyAuthenticatedUserDetailsService.class);
    private PerimetralSecurityWrapper perimetralSecurityWrapper;

    public UserDetails loadUserDetails(Authentication token) throws UsernameNotFoundException {
        Assert.notNull((Object)token.getCredentials());
        logger.trace("User's token is: " + token.toString());
        logger.trace("User's credentials are " + token.getCredentials().toString());
        Credentials Credentials2 = (Credentials)token.getCredentials();
        Object userDetails = null;
        if (Credentials2 != null) {
            Vector<String> vectorProfilesXLNET = Credentials2.getUserProfiles();
            GrantedAuthority[] profiles = null;
            if (vectorProfilesXLNET != null) {
                profiles = new XlnetGrantedAuthority[vectorProfilesXLNET.size()];
                int contadorAuthXLNET = 0;
                while (contadorAuthXLNET < vectorProfilesXLNET.size()) {
                    String authority = "ROLE_" + vectorProfilesXLNET.get(contadorAuthXLNET);
                    profiles[contadorAuthXLNET] = new XlnetGrantedAuthority(authority);
                    ++contadorAuthXLNET;
                }
            }
            userDetails = this.createuserDetails(token, profiles);
        }
        logger.trace("UserDetails is: " + userDetails.toString());
        return userDetails;
    }

    protected MyUserDetails createuserDetails(Authentication token, GrantedAuthority[] profiles) {
        return new MyUserDetails(token.getName(), "N/A", true, true, true, true, profiles);
    }

    public PerimetralSecurityWrapper getPerimetralSecurityWrapper() {
        return this.perimetralSecurityWrapper;
    }

    public void setPerimetralSecurityWrapper(PerimetralSecurityWrapper perimetralSecurityWrapper) {
        this.perimetralSecurityWrapper = perimetralSecurityWrapper;
    }
}

