/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.reports;

import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.reports.JerarquiaMetadata;
import com.ejie.x38.reports.ReportData;
import java.io.BufferedWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.web.servlet.view.AbstractView;

public class CSVReportView
extends AbstractView {
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Content-type", "application/octet-stream; charset=ISO-8859-1");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + model.get("fileName") + ".csv\"");
        Cookie cookie = new Cookie("fileDownload", "true");
        cookie.setPath("/");
        response.addCookie(cookie);
        String token = model.get("separator") != null ? (String)model.get("separator") : ";";
        ReportData reportData = (ReportData)model.get("reportData");
        boolean isJerarquia = reportData.isJerarquia();
        boolean isGrouping = reportData.isGrouping();
        JerarquiaMetadata jmd = reportData.getJerarquiaMetadada();
        BufferedWriter writer = new BufferedWriter(response.getWriter());
        LinkedHashMap dataHeader = (LinkedHashMap)reportData.getHeaderNames();
        if (reportData.isShowHeaders()) {
            if (isGrouping) {
                writer.write(token);
            }
            if (isJerarquia && jmd.isShowFiltered()) {
                if (!"".equals(jmd.getFilterHeaderName())) {
                    writer.write(jmd.getFilterHeaderName());
                }
                writer.write(token);
            }
            for (Map.Entry entry : dataHeader.entrySet()) {
                if (isGrouping && !reportData.isShowGroupColumng() && ((String)entry.getKey()).equals(reportData.getGroupColumnName())) continue;
                writer.write(this.parseValue((String)entry.getValue(), token));
                writer.write(token);
            }
            writer.newLine();
        }
        List<Object> modelData = !isJerarquia ? reportData.getModelData() : reportData.getModelDataJerarquia();
        String prevGroupValue = "";
        String groupValue = "";
        for (Object object : modelData) {
            int level = 0;
            boolean hasChildren = false;
            if (isGrouping) {
                groupValue = this.parseValue(BeanUtils.getProperty(((JerarquiaDto)object).getModel(), (String)reportData.getGroupColumnName()), token);
                if (!groupValue.equals(prevGroupValue)) {
                    prevGroupValue = groupValue;
                    writer.write(groupValue);
                    writer.newLine();
                }
                writer.write(token);
            }
            if (isJerarquia) {
                if (jmd.isShowFiltered()) {
                    if (((JerarquiaDto)object).isFilter()) {
                        writer.write(jmd.getFilterToken());
                    }
                    writer.write(token);
                }
                level = ((JerarquiaDto)object).getLevel();
                hasChildren = ((JerarquiaDto)object).isHasChildren();
                object = ((JerarquiaDto)object).getModel();
            }
            for (Map.Entry entry : dataHeader.entrySet()) {
                if (isGrouping && !reportData.isShowGroupColumng() && ((String)entry.getKey()).equals(reportData.getGroupColumnName())) continue;
                String columnValue = this.parseValue(BeanUtils.getProperty((Object)object, (String)((String)entry.getKey())), token);
                if (isJerarquia) {
                    if (jmd.isShowIcon() && ((String)entry.getKey()).equals(jmd.getIconColumnName())) {
                        columnValue = jmd.getIconCollapsedList().contains(BeanUtils.getProperty((Object)object, (String)jmd.getIconBeanAtribute())) ? String.valueOf(jmd.getIconUnexpanded()) + columnValue : (hasChildren ? String.valueOf(jmd.getIconExpanded()) + columnValue : String.valueOf(jmd.getIconNoChild()) + columnValue);
                    }
                    if (jmd.isShowTabbed() && ((String)entry.getKey()).equals(jmd.getTabColumnName())) {
                        columnValue = String.valueOf(jmd.getTab(level)) + columnValue;
                    }
                }
                writer.write(columnValue);
                writer.write(token);
            }
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }

    private String parseValue(String value, String token) {
        String string = value = value != null ? value : "";
        if (value.indexOf(token) != -1) {
            value = "\"" + value + "\"";
        }
        return value;
    }
}

