/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.reports;

import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.reports.JerarquiaMetadata;
import com.ejie.x38.reports.ReportData;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractPOIExcelView
extends AbstractView {
    private static final String CONTENT_TYPE_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final String CONTENT_TYPE_XLS = "application/vnd.ms-excel";

    protected boolean generatesDownloadContent() {
        return true;
    }

    protected final void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Workbook workbook = this.createWorkbook();
        if (workbook instanceof HSSFWorkbook) {
            this.setContentType(CONTENT_TYPE_XLS);
        } else {
            this.setContentType(CONTENT_TYPE_XLSX);
        }
        this.buildExcelDocument(model, workbook, request, response);
        response.setContentType(this.getContentType());
        ServletOutputStream out = response.getOutputStream();
        out.flush();
        workbook.write((OutputStream)out);
        out.flush();
    }

    protected abstract Workbook createWorkbook();

    protected abstract String getFileExtension();

    protected void buildExcelDocument(Map<String, Object> model, Workbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + model.get("fileName") + this.getFileExtension() + "\"");
        List reportData = (List)model.get("reportData");
        for (ReportData dataSheet : reportData) {
            boolean isJerarquia = dataSheet.isJerarquia();
            boolean isGrouping = dataSheet.isGrouping();
            JerarquiaMetadata jmd = dataSheet.getJerarquiaMetadada();
            Sheet sheet = workbook.createSheet(dataSheet.getSheetName());
            Row row = sheet.createRow(0);
            int cellNum = 0;
            int rowNum = 0;
            LinkedHashMap dataHeader = (LinkedHashMap)dataSheet.getHeaderNames();
            if (dataSheet.isShowHeaders()) {
                if (isGrouping) {
                    row.createCell(cellNum++).setCellValue("");
                }
                if (isJerarquia && jmd.isShowFiltered()) {
                    if (!"".equals(jmd.getFilterHeaderName())) {
                        row.createCell(cellNum++).setCellValue(jmd.getFilterHeaderName());
                    } else {
                        row.createCell(cellNum++).setCellValue("");
                    }
                }
                for (Map.Entry entry : dataHeader.entrySet()) {
                    if (isGrouping && !dataSheet.isShowGroupColumng() && ((String)entry.getKey()).equals(dataSheet.getGroupColumnName())) continue;
                    row.createCell(cellNum++).setCellValue((String)entry.getValue());
                }
                ++rowNum;
            }
            List<Object> modelData = !isJerarquia ? dataSheet.getModelData() : dataSheet.getModelDataJerarquia();
            String prevGroupValue = "";
            String groupValue = "";
            for (Object object : modelData) {
                row = sheet.createRow(rowNum++);
                cellNum = 0;
                int level = 0;
                boolean hasChildren = false;
                if (isGrouping) {
                    groupValue = BeanUtils.getProperty(((JerarquiaDto)object).getModel(), (String)dataSheet.getGroupColumnName());
                    if (!groupValue.equals(prevGroupValue)) {
                        prevGroupValue = groupValue;
                        row.createCell(cellNum++).setCellValue(groupValue);
                        row = sheet.createRow(rowNum++);
                        cellNum = 0;
                    }
                    row.createCell(cellNum++).setCellValue("");
                }
                if (isJerarquia) {
                    if (jmd.isShowFiltered()) {
                        if (((JerarquiaDto)object).isFilter()) {
                            row.createCell(cellNum++).setCellValue(jmd.getFilterToken());
                        } else {
                            row.createCell(cellNum++).setCellValue("");
                        }
                    }
                    level = ((JerarquiaDto)object).getLevel();
                    hasChildren = ((JerarquiaDto)object).isHasChildren();
                    object = ((JerarquiaDto)object).getModel();
                }
                for (Map.Entry entry : dataHeader.entrySet()) {
                    if (isGrouping && !dataSheet.isShowGroupColumng() && ((String)entry.getKey()).equals(dataSheet.getGroupColumnName())) continue;
                    String columnValue = BeanUtils.getProperty((Object)object, (String)((String)entry.getKey()));
                    if (isJerarquia) {
                        if (jmd.isShowIcon() && ((String)entry.getKey()).equals(jmd.getIconColumnName())) {
                            columnValue = jmd.getIconCollapsedList().contains(BeanUtils.getProperty((Object)object, (String)jmd.getIconBeanAtribute())) ? String.valueOf(jmd.getIconUnexpanded()) + columnValue : (hasChildren ? String.valueOf(jmd.getIconExpanded()) + columnValue : String.valueOf(jmd.getIconNoChild()) + columnValue);
                        }
                        if (jmd.isShowTabbed() && ((String)entry.getKey()).equals(jmd.getTabColumnName())) {
                            columnValue = String.valueOf(jmd.getTab(level)) + columnValue;
                        }
                    }
                    row.createCell(cellNum++).setCellValue(columnValue);
                }
            }
            int columnNumber = dataHeader.size();
            int i = 0;
            while (i < columnNumber) {
                sheet.autoSizeColumn(i);
                ++i;
            }
        }
        Cookie cookie = new Cookie("fileDownload", "true");
        cookie.setPath("/");
        response.addCookie(cookie);
    }
}

