/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.remote;

import com.ejie.x38.util.StackTraceManager;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionMetadataStubInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TransactionMetadataStubInterceptor.class);

    @AroundInvoke
    public Object manageTransactionMetadata(InvocationContext ic) throws Exception {
        long start = System.currentTimeMillis();
        try {
            logger.debug("Intercepting " + ic.getTarget() + "." + ic.getMethod().getName());
            String params = ic.getParameters().toString();
            if (params == null) {
                ic.setParameters((Object[])new String[]{"default"});
            }
            Object object = ic.proceed();
            return object;
        }
        catch (Exception e) {
            logger.error(StackTraceManager.getStackTrace(e));
            throw e;
        }
        finally {
            long time = System.currentTimeMillis() - start;
            logger.debug("Invocation of transaction " + ic.getTarget() + "." + ic.getMethod().getName() + " took " + time + "ms");
        }
    }
}

