/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.remote;

import com.ejie.x38.remote.TransactionMetadata;
import com.ejie.x38.util.StackTraceManager;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionMetadataSkeletonInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TransactionMetadataSkeletonInterceptor.class);

    @AroundInvoke
    public Object manageTransactionMetadata(InvocationContext ic) throws Exception {
        TransactionMetadata txMeta = null;
        try {
            Object[] params = ic.getParameters();
            txMeta = (TransactionMetadata)params[params.length - 1];
            txMeta.install();
            logger.info("Inside Interceptor invoked for " + ic.getTarget() + "." + ic.getMethod().getName());
            Object object = ic.proceed();
            return object;
        }
        catch (Exception e) {
            logger.error(StackTraceManager.getStackTrace(e));
            throw e;
        }
        finally {
            logger.info("Leaving Interceptor invoked for " + ic.getTarget() + "." + ic.getMethod().getName());
            txMeta.clear();
        }
    }
}

