/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.remote;

import com.ejie.x38.remote.RemoteEJBFactory;
import com.ejie.x38.util.StackTraceManager;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weblogic.jndi.Environment;

public class RemoteEJBFactoryImpl
implements RemoteEJBFactory {
    private static final Logger logger = LoggerFactory.getLogger(RemoteEJBFactoryImpl.class);
    private Map<Class<?>, Object> remoteInterfaces = new HashMap();
    private Properties appConfiguration;

    private RemoteEJBFactoryImpl() {
    }

    @Override
    public Object lookup(String serverName, Class<?> remoteInterfaceClass) throws Exception {
        String jndiName = this.appConfiguration.getProperty(String.valueOf(serverName) + "." + remoteInterfaceClass.getSimpleName() + ".jndi");
        logger.info("Looking Up EJB with JNDI Name: " + jndiName);
        Object remoteInterface = this.remoteInterfaces.get(remoteInterfaceClass);
        if (remoteInterface == null) {
            remoteInterface = this.getInitialContext(serverName).lookup(jndiName);
            this.remoteInterfaces.put(remoteInterfaceClass, remoteInterface);
        }
        return remoteInterface;
    }

    private Context getInitialContext(String serverName) {
        String url = this.appConfiguration.getProperty(String.valueOf(serverName) + ".url");
        String user = this.appConfiguration.getProperty(String.valueOf(serverName) + ".user");
        String password = this.appConfiguration.getProperty(String.valueOf(serverName) + ".password");
        Hashtable<String, String> ht = new Hashtable<String, String>();
        try {
            ht.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            ht.put("java.naming.provider.url", url);
            if (user != null) {
                ht.put("java.naming.security.principal", user);
                ht.put("java.naming.security.credentials", password == null ? "" : password);
            }
            Environment env = new Environment();
            env.setDelegateEnvironment(ht);
            return env.getInitialContext();
        }
        catch (Exception e) {
            logger.error("Failed to initialize InitialContext with error: " + StackTraceManager.getStackTrace(e));
            return null;
        }
    }

    @Override
    public void clearInstance(Class<?> remoteInterfaceClass) {
        this.remoteInterfaces.remove(remoteInterfaceClass);
    }

    public Properties getAppConfiguration() {
        return this.appConfiguration;
    }

    public void setAppConfiguration(Properties appConfiguration) {
        this.appConfiguration = appConfiguration;
    }
}

