/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.log;

import com.ejie.x38.log.LoggingAdvice;
import com.ejie.x38.log.LoggingManager;
import java.util.Arrays;
import java.util.Hashtable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;

public abstract class LoggingAdviceImpl
implements LoggingAdvice {
    private LoggingManager loggingManager;

    @Override
    public abstract void preLogging(ProceedingJoinPoint var1) throws Throwable;

    @Override
    public abstract void postLogging(ProceedingJoinPoint var1, Object var2) throws Throwable;

    @Override
    public void preComponentLogCall(ProceedingJoinPoint call, Hashtable<String, String> table, Logger logger) throws Throwable {
        StringBuilder message = new StringBuilder(call.getTarget().getClass().getSimpleName());
        message.append(call.toShortString());
        String aditionalInfo = Arrays.toString(call.getArgs());
        table.put("message", message.toString());
        table.put("aditionalInfo", aditionalInfo);
        this.loggingManager.autoLog(table, this.getClass().getName(), logger);
    }

    @Override
    public void postComponentLogCall(ProceedingJoinPoint call, Object ret, Hashtable<String, String> table, Logger logger) throws Throwable {
        StringBuilder message = new StringBuilder(call.getTarget().getClass().getSimpleName());
        String aditionalInfo = "";
        message.append(call.toShortString());
        message.append(" - finished");
        if (logger.isTraceEnabled() && ret != null) {
            aditionalInfo = "" + ret;
        }
        table.put("aditionalInfo", aditionalInfo);
        table.put("message", message.toString());
        this.loggingManager.autoLog(table, this.getClass().getName(), logger);
    }

    public LoggingManager getLoggingManager() {
        return this.loggingManager;
    }

    public void setLoggingManager(LoggingManager loggingManager) {
        this.loggingManager = loggingManager;
    }
}

